/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ConfigureGCLogsService;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.UpnpForwardingService;
import pl.smartapps.hm.WebViewer.shared.model.ConfigureLoggerStatus;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.GcMacId;
import pl.smartapps.restserver.db.main.DebuglogEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.GatewayClientSessionEntity;
import pl.smartapps.restserver.db.main.GatewayClientVersionEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ActivateGcResponse;
import pl.smartapps.restserver.rest.response.GCStatusResponse;
import pl.smartapps.restserver.rest.response.GatewayClientResponse;
import pl.smartapps.restserver.rest.response.GetCommServerUrlResponse;
import pl.smartapps.restserver.rest.response.RemoveResponse;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.GatewayClientServiceImpl;
import pl.smartapps.restserver.service.impl.GatewayClientServiceInternal;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GatewayClientServiceImpl.class, Date.class, DigestUtils.class, HashMap.class, GetCommServerUrlResponse.class, pl.smartapps.restserver.util.Utils.class, GatewayClientSessionEntity.class, GatewayClientResponse.class, VerifyGcResponse.class, URL.class, DebuglogEntity.class})
public class GatewayClientServiceTests
extends GatewayClientServiceInternal {
    @Test
    public void testFindAllGatewayClients() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ArrayList<GatewayClientEntity> foundClientEntities = new ArrayList<GatewayClientEntity>();
        Date activationDate = Utils.constructDate((int)2011, (int)3, (int)25, (int)8, (int)44, (int)0);
        GatewayClientEntity clientEntity1 = TestDataUtils.prepareGatewaClientEntity((Integer)1, (String)"01:00:00:00:04:05", (String)"01:00:00:00:04:05", (String)"01:00:00:00:04:05", (Date)activationDate, (boolean)false);
        foundClientEntities.add(clientEntity1);
        Date connectedDate1 = Utils.constructDate((int)2011, (int)10, (int)26, (int)11, (int)58, (int)20);
        GatewayDevice gatewayDevice1 = this.buildGatewayDevice("01:00:00:00:04:05", "192.168.21.101", connectedDate1);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("01:00:00:00:04:05")).andReturn((Object)gatewayDevice1);
        GatewayClientEntity clientEntity2 = TestDataUtils.prepareGatewaClientEntity((Integer)2, (String)"01:00:00:00:04:06", (String)"01:00:00:00:04:06", (String)"01:00:00:00:04:06", (Date)activationDate, (boolean)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("01:00:00:00:04:06")).andReturn(null);
        foundClientEntities.add(clientEntity2);
        GatewayClientEntity clientEntity3 = TestDataUtils.prepareGatewaClientEntity((Integer)3, (String)"01:00:00:00:04:07", (String)"01:00:00:00:04:07", (String)"01:00:00:00:04:07", (Date)activationDate, (boolean)false);
        Date connectedDate3 = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)1, (int)19);
        GatewayDevice gatewayDevice3 = this.buildGatewayDevice("01:00:00:00:04:07", "192.168.21.103", connectedDate3);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("01:00:00:00:04:07")).andReturn((Object)gatewayDevice3);
        foundClientEntities.add(clientEntity3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsWithCorrectDevicesByUserId(Integer.valueOf(1))).andReturn(foundClientEntities);
        ArrayList<GatewayClient> expectedClients = new ArrayList<GatewayClient>();
        GatewayClient client1 = TestDataUtils.prepareGatewaClient((Integer)1, (String)"01:00:00:00:04:05", (String)"01:00:00:00:04:05", (String)"01:00:00:00:04:05", (Date)activationDate, (boolean)false);
        client1.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        client1.setPublicIpAddress("192.168.21.101");
        expectedClients.add(client1);
        GatewayClient client2 = TestDataUtils.prepareGatewaClient((Integer)2, (String)"01:00:00:00:04:06", (String)"01:00:00:00:04:06", (String)"01:00:00:00:04:06", (Date)activationDate, (boolean)false);
        client2.setStatus(GatewayClient.GatewayClientStatus.DISCONNECTED);
        expectedClients.add(client2);
        GatewayClient client3 = TestDataUtils.prepareGatewaClient((Integer)3, (String)"01:00:00:00:04:07", (String)"01:00:00:00:04:07", (String)"01:00:00:00:04:07", (Date)activationDate, (boolean)false);
        client3.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        client3.setPublicIpAddress("192.168.21.103");
        expectedClients.add(client3);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.gatewayClientService.getGatewayClients();
        Assert.assertEquals(expectedClients, (Object)response);
        PowerMock.verifyAll();
    }

    private GatewayDevice buildGatewayDevice(String mac, String publicIpAddress, Date connectedDate) {
        GatewayDevice gd = new GatewayDevice(mac, publicIpAddress, "localIpAddress");
        gd.setDeviceType(Integer.valueOf(0));
        gd.setConnectedDate(connectedDate);
        return gd;
    }

    @Test
    public void testActivateGCInvalidCode() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("123")).andReturn(null);
        EasyMock.expect((Object)this.authUtils.getStoredData("unsuccessful_attempt_count")).andReturn(null);
        EasyMock.expectLastCall().times(2);
        this.authUtils.storeData("unsuccessful_attempt_count", (Object)1);
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("1234")).andReturn(null);
        EasyMock.expect((Object)this.authUtils.getStoredData("unsuccessful_attempt_count")).andReturn((Object)1);
        EasyMock.expectLastCall().times(2);
        this.authUtils.storeData("unsuccessful_attempt_count", (Object)2);
        this.eventlogService.registerEventlog(GCEventType.ACTIVATE, null, null, "INCORRECTCODE", null);
        EasyMock.expectLastCall().times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateGcResponse response1 = this.gatewayClientService.activeteGatewaClient("123");
        ActivateGcResponse expectedResponse = new ActivateGcResponse(ActivateGcResponse.ActivateStatus.INCORRECTCODE);
        Assert.assertEquals((Object)expectedResponse, (Object)response1);
        ActivateGcResponse response2 = this.gatewayClientService.activeteGatewaClient("1234");
        Assert.assertEquals((Object)expectedResponse, (Object)response2);
        PowerMock.verifyAll();
    }

    @Test
    public void testActiveteGcAlreadyActivated() throws InvalidSessionException {
        Date connectedDate = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)15, (int)4);
        Date disconnectedDate = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)18, (int)4);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("bef7-s6gr-xnew")).andReturn((Object)"00:1A:B6:00:0B:B5");
        GatewayClientEntity foundGatewayClient = TestDataUtils.prepareGatewaClientEntity();
        foundGatewayClient.setConnectedDate(connectedDate);
        foundGatewayClient.setDisconnectedDate(disconnectedDate);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(foundGatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        this.eventlogService.registerEventlog(GCEventType.ACTIVATE, "00:1A:B6:00:0B:B5", null, "ALREADYACTIVATED", null);
        GatewayDevice gatewayDevice = this.buildGatewayDevice("00:1A:B6:00:0B:B5", "192.168.21.121", connectedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)gatewayDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateGcResponse response = this.gatewayClientService.activeteGatewaClient("bef7-s6gr-xnew");
        GatewayClient gatewayClient = TestDataUtils.prepareGatewaClient();
        gatewayClient.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        gatewayClient.setPublicIpAddress("192.168.21.121");
        gatewayClient.setConnectedDate(connectedDate);
        gatewayClient.setDisconnectedDate(disconnectedDate);
        ActivateGcResponse expectedResponse = new ActivateGcResponse(ActivateGcResponse.ActivateStatus.ALREADYACTIVATED, gatewayClient);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testActiveteGcNotConnected() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabs-d8tH-Akex")).andReturn((Object)"00:02:D1:F9:D9:A2");
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:F9:D9:A2")).andReturn(clients);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:F9:D9:A2")).andReturn(null);
        this.eventlogService.registerEventlog(GCEventType.ACTIVATE, "00:02:D1:F9:D9:A2", null, "NOTCONNECTED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateGcResponse response = this.gatewayClientService.activeteGatewaClient("aabs-d8tH-Akex");
        ActivateGcResponse expectedResponse = new ActivateGcResponse(ActivateGcResponse.ActivateStatus.NOTCONNECTED, null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetGatewayClientStatusSuccessful() throws InvalidSessionException {
        Date connectedDate = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)15, (int)4);
        Date disconnectedDate = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)18, (int)4);
        GatewayClientEntity foundGatewayClient = TestDataUtils.prepareGatewaClientEntity();
        foundGatewayClient.setConnectedDate(connectedDate);
        foundGatewayClient.setDisconnectedDate(disconnectedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn((Object)foundGatewayClient);
        GatewayDevice gatewayDevice = this.buildGatewayDevice("00:1A:B6:00:0B:B5", "192.168.21.121", connectedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)gatewayDevice).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        GCStatusResponse response = this.gatewayClientService.getGatewayClientStatus(1);
        GatewayClient gatewayClient = TestDataUtils.prepareGatewaClient();
        gatewayClient.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        gatewayClient.setPublicIpAddress("192.168.21.121");
        gatewayClient.setConnectedDate(connectedDate);
        gatewayClient.setDisconnectedDate(disconnectedDate);
        GCStatusResponse expectedResponse = new GCStatusResponse(GCStatusResponse.GCStatus.OK, gatewayClient);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetGatewayClientStatusFailed() throws InvalidSessionException {
        GatewayClientEntity foundGatewayClient = TestDataUtils.prepareGatewaClientEntity();
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn((Object)foundGatewayClient);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        GCStatusResponse response = this.gatewayClientService.getGatewayClientStatus(1);
        GatewayClient gatewayClient = TestDataUtils.prepareGatewaClient();
        gatewayClient.setStatus(GatewayClient.GatewayClientStatus.DISCONNECTED);
        GCStatusResponse expectedResponse = new GCStatusResponse(GCStatusResponse.GCStatus.NOTCONNECTED, gatewayClient);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testActiveGcSuccess() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabs-d8tH-Akex")).andReturn((Object)"00:02:D1:F9:D9:A2");
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:F9:D9:A2")).andReturn(clients);
        Date connectedDate = Utils.constructDate((int)2011, (int)10, (int)26, (int)12, (int)25, (int)51);
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:F9:D9:A2", "ipAddress", "localIpAddress", 0, 0, 0, 16);
        gatewayDevice.setConnectedDate(connectedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:F9:D9:A2")).andReturn((Object)gatewayDevice).times(2);
        Date acitvationDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)10, (int)11, (int)23);
        GatewayClientEntity newGatewayClient = new GatewayClientEntity();
        newGatewayClient.setGatewayClientId(null);
        newGatewayClient.setSerialNumber("00:02:D1:F9:D9:A2");
        newGatewayClient.setMac("00:02:D1:F9:D9:A2");
        newGatewayClient.setName("00:02:D1:F9:D9:A2");
        newGatewayClient.setDeleted(false);
        newGatewayClient.setActivationDate(acitvationDate);
        newGatewayClient.setUser(TestDataUtils.prepareUserEntity());
        newGatewayClient.setDeviceType(Integer.valueOf(16));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GatewayClientEntity savedGatewayClient = new GatewayClientEntity();
        savedGatewayClient.setGatewayClientId(Integer.valueOf(1));
        savedGatewayClient.setSerialNumber("00:02:D1:F9:D9:A2");
        savedGatewayClient.setMac("00:02:D1:F9:D9:A2");
        savedGatewayClient.setName("00:02:D1:F9:D9:A2");
        savedGatewayClient.setDeleted(false);
        savedGatewayClient.setActivationDate(new Date());
        savedGatewayClient.setUser(TestDataUtils.prepareUserEntity());
        savedGatewayClient.setDeviceType(Integer.valueOf(16));
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)acitvationDate);
        EasyMock.expect((Object)this.gatewayClientDAO.saveGatewayClient(newGatewayClient)).andReturn((Object)savedGatewayClient);
        this.eventlogService.registerEventlog(GCEventType.ACTIVATE, "00:02:D1:F9:D9:A2", "ipAddress", "SUCCESS", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateGcResponse response = this.gatewayClientService.activeteGatewaClient("aabs-d8tH-Akex");
        GatewayClient client = new GatewayClient();
        client.setGatewayClientId(Integer.valueOf(1));
        client.setMac("00:02:D1:F9:D9:A2");
        client.setName("00:02:D1:F9:D9:A2");
        client.setSerialNumber("00:02:D1:F9:D9:A2");
        client.setActivationDate(acitvationDate);
        ActivateGcResponse expectedResponse = new ActivateGcResponse(ActivateGcResponse.ActivateStatus.SUCCESS, client);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.equalsActivateGcResponse(expectedResponse, response));
    }

    private boolean equalsActivateGcResponse(ActivateGcResponse resp1, ActivateGcResponse resp2) {
        if (resp1 == resp2) {
            return true;
        }
        if (resp1 == null || resp2 == null) {
            return false;
        }
        if (resp1.status == null ? resp2.status != null : !resp1.status.equals((Object)resp2.status)) {
            return false;
        }
        return this.equalsGcResponse(resp1.gatewayClient, resp2.gatewayClient);
    }

    private boolean equalsGcResponse(GatewayClient client1, GatewayClient client2) {
        if (client1 == client2) {
            return true;
        }
        if (client1 == null || client2 == null) {
            return false;
        }
        if (client1.getName() == null ? client2.getName() != null : !client1.getName().equals(client2.getName())) {
            return false;
        }
        return !(client1.getSerialNumber() == null ? client2.getSerialNumber() != null : !client1.getSerialNumber().equals(client2.getSerialNumber()));
    }

    @Test
    public void testRemoveGatewayClient() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GatewayClientEntity foundGatewayClient = TestDataUtils.prepareGatewaClientEntity();
        HashSet<LanDeviceEntity> lanDevices = new HashSet<LanDeviceEntity>();
        lanDevices.add(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        foundGatewayClient.setLanDevices(lanDevices);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), true)).andReturn((Object)foundGatewayClient);
        GatewayClientEntity deletedGatewayClient = TestDataUtils.prepareGatewaClientEntity();
        HashSet deletedLanDevices = new HashSet();
        lanDevices.add(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        deletedGatewayClient.setLanDevices(deletedLanDevices);
        deletedGatewayClient.setDeleted(true);
        for (LanDeviceEntity device : deletedGatewayClient.getLanDevices()) {
            device.setDeleted(true);
        }
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(deletedGatewayClient)).andReturn((Object)deletedGatewayClient);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse response = this.gatewayClientService.removeGatewayClient(Integer.valueOf(1));
        RemoveResponse expectedResponse = new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetGCCount() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.gatewayClientDAO.countGatewayClientsForUserId(Integer.valueOf(1))).andReturn((Object)3L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)3, (Object)this.gatewayClientService.getGCCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientBasicInfoFailureInvalidMac() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(3);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.getGatewayClientBasicInfo(null));
        Assert.assertEquals(null, (Object)this.gatewayClientService.getGatewayClientBasicInfo("00:00:00:00:00:00:"));
        Assert.assertEquals(null, (Object)this.gatewayClientService.getGatewayClientBasicInfo("00:00:00:00:00:0"));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientBasicInfoWhenDeviceDisconnected() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:00:00:00:00:00")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClient expectedResponse = new GatewayClient();
        expectedResponse.setStatus(GatewayClient.GatewayClientStatus.DISCONNECTED);
        GatewayClient response = this.gatewayClientService.getGatewayClientBasicInfo("00:00:00:00:00:00");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientBasicInfoWhenDeviceConnected() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String publicIp = "0.0.0.0";
        Date connectedDate = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)14, (int)15);
        GatewayDevice gatewayDevice = new GatewayDevice();
        gatewayDevice.setMac(mac);
        gatewayDevice.setPublicIpAddress(publicIp);
        gatewayDevice.setConnectedDate(connectedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:00:00:00:00:00")).andReturn((Object)gatewayDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClient expectedResponse = new GatewayClient();
        expectedResponse.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        expectedResponse.setConnectedDate(connectedDate);
        expectedResponse.setPublicIpAddress(publicIp);
        expectedResponse.setMac(mac);
        GatewayClient response = this.gatewayClientService.getGatewayClientBasicInfo("00:00:00:00:00:00");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendSuccecfully() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        URL url = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andReturn((Object)url);
        EasyMock.expect((Object)httpClientService.get(mac, url)).andReturn((Object)result);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        EasyMock.expect((Object)result.getResult()).andReturn((Object)HTTPClientServiceResult.Result.OK).times(2);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.OK;
        String body = "testBody";
        EasyMock.expect((Object)result.getBodyAsText()).andReturn((Object)body);
        response.body = body;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendNoAnswer() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        URL url = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andReturn((Object)url);
        EasyMock.expect((Object)httpClientService.get(mac, url)).andReturn((Object)result);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        EasyMock.expect((Object)result.getResult()).andReturn((Object)HTTPClientServiceResult.Result.NOANSWER).times(2);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.FAILED_NOANSWER;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendNoAccess() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        URL url = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andReturn((Object)url);
        EasyMock.expect((Object)httpClientService.get(mac, url)).andReturn((Object)result);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        EasyMock.expect((Object)result.getResult()).andReturn((Object)HTTPClientServiceResult.Result.NOACCESS).times(2);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.FAILED_NOANSWER;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendError() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        URL url = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andReturn((Object)url);
        EasyMock.expect((Object)httpClientService.get(mac, url)).andReturn((Object)result);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        EasyMock.expect((Object)result.getResult()).andReturn((Object)HTTPClientServiceResult.Result.ERROR).times(2);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.ERROR;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendNullResult() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        HTTPClientServiceResult result = (HTTPClientServiceResult)PowerMock.createMock(HTTPClientServiceResult.class);
        URL url = (URL)PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andReturn((Object)url);
        EasyMock.expect((Object)httpClientService.get(mac, url)).andReturn((Object)result);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        EasyMock.expect((Object)result.getResult()).andReturn(null).times(2);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.ERROR;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMalformedUrl() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{rawUrl}).andThrow((Throwable)new MalformedURLException());
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[]{GatewayClientResponse.GatewayClientResponseStatus.FAILED_MALFORMEDURL}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendDeviceDisconnected() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[]{GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendInvalidMac() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        String mac = "00:00:00:00:00:00";
        String rawUrl = "http://192.168.1.2/test";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)true);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[]{GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.send(mac, rawUrl);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientMACByIdSuccessfully() throws InvalidSessionException {
        Integer clientId = 1;
        String clientMac = "testMac";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientById(Integer.valueOf(1), false)).andReturn((Object)client);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)clientMac);
        PowerMock.replayAll((Object[])new Object[0]);
        String mac = this.gatewayClientService.getGatewayClientMACById(clientId);
        Assert.assertEquals((Object)clientMac, (Object)mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientMACByIdNotFouend() throws InvalidSessionException {
        Integer clientId = 1;
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientById(Integer.valueOf(1), false)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String mac = this.gatewayClientService.getGatewayClientMACById(clientId);
        Assert.assertEquals(null, (Object)mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogsSuccessfly() throws Exception {
        String mac = "00:1A:B6:00:0B:B5";
        ArrayList<Debuglog> debuglogs = new ArrayList<Debuglog>();
        String loggerName = "loggerName";
        String ndc = "ndc";
        String message = "message";
        String thread = "thread";
        Integer timestampSec = 1;
        Integer timestampUSec = 2;
        String file = "file";
        Integer line = 3;
        Debuglog debuglog1 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog1);
        Debuglog debuglog2 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog2);
        Debuglog debuglog3 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog3);
        Debuglog debuglog4 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog4);
        Debuglog debuglog5 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog5);
        Debuglog debuglog6 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog6);
        Debuglog debuglog7 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog7);
        Debuglog debuglog8 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog8);
        Debuglog debuglog9 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog9);
        Debuglog debuglog10 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog10);
        Debuglog debuglog11 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog11);
        Debuglog debuglog12 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog12);
        Debuglog debuglog13 = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog13);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.getSize(debuglogs)).andReturn((Object)2);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        DebuglogEntity entity1 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity1);
        EasyMock.expect((Object)debuglog1.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog1.getLogLevel()).andReturn((Object)0);
        EasyMock.expect((Object)debuglog1.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog1.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog1.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog1.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog1.getTimestampUSec()).andReturn((Object)timestampUSec);
        Date timestamp = new Date();
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog1.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog1.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity1.setLoggerName(loggerName);
        entity1.setLogLevel("FATAL");
        entity1.setNdc(ndc);
        entity1.setMessage(message);
        entity1.setThread(thread);
        entity1.setTimestamp(timestamp);
        entity1.setFile(file);
        entity1.setLine(line.intValue());
        entity1.setMac(mac);
        entity1.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity1)).andReturn((Object)entity1);
        DebuglogEntity entity2 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity2);
        EasyMock.expect((Object)debuglog2.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog2.getLogLevel()).andReturn((Object)100);
        EasyMock.expect((Object)debuglog2.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog2.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog2.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog2.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog2.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog2.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog2.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity2.setLoggerName(loggerName);
        entity2.setLogLevel("ALERT");
        entity2.setNdc(ndc);
        entity2.setMessage(message);
        entity2.setThread(thread);
        entity2.setTimestamp(timestamp);
        entity2.setFile(file);
        entity2.setLine(line.intValue());
        entity2.setMac(mac);
        entity2.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity2)).andReturn((Object)entity2);
        DebuglogEntity entity3 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity3);
        EasyMock.expect((Object)debuglog3.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog3.getLogLevel()).andReturn((Object)200);
        EasyMock.expect((Object)debuglog3.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog3.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog3.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog3.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog3.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog3.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog3.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity3.setLoggerName(loggerName);
        entity3.setLogLevel("CRIT");
        entity3.setNdc(ndc);
        entity3.setMessage(message);
        entity3.setThread(thread);
        entity3.setTimestamp(timestamp);
        entity3.setFile(file);
        entity3.setLine(line.intValue());
        entity3.setMac(mac);
        entity3.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity3)).andReturn((Object)entity3);
        DebuglogEntity entity4 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity4);
        EasyMock.expect((Object)debuglog4.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog4.getLogLevel()).andReturn((Object)300);
        EasyMock.expect((Object)debuglog4.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog4.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog4.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog4.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog4.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog4.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog4.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity4.setLoggerName(loggerName);
        entity4.setLogLevel("ERROR");
        entity4.setNdc(ndc);
        entity4.setMessage(message);
        entity4.setThread(thread);
        entity4.setTimestamp(timestamp);
        entity4.setFile(file);
        entity4.setLine(line.intValue());
        entity4.setMac(mac);
        entity4.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity4)).andReturn((Object)entity4);
        DebuglogEntity entity5 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity5);
        EasyMock.expect((Object)debuglog5.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog5.getLogLevel()).andReturn((Object)400);
        EasyMock.expect((Object)debuglog5.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog5.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog5.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog5.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog5.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog5.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog5.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity5.setLoggerName(loggerName);
        entity5.setLogLevel("WARN");
        entity5.setNdc(ndc);
        entity5.setMessage(message);
        entity5.setThread(thread);
        entity5.setTimestamp(timestamp);
        entity5.setFile(file);
        entity5.setLine(line.intValue());
        entity5.setMac(mac);
        entity5.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity5)).andReturn((Object)entity5);
        DebuglogEntity entity6 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity6);
        EasyMock.expect((Object)debuglog6.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog6.getLogLevel()).andReturn((Object)500);
        EasyMock.expect((Object)debuglog6.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog6.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog6.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog6.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog6.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog6.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog6.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity6.setLoggerName(loggerName);
        entity6.setLogLevel("NOTICE");
        entity6.setNdc(ndc);
        entity6.setMessage(message);
        entity6.setThread(thread);
        entity6.setTimestamp(timestamp);
        entity6.setFile(file);
        entity6.setLine(line.intValue());
        entity6.setMac(mac);
        entity6.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity6)).andReturn((Object)entity6);
        DebuglogEntity entity7 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity7);
        EasyMock.expect((Object)debuglog7.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog7.getLogLevel()).andReturn((Object)600);
        EasyMock.expect((Object)debuglog7.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog7.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog7.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog7.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog7.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog7.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog7.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity7.setLoggerName(loggerName);
        entity7.setLogLevel("INFO");
        entity7.setNdc(ndc);
        entity7.setMessage(message);
        entity7.setThread(thread);
        entity7.setTimestamp(timestamp);
        entity7.setFile(file);
        entity7.setLine(line.intValue());
        entity7.setMac(mac);
        entity7.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity7)).andReturn((Object)entity7);
        DebuglogEntity entity8 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity8);
        EasyMock.expect((Object)debuglog8.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog8.getLogLevel()).andReturn((Object)700);
        EasyMock.expect((Object)debuglog8.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog8.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog8.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog8.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog8.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog8.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog8.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity8.setLoggerName(loggerName);
        entity8.setLogLevel("DEBUG");
        entity8.setNdc(ndc);
        entity8.setMessage(message);
        entity8.setThread(thread);
        entity8.setTimestamp(timestamp);
        entity8.setFile(file);
        entity8.setLine(line.intValue());
        entity8.setMac(mac);
        entity8.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity8)).andReturn((Object)entity8);
        DebuglogEntity entity9 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity9);
        EasyMock.expect((Object)debuglog9.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog9.getLogLevel()).andReturn((Object)800);
        EasyMock.expect((Object)debuglog9.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog9.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog9.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog9.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog9.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog9.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog9.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity9.setLoggerName(loggerName);
        entity9.setLogLevel("TRACE");
        entity9.setNdc(ndc);
        entity9.setMessage(message);
        entity9.setThread(thread);
        entity9.setTimestamp(timestamp);
        entity9.setFile(file);
        entity9.setLine(line.intValue());
        entity9.setMac(mac);
        entity9.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity9)).andReturn((Object)entity9);
        DebuglogEntity entity10 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity10);
        EasyMock.expect((Object)debuglog10.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog10.getLogLevel()).andReturn((Object)900);
        EasyMock.expect((Object)debuglog10.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog10.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog10.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog10.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog10.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog10.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog10.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity10.setLoggerName(loggerName);
        entity10.setLogLevel("NOTSET");
        entity10.setNdc(ndc);
        entity10.setMessage(message);
        entity10.setThread(thread);
        entity10.setTimestamp(timestamp);
        entity10.setFile(file);
        entity10.setLine(line.intValue());
        entity10.setMac(mac);
        entity10.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity10)).andReturn((Object)entity10);
        DebuglogEntity entity11 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity11);
        EasyMock.expect((Object)debuglog11.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog11.getLogLevel()).andReturn((Object)1000);
        EasyMock.expect((Object)debuglog11.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog11.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog11.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog11.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog11.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog11.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog11.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity11.setLoggerName(loggerName);
        entity11.setLogLevel("UNKNOWN");
        entity11.setNdc(ndc);
        entity11.setMessage(message);
        entity11.setThread(thread);
        entity11.setTimestamp(timestamp);
        entity11.setFile(file);
        entity11.setLine(line.intValue());
        entity11.setMac(mac);
        entity11.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity11)).andReturn((Object)entity11);
        DebuglogEntity entity12 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity12);
        EasyMock.expect((Object)debuglog12.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog12.getLogLevel()).andReturn(null);
        EasyMock.expect((Object)debuglog12.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog12.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog12.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog12.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog12.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog12.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog12.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity12.setLoggerName(loggerName);
        entity12.setLogLevel(null);
        entity12.setNdc(ndc);
        entity12.setMessage(message);
        entity12.setThread(thread);
        entity12.setTimestamp(timestamp);
        entity12.setFile(file);
        entity12.setLine(line.intValue());
        entity12.setMac(mac);
        entity12.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity12)).andReturn((Object)entity12);
        DebuglogEntity entity13 = (DebuglogEntity)PowerMock.createMock(DebuglogEntity.class);
        PowerMock.expectNew(DebuglogEntity.class, (Object[])new Object[0]).andReturn((Object)entity13);
        EasyMock.expect((Object)debuglog13.getLoggerName()).andReturn((Object)loggerName);
        EasyMock.expect((Object)debuglog13.getLogLevel()).andReturn((Object)1);
        EasyMock.expect((Object)debuglog13.getNdc()).andReturn((Object)ndc);
        EasyMock.expect((Object)debuglog13.getMessage()).andReturn((Object)message);
        EasyMock.expect((Object)debuglog13.getThread()).andReturn((Object)thread);
        EasyMock.expect((Object)debuglog13.getTimestampSec()).andReturn((Object)timestampSec);
        EasyMock.expect((Object)debuglog13.getTimestampUSec()).andReturn((Object)timestampUSec);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.buildDate((Integer)timestampSec, (Integer)timestampUSec)).andReturn((Object)timestamp);
        EasyMock.expect((Object)debuglog13.getFile()).andReturn((Object)file);
        EasyMock.expect((Object)debuglog13.getLine()).andReturn((Object)line);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)"username");
        entity13.setLoggerName(loggerName);
        entity13.setLogLevel(null);
        entity13.setNdc(ndc);
        entity13.setMessage(message);
        entity13.setThread(thread);
        entity13.setTimestamp(timestamp);
        entity13.setFile(file);
        entity13.setLine(line.intValue());
        entity13.setMac(mac);
        entity13.setUsername("username");
        EasyMock.expect((Object)this.debuglogDAO.createDebuglogWithTransaction(entity13)).andReturn((Object)entity13);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.processLogs(mac, debuglogs);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogsNotFoundClients() {
        String mac = "00:1A:B6:00:0B:B5";
        ArrayList<Debuglog> debuglogs = new ArrayList<Debuglog>();
        Debuglog debuglog = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.getSize(debuglogs)).andReturn((Object)1);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.processLogs(mac, debuglogs);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogsEmptyDebulglogs() {
        String mac = "00:1A:B6:00:0B:B5";
        ArrayList debuglogs = new ArrayList();
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.getSize(debuglogs)).andReturn((Object)0);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.processLogs(mac, debuglogs);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogsNullDebulglogs() {
        String mac = "00:1A:B6:00:0B:B5";
        ArrayList debuglogs = new ArrayList();
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.getSize(debuglogs)).andReturn(null);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.processLogs(mac, debuglogs);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogsBlankMac() {
        String mac = "";
        ArrayList<Debuglog> debuglogs = new ArrayList<Debuglog>();
        Debuglog debuglog = (Debuglog)PowerMock.createMock(Debuglog.class);
        debuglogs.add(debuglog);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.getSize(debuglogs)).andReturn((Object)1);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.processLogs(mac, debuglogs);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsSuccessfuly() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)new GatewayDevice("", "", ""));
        ConfigureGCLogsService configureGCLogsService = (ConfigureGCLogsService)PowerMock.createMock(ConfigureGCLogsService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getConfigureGCLogsService()).andReturn((Object)configureGCLogsService);
        EasyMock.expect((Object)configureGCLogsService.configureLogs("00:1A:B6:00:0B:B5", "logsConfiguration")).andReturn((Object)LoggerConfigurationStatus.SUCCESS);
        GatewayClientEntity gatewayClient = TestDataUtils.prepareGatewaClientEntity();
        gatewayClient.setLogConf("logsConfiguration");
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(gatewayClient)).andReturn((Object)gatewayClient);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.SUCCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsFailureNoAnswer() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)new GatewayDevice("", "", ""));
        ConfigureGCLogsService configureGCLogsService = (ConfigureGCLogsService)PowerMock.createMock(ConfigureGCLogsService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getConfigureGCLogsService()).andReturn((Object)configureGCLogsService);
        EasyMock.expect((Object)configureGCLogsService.configureLogs("00:1A:B6:00:0B:B5", "logsConfiguration")).andReturn((Object)LoggerConfigurationStatus.FAILED_NOANSWER);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.FAILED_NOANSWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsFailureNullResponse() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)new GatewayDevice("", "", ""));
        ConfigureGCLogsService configureGCLogsService = (ConfigureGCLogsService)PowerMock.createMock(ConfigureGCLogsService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getConfigureGCLogsService()).andReturn((Object)configureGCLogsService);
        EasyMock.expect((Object)configureGCLogsService.configureLogs("00:1A:B6:00:0B:B5", "logsConfiguration")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsEmptyGcId() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(null, "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.FAILED_INVALIDID, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsNotFoundGC() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.FAILED_GCNOTFOUND, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsSendConfFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn((Object)new GatewayDevice("", "", ""));
        ConfigureGCLogsService configureGCLogsService = (ConfigureGCLogsService)PowerMock.createMock(ConfigureGCLogsService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getConfigureGCLogsService()).andReturn((Object)configureGCLogsService);
        EasyMock.expect((Object)configureGCLogsService.configureLogs("00:1A:B6:00:0B:B5", "logsConfiguration")).andReturn((Object)LoggerConfigurationStatus.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLogsFailureGatewayClientDisconnected() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ConfigureLoggerStatus response = this.gatewayClientService.configureLogs(Integer.valueOf(1), "logsConfiguration");
        Assert.assertEquals((Object)ConfigureLoggerStatus.FAILED_GCNOTCONNECTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardUpnpWorksStatus() throws Exception {
        String mac = "testMac";
        UpnpForwardingState state = UpnpForwardingState.Works;
        Integer upnpPort = 15800;
        Integer statusCode = 0;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, upnpReason)).andReturn(null);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "OK", "testReason: 15800");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forwardUpnpStatus(mac, state, upnpPort, statusCode, upnpReason, publicIp);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardUpnpNotWorksStatus() throws Exception {
        String mac = "testMac";
        UpnpForwardingState state = UpnpForwardingState.Checking;
        Integer upnpPort = 15800;
        Integer statusCode = 0;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, upnpReason)).andReturn(null);
        this.domainService.tearDownDomain(mac, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "FAILED", "testReason: 15800");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forwardUpnpStatus(mac, state, upnpPort, statusCode, upnpReason, publicIp);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingWorksWithNullPort() throws Exception {
        String mac = "00:00:00:00:00:01";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        UpnpForwardingService upnpService = (UpnpForwardingService)PowerMock.createMock(UpnpForwardingService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getUpnpForwardingService()).andReturn((Object)upnpService);
        Integer upnpPort = 123;
        EasyMock.expect((Object)client.getUpnpPort()).andReturn((Object)upnpPort);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpService.setUpUpnpForwarding(mac, upnpPort)).andReturn((Object)result);
        UpnpForwardingState state = UpnpForwardingState.Works;
        Integer statusCode = 15800;
        String reason = "Success";
        String publicIp = "11:11:11:11";
        EasyMock.expect((Object)result.getState()).andReturn((Object)state);
        EasyMock.expect((Object)result.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)result.getStatusCode()).andReturn((Object)statusCode);
        EasyMock.expect((Object)result.getReason()).andReturn((Object)reason);
        EasyMock.expect((Object)result.getPublicIp()).andReturn((Object)publicIp);
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, reason)).andReturn(null);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "OK", "Success: 123");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.setUpUpnpForwarding(mac, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingWorksWithNotNullPort() throws Exception {
        String mac = "00:00:00:00:00:01";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        UpnpForwardingService upnpService = (UpnpForwardingService)PowerMock.createMock(UpnpForwardingService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getUpnpForwardingService()).andReturn((Object)upnpService);
        Integer upnpPort = 123;
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpService.setUpUpnpForwarding(mac, upnpPort)).andReturn((Object)result);
        UpnpForwardingState state = UpnpForwardingState.Works;
        Integer statusCode = 0;
        String reason = "Success";
        String publicIp = "11:11:11:11";
        EasyMock.expect((Object)result.getState()).andReturn((Object)state);
        EasyMock.expect((Object)result.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)result.getStatusCode()).andReturn((Object)statusCode);
        EasyMock.expect((Object)result.getReason()).andReturn((Object)reason);
        EasyMock.expect((Object)result.getPublicIp()).andReturn((Object)publicIp);
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, reason)).andReturn(null);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "OK", "Success: 123");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.setUpUpnpForwarding(mac, upnpPort);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingNotWorksWithNullPort() throws Exception {
        String mac = "00:00:00:00:00:01";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        UpnpForwardingService upnpService = (UpnpForwardingService)PowerMock.createMock(UpnpForwardingService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getUpnpForwardingService()).andReturn((Object)upnpService);
        Integer upnpPort = 123;
        EasyMock.expect((Object)client.getUpnpPort()).andReturn((Object)upnpPort);
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpService.setUpUpnpForwarding(mac, upnpPort)).andReturn((Object)result);
        UpnpForwardingState state = UpnpForwardingState.Checking;
        Integer statusCode = 0;
        String reason = "testReason";
        String publicIp = "11:11:11:11";
        EasyMock.expect((Object)result.getState()).andReturn((Object)state);
        EasyMock.expect((Object)result.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)result.getStatusCode()).andReturn((Object)statusCode);
        EasyMock.expect((Object)result.getReason()).andReturn((Object)reason);
        EasyMock.expect((Object)result.getPublicIp()).andReturn((Object)publicIp);
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, reason)).andReturn(null);
        this.domainService.tearDownDomain(mac, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "FAILED", "testReason: 123");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.setUpUpnpForwarding(mac, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingNotWorksWithNotNullPort() throws Exception {
        String mac = "00:00:00:00:00:01";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        UpnpForwardingService upnpService = (UpnpForwardingService)PowerMock.createMock(UpnpForwardingService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getUpnpForwardingService()).andReturn((Object)upnpService);
        Integer upnpPort = 123;
        SetUpUpnpForwardingResult result = (SetUpUpnpForwardingResult)PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect((Object)upnpService.setUpUpnpForwarding(mac, upnpPort)).andReturn((Object)result);
        UpnpForwardingState state = UpnpForwardingState.Checking;
        Integer statusCode = 0;
        String reason = "testReason";
        String publicIp = "11:11:11:11";
        EasyMock.expect((Object)result.getState()).andReturn((Object)state);
        EasyMock.expect((Object)result.getUpnpPort()).andReturn((Object)upnpPort);
        EasyMock.expect((Object)result.getStatusCode()).andReturn((Object)statusCode);
        EasyMock.expect((Object)result.getReason()).andReturn((Object)reason);
        EasyMock.expect((Object)result.getPublicIp()).andReturn((Object)publicIp);
        HashMap params = (HashMap)PowerMock.createMock(HashMap.class);
        PowerMock.expectNew(HashMap.class, (Object[])new Object[0]).andReturn((Object)params);
        EasyMock.expect((Object)params.put(DomainService.Param.UPNP_PORT, upnpPort)).andReturn(null);
        EasyMock.expect((Object)params.put(DomainService.Param.REASON, reason)).andReturn(null);
        this.domainService.tearDownDomain(mac, DomainService.Type.PUBLIC, (Map)params);
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, "FAILED", "testReason: 123");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.setUpUpnpForwarding(mac, upnpPort);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(this.prepareGatewayClientEntity(Integer.valueOf(1), "11:11:11:11:11:11", "gc1"));
        clients.add(this.prepareGatewayClientEntity(Integer.valueOf(2), "22:22:22:22:22:22", "gc2"));
        clients.add(this.prepareGatewayClientEntity(Integer.valueOf(3), "33:33:33:33:33:33", "gc3"));
        EasyMock.expect((Object)this.gatewayClientDAO.getGatewayClients("2.7", Integer.valueOf(289), Integer.valueOf(5))).andReturn(clients);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("11:11:11:11:11:11")).andReturn((Object)new GatewayDevice("11:11:11:11:11:11", null, null));
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade("11:11:11:11:11:11")).andReturn((Object)true);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)"11:11:11:11:11:11")).andReturn((Object)false);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("22:22:22:22:22:22")).andReturn(null);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)"22:22:22:22:22:22")).andReturn((Object)false);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("33:33:33:33:33:33")).andReturn((Object)new GatewayDevice("33:33:33:33:33:33", null, null));
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade("33:33:33:33:33:33")).andReturn((Object)true);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)"33:33:33:33:33:33")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)2, (Object)this.gatewayClientService.updateGatewayClients("2.7 (289)", Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsWithVersionNullAndBuildNoNullSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(this.prepareGatewayClientEntity(Integer.valueOf(1), "11:11:11:11:11:11", "gc1"));
        EasyMock.expect((Object)this.gatewayClientDAO.getGatewayClients(null, null, Integer.valueOf(5))).andReturn(clients);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("11:11:11:11:11:11")).andReturn((Object)new GatewayDevice("11:11:11:11:11:11", null, null));
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade("11:11:11:11:11:11")).andReturn((Object)true);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)"11:11:11:11:11:11")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)1, (Object)this.gatewayClientService.updateGatewayClients("null (null)", Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    public void testUpdateGatewayClientsFailure(String version) throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.updateGatewayClients(version, Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsFailureNullVersion() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.updateGatewayClients(null, Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsFailureEmptyVersion() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.updateGatewayClients(null, Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsFailureMissingVersionOpeningParenthesis() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.updateGatewayClients("2 3)", Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientsFailureMissingVersionClosingParenthesis() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.gatewayClientService.updateGatewayClients("2 (3", Integer.valueOf(5)));
        PowerMock.verifyAll();
    }

    private GatewayClientEntity prepareGatewayClientEntity(Integer gatewayClientId, String mac, String name) {
        GatewayClientEntity client = new GatewayClientEntity();
        client.setGatewayClientId(gatewayClientId);
        client.setMac(mac);
        client.setName(name);
        client.setSerialNumber(mac);
        client.setDeleted(false);
        return client;
    }

    @Test
    public void testGetGCSummarySomeValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        summary.put("ver1", 1);
        summary.put("ver2", 2);
        summary.put("ver3", 3);
        EasyMock.expect((Object)this.gatewayClientDAO.countGatewayClientsForEachVersion()).andReturn(summary);
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.gatewayClientService.getGCSummary();
        Assert.assertEquals(summary, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGCSummaryNoneValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        HashMap summary = new HashMap();
        EasyMock.expect((Object)this.gatewayClientDAO.countGatewayClientsForEachVersion()).andReturn(summary);
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.gatewayClientService.getGCSummary();
        Assert.assertEquals(summary, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGCSummaryNullValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.countGatewayClientsForEachVersion()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.gatewayClientService.getGCSummary();
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientsByVerionSomeValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<GcMacId> gcs = new ArrayList<GcMacId>();
        gcs.add(new GcMacId("11:11:11:11:11:11", Integer.valueOf(1)));
        gcs.add(new GcMacId("22:22:22:22:22:22", Integer.valueOf(2)));
        gcs.add(new GcMacId("33:33:33:33:33:33", Integer.valueOf(3)));
        EasyMock.expect((Object)this.gatewayClientDAO.getGatewayClientsForVersion("ver1")).andReturn(gcs);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.gatewayClientService.getGatewayClientsByVerion("ver1");
        Assert.assertEquals(gcs, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientsByVerionNoneValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList gcs = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.getGatewayClientsForVersion("ver1")).andReturn(gcs);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.gatewayClientService.getGatewayClientsByVerion("ver1");
        Assert.assertEquals(gcs, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetGatewayClientsByVerionNullValues() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.getGatewayClientsForVersion("ver1")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.gatewayClientService.getGatewayClientsByVerion("ver1");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyWithDedicatedAccessDataAndWithoutForceCheck() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        String deviceUsername = "deviceUsername";
        String devicePassword = "devicePassword";
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)1);
        EasyMock.expect((Object)((LanDeviceEntity)devices.get(0))).andReturn((Object)device).times(2);
        EasyMock.expect((Object)device.getUsername()).andReturn((Object)deviceUsername);
        EasyMock.expect((Object)device.getPass()).andReturn((Object)devicePassword);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.SUCCESS, deviceUsername, devicePassword}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyWithDefaultAccessDataWithoutForceCheck() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)0);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.SUCCESS, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyWithForceCheckAndConnctedDevice() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        boolean forceGCCheck = true;
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)0);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.SUCCESS, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode, forceGCCheck);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyWithForceCheckAndDisconnctedDeviceAndMacActivationCode() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        boolean forceGCCheck = true;
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)0);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        boolean macActivationCode = true;
        EasyMock.expect((Object)this.activationCodeHandler.isMacAddress(activationCode)).andReturn((Object)macActivationCode);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED_TRYINSTALL, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode, forceGCCheck);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyWithForceCheckAndDisconnctedDeviceAndActivationCode() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        boolean forceGCCheck = true;
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)0);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        boolean macActivationCode = false;
        EasyMock.expect((Object)this.activationCodeHandler.isMacAddress(activationCode)).andReturn((Object)macActivationCode);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode, forceGCCheck);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyMultiRegistration() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)true);
        ArrayList devices = (ArrayList)PowerMock.createMock(ArrayList.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac(mac)).andReturn((Object)devices);
        EasyMock.expect((Object)devices.size()).andReturn((Object)0);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.SUCCESS, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientSuccessfullyAnotherAccountAssigned() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        String mac = "testMac";
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn((Object)mac);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS)).andReturn((Object)false);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer currentUserId = 345;
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        UserEntity client1Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        UserEntity client2Owner = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)client1.getUser()).andReturn((Object)client1Owner);
        EasyMock.expect((Object)client1Owner.getId()).andReturn((Object)1);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)client2.getUser()).andReturn((Object)client2Owner);
        EasyMock.expect((Object)client2Owner.getId()).andReturn((Object)2);
        EasyMock.expect((Object)currentUser.getId()).andReturn((Object)currentUserId);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.FAILED_ANOTHERACCOUNTASSIGNED, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyGatewayClientIncorrectCode() throws Exception {
        this.authUtils.ensureLoggedIn();
        String activationCode = "testActivationCode";
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress(activationCode)).andReturn(null);
        VerifyGcResponse reponse = (VerifyGcResponse)PowerMock.createMock(VerifyGcResponse.class);
        PowerMock.expectNew(VerifyGcResponse.class, (Object[])new Object[]{VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT, "root", ""}).andReturn((Object)reponse);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyGcResponse actualEesponse = this.gatewayClientService.verifyGatewayClient(activationCode);
        Assert.assertEquals((Object)reponse, (Object)actualEesponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testRunScriptFailureDeviceDissconnected() throws Exception {
        String mac = "00:00:00:00:00:00";
        String scriptname = "scriptname";
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[]{GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.runScript(mac, scriptname);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testRunScriptFailureInvalidMac() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank(null)).andReturn((Object)true);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[]{GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)response, (Object)this.gatewayClientService.runScript(null, "scriptname"));
        PowerMock.verifyAll();
    }

    @Test
    public void testRunScriptFailureNullResult() throws Exception {
        String mac = "00:00:00:00:00:00";
        String command = "command";
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)execCmdService.executeCommand(mac, command)).andReturn(null);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.ERROR;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.runScript(mac, command);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testRunScriptSuccecfully() throws Exception {
        String mac = "00:00:00:00:00:00";
        String command = "command";
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        CommandResult result = (CommandResult)PowerMock.createMock(CommandResult.class);
        EasyMock.expect((Object)execCmdService.executeCommand(mac, command)).andReturn((Object)result);
        String output = "output";
        EasyMock.expect((Object)result.getOutput()).andReturn((Object)output);
        int statusCode = 2;
        EasyMock.expect((Object)result.getStatusCode()).andReturn((Object)statusCode);
        GatewayClientResponse response = (GatewayClientResponse)PowerMock.createMock(GatewayClientResponse.class);
        PowerMock.expectNew(GatewayClientResponse.class, (Object[])new Object[0]).andReturn((Object)response);
        response.status = GatewayClientResponse.GatewayClientResponseStatus.OK;
        response.statusCode = statusCode;
        response.body = output;
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse actualResponse = this.gatewayClientService.runScript(mac, command);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgrade() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse response = this.gatewayClientService.forceUpgrade(mac);
        Assert.assertEquals((Object)response.status, (Object)GatewayClientResponse.GatewayClientResponseStatus.OK);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeEmptyMac() throws InvalidSessionException {
        String mac = null;
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse response = this.gatewayClientService.forceUpgrade(mac);
        Assert.assertEquals((Object)response.status, (Object)GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeDisconnected() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GatewayClientResponse response = this.gatewayClientService.forceUpgrade(mac);
        Assert.assertEquals((Object)response.status, (Object)GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredNoReboot() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        GatewayClientEntity client3 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)client1.isForceReboot()).andReturn((Object)false);
        EasyMock.expect((Object)client2.isForceReboot()).andReturn((Object)false);
        EasyMock.expect((Object)client3.isForceReboot()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertFalse((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredRebootOldGDClient() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        GatewayClientEntity client3 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)client1.isForceReboot()).andReturn((Object)false);
        EasyMock.expect((Object)client2.isForceReboot()).andReturn((Object)true);
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)device.getVersion()).andReturn((Object)"2.7");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"3.5");
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)"2.7", (String)"3.5")).andReturn((Object)false);
        CommandResult cmdResult = (CommandResult)PowerMock.createMock(CommandResult.class);
        EasyMock.expect((Object)client1.getSerialNumber()).andReturn((Object)mac);
        EasyMock.expect((Object)execCmdService.executeCommand(mac, "reboot &")).andReturn((Object)cmdResult);
        EasyMock.expect((Object)cmdResult.getStatusCode()).andReturn((Object)0);
        client1.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client1)).andReturn((Object)client1);
        client2.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client2)).andReturn((Object)client2);
        client3.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client3)).andReturn((Object)client3);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertTrue((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredRebootNewGDClient() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        GatewayClientEntity client3 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)client1.isForceReboot()).andReturn((Object)false);
        EasyMock.expect((Object)client2.isForceReboot()).andReturn((Object)true);
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)device.getVersion()).andReturn((Object)"3.5");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"3.5");
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)"3.5", (String)"3.5")).andReturn((Object)true);
        CommandResult cmdResult = (CommandResult)PowerMock.createMock(CommandResult.class);
        EasyMock.expect((Object)client1.getSerialNumber()).andReturn((Object)mac);
        EasyMock.expect((Object)execCmdService.executeCommand(mac, "reboot.sh")).andReturn((Object)cmdResult);
        EasyMock.expect((Object)cmdResult.getStatusCode()).andReturn((Object)0);
        client1.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client1)).andReturn((Object)client1);
        client2.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client2)).andReturn((Object)client2);
        client3.setForceReboot(false);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client3)).andReturn((Object)client3);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertTrue((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredRebootFailed() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        GatewayClientEntity client3 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)client1.isForceReboot()).andReturn((Object)false);
        EasyMock.expect((Object)client2.isForceReboot()).andReturn((Object)true);
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)device.getVersion()).andReturn((Object)"3.5");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"3.5");
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)"3.5", (String)"3.5")).andReturn((Object)true);
        CommandResult cmdResult = (CommandResult)PowerMock.createMock(CommandResult.class);
        EasyMock.expect((Object)client1.getSerialNumber()).andReturn((Object)mac);
        EasyMock.expect((Object)execCmdService.executeCommand(mac, "reboot.sh")).andReturn((Object)cmdResult);
        EasyMock.expect((Object)cmdResult.getStatusCode()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertFalse((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredRebootNotConnected() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertFalse((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceRebootIfRequiredRebootBlankMac() {
        String mac = "";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean result = this.gatewayClientService.forceRebootIfRequired(mac);
        Assert.assertFalse((boolean)result);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredNotConnected() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredNoGatewayClient() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredNoGatewayClientVersion() {
        String mac = "00:11:22:33:44:55";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)device);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredLowerVersion() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String deviceVersion = "2.7";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientVersionEntity gatewayClientVersion = (GatewayClientVersionEntity)PowerMock.createMock(GatewayClientVersionEntity.class);
        String minClientVersion = "3.5";
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn((Object)gatewayClientVersion);
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)deviceVersion);
        EasyMock.expect((Object)gatewayClientVersion.getMinVersion()).andReturn((Object)minClientVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)minClientVersion)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MAX_VERSION_FOR_FORCE_REBOOT)).andReturn(null);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredEqualOrHigherVersion() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String deviceVersion = "3.5";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientVersionEntity gatewayClientVersion = (GatewayClientVersionEntity)PowerMock.createMock(GatewayClientVersionEntity.class);
        String minClientVersion = "3.5";
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn((Object)gatewayClientVersion);
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)deviceVersion);
        EasyMock.expect((Object)gatewayClientVersion.getMinVersion()).andReturn((Object)minClientVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)minClientVersion)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredRebootLowerVersion() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String deviceVersion = "3.0";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientVersionEntity gatewayClientVersion = (GatewayClientVersionEntity)PowerMock.createMock(GatewayClientVersionEntity.class);
        String minClientVersion = "3.5";
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn((Object)gatewayClientVersion);
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)deviceVersion);
        EasyMock.expect((Object)gatewayClientVersion.getMinVersion()).andReturn((Object)minClientVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)minClientVersion)).andReturn((Object)false).times(2);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MAX_VERSION_FOR_FORCE_REBOOT)).andReturn((Object)"3.5");
        client1.setForceReboot(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client1)).andReturn((Object)client1);
        client2.setForceReboot(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client2)).andReturn((Object)client2);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredRebootEqualVersion() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String deviceVersion = "3.0";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientVersionEntity gatewayClientVersion = (GatewayClientVersionEntity)PowerMock.createMock(GatewayClientVersionEntity.class);
        String minClientVersion = "3.5";
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn((Object)gatewayClientVersion);
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)deviceVersion);
        EasyMock.expect((Object)gatewayClientVersion.getMinVersion()).andReturn((Object)minClientVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)minClientVersion)).andReturn((Object)false);
        String forceVersion = "3.0";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MAX_VERSION_FOR_FORCE_REBOOT)).andReturn((Object)forceVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)forceVersion)).andReturn((Object)false);
        client1.setForceReboot(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client1)).andReturn((Object)client1);
        client2.setForceReboot(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client2)).andReturn((Object)client2);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeIfRequiredRebootHigherVersion() throws InvalidSessionException {
        String mac = "00:11:22:33:44:55";
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String deviceVersion = "3.0";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientVersionEntity gatewayClientVersion = (GatewayClientVersionEntity)PowerMock.createMock(GatewayClientVersionEntity.class);
        String minClientVersion = "3.5";
        EasyMock.expect((Object)this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac)).andReturn((Object)gatewayClientVersion);
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)deviceVersion);
        EasyMock.expect((Object)gatewayClientVersion.getMinVersion()).andReturn((Object)minClientVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)minClientVersion)).andReturn((Object)false);
        String forceVersion = "2.7";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MAX_VERSION_FOR_FORCE_REBOOT)).andReturn((Object)forceVersion);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isAtMinimalVersion((String)deviceVersion, (String)forceVersion)).andReturn((Object)true);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.gatewayDeviceConnection.forceUpgrade(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCommServerUrlSuccessfully() throws Exception {
        String mac = "testMac";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)false);
        String url = "testUrl";
        EasyMock.expect((Object)this.connector.getVeryfiedServerUrl(mac)).andReturn((Object)url);
        GetCommServerUrlResponse response = (GetCommServerUrlResponse)PowerMock.createMock(GetCommServerUrlResponse.class);
        PowerMock.expectNew(GetCommServerUrlResponse.class, (Object[])new Object[]{GetCommServerUrlResponse.Status.SUCCESS, url}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetCommServerUrlResponse actual = this.gatewayClientService.getCommServerUrl(mac);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCommServerUrlBlankMac() throws Exception {
        String mac = "";
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.isBlank((String)mac)).andReturn((Object)true);
        GetCommServerUrlResponse response = (GetCommServerUrlResponse)PowerMock.createMock(GetCommServerUrlResponse.class);
        PowerMock.expectNew(GetCommServerUrlResponse.class, (Object[])new Object[]{GetCommServerUrlResponse.ErrorCode.NO_MAC}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        GetCommServerUrlResponse actual = this.gatewayClientService.getCommServerUrl(mac);
        Assert.assertEquals((Object)response, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusConnectedWithExistingSession() throws Exception {
        String mac = "testMac";
        boolean connected = true;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientSessionEntity foundSession = (GatewayClientSessionEntity)PowerMock.createMock(GatewayClientSessionEntity.class);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn((Object)foundSession);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        GatewayClientSessionEntity newSession = (GatewayClientSessionEntity)PowerMock.createMock(GatewayClientSessionEntity.class);
        PowerMock.expectNew(GatewayClientSessionEntity.class, (Object[])new Object[]{gatewayDevice, serverUrl}).andReturn((Object)newSession);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.updateGatewayClientSession(newSession)).andReturn((Object)newSession);
        int buildNo = 1;
        EasyMock.expect((Object)gatewayDevice.getBuildNo()).andReturn((Object)buildNo).times(2);
        String version = "1.0";
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)version).times(2);
        Date connectedDate = new Date();
        EasyMock.expect((Object)gatewayDevice.getConnectedDate()).andReturn((Object)connectedDate).times(2);
        client1.setBuildNo(Integer.valueOf(buildNo));
        client1.setVersion(version);
        client1.setConnectedDate(connectedDate);
        client2.setBuildNo(Integer.valueOf(buildNo));
        client2.setVersion(version);
        client2.setConnectedDate(connectedDate);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client1)).andReturn((Object)client1);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client2)).andReturn((Object)client2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusConnectedWithoutExistingSession() throws Exception {
        String mac = "testMac";
        boolean connected = true;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        Object foundSession = null;
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn(foundSession);
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn((Object)gatewayDevice);
        GatewayClientSessionEntity newSession = (GatewayClientSessionEntity)PowerMock.createMock(GatewayClientSessionEntity.class);
        PowerMock.expectNew(GatewayClientSessionEntity.class, (Object[])new Object[]{gatewayDevice, serverUrl}).andReturn((Object)newSession);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.saveGatewayClientSession(newSession)).andReturn((Object)newSession);
        int buildNo = 1;
        EasyMock.expect((Object)gatewayDevice.getBuildNo()).andReturn((Object)buildNo).times(2);
        String version = "1.0";
        EasyMock.expect((Object)gatewayDevice.getVersion()).andReturn((Object)version).times(2);
        Date connectedDate = new Date();
        EasyMock.expect((Object)gatewayDevice.getConnectedDate()).andReturn((Object)connectedDate).times(2);
        client1.setBuildNo(Integer.valueOf(buildNo));
        client1.setVersion(version);
        client1.setConnectedDate(connectedDate);
        client2.setBuildNo(Integer.valueOf(buildNo));
        client2.setVersion(version);
        client2.setConnectedDate(connectedDate);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client1)).andReturn((Object)client1);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client2)).andReturn((Object)client2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusCconnectedAndNotFoundDevice() throws Exception {
        String mac = "testMac";
        boolean connected = true;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        Object foundSession = null;
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn(foundSession);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusDisconnectedFromTheSameServer() throws Exception {
        String mac = "testMac";
        boolean connected = false;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientSessionEntity foundSession = (GatewayClientSessionEntity)PowerMock.createMock(GatewayClientSessionEntity.class);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn((Object)foundSession);
        Date disconnectedDate = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)disconnectedDate).times(2);
        client1.setDisconnectedDate(disconnectedDate);
        client2.setDisconnectedDate(disconnectedDate);
        EasyMock.expect((Object)foundSession.getServerUrl()).andReturn((Object)serverUrl);
        EasyMock.expect((Object)foundSession.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.removeGatewayClientSession(mac)).andReturn((Object)true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client1)).andReturn((Object)client1);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client2)).andReturn((Object)client2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusDisconnectedFromAnotherServer() throws Exception {
        String mac = "testMac";
        boolean connected = false;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        GatewayClientSessionEntity foundSession = (GatewayClientSessionEntity)PowerMock.createMock(GatewayClientSessionEntity.class);
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn((Object)foundSession);
        Date disconnectedDate = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)disconnectedDate).times(2);
        client1.setDisconnectedDate(disconnectedDate);
        client2.setDisconnectedDate(disconnectedDate);
        EasyMock.expect((Object)foundSession.getServerUrl()).andReturn((Object)"someAnotherServerUrl");
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client1)).andReturn((Object)client1);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client2)).andReturn((Object)client2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGatewayClientStatusDisconnectedWithoutExistingSession() throws Exception {
        String mac = "testMac";
        boolean connected = false;
        String serverUrl = "testServerUrl";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        Object foundSession = null;
        EasyMock.expect((Object)this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac)).andReturn(foundSession);
        Date disconnectedDate = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)disconnectedDate).times(2);
        client1.setDisconnectedDate(disconnectedDate);
        client2.setDisconnectedDate(disconnectedDate);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client1)).andReturn((Object)client1);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(client2)).andReturn((Object)client2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.updateGatewayClientStatus(mac, connected, serverUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceIdsWithSomeClients() {
        String mac = "testMac";
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client1);
        GatewayClientEntity client2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client2);
        GatewayClientEntity client3 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        clients.add(client3);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)client1.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)client1.getGatewayClientId()).andReturn((Object)1);
        EasyMock.expect((Object)client2.getDeleted()).andReturn((Object)true);
        EasyMock.expect((Object)client3.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)client3.getGatewayClientId()).andReturn((Object)3);
        PowerMock.replayAll((Object[])new Object[0]);
        Set actual = this.gatewayClientService.getDeviceIds(mac);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(1);
        expected.add(3);
        Assert.assertEquals(expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceIdsWithNoClients() {
        String mac = "testMac";
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        Set actual = this.gatewayClientService.getDeviceIds(mac);
        HashSet expected = new HashSet();
        Assert.assertEquals(expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testGetDeviceIdsWithNullMac() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.gatewayClientService.getDeviceIds(null);
        PowerMock.verifyAll();
    }
}

