/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.ConfigureGCLogsService;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.UpnpForwardingService;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.hm.WebViewer.shared.model.ConfigureLoggerStatus;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.GcMacId;
import pl.smartapps.restserver.db.dao.DebuglogDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.GatewayClientSessionDAO;
import pl.smartapps.restserver.db.dao.GatewayClientVersionDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.DebuglogEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.GatewayClientSessionEntity;
import pl.smartapps.restserver.db.main.GatewayClientVersionEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ActivateGcResponse;
import pl.smartapps.restserver.rest.response.GCStatusResponse;
import pl.smartapps.restserver.rest.response.GatewayClientResponse;
import pl.smartapps.restserver.rest.response.GetCommServerUrlResponse;
import pl.smartapps.restserver.rest.response.RemoveResponse;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.ActivationCodeHandler;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.GatewayClientServiceImpl;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GatewayClientServiceImpl
implements GatewayClientService {
    private static final String UNSUCCESSFUL_ATTEMPT_COUNT = "unsuccessful_attempt_count";
    private static Logger log = Logger.getLogger(GatewayClientServiceImpl.class);
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private GatewayClientVersionDAO gatewayClientVersionDAO;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private AuthenticationUtils authUtils;
    private EventlogService eventlogService;
    private ActivationCodeHandler activationCodeHandler;
    private DeviceDriverFactory deviceDriverFactory;
    private DebuglogDAO debuglogDAO;
    private ContainerserverServiceFactory containerserverServiceFactory;
    private SystemSupport systemSupport;
    private ParameterService parameterService;
    private Connector connector;
    private GatewayClientSessionDAO gatewayClientSessionDAO;
    private DomainService domainService;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setGatewayClientVersionDAO(GatewayClientVersionDAO gatewayClientVersionDAO) {
        this.gatewayClientVersionDAO = gatewayClientVersionDAO;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnectionService gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setActivationCodeHandler(ActivationCodeHandler activationCodeHandler) {
        this.activationCodeHandler = activationCodeHandler;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setDebuglogDAO(DebuglogDAO debuglogDAO) {
        this.debuglogDAO = debuglogDAO;
    }

    @Autowired
    @Required
    public void setContainerserverServiceFactory(ContainerserverServiceFactory containerserverServiceFactory) {
        this.containerserverServiceFactory = containerserverServiceFactory;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Autowired
    @Required
    public void setGatewayClientSessionDAO(GatewayClientSessionDAO gatewayClientSessionDAO) {
        this.gatewayClientSessionDAO = gatewayClientSessionDAO;
    }

    @Autowired
    @Required
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public List<GatewayClient> getGatewayClients() throws InvalidSessionException {
        log.trace((Object)"start getGatewayClients()");
        this.authUtils.ensureLoggedIn();
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsWithCorrectDevicesByUserId(this.authUtils.getCurrentUserId());
        return GatewayClientEntity.toDTOs((List)gatewayClients, (GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (boolean)false, (boolean)false);
    }

    public List<GatewayClient> getAllGatewayClients() throws InvalidSessionException {
        log.trace((Object)"start getGatewayClients()");
        this.authUtils.ensureLoggedIn();
        List gatewayClients = this.gatewayClientDAO.findGatewayClients(this.authUtils.getCurrentUserId(), false);
        return GatewayClientEntity.toDTOs((List)gatewayClients, (GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (boolean)false, (boolean)false);
    }

    @Transactional
    public ActivateGcResponse activeteGatewaClient(String code) throws InvalidSessionException {
        log.trace((Object)("start activeteGatewaClient(code=" + code + ")"));
        this.authUtils.ensureLoggedIn();
        String mac = this.activationCodeHandler.getMacAddress(code);
        if (mac == null) {
            log.debug((Object)"Incorrect code");
            this.delay(this.getUnsuccessfulAttemptCount() * 2);
            this.increaseUnsuccessfulAttemptCount();
            this.eventlogService.registerEventlog(GCEventType.ACTIVATE, null, null, ActivateGcResponse.ActivateStatus.INCORRECTCODE.name(), null);
            return new ActivateGcResponse(ActivateGcResponse.ActivateStatus.INCORRECTCODE);
        }
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        ActivateGcResponse.ActivateStatus status = ActivateGcResponse.ActivateStatus.ERROR;
        if (!gatewayClients.isEmpty() && !this.isMultiRegistrationEnabled()) {
            this.eventlogService.registerEventlog(GCEventType.ACTIVATE, mac, null, ActivateGcResponse.ActivateStatus.ALREADYACTIVATED.name(), null);
            GatewayClientEntity userClient = this.getClientBelongsToUser(gatewayClients, this.authUtils.getCurrentUser());
            if (userClient == null) {
                return new ActivateGcResponse(ActivateGcResponse.ActivateStatus.ANOTHERACCOUNTASSIGNED);
            }
            return new ActivateGcResponse(ActivateGcResponse.ActivateStatus.ALREADYACTIVATED, userClient.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, false, false));
        }
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(mac);
        if (gatewayDevice != null) {
            GatewayClientEntity gatewayClient = new GatewayClientEntity();
            gatewayClient.setSerialNumber(mac);
            gatewayClient.setMac(mac);
            gatewayClient.setName(mac);
            gatewayClient.setDeleted(false);
            gatewayClient.setActivationDate(new Date());
            gatewayClient.setUser(this.authUtils.getCurrentUser());
            gatewayClient.setDeviceType(gatewayDevice.getDeviceType());
            gatewayClient = this.gatewayClientDAO.saveGatewayClient(gatewayClient);
            if (gatewayClient == null) {
                status = ActivateGcResponse.ActivateStatus.ERROR;
                this.eventlogService.registerEventlog(GCEventType.ACTIVATE, gatewayDevice.getMac(), gatewayDevice.getPublicIpAddress(), status.name(), "Gateway client was not stored in database");
            } else {
                status = ActivateGcResponse.ActivateStatus.SUCCESS;
                this.eventlogService.registerEventlog(GCEventType.ACTIVATE, gatewayDevice.getMac(), gatewayDevice.getPublicIpAddress(), status.name(), null);
                this.connector.setRegistered(gatewayClient.getMac(), true);
            }
            return new ActivateGcResponse(status, gatewayClient == null ? null : gatewayClient.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, false, false));
        }
        status = ActivateGcResponse.ActivateStatus.NOTCONNECTED;
        this.eventlogService.registerEventlog(GCEventType.ACTIVATE, mac, null, status.name(), null);
        return new ActivateGcResponse(status);
    }

    private boolean isMultiRegistrationEnabled() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS);
    }

    private GatewayClientEntity getClientBelongsToUser(List<GatewayClientEntity> clients, UserEntity user) {
        for (GatewayClientEntity client : clients) {
            if (!client.getUser().getId().equals(user.getId())) continue;
            return client;
        }
        return null;
    }

    private Integer getUnsuccessfulAttemptCount() {
        Integer attemptCount = (Integer)this.authUtils.getStoredData("unsuccessful_attempt_count");
        return attemptCount == null ? 0 : attemptCount;
    }

    private void increaseUnsuccessfulAttemptCount() {
        this.authUtils.storeData("unsuccessful_attempt_count", (Object)(this.getUnsuccessfulAttemptCount() + 1));
    }

    private void delay(int time) {
        log.trace((Object)("start delay(time=" + time + ")"));
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.trace((Object)"exit from delay");
    }

    public boolean detectDeviceClient(String serialNumber) throws InvalidSessionException {
        log.trace((Object)("start detectDeviceClient(" + serialNumber + ")"));
        return this.gatewayDeviceConnection != null && this.gatewayDeviceConnection.findById(serialNumber) != null;
    }

    @Transactional
    public RemoveResponse removeGatewayClient(@PathParam(value="gc_id") Integer gatewayClientId) throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByIdAndUserId(gatewayClientId, this.authUtils.getCurrentUserId(), true);
        if (gatewayClient == null) {
            return new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        }
        for (LanDeviceEntity device : gatewayClient.getLanDevices()) {
            device.setDeleted(true);
        }
        gatewayClient.setDeleted(true);
        GatewayClientEntity updatedGatewayClient = this.gatewayClientDAO.updateGatewayClient(gatewayClient);
        if (updatedGatewayClient != null) {
            List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(gatewayClient.getMac());
            if (clients.isEmpty()) {
                this.connector.setRegistered(gatewayClient.getMac(), false);
            }
            return new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        }
        return new RemoveResponse(RemoveResponse.RemoveStatus.ERROR);
    }

    @Transactional(readOnly=false)
    public GCStatusResponse getGatewayClientStatus(@PathParam(value="gc_id") int gatewayClientId) throws InvalidSessionException {
        log.trace((Object)("start getGatewayClientStatus(" + gatewayClientId + ")"));
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity gatewayClient = this.getGatewayClientByIdWithAccessVerification(Integer.valueOf(gatewayClientId), false);
        if (gatewayClient == null) {
            return new GCStatusResponse(GCStatusResponse.GCStatus.INVALIDID);
        }
        GatewayClient dto = gatewayClient.toDTO(this.gatewayDeviceConnection, null, false, false);
        if (this.detectDeviceClient(gatewayClient.getMac())) {
            return new GCStatusResponse(GCStatusResponse.GCStatus.OK, dto);
        }
        return new GCStatusResponse(GCStatusResponse.GCStatus.NOTCONNECTED, dto);
    }

    private GatewayClientEntity getGatewayClientByIdWithAccessVerification(Integer gatewayClientId, boolean fetchLanDevices) throws InvalidSessionException {
        log.debug((Object)("start getGatewayClientByIdWithAccessVerification(gatewayClientId=" + gatewayClientId + ")"));
        this.authUtils.ensureLoggedIn();
        Integer currentUserId = this.authUtils.getCurrentUserId();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientById(gatewayClientId, fetchLanDevices);
        if (gatewayClient == null) {
            log.debug((Object)("exit getGatewayClientByIdWithAccessVerification(gatewayClientId=" + gatewayClientId + ") - not found gatewayClient, returning null"));
            return null;
        }
        if (currentUserId.equals(gatewayClient.getUser().getId())) {
            log.debug((Object)("exit getGatewayClientByIdWithAccessVerification(gatewayClientId=" + gatewayClientId + ") - gatewayClient belongs to current user - returning gatewayClient=" + gatewayClient.toString()));
            return gatewayClient;
        }
        gatewayClient = this.gatewayClientDAO.findGatewayClientByIdSharedWithUserId(gatewayClientId, currentUserId);
        log.debug((Object)("exit getGatewayClientByIdWithAccessVerification(gatewayClientId=" + gatewayClientId + ") - gatewayClient found = " + (gatewayClient != null ? gatewayClient.toString() : null)));
        return gatewayClient;
    }

    public Integer getGCCount() throws InvalidSessionException {
        log.trace((Object)"start getGCCount()");
        this.authUtils.ensureLoggedIn();
        return this.gatewayClientDAO.countGatewayClientsForUserId(this.authUtils.getCurrentUserId()).intValue();
    }

    @Transactional
    public SaveResponse updateGatewayClient(GatewayClient gatewayClient) throws InvalidSessionException {
        log.trace((Object)("start updateGatewayClient(gatewayClient=" + gatewayClient + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (gatewayClient == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        GatewayClientEntity gatewayClientEntity = this.gatewayClientDAO.findGatewayClientById(gatewayClient.getGatewayClientId(), false);
        if (gatewayClientEntity == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        if (this.isGatewayClientModified(gatewayClient, gatewayClientEntity)) {
            gatewayClientEntity.setModificationDate(new Date());
        }
        gatewayClientEntity.setMac(gatewayClient.getMac());
        gatewayClientEntity.setName(gatewayClient.getName());
        gatewayClientEntity.setSerialNumber(gatewayClient.getSerialNumber());
        if (gatewayClient.getDeleted().booleanValue() && !gatewayClientEntity.getDeleted()) {
            gatewayClientEntity.setDeleted(true);
        } else if (!gatewayClient.getDeleted().booleanValue() && gatewayClientEntity.getDeleted()) {
            gatewayClientEntity.setDeleted(false);
            gatewayClientEntity.setActivationDate(new Date());
        }
        GatewayClientEntity updatedGatewayClient = this.gatewayClientDAO.updateGatewayClient(gatewayClientEntity);
        return updatedGatewayClient == null ? new SaveResponse(SaveResponse.SaveStatus.NOTSAVED) : new SaveResponse(SaveResponse.SaveStatus.SAVED);
    }

    private boolean isGatewayClientModified(GatewayClient dto, GatewayClientEntity gc) {
        if (dto == null || gc == null) {
            return false;
        }
        if (!dto.getName().equals(gc.getName())) {
            return true;
        }
        if (!dto.getMac().equals(gc.getMac())) {
            return true;
        }
        if (!dto.getSerialNumber().equals(gc.getSerialNumber())) {
            return true;
        }
        return !dto.getDeleted().equals(gc.getDeleted());
    }

    public GatewayClient getGatewayClientBasicInfo(String macAddress) throws InvalidSessionException {
        log.trace((Object)("start getGatewayClientBasicInfo(macAddress=" + macAddress + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (Utils.isBlank((String)macAddress)) {
            return null;
        }
        GatewayClient gatewayClient = new GatewayClient();
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        if (gatewayDevice == null) {
            gatewayClient.setStatus(GatewayClient.GatewayClientStatus.DISCONNECTED);
        } else {
            gatewayClient.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
            gatewayClient.setConnectedDate(gatewayDevice.getConnectedDate());
            gatewayClient.setPublicIpAddress(gatewayDevice.getPublicIpAddress());
            gatewayClient.setMac(gatewayDevice.getMac());
        }
        return gatewayClient;
    }

    public GatewayClient getGatewayClient(Integer gatewayClientId) throws InvalidSessionException {
        log.trace((Object)("start getGatewayClient(getGatewayClient=" + gatewayClientId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (gatewayClientId == null) {
            return null;
        }
        GatewayClientEntity foundGatewayClient = this.gatewayClientDAO.findGatewayClientById(gatewayClientId, false);
        if (foundGatewayClient == null) {
            return null;
        }
        return foundGatewayClient.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, false, false);
    }

    public GatewayClientResponse send(String macAddress, String url) throws InvalidSessionException {
        log.trace((Object)("start send(macAddress=" + macAddress + ", url=" + url + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (Utils.isBlank((String)macAddress)) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS);
        }
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        if (gatewayDevice == null) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED);
        }
        HTTPClientService httpClientService = this.getHttpClientService();
        try {
            HTTPClientServiceResult response = httpClientService.get(macAddress, new URL(url));
            GatewayClientResponse gatewayClientResponse = new GatewayClientResponse();
            gatewayClientResponse.status = this.translateResponseStatus(response.getResult());
            if (response.getResult() == HTTPClientServiceResult.Result.OK) {
                gatewayClientResponse.body = response.getBodyAsText();
            }
            return gatewayClientResponse;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Error occured sending data via gateway client: " + e.getMessage()));
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_MALFORMEDURL);
        }
    }

    public GatewayClientResponse sendPost(String macAddress, String url, String body) throws InvalidSessionException {
        log.trace((Object)("start sendPost(macAddress=" + macAddress + ", url=" + url + ", body=" + body + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (Utils.isBlank((String)macAddress)) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS);
        }
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        if (gatewayDevice == null) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED);
        }
        HTTPClientService httpClientService = this.getHttpClientService();
        try {
            HTTPClientServiceResult response = httpClientService.post(macAddress, new URL(url), null, body.getBytes());
            GatewayClientResponse gatewayClientResponse = new GatewayClientResponse();
            gatewayClientResponse.status = this.translateResponseStatus(response.getResult());
            if (response.getResult() == HTTPClientServiceResult.Result.OK) {
                gatewayClientResponse.body = response.getBodyAsText();
            }
            return gatewayClientResponse;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Error occured sending data via gateway client: " + e.getMessage()));
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_MALFORMEDURL);
        }
    }

    public GatewayClientResponse restart(String macAddress) throws InvalidSessionException {
        log.trace((Object)("start restart(macAddress=" + macAddress + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.doForceUpgrade(macAddress);
    }

    public GatewayClientResponse forceUpgrade(String macAddress) throws InvalidSessionException {
        log.trace((Object)("start forceUpgrade(macAddress=" + macAddress + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.doForceUpgrade(macAddress);
    }

    private GatewayClientResponse doForceUpgrade(String macAddress) {
        if (Utils.isBlank((String)macAddress)) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS);
        }
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        if (gatewayDevice == null) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED);
        }
        this.gatewayDeviceConnection.forceUpgrade(macAddress);
        return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.OK);
    }

    /*
     * Exception decompiling
     */
    private GatewayClientResponse.GatewayClientResponseStatus translateResponseStatus(HTTPClientServiceResult.Result result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(readOnly=true)
    public VerifyGcResponse verifyGatewayClient(String activationCode, boolean forceGCCheck) throws InvalidSessionException {
        GatewayDevice gatewayDevice;
        log.trace((Object)("start verifyGatewayClient(activationCode=" + activationCode + ",forceGCCheck=" + forceGCCheck + ")"));
        this.authUtils.ensureLoggedIn();
        String username = "root";
        String password = "";
        String macAddress = this.activationCodeHandler.getMacAddress(activationCode);
        if (macAddress == null) {
            return new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT, username, password);
        }
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsByMacAddress(macAddress);
        if (!gatewayClients.isEmpty() && !this.isMultiRegistrationEnabled() && this.getClientBelongsToUser(gatewayClients, this.authUtils.getCurrentUser()) == null) {
            return new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_ANOTHERACCOUNTASSIGNED, username, password);
        }
        log.trace((Object)("retrived mac address: " + macAddress));
        List lanDevices = this.lanDeviceDAO.findAllLanDevicesByMac(macAddress);
        if (lanDevices.size() > 0) {
            username = ((LanDeviceEntity)lanDevices.get(0)).getUsername();
            password = ((LanDeviceEntity)lanDevices.get(0)).getPass();
        }
        if (forceGCCheck && (gatewayDevice = this.gatewayDeviceConnection.findById(macAddress)) == null) {
            boolean activationCodeAsMac = this.activationCodeHandler.isMacAddress(activationCode);
            return new VerifyGcResponse(activationCodeAsMac ? VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED_TRYINSTALL : VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED, username, password);
        }
        return new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, username, password);
    }

    @Transactional(readOnly=true)
    public VerifyGcResponse verifyGatewayClient(String activationCode) throws InvalidSessionException {
        return this.verifyGatewayClient(activationCode, false);
    }

    public String getGatewayClientMACById(Integer gatewayClienId) throws InvalidSessionException {
        log.trace((Object)("start getGatewayClientById(gatewayClienId=" + gatewayClienId + ")"));
        if (gatewayClienId == null) {
            return null;
        }
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientById(gatewayClienId, false);
        return gatewayClient != null ? gatewayClient.getMac() : null;
    }

    public GatewayClientResponse runScript(String macAddress, String scriptName) throws InvalidSessionException {
        log.trace((Object)("start runScript(macAddress=" + macAddress + ", scriptName=" + scriptName + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (Utils.isBlank((String)macAddress)) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_INVALIDMACADDRESS);
        }
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        if (gatewayDevice == null) {
            return new GatewayClientResponse(GatewayClientResponse.GatewayClientResponseStatus.FAILED_GCDISCONNECTED);
        }
        ExecCmdService execCmdService = this.containerserverServiceFactory.getExecCmdService();
        CommandResult cmdResult = execCmdService.executeCommand(macAddress, scriptName);
        GatewayClientResponse response = new GatewayClientResponse();
        if (cmdResult == null) {
            response.status = GatewayClientResponse.GatewayClientResponseStatus.ERROR;
            return response;
        }
        response.status = GatewayClientResponse.GatewayClientResponseStatus.OK;
        response.statusCode = cmdResult.getStatusCode();
        response.body = cmdResult.getOutput();
        return response;
    }

    @Transactional
    public void processLogs(String mac, List<Debuglog> debuglogs) {
        log.trace((Object)("start receivedLogs(mac=" + mac + ", logs=" + Utils.getSize(debuglogs)));
        if (Utils.isBlank((String)mac)) {
            log.debug((Object)"Received mac address is null or empty.");
            return;
        }
        if (debuglogs == null || debuglogs.isEmpty()) {
            log.debug((Object)("Received log from gatewayclient with mac address '" + mac + "' is null or is empty."));
            return;
        }
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        for (GatewayClientEntity gatewayClient : gatewayClients) {
            for (Debuglog debuglog : debuglogs) {
                DebuglogEntity debuglogEntity = this.createEntity(gatewayClient, debuglog);
                if (this.debuglogDAO.createDebuglogWithTransaction(debuglogEntity) != null) continue;
                log.warn((Object)("Debuglog " + debuglogEntity + " was not saved."));
            }
        }
    }

    private DebuglogEntity createEntity(GatewayClientEntity gatewayClient, Debuglog debuglog) {
        DebuglogEntity entity = new DebuglogEntity();
        entity.setLoggerName(debuglog.getLoggerName());
        LogLevel logLevel = this.parseLogLevel(debuglog.getLogLevel());
        entity.setLogLevel(logLevel == null ? null : logLevel.name());
        entity.setNdc(debuglog.getNdc());
        entity.setMessage(debuglog.getMessage());
        entity.setThread(debuglog.getThread());
        entity.setTimestamp(Utils.buildDate((Integer)debuglog.getTimestampSec(), (Integer)debuglog.getTimestampUSec()));
        entity.setFile(debuglog.getFile());
        entity.setLine(debuglog.getLine().intValue());
        entity.setMac(gatewayClient.getMac());
        entity.setUsername(gatewayClient.getUser().getUsername());
        return entity;
    }

    private LogLevel parseLogLevel(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return LogLevel.FATAL;
            }
            case 100: {
                return LogLevel.ALERT;
            }
            case 200: {
                return LogLevel.CRIT;
            }
            case 300: {
                return LogLevel.ERROR;
            }
            case 400: {
                return LogLevel.WARN;
            }
            case 500: {
                return LogLevel.NOTICE;
            }
            case 600: {
                return LogLevel.INFO;
            }
            case 700: {
                return LogLevel.DEBUG;
            }
            case 800: {
                return LogLevel.TRACE;
            }
            case 900: {
                return LogLevel.NOTSET;
            }
            case 1000: {
                return LogLevel.UNKNOWN;
            }
        }
        log.warn((Object)("Unknown log level: " + value + "."));
        return null;
    }

    @Transactional
    public ConfigureLoggerStatus configureLogs(Integer gcId, String logsConfiguration) throws InvalidSessionException {
        log.debug((Object)("configureLogs(gcId=" + gcId + ", logsConfiguration=" + logsConfiguration + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (gcId == null) {
            return ConfigureLoggerStatus.FAILED_INVALIDID;
        }
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findNotDeletedGatewayClientByIdAndUserId(gcId);
        if (gatewayClient == null) {
            return ConfigureLoggerStatus.FAILED_GCNOTFOUND;
        }
        if (!this.isGatewayClientConnected(gatewayClient.getSerialNumber()).booleanValue()) {
            return ConfigureLoggerStatus.FAILED_GCNOTCONNECTED;
        }
        ConfigureGCLogsService configureGCLogsService = this.containerserverServiceFactory.getConfigureGCLogsService();
        LoggerConfigurationStatus status = configureGCLogsService.configureLogs(gatewayClient.getSerialNumber(), logsConfiguration);
        log.debug((Object)("status: " + status));
        if (status == null) {
            return ConfigureLoggerStatus.ERROR;
        }
        if (status == LoggerConfigurationStatus.SUCCESS) {
            gatewayClient.setLogConf(logsConfiguration);
            this.gatewayClientDAO.updateGatewayClient(gatewayClient);
            return ConfigureLoggerStatus.SUCCESS;
        }
        if (status == LoggerConfigurationStatus.FAILED_NOANSWER) {
            return ConfigureLoggerStatus.FAILED_NOANSWER;
        }
        return ConfigureLoggerStatus.ERROR;
    }

    public Boolean isGatewayClientConnected(String serialNumber) {
        return this.gatewayDeviceConnection.findById(serialNumber) == null ? Boolean.FALSE : Boolean.TRUE;
    }

    public Map<String, Integer> getGCSummary() throws InvalidSessionException {
        log.debug((Object)"start getGCSummary()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Map summary = this.gatewayClientDAO.countGatewayClientsForEachVersion();
        log.debug((Object)("end getGCSummary(): " + (summary == null ? "null" : summary.toString())));
        return summary;
    }

    public List<GcMacId> getGatewayClientsByVerion(String version) throws InvalidSessionException {
        log.debug((Object)("start getGatewayClientsByVerion(version=" + version + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List gcs = this.gatewayClientDAO.getGatewayClientsForVersion(version);
        log.debug((Object)("end getGatewayClientsByVerion(): " + (gcs == null ? "null" : gcs.toString())));
        return gcs;
    }

    public Integer updateGatewayClients(String version, Integer count) throws InvalidSessionException {
        log.debug((Object)("start updateGatewayClients(version=" + version + ", count=" + count + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Version ver = this.parseVersion(version);
        if (ver == null) {
            log.warn((Object)("Unexpected version form: " + version + "."));
            return null;
        }
        List clients = this.gatewayClientDAO.getGatewayClients(Version.access$0((Version)ver), Version.access$1((Version)ver), count);
        int updatedClientsCount = 0;
        for (GatewayClientEntity client : clients) {
            log.info((Object)("Updating gateway client with gatewayClientId=" + client.getGatewayClientId() + "."));
            GatewayClientResponse resetResponse = this.forceUpgrade(client.getMac());
            if (resetResponse.status != GatewayClientResponse.GatewayClientResponseStatus.OK) continue;
            ++updatedClientsCount;
        }
        return updatedClientsCount;
    }

    public GatewayClientResponse upgradeGatewayClient(String mac) throws InvalidSessionException {
        log.debug((Object)("start upgradeGatewayClient(mac=" + mac + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        GatewayClientResponse response = this.forceUpgrade(mac);
        log.debug((Object)("exit upgradeGatewayClient(mac=" + mac + ") response = " + response.toString()));
        return response;
    }

    private Version parseVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            return null;
        }
        int openParenthesisPos = version.indexOf("(");
        int closeParenthesisPos = version.indexOf(")");
        if (openParenthesisPos == -1 || closeParenthesisPos == -1) {
            return null;
        }
        Version ver = new Version(this, null);
        String rawVersion = version.substring(0, openParenthesisPos).trim();
        Version.access$3((Version)ver, (String)(rawVersion.equals("null") ? null : rawVersion));
        String rawBuildNo = version.substring(openParenthesisPos + 1, closeParenthesisPos);
        Version.access$4((Version)ver, rawBuildNo.equals("null") ? null : Integer.valueOf(Integer.parseInt(rawBuildNo)));
        return ver;
    }

    public boolean forceRebootIfRequired(String mac) {
        log.debug((Object)("start forceRebootIfRequired(mac=" + mac + ")"));
        if (Utils.isBlank((String)mac)) {
            return false;
        }
        GatewayDevice device = this.gatewayDeviceConnection.findById(mac);
        if (device == null) {
            log.trace((Object)("Device with mac=" + mac + " is not connected."));
            return false;
        }
        List gcs = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        if (!this.isRebootRequired(gcs)) {
            return false;
        }
        log.info((Object)("Rebooting gateway client with mac = " + mac + " (force reboot)"));
        CommandResult result = null;
        ExecCmdService execCmdService = this.containerserverServiceFactory.getExecCmdService();
        if (Utils.isAtMinimalVersion((String)device.getVersion(), (String)this.getUsesScriptsDirectoryMinimalVersion())) {
            log.debug((Object)"Executing scripts/reboot.sh on gdclient");
            result = execCmdService.executeCommand(((GatewayClientEntity)gcs.get(0)).getSerialNumber(), "reboot.sh");
        } else {
            log.debug((Object)"Executing (old) reboot on gdclient");
            result = execCmdService.executeCommand(((GatewayClientEntity)gcs.get(0)).getSerialNumber(), "reboot &");
        }
        if (result.getStatusCode() == 0) {
            log.info((Object)("Reboot of gateway client " + mac + " successful"));
            for (GatewayClientEntity gc : gcs) {
                gc.setForceReboot(false);
                this.gatewayClientDAO.updateGatewayClientWithTransaction(gc);
            }
            return true;
        }
        log.info((Object)("Reboot of gateway client " + mac + " failed, will try next time"));
        return false;
    }

    private boolean isRebootRequired(List<GatewayClientEntity> clients) {
        for (GatewayClientEntity client : clients) {
            if (!client.isForceReboot()) continue;
            return true;
        }
        return false;
    }

    public String getUsesScriptsDirectoryMinimalVersion() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT);
    }

    public String getForceRebootMaxVersion() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MAX_VERSION_FOR_FORCE_REBOOT);
    }

    public void forceUpgradeIfRequired(String mac) {
        String minVersion;
        log.debug((Object)("start forceUpgradeIfRequired(mac=" + mac + ")"));
        if (Utils.isBlank((String)mac)) {
            log.debug((Object)"Upgrade will not be executed beause of blank mac.");
            return;
        }
        GatewayDevice device = this.gatewayDeviceConnection.findById(mac);
        List gcs = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        if (device == null || gcs.isEmpty()) {
            return;
        }
        GatewayClientVersionEntity gatewayClientVersion = this.gatewayClientVersionDAO.findBestMatchedGatewayClientVersion(mac);
        if (gatewayClientVersion == null) {
            return;
        }
        String gcVersion = device.getVersion();
        if (!Utils.isAtMinimalVersion((String)gcVersion, (String)(minVersion = gatewayClientVersion.getMinVersion()))) {
            log.info((Object)("GatewayClient " + mac + " version (" + gcVersion + ") is lower than required (" + minVersion + ") - upgrading..."));
            String forceRebootMaxVersion = this.getForceRebootMaxVersion();
            if (forceRebootMaxVersion != null && (!Utils.isAtMinimalVersion((String)gcVersion, (String)forceRebootMaxVersion) || gcVersion.equals(forceRebootMaxVersion))) {
                log.info((Object)("GatewayClient with mac = " + mac + "and version = " + gcVersion + " will be rebooted after connect"));
                for (GatewayClientEntity gc : gcs) {
                    gc.setForceReboot(true);
                    this.gatewayClientDAO.updateGatewayClientWithTransaction(gc);
                }
            }
            this.doForceUpgrade(mac);
        }
    }

    private HTTPClientService getHttpClientService() {
        HTTPClientService service = this.containerserverServiceFactory.getHttpClientService();
        service.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        return service;
    }

    @Transactional
    public void setUpUpnpForwarding(String mac, Integer upnpPort) {
        log.trace((Object)("start setUpUpnpForwarding(mac=" + mac + ", upnpPort=" + upnpPort + ")"));
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        if (clients.isEmpty()) {
            log.debug((Object)("Gateway client with mac=" + mac + " is not registered."));
            return;
        }
        UpnpForwardingService service = this.containerserverServiceFactory.getUpnpForwardingService();
        SetUpUpnpForwardingResult result = service.setUpUpnpForwarding(mac, upnpPort == null ? ((GatewayClientEntity)clients.get(0)).getUpnpPort() : upnpPort);
        if (result == null) {
            log.warn((Object)"Failed to set up upnp forwarding.");
            return;
        }
        this.forwardUpnpStatus(mac, result.getState(), result.getUpnpPort(), result.getStatusCode(), result.getReason(), result.getPublicIp());
    }

    @Transactional
    public void forwardUpnpStatus(String mac, UpnpForwardingState state, Integer upnpPort, Integer statusCode, String reason, String publicIp) {
        log.trace((Object)("start forwardUpnpStatus(mac=" + mac + " state=" + state + ", upnpPort=" + upnpPort + ", statusCode=" + statusCode + ", reason=" + reason + ", publicIp=" + publicIp + ")"));
        HashMap<DomainService.Param, Object> params = new HashMap<DomainService.Param, Object>();
        params.put(DomainService.Param.UPNP_PORT, upnpPort);
        params.put(DomainService.Param.REASON, reason);
        if (state == UpnpForwardingState.Works) {
            this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        } else {
            this.domainService.tearDownDomain(mac, DomainService.Type.PUBLIC, params);
        }
        this.registerEventlog(mac, publicIp, state, reason, upnpPort);
    }

    private void registerEventlog(String mac, String publicIp, UpnpForwardingState state, String reason, Integer upnpPort) {
        this.eventlogService.registerEventlog(GCEventType.UPNPSETUP, mac, publicIp, state == UpnpForwardingState.Works ? "OK" : "FAILED", String.valueOf(reason) + ": " + String.valueOf(upnpPort));
    }

    @Transactional
    public void setUpLocalIpDomain(String mac, String localIpAddress) {
        log.trace((Object)("start setUpLocalIpDomain (mac=" + mac + ",localIpAddress=" + localIpAddress + ")"));
        this.domainService.setUpDomain(mac, localIpAddress, DomainService.Type.LOCAL, new HashMap());
    }

    public boolean isRegistered(String mac) {
        return !this.gatewayClientDAO.findGatewayClientsByMacAddress(mac).isEmpty();
    }

    @Transactional
    public void updateGatewayClientStatus(String mac, boolean connected, String serverUrl) {
        log.debug((Object)("start updateGatewayClientStatus(mac=" + mac + ", connected=" + connected + ")"));
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        GatewayClientSessionEntity session = this.gatewayClientSessionDAO.findGatewayClientSessionByMac(mac);
        if (connected) {
            GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(mac);
            if (gatewayDevice == null) {
                log.debug((Object)("Not found gateway device with mac=" + mac + "."));
                return;
            }
            GatewayClientSessionEntity sessionFromDevice = new GatewayClientSessionEntity(gatewayDevice, serverUrl);
            if (session == null) {
                this.gatewayClientSessionDAO.saveGatewayClientSession(sessionFromDevice);
            } else {
                this.gatewayClientSessionDAO.updateGatewayClientSession(sessionFromDevice);
            }
            for (GatewayClientEntity client : clients) {
                client.setBuildNo(gatewayDevice.getBuildNo());
                client.setVersion(gatewayDevice.getVersion());
                client.setConnectedDate(gatewayDevice.getConnectedDate());
            }
        } else {
            String sessionServerUrl;
            for (GatewayClientEntity client : clients) {
                client.setDisconnectedDate(this.systemSupport.getCurrentDate());
            }
            if (session != null && (sessionServerUrl = session.getServerUrl()) != null && sessionServerUrl.equals(serverUrl)) {
                this.gatewayClientSessionDAO.removeGatewayClientSession(session.getMac());
            }
        }
        for (GatewayClientEntity client : clients) {
            if (this.gatewayClientDAO.updateGatewayClient(client) != null) continue;
            log.warn((Object)("Failed to update version and build number for gateway client with gatewayclientId=" + client.getGatewayClientId() + "."));
        }
    }

    public GetCommServerUrlResponse getCommServerUrl(String mac) {
        log.trace((Object)("start getCommServer(mac=" + mac + ")"));
        if (Utils.isBlank((String)mac)) {
            return new GetCommServerUrlResponse(GetCommServerUrlResponse.ErrorCode.NO_MAC);
        }
        return new GetCommServerUrlResponse(GetCommServerUrlResponse.Status.SUCCESS, this.connector.getVeryfiedServerUrl(mac));
    }

    @Transactional(readOnly=true)
    public Set<Integer> getDeviceIds(String mac) {
        log.trace((Object)("start getDeviceIds(mac=" + mac + ")"));
        if (mac == null) {
            throw new NullPointerException("mac");
        }
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        HashSet<Integer> ids = new HashSet<Integer>();
        for (GatewayClientEntity client : clients) {
            if (client.getDeleted()) continue;
            ids.add(client.getGatewayClientId());
        }
        return ids;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
        }
        int[] nArray = new int[HTTPClientServiceResult.Result.values().length];
        try {
            nArray[HTTPClientServiceResult.Result.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result = nArray;
        return nArray;
    }
}

