/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.core.task.TaskExecutor;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.DynDNSService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.impl.DeviceSessions;
import pl.smartapps.restserver.service.impl.GDServerCallbacks;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GDServerCallbacks.class, Date.class})
public class GDServerCallbacksTests {
    private GDServerCallbacks gdServerCallbacks;
    private EventlogService eventlogService;
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;
    private TaskExecutor taskExecutor;
    private GatewayClientDAO gatewayClientDAO;
    private DeviceSessions sessions;
    private Connector connector;
    private DomainService domainService;
    private DynDNSService dynDNSService;

    @Before
    public void setUp() {
        this.gdServerCallbacks = new GDServerCallbacks();
        this.gatewayClientService = (GatewayClientService)PowerMock.createMock(GatewayClientService.class);
        this.gdServerCallbacks.setGatewayClientService(this.gatewayClientService);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.gdServerCallbacks.setLanDeviceService(this.lanDeviceService);
        this.eventlogService = (EventlogService)PowerMock.createMock(EventlogService.class);
        this.gdServerCallbacks.setEventlogService(this.eventlogService);
        this.taskExecutor = (TaskExecutor)PowerMock.createMock(TaskExecutor.class);
        this.gdServerCallbacks.setTaskExecutor(this.taskExecutor);
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.gdServerCallbacks.setGatewayClientDAO(this.gatewayClientDAO);
        this.sessions = (DeviceSessions)PowerMock.createMock(DeviceSessions.class);
        this.gdServerCallbacks.setSessions(this.sessions);
        this.connector = (Connector)PowerMock.createMock(Connector.class);
        this.gdServerCallbacks.setConnector(this.connector);
        this.domainService = (DomainService)PowerMock.createMock(DomainService.class);
        this.gdServerCallbacks.setDomainService(this.domainService);
        this.dynDNSService = (DynDNSService)PowerMock.createMock(DynDNSService.class);
        this.gdServerCallbacks.setDynDNSService(this.dynDNSService);
    }

    @Test
    public void testConnectedRegisteredDevice() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.12";
        String commServerUrl = "http://commserver.com";
        boolean registered = false;
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        this.sessions.add(mac, commServerUrl);
        Capture captureGatewayClientConnectedHandler = new Capture();
        this.taskExecutor.execute((Runnable)EasyMock.capture((Capture)captureGatewayClientConnectedHandler));
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.connected(mac, publicIP, localIP, commServerUrl, Boolean.valueOf(registered));
        Assert.assertEquals((Object)mac, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).mac);
        Assert.assertEquals((Object)publicIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).publicIpAddress);
        Assert.assertEquals((Object)localIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).localIpAddress);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectedNoRegisteredDeviceAndNoDynDnsRegistered() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.12";
        String commServerUrl = "http://commserver.com";
        Boolean registered = null;
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients).times(2);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)true).times(2);
        EasyMock.expect((Object)this.dynDNSService.isRegistered(mac)).andReturn((Object)false).times(2);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(mac, false)).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.connected(mac, publicIP, localIP, commServerUrl, registered);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectedNoRegisteredDeviceAndDynDnsRegistered() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.12";
        String commServerUrl = "http://commserver.com";
        Boolean registered = null;
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients).times(2);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)true).times(2);
        EasyMock.expect((Object)this.dynDNSService.isRegistered(mac)).andReturn((Object)true).times(2);
        this.sessions.add(mac, commServerUrl);
        Capture captureGatewayClientConnectedHandler = new Capture();
        this.taskExecutor.execute((Runnable)EasyMock.capture((Capture)captureGatewayClientConnectedHandler));
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(mac, true)).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.connected(mac, publicIP, localIP, commServerUrl, registered);
        Assert.assertEquals((Object)mac, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).mac);
        Assert.assertEquals((Object)publicIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).publicIpAddress);
        Assert.assertEquals((Object)localIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).localIpAddress);
        PowerMock.verifyAll();
    }

    @Test
    public void testConnectedRegisteredDeviceAndDynDnsRegistered() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.12";
        String commServerUrl = "http://commserver.com";
        Boolean registered = null;
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients).times(2);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false).times(2);
        this.sessions.add(mac, commServerUrl);
        Capture captureGatewayClientConnectedHandler = new Capture();
        this.taskExecutor.execute((Runnable)EasyMock.capture((Capture)captureGatewayClientConnectedHandler));
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(mac, true)).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.connected(mac, publicIP, localIP, commServerUrl, registered);
        Assert.assertEquals((Object)mac, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).mac);
        Assert.assertEquals((Object)publicIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).publicIpAddress);
        Assert.assertEquals((Object)localIP, (Object)((GDServerCallbacks.GatewayClientConnectedHandler)captureGatewayClientConnectedHandler.getValue()).localIpAddress);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedRegisteredDeviceFromTheSameServer() {
        String mac = "00:1A:B6:00:0B:B5";
        String commServerUrl = "http://commserver.com";
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        EasyMock.expect((Object)this.sessions.get(mac)).andReturn((Object)commServerUrl);
        this.sessions.remove(mac);
        this.gatewayClientService.updateGatewayClientStatus(mac, false, commServerUrl);
        this.eventlogService.registerEventlog(GCEventType.DISCONNECT, mac, "89.186.27.139", null, "nothing");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.disconnected("00:1A:B6:00:0B:B5", "89.186.27.139", "nothing", commServerUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedRegisteredDeviceFromAnotherServer() {
        String mac = "00:1A:B6:00:0B:B5";
        String commServerUrl = "http://commserver.com";
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        EasyMock.expect((Object)this.sessions.get(mac)).andReturn((Object)"someAnotherCommServerUrl");
        this.gatewayClientService.updateGatewayClientStatus(mac, false, commServerUrl);
        this.eventlogService.registerEventlog(GCEventType.DISCONNECT, mac, "89.186.27.139", null, "nothing");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.disconnected("00:1A:B6:00:0B:B5", "89.186.27.139", "nothing", commServerUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedRegisteredDeviceWithNoStoredSession() {
        String mac = "00:1A:B6:00:0B:B5";
        String commServerUrl = "http://commserver.com";
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        EasyMock.expect((Object)this.sessions.get(mac)).andReturn(null);
        this.gatewayClientService.updateGatewayClientStatus(mac, false, commServerUrl);
        this.eventlogService.registerEventlog(GCEventType.DISCONNECT, mac, "89.186.27.139", null, "nothing");
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.disconnected("00:1A:B6:00:0B:B5", "89.186.27.139", "nothing", commServerUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisconnectedNoRegisteredDeviceAndNoDynDnsRegistered() {
        String mac = "00:1A:B6:00:0B:B5";
        String commServerUrl = "http://commserver.com";
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)true);
        EasyMock.expect((Object)this.dynDNSService.isRegistered(mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.disconnected(mac, "89.186.27.139", "nothing", commServerUrl);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedLogs() {
        this.gatewayClientService.processLogs("00:1A:B6:00:0B:B5", new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        this.gdServerCallbacks.receivedLogs("00:1A:B6:00:0B:B5", new ArrayList());
        PowerMock.verifyAll();
    }

    @Test
    public void testGatewayClientConnectedHandler() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.2";
        String commServerUrl = "http://commserver.com";
        this.eventlogService.registerEventlog(GCEventType.CONNECT, mac, publicIP, null, null);
        this.gatewayClientService.updateGatewayClientStatus(mac, true, commServerUrl);
        this.gatewayClientService.setUpUpnpForwarding(mac, null);
        this.lanDeviceService.updateLanDeviceAfterConnect(mac);
        EasyMock.expect((Object)this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIP)).andReturn((Object)true);
        this.gatewayClientService.setUpLocalIpDomain(mac, localIP);
        this.dynDNSService.notifyCommServer(mac);
        EasyMock.expect((Object)this.gatewayClientService.forceRebootIfRequired(mac)).andReturn((Object)false);
        this.gatewayClientService.forceUpgradeIfRequired(mac);
        PowerMock.replayAll((Object[])new Object[0]);
        GDServerCallbacks gDServerCallbacks = this.gdServerCallbacks;
        gDServerCallbacks.getClass();
        GDServerCallbacks.GatewayClientConnectedHandler handler = new GDServerCallbacks.GatewayClientConnectedHandler(gDServerCallbacks, mac, publicIP, localIP, commServerUrl);
        handler.run();
        PowerMock.verifyAll();
    }

    @Test
    public void testGatewayClientConnectedHandlerRebootDone() {
        String mac = "00:1A:B6:00:0B:B5";
        String publicIP = "89.186.27.139";
        String localIP = "192.168.1.2";
        String commServerUrl = "http://commserver.com";
        this.eventlogService.registerEventlog(GCEventType.CONNECT, mac, publicIP, null, null);
        this.gatewayClientService.updateGatewayClientStatus(mac, true, commServerUrl);
        this.gatewayClientService.setUpUpnpForwarding(mac, null);
        this.lanDeviceService.updateLanDeviceAfterConnect(mac);
        EasyMock.expect((Object)this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIP)).andReturn((Object)true);
        this.gatewayClientService.setUpLocalIpDomain(mac, localIP);
        this.dynDNSService.notifyCommServer(mac);
        EasyMock.expect((Object)this.gatewayClientService.forceRebootIfRequired(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        GDServerCallbacks gDServerCallbacks = this.gdServerCallbacks;
        gDServerCallbacks.getClass();
        GDServerCallbacks.GatewayClientConnectedHandler handler = new GDServerCallbacks.GatewayClientConnectedHandler(gDServerCallbacks, mac, publicIP, localIP, commServerUrl);
        handler.run();
        PowerMock.verifyAll();
    }
}

