/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.Message;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.DynDNSService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.DeviceSessions;
import pl.smartapps.restserver.service.impl.GDServerCallbacks;

@Component(value="gdServerCallbacks")
public class GDServerCallbacks {
    private Logger log = Logger.getLogger(GDServerCallbacks.class);
    private EventlogService eventlogService;
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;
    private TaskExecutor taskExecutor;
    private GatewayClientDAO gatewayClientDAO;
    private DeviceSessions sessions;
    private Connector connector;
    private DomainService domainService;
    private DynDNSService dynDNSService;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type;

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setGatewayClientService(GatewayClientService gatewayClientService) {
        this.gatewayClientService = gatewayClientService;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setSessions(DeviceSessions sessions) {
        this.sessions = sessions;
    }

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Autowired
    @Required
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Autowired
    @Required
    public void setDynDNSService(DynDNSService dynDNSService) {
        this.dynDNSService = dynDNSService;
    }

    private boolean forceRebootIfRequired(String mac) {
        this.log.trace((Object)("start forceRebootIfRequired(mac=" + mac + ")"));
        return this.gatewayClientService.forceRebootIfRequired(mac);
    }

    private void forceUpgradeIfRequired(String mac) {
        this.log.trace((Object)("start forceUpgradeIfRequired(mac=" + mac + ")"));
        this.gatewayClientService.forceUpgradeIfRequired(mac);
    }

    public void connected(String mac, String publicIpAddress, String localIpAddress, String gdServerAddress, Boolean registered) {
        this.log.trace((Object)("start connected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", localIpAddress=" + localIpAddress + ", gdServerAddress=" + gdServerAddress + ", registered=" + registered + ")"));
        if (this.isDeviceRegistered(mac)) {
            this.sessions.add(mac, gdServerAddress);
            this.taskExecutor.execute((Runnable)new GatewayClientConnectedHandler(this, mac, publicIpAddress, localIpAddress, gdServerAddress));
        }
        if (registered == null) {
            this.connector.setRegistered(mac, this.isDeviceRegistered(mac));
        }
    }

    private boolean isDeviceRegistered(String mac) {
        return !this.gatewayClientDAO.findGatewayClientsByMacAddress(mac).isEmpty() || this.dynDNSService.isRegistered(mac);
    }

    public void disconnected(String mac, String publicIpAddress, String reason, String gdServerAddress) {
        this.log.trace((Object)("start processDisconnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", reason=" + reason + ", gdServerAddress=" + gdServerAddress + ")"));
        if (this.isDeviceRegistered(mac)) {
            if (this.isSessionRemovable(mac, gdServerAddress)) {
                this.sessions.remove(mac);
            }
            this.gatewayClientService.updateGatewayClientStatus(mac, false, gdServerAddress);
            this.eventlogService.registerEventlog(GCEventType.DISCONNECT, mac, publicIpAddress, null, reason);
        }
    }

    private boolean isSessionRemovable(String mac, String gdServerAddress) {
        String serverUrl = this.sessions.get(mac);
        return serverUrl != null && serverUrl.equals(gdServerAddress);
    }

    public void receivedLogs(String mac, List<Debuglog> logs) {
        this.gatewayClientService.processLogs(mac, logs);
    }

    /*
     * Exception decompiling
     */
    public void receivedBatch(List<Message> messages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleConnected(Message msg, Map<String, Boolean> batch) {
        this.handleConnected(msg.getMac(), msg.getParam(Message.Param.PUBLIC_IP_ADDRESS), msg.getParam(Message.Param.LOCAL_IP_ADDRESS), msg.getParam(Message.Param.REST_URL), this.getRegistered(msg), batch);
    }

    private Boolean getRegistered(Message message) {
        String value = message.getParam(Message.Param.REGISTERED);
        return value == null ? null : Boolean.valueOf(value);
    }

    private void handleConnected(String mac, String publicIpAddress, String localIpAddress, String gdServerAddress, Boolean registered, Map<String, Boolean> batch) {
        this.log.trace((Object)("start handleConnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", localIpAddress=" + localIpAddress + ", gdServerAddress=" + gdServerAddress + ", registered=" + registered + ")"));
        if (this.isDeviceRegistered(mac)) {
            this.sessions.add(mac, gdServerAddress);
            this.taskExecutor.execute((Runnable)new GatewayClientConnectedHandler(this, mac, publicIpAddress, localIpAddress, gdServerAddress));
        }
        if (registered == null) {
            batch.put(mac, this.isDeviceRegistered(mac));
        }
    }

    private void handleDisconnected(Message msg) {
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleReceivedLogs(Message msg) {
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isCallback(Message message) {
        Message.Type type = message.getType();
        return type == Message.Type.CONNECTED || type == Message.Type.DISCONNECTED || type == Message.Type.LOGS;
    }

    static /* synthetic */ EventlogService access$0(GDServerCallbacks gDServerCallbacks) {
        return gDServerCallbacks.eventlogService;
    }

    static /* synthetic */ GatewayClientService access$1(GDServerCallbacks gDServerCallbacks) {
        return gDServerCallbacks.gatewayClientService;
    }

    static /* synthetic */ LanDeviceService access$2(GDServerCallbacks gDServerCallbacks) {
        return gDServerCallbacks.lanDeviceService;
    }

    static /* synthetic */ DomainService access$3(GDServerCallbacks gDServerCallbacks) {
        return gDServerCallbacks.domainService;
    }

    static /* synthetic */ DynDNSService access$4(GDServerCallbacks gDServerCallbacks) {
        return gDServerCallbacks.dynDNSService;
    }

    static /* synthetic */ boolean access$5(GDServerCallbacks gDServerCallbacks, String string) {
        return gDServerCallbacks.forceRebootIfRequired(string);
    }

    static /* synthetic */ void access$6(GDServerCallbacks gDServerCallbacks, String string) {
        gDServerCallbacks.forceUpgradeIfRequired(string);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type;
        }
        int[] nArray = new int[Message.Type.values().length];
        try {
            nArray[Message.Type.CONNECTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.DISCONNECTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.LOGS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.UPNP_STATUS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type = nArray;
        return nArray;
    }
}

