/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.db.dao.FirmwareDAO;
import pl.smartapps.restserver.db.main.FirmwareEntity;
import pl.smartapps.restserver.service.FirmwareService;
import pl.smartapps.restserver.service.FirmwareVersion;
import pl.smartapps.restserver.service.impl.FirmwareServiceImpl;
import pl.smartapps.restserver.service.impl.GetFirmwareVersionException;

@Service
public class FirmwareServiceImpl
implements FirmwareService {
    private FirmwareDAO firmwareDAO;

    @Autowired
    @Required
    public void setFirmwareDAO(FirmwareDAO firmwareDAO) {
        this.firmwareDAO = firmwareDAO;
    }

    public List<FirmwareVersion> getFirmwareVersions(String mac) {
        this.throwIf(StringUtils.isBlank((CharSequence)mac), GetFirmwareVersionException.ErrorCode.NO_MAC);
        ArrayList<FirmwareVersion> versions = new ArrayList<FirmwareVersion>();
        for (FirmwareEntity firmware : this.filter(this.firmwareDAO.getAll(), mac)) {
            FirmwareVersion version = new FirmwareVersion();
            version.setDeviceClass(firmware.getDeviceClass());
            version.setVendor(firmware.getVendor());
            version.setModel(firmware.getModel());
            version.setDomain(firmware.getDomain());
            version.setVersion(firmware.getVersion());
            version.setUrl(firmware.getUrl());
            version.setMd5(firmware.getMd5());
            versions.add(version);
        }
        return versions;
    }

    private List<FirmwareEntity> filter(List<FirmwareEntity> firmwares, String mac) {
        HashMap<Key, FirmwareEntity> selectedFirmwares = new HashMap<Key, FirmwareEntity>();
        for (FirmwareEntity firmware : firmwares) {
            Key key = new Key(this, firmware);
            if (!selectedFirmwares.containsKey(key)) {
                if (!firmware.isInRange(mac)) continue;
                selectedFirmwares.put(key, firmware);
                continue;
            }
            FirmwareEntity selectedFirmware = (FirmwareEntity)selectedFirmwares.get(key);
            if (!firmware.isNewer(selectedFirmware) || !firmware.isInRange(mac)) continue;
            selectedFirmwares.put(key, firmware);
        }
        return new ArrayList<FirmwareEntity>(selectedFirmwares.values());
    }

    private void throwIf(boolean condition, GetFirmwareVersionException.ErrorCode errorCode) {
        if (condition) {
            throw new GetFirmwareVersionException(errorCode);
        }
    }
}

