/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.allen_sauer.gwt.log.client.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.impl.AwsS3Controller;
import pl.smartapps.restserver.service.impl.LocalFilesController;

@Component
public class EventsFilesControllerFactory
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static String eventsStorageType;

    @Value(value="${lanDevice.eventsStorageType:local}")
    public void setEventsStorageType(String eventsStorageType) {
        EventsFilesControllerFactory.eventsStorageType = eventsStorageType;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        EventsFilesControllerFactory.applicationContext = applicationContext;
    }

    public EventsFilesController getEventsFilesController() {
        EventsFilesController controller = null;
        if (eventsStorageType.trim().equals("s3")) {
            Log.info((String)"Setting events storage to S3.");
            controller = (EventsFilesController)applicationContext.getBean(AwsS3Controller.class);
        } else if (eventsStorageType.trim().equals("local")) {
            Log.info((String)"Setting events storage to local.");
            controller = (EventsFilesController)applicationContext.getBean(LocalFilesController.class);
        } else {
            Log.error((String)"Wrong type or no events storage defined!");
        }
        return controller;
    }
}

