/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.Eventlog;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.restserver.db.dao.EventlogDAO;
import pl.smartapps.restserver.db.main.EventlogEntity;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.EventlogServiceImpl;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={EventlogServiceImpl.class})
public class EventlogServiceImplTests {
    private EventlogServiceImpl eventlogService;
    private AuthenticationUtils authUtils;
    private EventlogDAO eventlogDAO;

    @Before
    public void setUp() {
        this.eventlogService = new EventlogServiceImpl();
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.eventlogService.setAuthUtils(this.authUtils);
        this.eventlogDAO = (EventlogDAO)PowerMock.createMock(EventlogDAO.class);
        this.eventlogService.setEventlogDAO(this.eventlogDAO);
    }

    @Test
    public void testGetEventlogsSuccess() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<EventlogEntity> eventlogs = new ArrayList<EventlogEntity>();
        EventlogEntity eventlog1 = new EventlogEntity();
        eventlog1.setEventId(Integer.valueOf(1));
        eventlog1.setSource("GD");
        eventlog1.setSourceMac("00:1A:B6:00:0E:9A");
        eventlog1.setSourceIp("192.168.21.18");
        eventlog1.setEventType("CONNECT");
        eventlog1.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        eventlog1.setStatus(null);
        eventlog1.setDescription(null);
        eventlogs.add(eventlog1);
        EventlogEntity eventlog2 = new EventlogEntity();
        eventlog2.setEventId(Integer.valueOf(1));
        eventlog2.setSource("GD");
        eventlog2.setSourceMac("00:1A:B6:00:0E:9A");
        eventlog2.setSourceIp("192.168.21.18");
        eventlog2.setEventType("ACTIVATE");
        eventlog2.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        eventlog2.setStatus("OK");
        eventlog2.setDescription(null);
        eventlogs.add(eventlog2);
        EventlogEntity eventlog3 = new EventlogEntity();
        eventlog3.setEventId(Integer.valueOf(1));
        eventlog3.setSource("LD");
        eventlog3.setSourceMac("00:1A:B6:00:0E:9A");
        eventlog3.setSourceIp("192.168.21.18");
        eventlog3.setEventType("CONFIGURE");
        eventlog3.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        eventlog3.setStatus("ERROR");
        eventlog3.setDescription("Error message");
        eventlogs.add(eventlog3);
        EasyMock.expect((Object)this.eventlogDAO.findEventlogs()).andReturn(eventlogs);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<Eventlog> expectedResponse = new ArrayList<Eventlog>();
        Eventlog dto1 = new Eventlog();
        dto1.setEventId(Integer.valueOf(1));
        dto1.setSource("GD");
        dto1.setSourceMac("00:1A:B6:00:0E:9A");
        dto1.setSourceIp("192.168.21.18");
        dto1.setEventType("CONNECT");
        dto1.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        dto1.setStatus(null);
        dto1.setDescription(null);
        expectedResponse.add(dto1);
        Eventlog dto2 = new Eventlog();
        dto2.setEventId(Integer.valueOf(1));
        dto2.setSource("GD");
        dto2.setSourceMac("00:1A:B6:00:0E:9A");
        dto2.setSourceIp("192.168.21.18");
        dto2.setEventType("ACTIVATE");
        dto2.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        dto2.setStatus("OK");
        dto2.setDescription(null);
        expectedResponse.add(dto2);
        Eventlog dto3 = new Eventlog();
        dto3.setEventId(Integer.valueOf(1));
        dto3.setSource("LD");
        dto3.setSourceMac("00:1A:B6:00:0E:9A");
        dto3.setSourceIp("192.168.21.18");
        dto3.setEventType("CONFIGURE");
        dto3.setTimestamp(Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44));
        dto3.setStatus("ERROR");
        dto3.setDescription("Error message");
        expectedResponse.add(dto3);
        List response = this.eventlogService.getEventlogs();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventlogsSuccessEmptyList() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList eventlogs = new ArrayList();
        EasyMock.expect((Object)this.eventlogDAO.findEventlogs()).andReturn(eventlogs);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList expectedResponse = new ArrayList();
        List response = this.eventlogService.getEventlogs();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventlogsFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventlogDAO.findEventlogs()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.eventlogService.getEventlogs();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterGCEventlog() throws Exception {
        Date date = Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EventlogEntity newEventlog = new EventlogEntity();
        newEventlog.setEventId(null);
        newEventlog.setSource("GD");
        newEventlog.setSourceMac("00:1A:B6:00:0E:9A");
        newEventlog.setSourceIp("192.168.21.18");
        newEventlog.setEventType("CONNECT");
        newEventlog.setTimestamp(date);
        newEventlog.setStatus("OK");
        newEventlog.setDescription("message");
        EventlogEntity savedEventlog = new EventlogEntity();
        savedEventlog.setEventId(Integer.valueOf(1));
        savedEventlog.setSource("GD");
        savedEventlog.setSourceMac("00:1A:B6:00:0E:9A");
        savedEventlog.setSourceIp("192.168.21.18");
        savedEventlog.setEventType("CONNECT");
        savedEventlog.setTimestamp(date);
        savedEventlog.setStatus("OK");
        savedEventlog.setDescription("message");
        EasyMock.expect((Object)this.eventlogDAO.createEventlogWithTransaction(newEventlog)).andReturn((Object)savedEventlog);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventlogService.registerEventlog(GCEventType.CONNECT, "00:1A:B6:00:0E:9A", "192.168.21.18", "OK", "message");
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterGCEventlogMinimumData() throws Exception {
        Date date = Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EventlogEntity newEventlog = new EventlogEntity();
        newEventlog.setEventId(null);
        newEventlog.setSource("GD");
        newEventlog.setSourceMac(null);
        newEventlog.setSourceIp(null);
        newEventlog.setEventType("CONNECT");
        newEventlog.setTimestamp(date);
        newEventlog.setStatus(null);
        newEventlog.setDescription(null);
        EventlogEntity savedEventlog = new EventlogEntity();
        savedEventlog.setEventId(Integer.valueOf(1));
        savedEventlog.setSource("GD");
        savedEventlog.setSourceMac(null);
        savedEventlog.setSourceIp(null);
        savedEventlog.setEventType("CONNECT");
        savedEventlog.setTimestamp(date);
        savedEventlog.setStatus(null);
        savedEventlog.setDescription(null);
        EasyMock.expect((Object)this.eventlogDAO.createEventlogWithTransaction(newEventlog)).andReturn((Object)savedEventlog);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventlogService.registerEventlog(GCEventType.CONNECT, null, null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterLDEventlog() throws Exception {
        Date date = Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EventlogEntity newEventlog = new EventlogEntity();
        newEventlog.setEventId(null);
        newEventlog.setSource("LD");
        newEventlog.setSourceMac("00:1A:B6:00:0E:9A");
        newEventlog.setSourceIp("192.168.21.18");
        newEventlog.setEventType("CONFIGURE");
        newEventlog.setTimestamp(date);
        newEventlog.setStatus("OK");
        newEventlog.setDescription("message");
        EventlogEntity savedEventlog = new EventlogEntity();
        savedEventlog.setEventId(Integer.valueOf(1));
        savedEventlog.setSource("LD");
        savedEventlog.setSourceMac("00:1A:B6:00:0E:9A");
        savedEventlog.setSourceIp("192.168.21.18");
        savedEventlog.setEventType("CONFIGURE");
        savedEventlog.setTimestamp(date);
        savedEventlog.setStatus("OK");
        savedEventlog.setDescription("message");
        EasyMock.expect((Object)this.eventlogDAO.createEventlogWithTransaction(newEventlog)).andReturn((Object)savedEventlog);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:1A:B6:00:0E:9A", "192.168.21.18", "OK", "message");
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterLDEventlogMinimumData() throws Exception {
        Date date = Utils.constructDate((int)2011, (int)6, (int)10, (int)11, (int)43, (int)44);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EventlogEntity newEventlog = new EventlogEntity();
        newEventlog.setEventId(null);
        newEventlog.setSource("LD");
        newEventlog.setSourceMac(null);
        newEventlog.setSourceIp(null);
        newEventlog.setEventType("CONFIGURE");
        newEventlog.setTimestamp(date);
        newEventlog.setStatus(null);
        newEventlog.setDescription(null);
        EventlogEntity savedEventlog = new EventlogEntity();
        savedEventlog.setEventId(Integer.valueOf(1));
        newEventlog.setSource("LD");
        newEventlog.setSourceMac(null);
        newEventlog.setSourceIp(null);
        newEventlog.setEventType("CONFIGURE");
        newEventlog.setTimestamp(date);
        newEventlog.setStatus(null);
        newEventlog.setDescription(null);
        EasyMock.expect((Object)this.eventlogDAO.createEventlogWithTransaction(newEventlog)).andReturn((Object)savedEventlog);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, null, null);
        PowerMock.verifyAll();
    }
}

