/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.hm.WebViewer.shared.model.Eventlog;
import pl.smartapps.hm.WebViewer.shared.model.EventlogSource;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.restserver.db.dao.EventlogDAO;
import pl.smartapps.restserver.db.main.EventlogEntity;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

@Service
public class EventlogServiceImpl
implements EventlogService {
    private static Logger log = Logger.getLogger(EventlogServiceImpl.class);
    private AuthenticationUtils authUtils;
    private EventlogDAO eventlogDAO;

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setEventlogDAO(EventlogDAO eventlogDAO) {
        this.eventlogDAO = eventlogDAO;
    }

    public List<Eventlog> getEventlogs() throws InvalidSessionException {
        log.debug((Object)"start getEventlogs()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List eventlogs = this.eventlogDAO.findEventlogs();
        return eventlogs == null ? null : EventlogEntity.toDTOs((List)eventlogs);
    }

    public List<Eventlog> getEventlogs(Date dateFrom, Date dateTo, EventlogSource source, String macAddress, String ipAddress, String eventType) throws InvalidSessionException {
        log.debug((Object)("start getEventlogs(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", source=" + source + ", macAddress=" + macAddress + ", ipAddress=" + ipAddress + ", eventType=" + eventType + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List eventlogs = this.eventlogDAO.findEventlogs(dateFrom, dateTo, source, macAddress, ipAddress, eventType);
        return eventlogs == null ? null : EventlogEntity.toDTOs((List)eventlogs);
    }

    @Transactional
    public void registerEventlog(GCEventType eventType, String sourceMac, String sourceIp, String status, String description) {
        this.registerEventlog(eventType, null, sourceMac, sourceIp, status, description);
    }

    @Transactional
    public void registerEventlog(LDEventType eventType, String sourceMac, String sourceIp, String status, String description) {
        this.registerEventlog(null, eventType, sourceMac, sourceIp, status, description);
    }

    private void registerEventlog(GCEventType gcEventType, LDEventType ldEventType, String sourceMac, String sourceIp, String status, String description) {
        log.debug((Object)("start registerEventlog(gcEventType=" + gcEventType + ", ldEventType=" + ldEventType + ", sourceMac=" + sourceMac + ", sourceIp=" + sourceIp + ", status=" + status + ", description=" + description + ")"));
        EventlogEntity eventlog = new EventlogEntity();
        eventlog.setSourceMac(sourceMac);
        eventlog.setSourceIp(sourceIp);
        eventlog.setStatus(status);
        eventlog.setDescription(description);
        if (gcEventType != null) {
            if (gcEventType.equals((Object)GCEventType.CLIENTICE) || gcEventType.equals((Object)GCEventType.VIDEOSTREAM)) {
                eventlog.setSource(EventlogSource.VIEWER.name());
            } else {
                eventlog.setSource(EventlogSource.GC.name());
            }
            eventlog.setEventType(gcEventType.name());
        } else {
            eventlog.setSource(EventlogSource.LD.name());
            eventlog.setEventType(ldEventType.name());
        }
        eventlog.setTimestamp(new Date());
        EventlogEntity savedEventlog = this.eventlogDAO.createEventlogWithTransaction(eventlog);
        if (savedEventlog == null) {
            log.warn((Object)"Eventlog has not been recoded!");
        }
    }
}

