/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.response.GatewayDevice;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.LockModeType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.transaction.TransactionStatus;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.Event;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.ProcessEventResponse;
import pl.smartapps.restserver.rest.response.RecordingControlResponse;
import pl.smartapps.restserver.rest.response.RemoveEventResponse;
import pl.smartapps.restserver.service.AndroidNotificationService;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoPostprocessingService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AndroidNotificationServiceImpl;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.AwsS3Controller;
import pl.smartapps.restserver.service.impl.CreateSnapshotEventException;
import pl.smartapps.restserver.service.impl.EventNotificationType;
import pl.smartapps.restserver.service.impl.EventServiceImpl;
import pl.smartapps.restserver.service.impl.ProductBuilder;
import pl.smartapps.restserver.service.impl.StopVideoRecordingException;
import pl.smartapps.restserver.service.impl.TransactionUtility;
import pl.smartapps.restserver.service.impl.VideoRecorderServiceImpl;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={EventServiceImpl.class, pl.smartapps.restserver.util.Utils.class, FileUtils.class, StringUtils.class})
public class EventServiceTests {
    private EventServiceImpl eventService;
    private LanDeviceDAO lanDeviceDAO;
    private EventDAO eventDAO;
    private EventNotificationDAO eventNotificationDAO;
    private AuthenticationUtils authUtils;
    private DeviceDriverFactory deviceDriverFactory;
    private PushNotificationGate iphoneNotificationService;
    private VideoRecorderServiceImpl videoRecorderService;
    private SystemSupport systemSupport;
    private EmailNotificationService emailNotificationService;
    private TransactionUtility transactionUtility;
    private VideoPostprocessingService videoPostprocessingService;
    private ParameterService parameterService;
    private AndroidNotificationServiceImpl androidNotificationService;
    private static final String CAMERA_NAME = "TC5633-TCSW-0100h";
    private static final String BRICKCOM_CAMERA_NAME = "Brickcom";
    private EventsFilesController eventsFilesController;
    private GatewayDeviceConnectionService connectionService;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        this.eventService = new EventServiceImpl();
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.eventService.setLanDeviceDAO(this.lanDeviceDAO);
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.eventService.setEventDAO(this.eventDAO);
        this.eventNotificationDAO = (EventNotificationDAO)PowerMock.createMock(EventNotificationDAO.class);
        this.eventService.setEventNotificationDAO(this.eventNotificationDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.eventService.setAuthUtils(this.authUtils);
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.eventService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.iphoneNotificationService = (PushNotificationGate)PowerMock.createMock(PushNotificationGate.class);
        this.eventService.setApnsNotificationGate(this.iphoneNotificationService);
        this.videoRecorderService = (VideoRecorderServiceImpl)PowerMock.createMock(VideoRecorderServiceImpl.class);
        this.eventService.setVideoRecorderService(this.videoRecorderService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.eventService.setSystemSupport(this.systemSupport);
        this.emailNotificationService = (EmailNotificationService)PowerMock.createMock(EmailNotificationService.class);
        this.eventService.setEmailNotificationService(this.emailNotificationService);
        this.transactionUtility = (TransactionUtility)PowerMock.createMock(TransactionUtility.class);
        this.eventService.setTransactionUtility(this.transactionUtility);
        this.videoPostprocessingService = (VideoPostprocessingService)PowerMock.createMock(VideoPostprocessingService.class);
        this.eventService.setVideoPostprocessingService(this.videoPostprocessingService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.eventService.setParameterService(this.parameterService);
        this.eventService.setSnapshotsPath("/events/");
        this.androidNotificationService = (AndroidNotificationServiceImpl)PowerMock.createMock(AndroidNotificationServiceImpl.class);
        this.eventService.setAndroidNotificationService((AndroidNotificationService)this.androidNotificationService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.eventService.setParameterService(this.parameterService);
        this.connectionService = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.eventService.setConnectionService(this.connectionService);
        this.eventsFilesController = (EventsFilesController)PowerMock.createMock(AwsS3Controller.class);
    }

    @Test
    public void testGetEvents() throws InvalidSessionException {
        ArrayList<EventEntity> eventEntities = new ArrayList<EventEntity>();
        eventEntities.add(TestDataUtils.prepareEventEntity());
        EventEntity eventEntity = new EventEntity();
        eventEntity.setEventId(Integer.valueOf(2));
        Date startDate = Utils.constructDate((int)2011, (int)4, (int)11, (int)14, (int)40, (int)0);
        Date endDate = Utils.constructDate((int)2011, (int)4, (int)11, (int)14, (int)50, (int)0);
        eventEntity.setDateEvent(startDate);
        eventEntity.setDateStartRequested(startDate);
        eventEntity.setDateStarted(startDate);
        eventEntity.setDateStopped(endDate);
        eventEntity.setDateStopRequested(endDate);
        eventEntity.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        eventEntity.setVideoFileSize(Integer.valueOf(123));
        eventEntity.setDeletedVideo(false);
        eventEntity.setDeleted(false);
        eventEntity.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true));
        eventEntity.setImageFileSize(Integer.valueOf(234));
        eventEntities.add(eventEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.eventDAO.findEventsByUserId(Integer.valueOf(1))).andReturn(eventEntities);
        ArrayList<Event> expectedResponse = new ArrayList<Event>();
        expectedResponse.add(TestDataUtils.prepareEvent());
        Event event = new Event();
        event.setCameraName(CAMERA_NAME);
        event.setDateEvent(startDate);
        event.setDateStarted(startDate);
        event.setDateStartRequested(startDate);
        event.setDateStopped(endDate);
        event.setDateStopRequested(endDate);
        event.setDuration(Integer.valueOf(600));
        event.setEventId(Integer.valueOf(2));
        event.setEventTrigger("MANUAL");
        event.setImageFileSize(Integer.valueOf(234));
        event.setLanDeviceId(Integer.valueOf(1));
        event.setVideoFileSize(Integer.valueOf(123));
        event.setDeletedVideoDate(null);
        event.setDeleted(Boolean.valueOf(false));
        event.setDeletedVideo(Boolean.valueOf(false));
        expectedResponse.add(event);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.eventService.getEvents();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventSnapshotFileAndVideoFileExists() throws InvalidSessionException {
        this.eventService.setSnapshotsPath("/events/data/");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        event.setImageFileSize(Integer.valueOf(123));
        event.setVideoFileSize(Integer.valueOf(123));
        event.setDeletedVideo(false);
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.jpg")).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.mp4")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Event response = this.eventService.getEvent(Integer.valueOf(1));
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(true));
        expectedResponse.setVideoExist(Boolean.valueOf(true));
        expectedResponse.setImageFileSize(Integer.valueOf(123));
        expectedResponse.setVideoFileSize(Integer.valueOf(123));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventSnapshotFileAndVideoFileNotExists() throws InvalidSessionException {
        this.eventService.setSnapshotsPath("/events/data/");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        event.setImageFileSize(Integer.valueOf(123));
        event.setVideoFileSize(Integer.valueOf(123));
        event.setDeletedVideo(false);
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.jpg")).andReturn((Object)false);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.mp4")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Event response = this.eventService.getEvent(Integer.valueOf(1));
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(false));
        expectedResponse.setVideoExist(Boolean.valueOf(false));
        expectedResponse.setImageFileSize(Integer.valueOf(123));
        expectedResponse.setVideoFileSize(Integer.valueOf(123));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventSnapshotFileExsitsAndVideoFileDeleted() throws InvalidSessionException {
        this.eventService.setSnapshotsPath("/events/data/");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        event.setImageFileSize(Integer.valueOf(123));
        event.setVideoFileSize(Integer.valueOf(123));
        event.setDeletedVideo(true);
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.jpg")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Event response = this.eventService.getEvent(Integer.valueOf(1));
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(false));
        expectedResponse.setVideoExist(Boolean.valueOf(false));
        expectedResponse.setImageFileSize(Integer.valueOf(123));
        expectedResponse.setVideoFileSize(Integer.valueOf(123));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventSnapshotFileSizeIsNullAndVideoFileSizeIsNull() throws InvalidSessionException {
        this.eventService.setSnapshotsPath("/events/data/");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        event.setImageFileSize(null);
        event.setVideoFileSize(null);
        event.setDeletedVideo(false);
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)event);
        PowerMock.replayAll((Object[])new Object[0]);
        Event response = this.eventService.getEvent(Integer.valueOf(1));
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(false));
        expectedResponse.setVideoExist(Boolean.valueOf(false));
        expectedResponse.setImageFileSize(null);
        expectedResponse.setVideoFileSize(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventSnapshotFileSizeIsZeroAndVideoFileSizeIsZero() throws InvalidSessionException {
        this.eventService.setSnapshotsPath("/events/data/");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        event.setImageFileSize(Integer.valueOf(0));
        event.setVideoFileSize(Integer.valueOf(0));
        event.setDeletedVideo(false);
        event.setDeletedVideo(false);
        event.setVideoFileSize(Integer.valueOf(0));
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)event);
        PowerMock.replayAll((Object[])new Object[0]);
        Event response = this.eventService.getEvent(Integer.valueOf(1));
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(false));
        expectedResponse.setVideoExist(Boolean.valueOf(false));
        expectedResponse.setImageFileSize(Integer.valueOf(0));
        expectedResponse.setVideoFileSize(Integer.valueOf(0));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveEvent() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.eventDAO.findEventByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareEventEntity());
        EventEntity deletedEvent = TestDataUtils.prepareEventEntity();
        deletedEvent.setDeleted(true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(deletedEvent)).andReturn((Object)deletedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveEventResponse response = this.eventService.removeEvent(Integer.valueOf(1));
        RemoveEventResponse expectedResponse = new RemoveEventResponse(RemoveEventResponse.RemoveEventStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventsWithPeriod() throws InvalidSessionException {
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expectLastCall().times(5);
        ArrayList<EventEntity> eventEntities = new ArrayList<EventEntity>();
        eventEntities.add(TestDataUtils.prepareEventEntity());
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(TestDataUtils.prepareEvent());
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), null, null, null)).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), null, null, null)).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(0), this.prepareEndRange())).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(-7), this.prepareEndRange())).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(-30), this.prepareEndRange())).andReturn(eventEntities);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(events, (Object)this.eventService.getEvents(null, null));
        Assert.assertEquals(events, (Object)this.eventService.getEvents("0", "any"));
        Assert.assertEquals(events, (Object)this.eventService.getEvents("1", "day"));
        Assert.assertEquals(events, (Object)this.eventService.getEvents("1", "week"));
        Assert.assertEquals(events, (Object)this.eventService.getEvents("1", "month"));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetEventsWithFileExistanceChecking() throws InvalidSessionException {
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expectLastCall().times(5);
        ArrayList<EventEntity> eventEntities = new ArrayList<EventEntity>();
        EventEntity eventEntity = TestDataUtils.prepareEventEntity();
        eventEntity.setImageFileSize(Integer.valueOf(123));
        eventEntity.setVideoFileSize(Integer.valueOf(123));
        eventEntity.setDeletedVideo(false);
        eventEntities.add(eventEntity);
        ArrayList<Event> events = new ArrayList<Event>();
        Event expectedResponse = TestDataUtils.prepareEvent();
        expectedResponse.setSnapshotExist(Boolean.valueOf(true));
        expectedResponse.setVideoExist(Boolean.valueOf(true));
        expectedResponse.setImageFileSize(Integer.valueOf(123));
        expectedResponse.setVideoFileSize(Integer.valueOf(123));
        events.add(expectedResponse);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), null, null, null)).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), null, null, null)).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(0), this.prepareEndRange())).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(-7), this.prepareEndRange())).andReturn(eventEntities);
        EasyMock.expect((Object)this.eventDAO.findEvents(Integer.valueOf(1), Integer.valueOf(1), this.prepareStartRange(-30), this.prepareEndRange())).andReturn(eventEntities);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController).times(5);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.jpg")).andReturn((Object)true).times(5);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController).times(5);
        EasyMock.expect((Object)this.eventsFilesController.fileExists("20110411143000_1.mp4")).andReturn((Object)true).times(5);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(events, (Object)this.eventService.getEventsWithFileExistanceChecking(null, null));
        Assert.assertEquals(events, (Object)this.eventService.getEventsWithFileExistanceChecking("0", "any"));
        Assert.assertEquals(events, (Object)this.eventService.getEventsWithFileExistanceChecking("1", "day"));
        Assert.assertEquals(events, (Object)this.eventService.getEventsWithFileExistanceChecking("1", "week"));
        Assert.assertEquals(events, (Object)this.eventService.getEventsWithFileExistanceChecking("1", "month"));
        PowerMock.verifyAll();
    }

    private Date prepareStartRange(int dayAddition) {
        GregorianCalendar endRange = new GregorianCalendar();
        endRange.add(6, dayAddition);
        endRange.set(11, 0);
        endRange.set(12, 0);
        endRange.set(13, 0);
        endRange.set(14, 0);
        return endRange.getTime();
    }

    private Date prepareEndRange() {
        GregorianCalendar startRange = new GregorianCalendar();
        startRange.set(11, 23);
        startRange.set(12, 59);
        startRange.set(13, 59);
        startRange.set(14, 999);
        return startRange.getTime();
    }

    @Test
    public void testStartVideoRecordingForNullVideoEncodingSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        foundDevice.setVideoEncoding(null);
        foundDevice.setParam("viewer_user", "viewerUser");
        foundDevice.setParam("viewer_pass", "viewerPass");
        foundDevice.setParam("path", "video2.mjpg");
        foundDevice.setParam("resolution", "640x480");
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 60000L}).andReturn((Object)endDateEvent);
        EventEntity notSavedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        notSavedEvent.setEventId(null);
        EventEntity savedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        EasyMock.expect((Object)this.eventDAO.createEvent(notSavedEvent)).andReturn((Object)savedEvent);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingForMjpegVideoEncodingSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        foundDevice.setVideoEncoding("MJPEG");
        foundDevice.setParam("viewer_user", "viewerUser");
        foundDevice.setParam("viewer_pass", "viewerPass");
        foundDevice.setParam("path", "video2.mjpg");
        foundDevice.setParam("resolution", "640x480");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "ON");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 60000L}).andReturn((Object)endDateEvent);
        EventEntity notSavedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        notSavedEvent.setEventId(null);
        EventEntity savedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        EasyMock.expect((Object)this.eventDAO.createEvent(notSavedEvent)).andReturn((Object)savedEvent);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingForMpeg4VideoEncodingSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        foundDevice.setVideoEncoding("MPEG4");
        foundDevice.setParam("viewer_user", "viewerUser");
        foundDevice.setParam("viewer_pass", "viewerPass");
        foundDevice.setParam("path", "video2.mjpg");
        foundDevice.setParam("resolution", "640x480");
        foundDevice.setParam("rtsp_port", "554");
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 60000L}).andReturn((Object)endDateEvent);
        EventEntity notSavedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        notSavedEvent.setEventId(null);
        EventEntity savedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        EasyMock.expect((Object)this.eventDAO.createEvent(notSavedEvent)).andReturn((Object)savedEvent);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingForH264VideoEncodingSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        foundDevice.setVideoEncoding("H264");
        foundDevice.setParam("viewer_user", "viewerUser");
        foundDevice.setParam("viewer_pass", "viewerPass");
        foundDevice.setParam("path", "video2.mjpg");
        foundDevice.setParam("resolution", "640x480");
        foundDevice.setParam("rtsp_port", "554");
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 60000L}).andReturn((Object)endDateEvent);
        EventEntity notSavedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        notSavedEvent.setEventId(null);
        EventEntity savedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        EasyMock.expect((Object)this.eventDAO.createEvent(notSavedEvent)).andReturn((Object)savedEvent);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingTooQuicklyFromPreviousRequest() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "ON");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        this.eventService.lastRecordingOrderDates.put(1, 10L);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingDeviceNotFound() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.FAILED_NODEVICEFOUND);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingFailure() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "ON");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 60000L}).andReturn((Object)endDateEvent);
        EventEntity notSavedEvent = this.prepareIncompleteEvent(foundDevice, currentDate, endDateEvent);
        notSavedEvent.setEventId(null);
        EasyMock.expect((Object)this.eventDAO.createEvent(notSavedEvent)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.ERROR);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStartVideoRecordingDisabled() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "OFF");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), true);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.FAILED_NOTSUPPORTED);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testStopVideoReording() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "ON");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        EventEntity event = this.prepareIncompleteEvent(foundDevice);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event)).andReturn((Object)event);
        this.videoRecorderService.stopRecording(Integer.valueOf(1));
        PowerMock.replayAll((Object[])new Object[0]);
        RecordingControlResponse response = this.eventService.recordingControl(Integer.valueOf(1), false);
        RecordingControlResponse expectedResponse = new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private EventEntity prepareIncompleteEvent(LanDeviceEntity device, Date startDate, Date endDate) {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setLanDevice(device);
        event.setDateEvent(startDate);
        event.setDateStartRequested(startDate);
        event.setDateStopRequested(endDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        return event;
    }

    private EventEntity prepareIncompleteEvent(LanDeviceEntity device) {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setLanDevice(device);
        Date startDate = new Date();
        Date endDate = new Date(startDate.getTime() + 60000L);
        event.setDateEvent(startDate);
        event.setDateStartRequested(startDate);
        event.setDateStopRequested(endDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        return event;
    }

    @Test
    public void testProcessUndefinedEventType() {
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessEventResponse response = this.eventService.processEvent(Integer.valueOf(1), null, null, "VIDEO", null, null, null);
        ProcessEventResponse expectedResponse = new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDTRIGGERTYPE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessManualEventType() {
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessEventResponse response = this.eventService.processEvent(Integer.valueOf(1), "MANUAL", null, "VIDEO", null, null, null);
        ProcessEventResponse expectedResponse = new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDTRIGGERTYPE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUndefinedMediaType() {
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessEventResponse response = this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, null, null, null, null);
        ProcessEventResponse expectedResponse = new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDMEDIATYPE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithMotionDetectionDisabled() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("audio_detection", "ON", "ON");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessEventResponse response = this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        ProcessEventResponse expectedResponse = new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_MOTIONDETECTIONDISABLED);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithAudioDetectionDisabled() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "OFF", "OFF");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(1);
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessEventResponse response = this.eventService.processEvent(Integer.valueOf(1), "AUDIO", null, "VIDEO", null, null, null);
        ProcessEventResponse expectedResponse = new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_AUDIODETECTIONDISABLED);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithNullVideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding(null);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithMjpegVideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "OFF");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    private void handleIphoneNotifications(int eventId, String cameraName) {
        ArrayList<EventNotificationEntity> iphoneEventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        iphoneEventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(iphoneEventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"" + cameraName + "\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":" + eventId + "}";
        this.iphoneNotificationService.sendMessage("123", payload);
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithMpeg4VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithH264VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithMjpegVideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    private void handleAndroidNotifications(int eventId, String cameraName) {
        ArrayList<EventNotificationEntity> androidEventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification2 = new EventNotificationEntity();
        eventNotification2.setEventnotificationId(Integer.valueOf(2));
        eventNotification2.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification2.setNotificationType("C2DM");
        eventNotification2.setToken("123-aaa");
        androidEventNotifications.add(eventNotification2);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(androidEventNotifications);
        EasyMock.expect((Object)this.androidNotificationService.sendMessage("123-aaa", "data.cameraid=1&data.eventid=" + eventId + "&data.cameraName=" + cameraName + "&data.dateEvent=1319445040000")).andReturn((Object)true);
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotificationAndWithAndroidNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithMpeg4VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithH264VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithSnapshotMediaTypeAndVideoRecordingEnabledAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "SNAPSHOT", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithMjpegVideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithMpeg4VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithH264VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithMjpegVideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 80, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithMpeg4VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithH264VideoEncodingWithVideoMediaTypeAndVideoRecordingEnabledAndNonDefaultVideoDurationAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 120000L}).andReturn((Object)endDateEvent);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"TC5633-TCSW-0100h\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithSnapshotMediaTypeAndVideoRecordingEnabledAndWithEmailNotificationAndWithIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        byte[] snapshot = new byte[5];
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "SNAPSHOT", Integer.valueOf(120), null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventFailureCreateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventFailureCreateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        ProcessEventResponse resp = this.eventService.processEvent(Integer.valueOf(1), "AUDIO", picture, "VIDEO", null, null, null);
        System.out.println(resp);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventWithEventDate() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        Date eventDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)28, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(eventDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(eventDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024102840_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventWithObsoleteEventDate() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        Date eventDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)20, (int)39);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventWithVideoClip() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        Date eventDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)28, (int)40);
        byte[] videoClip = new byte[10];
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"resolution", (String)"640x480", null));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(eventDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setVideoFileSize(Integer.valueOf(10));
        event.setDeletedVideo(false);
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(eventDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setVideoFileSize(Integer.valueOf(10));
        savedEvent.setDeletedVideo(false);
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024102840_1.mp4", videoClip)).andReturn((Object)true);
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToPoster("/events/20111024102840_1.mp4", "/events/20111024102840_1.jpg", "640x480", "H264")).andReturn((Object)123L);
        EventEntity eventWithSnapshot = new EventEntity();
        eventWithSnapshot.setLanDevice(device);
        eventWithSnapshot.setEventId(Integer.valueOf(1));
        eventWithSnapshot.setDateEvent(eventDate);
        eventWithSnapshot.setDateStartRequested(null);
        eventWithSnapshot.setDateStopRequested(null);
        eventWithSnapshot.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        eventWithSnapshot.setVideoFileSize(Integer.valueOf(10));
        eventWithSnapshot.setDeletedVideo(false);
        eventWithSnapshot.setImageFileSize(Integer.valueOf(123));
        EasyMock.expect((Object)this.eventDAO.updateEvent(eventWithSnapshot)).andReturn((Object)eventWithSnapshot);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/events/20111024102840_1.mp4")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, eventDate, videoClip);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsAndWithVideoMediaTypeVideoRecordingDisabledWithDefaultVideoDurationAndWihoutEmailNotificationAndWithoutIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsAndWithSnapshotMediaTypeVideoRecordingDisabledWithDefaultVideoDurationAndWihoutEmailNotificationAndWithoutIpnoneNotificationAndWithoutAndroidNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "SNAPSHOT", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsAndWithVideoMediaTypeVideoRecordingDisabledAndWihoutEmailNotificationAndWithoutIpnoneNotificationAndWithoutAndroidNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsAndWithSnapshotMediaTypeVideoRecordingDisabledAndWihoutEmailNotificationAndWithoutIpnoneNotification() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "SNAPSHOT", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithMotionOrAudioEventOngoingAlready() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EventEntity ongoingMotionEvent = new EventEntity();
        ongoingMotionEvent.setEventId(Integer.valueOf(1));
        ongoingMotionEvent.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEvent.setDateStarted(ongoingMotionEvent.getDateEvent());
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)900);
        ongoingMotionEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingMotionEvent);
        EventEntity ongoingMotionEventUpdate = new EventEntity();
        ongoingMotionEventUpdate.setEventId(Integer.valueOf(1));
        ongoingMotionEventUpdate.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEventUpdate.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEventUpdate.setDateStarted(ongoingMotionEventUpdate.getDateEvent());
        ongoingMotionEventUpdate.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        ongoingMotionEventUpdate.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.updateEvent(ongoingMotionEventUpdate)).andReturn((Object)ongoingMotionEventUpdate);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.updateRequestedStopTime(Integer.valueOf(1), Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithMotionOrAudioEventOngoingAlreadyDurationLimitExceeded() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)50, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity ongoingMotionEvent = new EventEntity();
        ongoingMotionEvent.setEventId(Integer.valueOf(1));
        ongoingMotionEvent.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEvent.setDateStarted(ongoingMotionEvent.getDateEvent());
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)900);
        ongoingMotionEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingMotionEvent);
        EventEntity ongoingMotionEventUpdate = new EventEntity();
        ongoingMotionEventUpdate.setEventId(Integer.valueOf(1));
        ongoingMotionEventUpdate.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEventUpdate.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEventUpdate.setDateStarted(ongoingMotionEventUpdate.getDateEvent());
        ongoingMotionEventUpdate.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)44, (int)40));
        ongoingMotionEventUpdate.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.updateEvent(ongoingMotionEventUpdate)).andReturn((Object)ongoingMotionEventUpdate);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.updateRequestedStopTime(Integer.valueOf(1), Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)44, (int)40));
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithMotionOrAudioEventOngoingAlready() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EventEntity ongoingMotionEvent = new EventEntity();
        ongoingMotionEvent.setEventId(Integer.valueOf(1));
        ongoingMotionEvent.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEvent.setDateStarted(ongoingMotionEvent.getDateEvent());
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)900);
        ongoingMotionEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingMotionEvent);
        EventEntity ongoingMotionEventUpdate = new EventEntity();
        ongoingMotionEventUpdate.setEventId(Integer.valueOf(1));
        ongoingMotionEventUpdate.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEventUpdate.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEventUpdate.setDateStarted(ongoingMotionEventUpdate.getDateEvent());
        ongoingMotionEventUpdate.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        ongoingMotionEventUpdate.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        EasyMock.expect((Object)this.eventDAO.updateEvent(ongoingMotionEventUpdate)).andReturn((Object)ongoingMotionEventUpdate);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.updateRequestedStopTime(Integer.valueOf(1), Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithMotionOrAudioEventOngoingAlreadyFailureUpdateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EventEntity ongoingMotionEvent = new EventEntity();
        ongoingMotionEvent.setEventId(Integer.valueOf(1));
        ongoingMotionEvent.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEvent.setDateStarted(ongoingMotionEvent.getDateEvent());
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)900);
        ongoingMotionEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingMotionEvent);
        EventEntity ongoingMotionEventUpdate = new EventEntity();
        ongoingMotionEventUpdate.setEventId(Integer.valueOf(1));
        ongoingMotionEventUpdate.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEventUpdate.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEventUpdate.setDateStarted(ongoingMotionEventUpdate.getDateEvent());
        ongoingMotionEventUpdate.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        ongoingMotionEventUpdate.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.updateEvent(ongoingMotionEventUpdate)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithMotionOrAudioEventOngoingAlreadyFailureUpdateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EventEntity ongoingMotionEvent = new EventEntity();
        ongoingMotionEvent.setEventId(Integer.valueOf(1));
        ongoingMotionEvent.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEvent.setDateStarted(ongoingMotionEvent.getDateEvent());
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)900);
        ongoingMotionEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingMotionEvent);
        EventEntity ongoingMotionEventUpdate = new EventEntity();
        ongoingMotionEventUpdate.setEventId(Integer.valueOf(1));
        ongoingMotionEventUpdate.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        ongoingMotionEventUpdate.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingMotionEventUpdate.setDateStarted(ongoingMotionEventUpdate.getDateEvent());
        ongoingMotionEventUpdate.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)31, (int)10));
        ongoingMotionEventUpdate.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        EasyMock.expect((Object)this.eventDAO.updateEvent(ongoingMotionEventUpdate)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithManualEventOngoingAlready() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity ongoingManualEvent = new EventEntity();
        ongoingManualEvent.setEventId(Integer.valueOf(1));
        ongoingManualEvent.setLanDevice(device);
        ongoingManualEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingManualEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingManualEvent.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingManualEvent);
        EventEntity motionEvent = new EventEntity();
        motionEvent.setEventId(null);
        motionEvent.setLanDevice(device);
        motionEvent.setDateEvent(currentDate);
        motionEvent.setDateStopRequested(null);
        motionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        motionEvent.setImageFileSize(Integer.valueOf(5));
        EventEntity motionEventSaved = new EventEntity();
        motionEventSaved.setEventId(Integer.valueOf(2));
        motionEventSaved.setLanDevice(device);
        motionEventSaved.setDateEvent(currentDate);
        motionEventSaved.setDateStopRequested(null);
        motionEventSaved.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        motionEventSaved.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(motionEvent)).andReturn((Object)motionEventSaved);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_2.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_2.jpg");
        this.handleIphoneNotifications(2, CAMERA_NAME);
        this.handleAndroidNotifications(2, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithManualEventOngoingAlready() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity ongoingManualEvent = new EventEntity();
        ongoingManualEvent.setEventId(Integer.valueOf(1));
        ongoingManualEvent.setLanDevice(device);
        ongoingManualEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingManualEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingManualEvent.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingManualEvent);
        EventEntity motionEvent = new EventEntity();
        motionEvent.setEventId(null);
        motionEvent.setLanDevice(device);
        motionEvent.setDateEvent(currentDate);
        motionEvent.setDateStopRequested(null);
        motionEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        motionEvent.setImageFileSize(Integer.valueOf(5));
        EventEntity motionEventSaved = new EventEntity();
        motionEventSaved.setEventId(Integer.valueOf(2));
        motionEventSaved.setLanDevice(device);
        motionEventSaved.setDateEvent(currentDate);
        motionEventSaved.setDateStopRequested(null);
        motionEventSaved.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        motionEventSaved.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(motionEvent)).andReturn((Object)motionEventSaved);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_2.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_2.jpg");
        this.handleIphoneNotifications(2, CAMERA_NAME);
        this.handleAndroidNotifications(2, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithManualEventOngoingAlreadyFailureCreateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity ongoingManualEvent = new EventEntity();
        ongoingManualEvent.setEventId(Integer.valueOf(1));
        ongoingManualEvent.setLanDevice(device);
        ongoingManualEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingManualEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingManualEvent.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingManualEvent);
        EventEntity motionEvent = new EventEntity();
        motionEvent.setEventId(null);
        motionEvent.setLanDevice(device);
        motionEvent.setDateEvent(currentDate);
        motionEvent.setDateStopRequested(null);
        motionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        motionEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(motionEvent)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithManualEventOngoingAlreadyFailureCreateEvent() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EventEntity ongoingManualEvent = new EventEntity();
        ongoingManualEvent.setEventId(Integer.valueOf(1));
        ongoingManualEvent.setLanDevice(device);
        ongoingManualEvent.setDateEvent(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)29, (int)40));
        ongoingManualEvent.setDateStopRequested(Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)55));
        ongoingManualEvent.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)ongoingManualEvent);
        EventEntity motionEvent = new EventEntity();
        motionEvent.setEventId(null);
        motionEvent.setLanDevice(device);
        motionEvent.setDateEvent(currentDate);
        motionEvent.setDateStopRequested(null);
        motionEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        motionEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(motionEvent)).andReturn(null);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] picture = new byte[5];
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", picture, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testStartManualVideoRecordingWithMotionEventOngoing() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)123L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VIDEORECORDING, "ON");
        foundDevice.setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(1);
        EventEntity currentMotionEvent = new EventEntity();
        currentMotionEvent.setEventId(Integer.valueOf(1));
        currentMotionEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn((Object)currentMotionEvent);
        this.transactionUtility.rollbackTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.recordingControl(Integer.valueOf(1), true);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver).times(3);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS).times(2);
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUndefinedEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver).times(3);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS).times(2);
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"Brickcom\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver).times(3);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS).times(2);
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUndefinedEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("motion_detection", "ON");
        device.setParam("alarm_limit", "15");
        device.setParam("record_video", "ON");
        device.setParam("video_recording_duration", "30");
        device.setParam("email_notification_0", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("event_led_light", "ON");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        ArrayList<EventNotificationEntity> eventNotifications = new ArrayList<EventNotificationEntity>();
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false));
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        eventNotifications.add(eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceId(Integer.valueOf(1))).andReturn(eventNotifications);
        String payload = "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"Brickcom\",\"11.10.24 10:30\"]}},\"cameraid\":1,\"eventid\":1}";
        this.iphoneNotificationService.sendMessage("123", payload);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsAndWithEventLedLightEnabledAndRecordingVideoEnabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "ON", "ON");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        device.setParam("rtsp_port", "554");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "H264", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithEventLedLightEnabledAndRecordVideoDisabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver).times(3);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithEventLedLightEnabledAndRecordVideoDisabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "ON", "ON");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver).times(3);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithEventLedLightEnabledAndRecordVideoDisabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"event_led_light", (String)"ON", (String)"ON"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithEventLedLightEnabledAndRecordVideoDisabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"event_led_light", (String)"ON", (String)"ON"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithEventLedLightDisabledAndRecordingVideoDisabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "OFF", "OFF");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithEventLedLightDisabledAndRecordingVideoDisabledAndEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("resolution", "640x480", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("audio_detection", "ON", "ON");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("event_led_light", "OFF", "OFF");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        GenericCamera driver = (GenericCamera)PowerMock.createMock(GenericCamera.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)driver.getCurrentSnapshot(device, "640x480")).andReturn((Object)snapshot);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventWithoutAnyOngoingEventsWithEventLedLightDisabledAndRecordingVideoDisabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"event_led_light", (String)"OFF", (String)"OFF"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventWithoutAnyOngoingEventsWithEventLedLightDisabledAndRecordingVideoDisabledAndNonEmptySnapshotForBrickcomCamera() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"audio_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"event_led_light", (String)"OFF", (String)"OFF"));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(null);
        event.setDateStopRequested(null);
        event.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(null);
        savedEvent.setDateStopRequested(null);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.AUDIO);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, BRICKCOM_CAMERA_NAME);
        this.handleAndroidNotifications(1, BRICKCOM_CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", BRICKCOM_CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.AUDIO_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessMotionEventForInvalidCameraAccount() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)1));
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessAudioEventForInvalidCameraAccount() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)1));
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "AUDIO", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForDisabledMotionDetection() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)9, (int)15, (int)9, (int)59, (int)59));
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit0Obtain() throws Exception {
        this.eventService.lastEventDates.put(1, 0L);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)3L);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit5Obtain() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)720000L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"5", (String)"5"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)9, (int)0, (int)58);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit10Obtain() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)360000L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"10", (String)"10"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)54, (int)58);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit15Obtain() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)240000L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)51, (int)58);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit30Obtain() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)120000L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)50, (int)58);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit60Obtain() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)60000L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)49, (int)58);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit0() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"0", (String)"0"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)0, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527080003_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527080003_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit5() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)720001L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)12, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527081200_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527081200_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit10() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)360001L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)6, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527080600_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527080600_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit15() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)240001L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)4, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527080400_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527080400_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit30() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)120001L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)2, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527080200_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527080200_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForAlarmLimit60() throws Exception {
        this.eventService.lastAlarmDates.put(1, new EventServiceImpl.LastAlarmDate(Long.valueOf(0L), Boolean.valueOf(false)));
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)60001L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)27, (int)8, (int)1, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20110527080100_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20110527080100_1.jpg");
        ArrayList eventNotifications = new ArrayList();
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.APNS)).andReturn(eventNotifications);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(Integer.valueOf(1), EventNotificationType.C2DM)).andReturn(eventNotifications);
        this.transactionUtility.commitTransaction(transactionStatus);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForInvalidLanDevice() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"60", (String)"60"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForNoAlarmScheduleMatch() {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        this.prepareOverlapTerm(params);
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"OFF", (String)"OO"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        device.setLanDeviceParams(params);
        device.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)9, (int)15, (int)9, (int)59, (int)59));
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessEventForNoAlarmScheduleNoMatch() throws Exception {
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)0L).times(2);
        Date currentDate = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)30, (int)40);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.ALARM_VIDEORECORDING, "ON");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        this.prepareNotOverlapBeforeTerm(params);
        this.prepareNotOverlapAfterTerm(params);
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)1, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)2, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)3, (String)"record_video", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)4, (String)"video_recording_duration", (String)"30", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)5, (String)"email_notification_0", (String)"q1@mail.com", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)6, (String)"email_notification_1", (String)"q2@mail.com", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)7, (String)"viewer_user", (String)"viewerUser", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)8, (String)"viewer_pass", (String)"viewerPass", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"path", (String)"video2.mjpg", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)10, (String)"resolution", (String)"640x480", null));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)11, (String)"rtsp_port", (String)"554", null));
        device.setLanDeviceParams(params);
        Date validTo = Utils.adjustDate((Date)currentDate, (int)5, (int)1);
        device.setValidTo(validTo);
        device.setUser(TestDataUtils.prepareUserEntity());
        TransactionStatus transactionStatus = (TransactionStatus)PowerMock.createMock(TransactionStatus.class);
        EasyMock.expect((Object)this.transactionUtility.startTransaction("Manage event transaction", 3)).andReturn((Object)transactionStatus);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndLock(Integer.valueOf(1), LockModeType.PESSIMISTIC_READ)).andReturn((Object)device);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION)).andReturn((Object)60);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(3);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        Date endDateEvent = Utils.constructDate((int)2011, (int)10, (int)24, (int)10, (int)32, (int)40);
        PowerMock.expectNew(Date.class, (Object[])new Object[]{currentDate.getTime() + 30000L}).andReturn((Object)endDateEvent);
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventId(null);
        event.setDateEvent(currentDate);
        event.setDateStartRequested(currentDate);
        event.setDateStopRequested(endDateEvent);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        event.setImageFileSize(Integer.valueOf(5));
        EventEntity savedEvent = new EventEntity();
        savedEvent.setLanDevice(device);
        savedEvent.setEventId(Integer.valueOf(1));
        savedEvent.setDateEvent(currentDate);
        savedEvent.setDateStartRequested(currentDate);
        savedEvent.setDateStopRequested(endDateEvent);
        savedEvent.setEventtrigger(EventServiceImpl.EventTrigger.MOTION);
        savedEvent.setImageFileSize(Integer.valueOf(5));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)savedEvent);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)this.systemSupport.saveFile("/events/20111024103040_1.jpg", snapshot)).andReturn((Object)true);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)this.eventsFilesController);
        this.eventsFilesController.uploadFile("/events/20111024103040_1.jpg");
        this.handleIphoneNotifications(1, CAMERA_NAME);
        this.handleAndroidNotifications(1, CAMERA_NAME);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", CAMERA_NAME);
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q1@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("q2@mail.com", EmailNotificationService.EmailCode.MOTION_DETECTION, "testLanguage", placeholders, attachments)).andReturn((Object)true);
        this.transactionUtility.commitTransaction(transactionStatus);
        this.videoRecorderService.startRecording(savedEvent, "192.168.21.138", 554, "viewerUser", "viewerPass", "video2.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, null, null);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordingStatusSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        ArrayList<LanDeviceEntity> foundDevices = new ArrayList<LanDeviceEntity>();
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(1)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(2)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(3)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(4)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(5)));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(foundDevices);
        ArrayList<LanDeviceEntity> deviceWithActiveRecordings = new ArrayList<LanDeviceEntity>();
        deviceWithActiveRecordings.add(new LanDeviceEntity(Integer.valueOf(1)));
        deviceWithActiveRecordings.add(new LanDeviceEntity(Integer.valueOf(3)));
        deviceWithActiveRecordings.add(new LanDeviceEntity(Integer.valueOf(5)));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserIdWithActiveEvents(Integer.valueOf(1))).andReturn(deviceWithActiveRecordings);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap<Integer, Boolean> expectedResponse = new HashMap<Integer, Boolean>();
        expectedResponse.put(1, Boolean.TRUE);
        expectedResponse.put(2, Boolean.FALSE);
        expectedResponse.put(3, Boolean.TRUE);
        expectedResponse.put(4, Boolean.FALSE);
        expectedResponse.put(5, Boolean.TRUE);
        Map response = this.eventService.getRecordingStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordingStatusFailureListDevices() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap expectedResponse = new HashMap();
        Map response = this.eventService.getRecordingStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordingStatusFailureListDevicesWithActiveRecordings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        ArrayList<LanDeviceEntity> foundDevices = new ArrayList<LanDeviceEntity>();
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(1)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(2)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(3)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(4)));
        foundDevices.add(new LanDeviceEntity(Integer.valueOf(5)));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(foundDevices);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserIdWithActiveEvents(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap<Integer, Boolean> expectedResponse = new HashMap<Integer, Boolean>();
        expectedResponse.put(1, Boolean.FALSE);
        expectedResponse.put(2, Boolean.FALSE);
        expectedResponse.put(3, Boolean.FALSE);
        expectedResponse.put(4, Boolean.FALSE);
        expectedResponse.put(5, Boolean.FALSE);
        Map response = this.eventService.getRecordingStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private void prepareOverlapTerm(List<LanDeviceParamEntity> params) {
        GregorianCalendar currentDate = new GregorianCalendar();
        GregorianCalendar startTime = new GregorianCalendar(0, 0, 0, currentDate.get(11), 0);
        GregorianCalendar endTime = new GregorianCalendar(0, 0, 0, startTime.get(11) + 1, 0);
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"no_alarm_start_time_1", (String)this.convertDateToText(startTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)10, (String)"no_alarm_end_time_1", (String)this.convertDateToText(endTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)11, (String)"no_alarm_weekdays_1", (String)this.prepareClashWeekdays(), (String)""));
    }

    private void prepareNotOverlapBeforeTerm(List<LanDeviceParamEntity> params) {
        GregorianCalendar currentDate = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar(0, 0, 0, currentDate.get(11), currentDate.get(12) - 1);
        GregorianCalendar startTime = new GregorianCalendar(0, 0, 0, currentDate.get(11) - 1, 0);
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"no_alarm_start_time_1", (String)this.convertDateToText(startTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)10, (String)"no_alarm_end_time_1", (String)this.convertDateToText(endTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)11, (String)"no_alarm_weekdays_1", (String)this.prepareNotClashWeekdays(), (String)""));
    }

    private void prepareNotOverlapAfterTerm(List<LanDeviceParamEntity> params) {
        GregorianCalendar currentDate = new GregorianCalendar();
        GregorianCalendar startTime = new GregorianCalendar(0, 0, 0, currentDate.get(11), currentDate.get(12) + 1);
        GregorianCalendar endTime = new GregorianCalendar(0, 0, 0, currentDate.get(11) + 1, 0);
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)9, (String)"no_alarm_start_time_1", (String)this.convertDateToText(startTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)10, (String)"no_alarm_end_time_1", (String)this.convertDateToText(endTime.getTime(), "HH:mm"), (String)""));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)11, (String)"no_alarm_weekdays_1", (String)this.prepareNotClashWeekdays(), (String)""));
    }

    private String prepareClashWeekdays() {
        GregorianCalendar currentDate = new GregorianCalendar();
        int[] weekdays = new int[7];
        int currentDay = currentDate.get(7);
        switch (currentDay) {
            case 2: {
                weekdays[0] = 1;
                break;
            }
            case 3: {
                weekdays[1] = 1;
                break;
            }
            case 4: {
                weekdays[2] = 1;
                break;
            }
            case 5: {
                weekdays[3] = 1;
                break;
            }
            case 6: {
                weekdays[4] = 1;
                break;
            }
            case 7: {
                weekdays[5] = 1;
                break;
            }
            case 1: {
                weekdays[6] = 1;
                break;
            }
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < weekdays.length) {
            text.append(weekdays[i]);
            ++i;
        }
        return text.toString();
    }

    private String prepareNotClashWeekdays() {
        GregorianCalendar currentDate = new GregorianCalendar();
        int[] weekdays = new int[]{1, 1, 1, 1, 1, 1, 1};
        int currentDay = currentDate.get(7);
        switch (currentDay) {
            case 2: {
                weekdays[0] = 0;
                break;
            }
            case 3: {
                weekdays[1] = 0;
                break;
            }
            case 4: {
                weekdays[2] = 0;
                break;
            }
            case 5: {
                weekdays[3] = 0;
                break;
            }
            case 6: {
                weekdays[4] = 0;
                break;
            }
            case 7: {
                weekdays[5] = 0;
                break;
            }
            case 1: {
                weekdays[6] = 0;
                break;
            }
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < weekdays.length) {
            text.append(weekdays[i]);
            ++i;
        }
        return text.toString();
    }

    private String convertDateToText(Date date, String format) {
        if (date == null || format == null || format.length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    @Test
    public void testStopVideoRecordingSuccessfully() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.connectionService.findById(mac)).andReturn((Object)gatewayDevice);
        EventEntity event = (EventEntity)PowerMock.createMock(EventEntity.class);
        Integer deviceId = 123;
        EasyMock.expect((Object)device.getLanDeviceId()).andReturn((Object)deviceId);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(deviceId)).andReturn((Object)event);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        event.setDateStopRequested(now);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event)).andReturn((Object)event);
        Integer evetnId = 234;
        EasyMock.expect((Object)event.getEventId()).andReturn((Object)evetnId);
        EasyMock.expect((Object)event.getDateStopRequested()).andReturn((Object)now);
        this.videoRecorderService.updateRequestedStopTime(evetnId, now);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingFailedToUpdateEvent() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.connectionService.findById(mac)).andReturn((Object)gatewayDevice);
        EventEntity event = (EventEntity)PowerMock.createMock(EventEntity.class);
        Integer deviceId = 123;
        EasyMock.expect((Object)device.getLanDeviceId()).andReturn((Object)deviceId);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(deviceId)).andReturn((Object)event);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        event.setDateStopRequested(now);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event)).andReturn(null);
        Integer evetnId = 234;
        EasyMock.expect((Object)event.getEventId()).andReturn((Object)evetnId);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.ERROR, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingNoActiveRecording() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        GatewayDevice gatewayDevice = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.connectionService.findById(mac)).andReturn((Object)gatewayDevice);
        Integer deviceId = 123;
        EasyMock.expect((Object)device.getLanDeviceId()).andReturn((Object)deviceId);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(deviceId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.NO_ACTIVE_RECORDING, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingDeviceNotConnected() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        String mac = "testMac";
        EasyMock.expect((Object)device.getMac()).andReturn((Object)mac);
        EasyMock.expect((Object)this.connectionService.findById(mac)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.DEVICE_DISCONNECTED, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingUnsupportedOperation() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"not-a-camera");
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.UNSUPPORTED_OPERATION, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingDeviceDeleted() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.DEVICE_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingDeviceNotExistsInDatabaseAtAll() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)false);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.DEVICE_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testStopVideoRecordingDeviceNoToken() {
        PowerMock.mockStatic(StringUtils.class);
        String token = "testToken";
        EasyMock.expect((Object)StringUtils.isBlank((CharSequence)token)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        StopVideoRecordingException.ErrorCode errorCode = null;
        try {
            this.eventService.stopVideoRecording(token);
        }
        catch (StopVideoRecordingException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)StopVideoRecordingException.ErrorCode.NO_TOKEN, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventSuccessfully() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = new byte[]{-127, -126, -125};
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EventEntity event = (EventEntity)PowerMock.createMock(EventEntity.class);
        PowerMock.expectNew(EventEntity.class, (Object[])new Object[0]).andReturn((Object)event);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        event.setDateEvent(now);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        event.setLanDevice(device);
        event.setImageFileSize(Integer.valueOf(snapshot.length));
        EventEntity storedEvent = (EventEntity)PowerMock.createMock(EventEntity.class);
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn((Object)storedEvent);
        EasyMock.expect((Object)storedEvent.getDateEvent()).andReturn((Object)now);
        EasyMock.expect((Object)pl.smartapps.restserver.util.Utils.formatDate((Date)now, (String)"yyyyMMddHHmmss")).andReturn((Object)"timeOfEvent");
        EasyMock.expect((Object)storedEvent.getEventId()).andReturn((Object)123);
        File file = (File)PowerMock.createMock(File.class);
        String filepath = "/events/timeOfEvent_123.jpg";
        PowerMock.expectNew(File.class, (Object[])new Object[]{filepath}).andReturn((Object)file);
        FileUtils.writeByteArrayToFile((File)file, (byte[])snapshot);
        EventsFilesController eventsFilesController = (EventsFilesController)PowerMock.createMock(EventsFilesController.class);
        EasyMock.expect((Object)this.videoRecorderService.getEventsFilesController()).andReturn((Object)eventsFilesController);
        eventsFilesController.uploadFile(filepath);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventFailedToStoreEvent() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = new byte[]{-127, -126, -125};
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EventEntity event = (EventEntity)PowerMock.createMock(EventEntity.class);
        PowerMock.expectNew(EventEntity.class, (Object[])new Object[0]).andReturn((Object)event);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        event.setDateEvent(now);
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        event.setLanDevice(device);
        event.setImageFileSize(Integer.valueOf(snapshot.length));
        EasyMock.expect((Object)this.eventDAO.createEvent(event)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.ERROR, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventUnsupportedOperation() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = new byte[]{-127, -126, -125};
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"no-camera");
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.UNSUPPORTED_OPERATION, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventDeviceDeleted() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = new byte[]{-127, -126, -125};
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.DEVICE_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventNotFoundDevice() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = new byte[]{-127, -126, -125};
        EasyMock.expect((Object)this.lanDeviceDAO.getDeviceByToken(token)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.DEVICE_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventNoSnapshot() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = "testToken";
        byte[] snapshot = null;
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.NO_SNAPSHOT, (Object)errorCode);
    }

    @Test
    public void testCreateSnapshotEventNoToken() throws Exception {
        PowerMock.mockStatic(FileUtils.class);
        PowerMock.mockStatic(pl.smartapps.restserver.util.Utils.class);
        String token = null;
        byte[] snapshot = new byte[]{-127, -126, -125};
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSnapshotEventException.ErrorCode errorCode = null;
        try {
            this.eventService.createSnapshotEvent(token, snapshot);
        }
        catch (CreateSnapshotEventException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)CreateSnapshotEventException.ErrorCode.NO_TOKEN, (Object)errorCode);
    }
}

