/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.Event;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.ProcessEventResponse;
import pl.smartapps.restserver.rest.response.RecordingControlResponse;
import pl.smartapps.restserver.rest.response.RemoveEventResponse;
import pl.smartapps.restserver.rest.response.RemoveEventsResponse;
import pl.smartapps.restserver.service.AndroidNotificationService;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoPostprocessingService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.CreateEventException;
import pl.smartapps.restserver.service.impl.CreateSnapshotEventException;
import pl.smartapps.restserver.service.impl.EventNotificationType;
import pl.smartapps.restserver.service.impl.EventServiceImpl;
import pl.smartapps.restserver.service.impl.StopVideoRecordingException;
import pl.smartapps.restserver.service.impl.TransactionUtility;
import pl.smartapps.restserver.service.impl.VideoRecorderServiceImpl;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventServiceImpl
implements EventService {
    private static Logger log = Logger.getLogger(EventServiceImpl.class);
    private SystemSupport systemSupport;
    private EventDAO eventDAO;
    private AuthenticationUtils authUtils;
    private String snapshotsPath;
    private EmailNotificationService emailNotificationService;
    private EventNotificationDAO eventNotificationDAO;
    private DeviceDriverFactory deviceDriverFactory;
    private LanDeviceDAO lanDeviceDAO;
    private PushNotificationGate apnsNotificationGate;
    private VideoRecorderServiceImpl videoRecorderService;
    private TransactionUtility transactionUtility;
    private AndroidNotificationService androidNotificationService;
    private VideoPostprocessingService videoPostprocessingService;
    private ParameterService parameterService;
    private LanDeviceService lanDeviceService;
    private GatewayDeviceConnectionService connectionService;
    Map<Integer, Long> lastRecordingOrderDates = new ConcurrentHashMap();
    Map<Integer, Long> lastEventDates = new HashMap();
    Map<Integer, LastAlarmDate> lastAlarmDates = new HashMap();

    @Autowired
    @Required
    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setEmailNotificationService(EmailNotificationService emailNotificationService) {
        this.emailNotificationService = emailNotificationService;
    }

    @Value(value="${lanDevice.snapshotsPath:./events}")
    public void setSnapshotsPath(String snapshotsPath) {
        this.snapshotsPath = snapshotsPath;
    }

    @Autowired
    @Required
    public void setEventNotificationDAO(EventNotificationDAO eventNotificationDAO) {
        this.eventNotificationDAO = eventNotificationDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    @Qualifier(value="apnsNotificationGateImpl")
    public void setApnsNotificationGate(PushNotificationGate apnsNotificationGate) {
        this.apnsNotificationGate = apnsNotificationGate;
    }

    @Autowired
    @Required
    public void setVideoRecorderService(VideoRecorderServiceImpl videoRecorderService) {
        this.videoRecorderService = videoRecorderService;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setTransactionUtility(TransactionUtility transactionUtility) {
        this.transactionUtility = transactionUtility;
    }

    @Autowired
    @Required
    public void setAndroidNotificationService(AndroidNotificationService androidNotificationService) {
        this.androidNotificationService = androidNotificationService;
    }

    @Autowired
    @Required
    public void setVideoPostprocessingService(VideoPostprocessingService videoPostprocessingService) {
        this.videoPostprocessingService = videoPostprocessingService;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setConnectionService(GatewayDeviceConnectionService connectionService) {
        this.connectionService = connectionService;
    }

    public List<Event> getEvents() throws InvalidSessionException {
        log.debug((Object)"start getEvents()");
        this.authUtils.ensureLoggedIn();
        List eventEntities = this.eventDAO.findEventsByUserId(this.authUtils.getCurrentUserId());
        log.trace((Object)("Found own events: " + eventEntities));
        List sharedLanDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(this.authUtils.getCurrentUserId(), "camera");
        log.trace((Object)("Found shared events: " + eventEntities));
        for (LanDeviceEntity lanDeviceEntity : sharedLanDevices) {
            List foundEvents = this.eventDAO.findEvents(lanDeviceEntity.getUser().getId(), lanDeviceEntity.getLanDeviceId(), null, null);
            if (foundEvents == null) continue;
            eventEntities.addAll(foundEvents);
        }
        eventEntities = this.sortEventsByDate(eventEntities);
        return this.convertToDTOs(eventEntities);
    }

    @Transactional
    public List<Event> getEvents(String cameraId, String period) throws InvalidSessionException {
        log.debug((Object)("start getEvents(cameraId=" + cameraId + ", period=" + period + ")"));
        Integer lanDeviceId = null;
        Integer userId = this.authUtils.getCurrentUserId();
        if (cameraId != null && !cameraId.trim().equals("0")) {
            lanDeviceId = Integer.parseInt(cameraId);
            LanDeviceEntity lanDevice = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
            if (lanDevice == null) {
                return this.convertToDTOs(new ArrayList(), Boolean.valueOf(false));
            }
            userId = lanDevice.getUser().getId();
        }
        DateRange dateRange = this.prepareDateRange(period);
        List eventEntities = this.eventDAO.findEvents(userId, lanDeviceId, dateRange.getStartRage(), dateRange.getEndRange());
        if (lanDeviceId == null) {
            List sharedLanDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(userId, "camera");
            for (LanDeviceEntity lanDeviceEntity : sharedLanDevices) {
                List foundEvents = this.eventDAO.findEvents(lanDeviceEntity.getUser().getId(), lanDeviceEntity.getLanDeviceId(), dateRange.getStartRage(), dateRange.getEndRange());
                if (foundEvents == null) continue;
                eventEntities.addAll(foundEvents);
            }
        }
        eventEntities = this.sortEventsByDate(eventEntities);
        return this.convertToDTOs(eventEntities);
    }

    @Transactional
    public List<Event> getEventsWithFileExistanceChecking(String cameraId, String period) throws InvalidSessionException {
        log.debug((Object)("start getEvents(cameraId=" + cameraId + ", period=" + period + ")"));
        Integer lanDeviceId = null;
        Integer userId = this.authUtils.getCurrentUserId();
        if (cameraId != null && !cameraId.trim().equals("0")) {
            lanDeviceId = Integer.parseInt(cameraId);
            LanDeviceEntity lanDevice = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
            if (lanDevice == null) {
                return this.convertToDTOs(new ArrayList(), Boolean.valueOf(false));
            }
            userId = lanDevice.getUser().getId();
        }
        DateRange dateRange = this.prepareDateRange(period);
        List eventEntities = this.eventDAO.findEvents(userId, lanDeviceId, dateRange.getStartRage(), dateRange.getEndRange());
        if (lanDeviceId == null) {
            List sharedLanDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(userId, "camera");
            for (LanDeviceEntity lanDeviceEntity : sharedLanDevices) {
                List foundEvents = this.eventDAO.findEvents(lanDeviceEntity.getUser().getId(), lanDeviceEntity.getLanDeviceId(), dateRange.getStartRage(), dateRange.getEndRange());
                if (foundEvents == null) continue;
                eventEntities.addAll(foundEvents);
            }
        }
        eventEntities = this.sortEventsByDate(eventEntities);
        return this.convertToDTOs(eventEntities, Boolean.valueOf(true));
    }

    private List<EventEntity> sortEventsByDate(List<EventEntity> eventEntities) {
        Collections.sort(eventEntities, new EventsByDateComparator(this, null));
        return eventEntities;
    }

    private DateRange prepareDateRange(String period) {
        log.debug((Object)("start prepareDateRange(period=" + period + ")"));
        if (period == null || period.equals("any")) {
            return new DateRange(this);
        }
        if (period.equals("day")) {
            return new DateRange(this, this.prepareStartRange(0), this.prepareEndRange());
        }
        if (period.equals("week")) {
            return new DateRange(this, this.prepareStartRange(-7), this.prepareEndRange());
        }
        if (period.equals("month")) {
            return new DateRange(this, this.prepareStartRange(-30), this.prepareEndRange());
        }
        return null;
    }

    private Date prepareStartRange(int dayAddition) {
        GregorianCalendar endRange = new GregorianCalendar();
        endRange.add(6, dayAddition);
        endRange.set(11, 0);
        endRange.set(12, 0);
        endRange.set(13, 0);
        endRange.set(14, 0);
        return endRange.getTime();
    }

    private Date prepareEndRange() {
        GregorianCalendar startRange = new GregorianCalendar();
        startRange.set(11, 23);
        startRange.set(12, 59);
        startRange.set(13, 59);
        startRange.set(14, 999);
        return startRange.getTime();
    }

    public Event getEvent(Integer eventId) throws InvalidSessionException {
        log.debug((Object)("start getEvent(eventId=" + eventId + ")"));
        this.authUtils.ensureLoggedIn();
        EventEntity eventEntity = this.eventDAO.findEventById(eventId);
        if (!this.canCurrentUserAccessEvent(eventEntity)) {
            return null;
        }
        return this.convertToDTO(eventEntity, true);
    }

    private boolean canCurrentUserAccessEvent(EventEntity event) throws InvalidSessionException {
        Integer lanDeviceId = event.getLanDevice() != null ? event.getLanDevice().getLanDeviceId() : null;
        LanDeviceEntity lanDevice = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        return lanDevice != null;
    }

    public RemoveEventResponse removeEvent(Integer eventId) throws InvalidSessionException {
        log.debug((Object)("start removeEvent(eventId=" + eventId + ")"));
        this.authUtils.ensureLoggedIn();
        EventEntity eventEntity = this.eventDAO.findEventById(eventId);
        if (eventEntity == null || !this.canCurrentUserAccessEvent(eventEntity)) {
            return new RemoveEventResponse(RemoveEventResponse.RemoveEventStatus.FAILED_EVENTNOTFOUND);
        }
        this.forceStopRecordingIfRequired(eventEntity);
        eventEntity.setDeleted(true);
        EventEntity updatedEvent = this.eventDAO.updateEvent(eventEntity);
        if (updatedEvent == null) {
            return new RemoveEventResponse(RemoveEventResponse.RemoveEventStatus.ERROR);
        }
        return new RemoveEventResponse(RemoveEventResponse.RemoveEventStatus.SUCCESS);
    }

    private void forceStopRecordingIfRequired(EventEntity eventEntity) {
        if ((eventEntity.getDateStarted() != null || eventEntity.getDateStartRequested() != null) && eventEntity.getDateStopped() == null) {
            this.videoRecorderService.forceStopRecordingAndDeleteEvent(eventEntity.getEventId());
        }
    }

    public Event convertToDTO(EventEntity eventEntity, boolean checkFileExistence) {
        Event dto = new Event();
        LanDeviceEntity lanDevice = eventEntity.getLanDevice();
        Integer userId = this.authUtils.getCurrentUserId();
        dto.setCameraName(lanDevice.getNameForUserId(userId));
        dto.setDateEvent(eventEntity.getDateEvent());
        dto.setDateStarted(eventEntity.getDateStarted());
        dto.setDateStartRequested(eventEntity.getDateStartRequested());
        dto.setDateStopped(eventEntity.getDateStopped());
        dto.setDateStopRequested(eventEntity.getDateStopRequested());
        dto.setDuration(this.computeDuration(eventEntity));
        dto.setEventId(eventEntity.getEventId());
        dto.setEventTrigger(eventEntity.getEventtrigger().toString());
        dto.setImageFileSize(eventEntity.getImageFileSize());
        dto.setLanDeviceId(eventEntity.getLanDevice().getLanDeviceId());
        dto.setVideoFileSize(eventEntity.getVideoFileSize());
        dto.setDeletedVideo(Boolean.valueOf(eventEntity.getDeletedVideo()));
        dto.setDeletedVideoDate(eventEntity.getDeletedVideoDate());
        dto.setDeleted(Boolean.valueOf(eventEntity.getDeleted()));
        if (checkFileExistence) {
            if (eventEntity.getImageFileSize() == null || eventEntity.getImageFileSize() == 0) {
                dto.setSnapshotExist(Boolean.FALSE);
            } else {
                dto.setSnapshotExist(Boolean.valueOf(this.existFile(this.prepareEventFileName(eventEntity, "jpg"))));
            }
            if (eventEntity.getVideoFileSize() == null || eventEntity.getVideoFileSize() == 0 || eventEntity.getDeletedVideo()) {
                dto.setVideoExist(Boolean.FALSE);
            } else {
                dto.setVideoExist(Boolean.valueOf(this.existFile(this.prepareEventFileName(eventEntity, "mp4"))));
            }
        }
        return dto;
    }

    private boolean existFile(String filename) {
        log.debug((Object)("start existFile(filename=" + filename + ")"));
        if (filename == null || filename.length() == 0) {
            return false;
        }
        return this.videoRecorderService.getEventsFilesController().fileExists(filename);
    }

    private Integer computeDuration(EventEntity event) {
        if (event == null || event.getDateStarted() == null || event.getDateStopRequested() == null) {
            return 0;
        }
        return (int)((event.getDateStopRequested().getTime() - event.getDateStarted().getTime()) / 1000L);
    }

    public List<Event> convertToDTOs(List<EventEntity> eventEntities) {
        return this.convertToDTOs(eventEntities, Boolean.valueOf(false));
    }

    public List<Event> convertToDTOs(List<EventEntity> eventEntities, Boolean checkFileExistance) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (eventEntities != null) {
            for (EventEntity eventEntity : eventEntities) {
                events.add(this.convertToDTO(eventEntity, checkFileExistance.booleanValue()));
            }
        }
        return events;
    }

    private boolean blockProcessingRecordingOrder(Integer deviceId) {
        log.debug((Object)("start blockProcessingRecordingOrder(landeviceId=" + deviceId + ")"));
        Long lastRecodingTimestamp = (Long)this.lastRecordingOrderDates.get(deviceId);
        long currentTimestamp = this.systemSupport.currentTimeMillis();
        log.debug((Object)("lastRecodingTimestamp for device with landeviceId=" + deviceId + ": " + lastRecodingTimestamp + "."));
        if (lastRecodingTimestamp == null || currentTimestamp - lastRecodingTimestamp > 500L) {
            this.lastRecordingOrderDates.put(deviceId, currentTimestamp);
            return false;
        }
        return true;
    }

    public RecordingControlResponse recordingControl(Integer lanDeviceId, boolean isRecording) throws InvalidSessionException {
        log.debug((Object)("start recordingControl(lanDeviceId=" + lanDeviceId + ", isRecording=" + isRecording + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (device == null) {
            return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.FAILED_NODEVICEFOUND);
        }
        if (!this.isProductSupportRecording(device)) {
            log.info((Object)("Device with mac address '" + device.getMac() + "' has product without recording support."));
            return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.FAILED_NOTSUPPORTED);
        }
        if (isRecording) {
            if (this.blockProcessingRecordingOrder(lanDeviceId)) {
                log.warn((Object)("Recording order for device with lanDeviceId=" + lanDeviceId + " has been blocked."));
                return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
            }
            Date eventDate = this.systemSupport.getCurrentDate();
            ManageEventResult result = this.manageEvent(device.getLanDeviceId(), EventTrigger.MANUAL, null, MediaType.VIDEO, null, eventDate, null);
            if (ManageEventResult.access$0((ManageEventResult)result) == ManageEventStatus.START_RECORDING) {
                log.info((Object)("Starting manual video recording for lan device with landeviceId=" + lanDeviceId + "."));
                this.startVideoRecording(device, ManageEventResult.access$1((ManageEventResult)result));
                return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
            }
            if (ManageEventResult.access$0((ManageEventResult)result) == ManageEventStatus.NOTHING) {
                return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
            }
            return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.ERROR);
        }
        EventEntity currentEvent = this.eventDAO.getActiveEvent(device.getLanDeviceId());
        log.info((Object)("Stopping manual video recording for lan device with landeviceId=" + lanDeviceId + "."));
        return this.stopRecording(currentEvent);
    }

    private ManageEventResult manageEvent(Integer lanDeviceId, EventTrigger eventTrigger, byte[] snapshot, MediaType mediaType, Integer videoDuration, Date eventDate, byte[] videoClip) {
        TransactionStatus transactionStatus = this.transactionUtility.startTransaction("Manage event transaction", 3);
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        int timeAddition = this.prepareTimeAddition(device, eventTrigger, videoDuration);
        EventEntity currentEvent = null;
        if (videoClip == null) {
            currentEvent = this.eventDAO.getActiveEvent(device.getLanDeviceId());
        }
        if (currentEvent == null) {
            EventEntity event = this.createEvent(device, eventTrigger, mediaType, videoDuration, snapshot, true, eventDate, videoClip);
            if (event == null) {
                log.warn((Object)("Event for device with deviceId=" + device.getLanDeviceId() + " and eventTrigger=" + eventTrigger.name() + " was not saved."));
                this.transactionUtility.rollbackTransaction(transactionStatus);
                return new ManageEventResult(this, null, ManageEventStatus.ERROR, null);
            }
            if (snapshot != null) {
                log.debug((Object)("Saving snapshot for event " + event));
                if (!this.saveEventFile(snapshot, event, "jpg")) {
                    log.warn((Object)("Snapshot has not been saved for event " + event + "."));
                } else {
                    String filename = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(event, "jpg");
                    this.videoRecorderService.getEventsFilesController().uploadFile(filename);
                }
            }
            if ((eventTrigger == EventTrigger.MOTION || eventTrigger == EventTrigger.AUDIO) && videoClip == null) {
                this.sendEmailNotifications(device, eventTrigger, snapshot);
                this.sendIphoneNotifications(event);
                this.sendAndroidNotifications(event);
            }
            this.transactionUtility.commitTransaction(transactionStatus);
            if (videoClip == null && this.isVideoRecording(device, eventTrigger, mediaType)) {
                return new ManageEventResult(this, event, ManageEventStatus.START_RECORDING, null);
            }
            return new ManageEventResult(this, event, ManageEventStatus.NOTHING, null);
        }
        if (eventTrigger == EventTrigger.MANUAL && (currentEvent.getEventtrigger().equals((Object)EventTrigger.MOTION.name()) || currentEvent.getEventtrigger().equals((Object)EventTrigger.AUDIO.name()))) {
            log.debug((Object)"Detect MANUAL event during MOTION/AUDIO event");
            this.transactionUtility.rollbackTransaction(transactionStatus);
            return new ManageEventResult(this, null, ManageEventStatus.NOTHING, null);
        }
        if ((eventTrigger == EventTrigger.MOTION || eventTrigger == EventTrigger.AUDIO) && currentEvent.getEventtrigger().equals((Object)EventTrigger.MANUAL.name())) {
            log.debug((Object)"Detect MOTION/AUDIO event during MANUAL event");
            EventEntity event = this.createEvent(device, eventTrigger, mediaType, videoDuration, snapshot, false, eventDate, videoClip);
            if (event == null) {
                this.transactionUtility.rollbackTransaction(transactionStatus);
                return new ManageEventResult(this, event, ManageEventStatus.ERROR, null);
            }
            this.saveEventFile(snapshot, event, "jpg");
            String filename = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(event, "jpg");
            this.videoRecorderService.getEventsFilesController().uploadFile(filename);
            this.sendEmailNotifications(device, eventTrigger, snapshot);
            this.sendIphoneNotifications(event);
            this.sendAndroidNotifications(event);
            this.transactionUtility.commitTransaction(transactionStatus);
            return new ManageEventResult(this, event, ManageEventStatus.NOTHING, null);
        }
        if ((eventTrigger == EventTrigger.MOTION || eventTrigger == EventTrigger.AUDIO) && (currentEvent.getEventtrigger().equals((Object)EventTrigger.MOTION.name()) || currentEvent.getEventtrigger().equals((Object)EventTrigger.AUDIO.name()))) {
            log.debug((Object)"Detect MOTION/AUDIO event during MOTION/AUDIO event");
            try {
                currentEvent.setDateStopRequested(this.increaseDateWithLimit(timeAddition, currentEvent));
            }
            catch (Exception e) {
                log.warn((Object)("Exception during increaseDateWithLimit for eventId = " + currentEvent.getEventId() + " and mac = " + currentEvent.getLanDevice().getMac()));
                this.transactionUtility.rollbackTransaction(transactionStatus);
                return new ManageEventResult(this, currentEvent, ManageEventStatus.ERROR, null);
            }
            if (this.eventDAO.updateEvent(currentEvent) == null) {
                this.transactionUtility.rollbackTransaction(transactionStatus);
                return new ManageEventResult(this, currentEvent, ManageEventStatus.ERROR, null);
            }
            this.transactionUtility.commitTransaction(transactionStatus);
            return new ManageEventResult(this, currentEvent, ManageEventStatus.PROLONG_RECORDING, null);
        }
        this.transactionUtility.commitTransaction(transactionStatus);
        return new ManageEventResult(this, null, ManageEventStatus.NOTHING, null);
    }

    private EventEntity createEvent(LanDeviceEntity device, EventTrigger eventTrigger, MediaType mediaType, Integer videoDuration, byte[] snapshot, boolean recordVideoAllowed, Date eventDate, byte[] videoClip) {
        EventEntity event = new EventEntity();
        event.setLanDevice(device);
        event.setEventtrigger(eventTrigger);
        event.setDateEvent(eventDate);
        if (snapshot != null) {
            event.setImageFileSize(Integer.valueOf(snapshot.length));
        }
        if (videoClip == null && recordVideoAllowed && this.isVideoRecording(device, eventTrigger, mediaType)) {
            Date currentDate = this.systemSupport.getCurrentDate();
            event.setDateStartRequested(currentDate);
            int timeAddition = this.prepareTimeAddition(device, eventTrigger, videoDuration);
            event.setDateStopRequested(this.increaseDate(currentDate, timeAddition));
        } else if (videoClip != null) {
            event.setDateStopRequested(eventDate);
            event.setDateStopped(eventDate);
            String videoClipDurationValue = device.getParamValue("videoclip_duration");
            int videoClipDuration = videoClipDurationValue == null ? 0 : Integer.parseInt(videoClipDurationValue);
            Date startDate = this.increaseDate(eventDate, -videoClipDuration);
            event.setDateStarted(startDate);
            event.setDateStartRequested(startDate);
        }
        return this.eventDAO.createEvent(event);
    }

    private boolean isVideoRecording(LanDeviceEntity device, EventTrigger eventTrigger, MediaType mediaType) {
        return this.isVideoRecordingEnabled(device) && mediaType == MediaType.VIDEO || eventTrigger == EventTrigger.MANUAL;
    }

    private void startVideoRecording(LanDeviceEntity device, EventEntity event) {
        log.debug((Object)("start startVideoRecording(device with lanDeviceId=" + device.getLanDeviceId() + ", event with eventId=" + event.getEventId() + "."));
        if (this.isMotionOrAudioEvent(event) && this.isEventLedLightEnabled(device)) {
            this.switchIllumination(device, true);
        }
        String path = device.getParamValue("path");
        String viewerUsername = device.getParamValue("viewer_user");
        String viewerPassword = device.getParamValue("viewer_pass");
        String resolution = device.getParamValue("resolution");
        String videoEncoding = device.getVideoEncoding() == null ? "MJPEG" : device.getVideoEncoding();
        int port = videoEncoding.equals("MJPEG") ? device.getPort() : Integer.parseInt(device.getParamValue("rtsp_port"));
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        boolean supportsRtcpOverRtsp = driver.isRtcpOverRtspSupported();
        boolean audioEnabled = this.cameraHasAudioEnabled(device);
        this.videoRecorderService.startRecording(event, device.getIpAddress(), port, viewerUsername, viewerPassword, path, resolution, videoEncoding, supportsRtcpOverRtsp, audioEnabled);
    }

    private boolean cameraHasAudioEnabled(LanDeviceEntity device) {
        return !"MJPEG".equals(device.getVideoEncoding()) && "ON".equals(device.getParamValue("has_mute_audio")) && !"ON".equals(device.getParamValue("mute_audio"));
    }

    private boolean isMotionOrAudioEvent(EventEntity event) {
        return event.getEventtrigger() != null && (event.getEventtrigger().equals((Object)"MOTION") || event.getEventtrigger().equals((Object)"AUDIO"));
    }

    private boolean isEventLedLightEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("event_led_light"));
    }

    private void switchIllumination(LanDeviceEntity device, boolean enable) {
        UpdateSettingStatus status;
        log.trace((Object)("start switchIllumination(deviceId=" + device.getLanDeviceId() + ", enable=" + enable + ")"));
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (enable) {
            log.debug((Object)"Turn on illumiantion.");
            status = driver.updateSingleSetting(device, "illumination", "ON");
        } else {
            log.debug((Object)"Turn off illumiantion.");
            status = driver.updateSingleSetting(device, "illumination", "OFF");
        }
        log.debug((Object)("Turn on/off illumiantion status: " + status));
    }

    private RecordingControlResponse stopRecording(EventEntity event) {
        if (event == null) {
            log.debug((Object)"start stopRecording(event=null)");
            return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.FAILED_NORECORDING);
        }
        log.debug((Object)("start stopRecording(event with eventId=" + event.getEventId() + ")"));
        EventEntity updatedEvent = this.eventDAO.updateEvent(event);
        if (updatedEvent == null) {
            return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.ERROR);
        }
        this.videoRecorderService.stopRecording(updatedEvent.getEventId());
        return new RecordingControlResponse(RecordingControlResponse.RecordingControlStatus.SUCCESS);
    }

    public Map<Integer, Boolean> getRecordingStatus() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        HashMap<Integer, Boolean> states = new HashMap<Integer, Boolean>();
        List devices = this.lanDeviceDAO.findLanDevicesByUserId(this.authUtils.getCurrentUserId(), false);
        List sharedDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(this.authUtils.getCurrentUserId(), null);
        if (devices == null) {
            devices = sharedDevices;
        } else if (sharedDevices != null) {
            devices.addAll(sharedDevices);
        }
        if (devices == null) {
            return states;
        }
        for (LanDeviceEntity device : devices) {
            states.put(device.getLanDeviceId(), false);
        }
        List devicesWithActiveEvents = this.lanDeviceDAO.findLanDevicesByUserIdWithActiveEvents(this.authUtils.getCurrentUserId());
        List sharedDevicesWithActiveEvents = this.lanDeviceDAO.findLanDevicesSharedWithUserWithActiveEvents(this.authUtils.getCurrentUserId(), null);
        if (devicesWithActiveEvents == null) {
            devicesWithActiveEvents = sharedDevicesWithActiveEvents;
        } else if (sharedDevicesWithActiveEvents != null) {
            devicesWithActiveEvents.addAll(sharedDevicesWithActiveEvents);
        }
        if (devicesWithActiveEvents == null) {
            return states;
        }
        for (LanDeviceEntity device : devicesWithActiveEvents) {
            states.put(device.getLanDeviceId(), true);
        }
        return states;
    }

    private int prepareTimeAddition(LanDeviceEntity device, EventTrigger eventTrigger, Integer videoDuration) {
        log.debug((Object)("start prepareTimeAddition(device with lanDeviceId=" + device.getLanDeviceId() + ", eventTrigger=" + eventTrigger + ", videoDuration=" + videoDuration + ")"));
        if (eventTrigger == null) {
            log.warn((Object)("Unexpected event trigger: " + eventTrigger + "."));
            return 0;
        }
        if (device == null || device.getLanDeviceParams() == null) {
            log.warn((Object)"Incorrect lan device. Device is null or params are null");
            return 0;
        }
        if (eventTrigger == EventTrigger.MOTION || eventTrigger == EventTrigger.AUDIO) {
            return videoDuration == null ? this.getVideoRecordingDuration(device) : videoDuration.intValue();
        }
        return this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION);
    }

    private Date increaseDate(Date date, int timeAddition) {
        return new Date(date.getTime() + (long)(timeAddition * 1000));
    }

    private Date increaseDateWithLimit(int timeAddition, EventEntity currentEvent) {
        Date dateStopLimited;
        int durationLimit = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION);
        Date currentDate = this.systemSupport.getCurrentDate();
        Date dateStopRequest = new Date(currentDate.getTime() + (long)(timeAddition * 1000));
        Date dateStart = currentEvent.getDateStarted();
        if (dateStart == null) {
            log.debug((Object)("dateStarted was null, using dateStartRequest instead (event = " + currentEvent + ")"));
            dateStart = currentEvent.getDateStartRequested();
        }
        if (dateStopRequest.before(dateStopLimited = new Date(dateStart.getTime() + (long)(durationLimit * 1000)))) {
            return dateStopRequest;
        }
        return dateStopLimited;
    }

    private boolean blockProcessing(Integer deviceId) {
        log.debug((Object)("start blockProcessing(device with landeviceId=" + deviceId + ")"));
        Long lastEventTimestamp = (Long)this.lastEventDates.get(deviceId);
        long currentTimestamp = this.systemSupport.currentTimeMillis();
        log.debug((Object)("lastEventDate for device with landeviceId=" + deviceId + ": " + lastEventTimestamp + "."));
        if (lastEventTimestamp == null || currentTimestamp - lastEventTimestamp > 2000L) {
            this.lastEventDates.put(deviceId, currentTimestamp);
            return false;
        }
        return true;
    }

    public ProcessEventResponse processEvent(Integer lanDeviceId, String eventType, byte[] snapshot, String mediaType, Integer videoDuration, Date eventDate, byte[] videoClip) {
        log.debug((Object)("start processEvent(lanDeviceId=" + lanDeviceId + "eventType=" + eventType + ", snapshot=" + snapshot + ", mediaType=" + mediaType + ", videoDuration=" + videoDuration + ", eventDate=" + eventDate + ", videoClip=" + videoClip + ")"));
        if (lanDeviceId == null) {
            log.debug((Object)"Lan device id is null.");
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDDEVICEID);
        }
        EventTrigger eventTrigger = this.getEventTrigger(eventType);
        if (eventTrigger == null || eventTrigger == EventTrigger.MANUAL) {
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDTRIGGERTYPE);
        }
        MediaType eventMediaType = this.getMediaType(mediaType);
        if (eventMediaType == null) {
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_INVALIDMEDIATYPE);
        }
        if (this.blockProcessing(lanDeviceId)) {
            log.debug((Object)("Event processing for device with lanDeviceId=" + lanDeviceId + " has been blocked."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_PERIODEXCEEDED);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            log.debug((Object)("Not found lan device by lanDeviceId=" + lanDeviceId + "."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_NODEVICEFOUND);
        }
        if (device.getDeleted()) {
            log.debug((Object)("Lan device with lanDeviceId=" + lanDeviceId + " is removed."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_NODEVICEFOUND);
        }
        if (!this.isLanDeviceValid(device)) {
            log.info((Object)("Device with mac address '" + device.getMac() + "' has exceeded the expiry date."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_EXCEEDEDEXPIRYDATED);
        }
        if (!this.isProductSupportAlarms(device)) {
            log.info((Object)("Device with mac address '" + device.getMac() + "' has product without alarm support."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_PRODUCTWITHOUTALARMSUPPORT);
        }
        if (eventTrigger == EventTrigger.MOTION && !this.isMotionDetectionEnabled(device)) {
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_MOTIONDETECTIONDISABLED);
        }
        if (eventTrigger == EventTrigger.AUDIO && !this.isAudioDetectionEnabled(device)) {
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_AUDIODETECTIONDISABLED);
        }
        if (this.isAlarmLimit(device, videoClip != null)) {
            log.debug((Object)("Alarm limit for device with mac address '" + device.getMac() + "' is reached."));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_EXCEEDEDALARMLIMIT);
        }
        if (this.isAlarmOutOfPeriod(device)) {
            log.debug((Object)("Alarm for device with mac address '" + device.getMac() + "' is in range no alarm schedule"));
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.FAILED_ALARMOUTSIDEPERIOD);
        }
        if (snapshot == null && videoClip == null) {
            log.debug((Object)"Provided snapshot is null. Downloading snapshot manually.");
            snapshot = this.getCameraSnapshot(device);
        }
        Date currentDate = this.systemSupport.getCurrentDate();
        if (eventDate == null || Math.abs(eventDate.getTime() - currentDate.getTime()) > 600000L) {
            log.debug((Object)("There is significant difference between event date and current date (eventDate=" + eventDate + ", currentDate=" + currentDate + ")."));
            eventDate = currentDate;
        }
        ManageEventResult result = this.manageEvent(device.getLanDeviceId(), eventTrigger, snapshot, eventMediaType, videoDuration, eventDate, videoClip);
        if (videoClip != null) {
            String resolution;
            String videoClipFilePath = null;
            videoClipFilePath = this.isBrickcomCamera(device) ? String.valueOf(this.snapshotsPath) + this.prepareEventFileName(ManageEventResult.access$1((ManageEventResult)result), "mp4") : String.valueOf(this.snapshotsPath) + this.prepareEventFileName(ManageEventResult.access$1((ManageEventResult)result), "3gp");
            long videoClipFileSize = 0L;
            if (this.systemSupport.saveFile(videoClipFilePath, videoClip)) {
                String videooutFilePath = null;
                videooutFilePath = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(ManageEventResult.access$1((ManageEventResult)result), "mp4");
                resolution = device.getParamValue("resolution");
                videoClipFileSize = this.videoPostprocessingService.convertToMP4(videoClipFilePath, videooutFilePath, resolution, device.getVideoEncoding());
                if (!videoClipFilePath.equals(videooutFilePath)) {
                    log.debug((Object)("videoclip file name (" + videoClipFilePath + ") and mp4 file name (" + videooutFilePath + ") are different, removing original file"));
                    this.systemSupport.deleteFile(videoClipFilePath);
                }
                videoClipFilePath = videooutFilePath;
                ManageEventResult.access$1((ManageEventResult)result).setVideoFileSize(Integer.valueOf((int)videoClipFileSize));
            } else {
                log.warn((Object)("Video clip with name '" + videoClipFilePath + "' has not been saved for event " + ManageEventResult.access$1((ManageEventResult)result) + "."));
            }
            String snapshotFilePath = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(ManageEventResult.access$1((ManageEventResult)result), "jpg");
            if (snapshot == null) {
                resolution = device.getParamValue("resolution");
                long snapshotSize = this.videoPostprocessingService.convertToPoster(videoClipFilePath, snapshotFilePath, resolution, device.getVideoEncoding());
                ManageEventResult.access$1((ManageEventResult)result).setImageFileSize(Integer.valueOf((int)snapshotSize));
            }
            this.videoPostprocessingService.hintVideoFile(videoClipFilePath);
            if (this.productSupportAlarmVideoRecording(device)) {
                this.videoRecorderService.getEventsFilesController().uploadFile(videoClipFilePath);
            } else {
                this.systemSupport.deleteFile(videoClipFilePath);
                ManageEventResult.access$1((ManageEventResult)result).setVideoFileSize(null);
            }
            this.videoRecorderService.getEventsFilesController().uploadFile(snapshotFilePath);
            if (this.eventDAO.updateEvent(ManageEventResult.access$1((ManageEventResult)result)) == null) {
                log.warn((Object)("Failed to update event wth eventId=" + ManageEventResult.access$1((ManageEventResult)result).getEventId() + "."));
            }
        }
        if (ManageEventResult.access$0((ManageEventResult)result) == ManageEventStatus.START_RECORDING && this.productSupportAlarmVideoRecording(device)) {
            log.info((Object)("Starting video recording for lan device with landeviceId=" + device.getLanDeviceId() + " by motion detection."));
            this.startVideoRecording(device, ManageEventResult.access$1((ManageEventResult)result));
        } else if (ManageEventResult.access$0((ManageEventResult)result) == ManageEventStatus.PROLONG_RECORDING) {
            log.info((Object)("Prolong current video recording for lan device with landeviceId=" + device.getLanDeviceId() + " by motion detection."));
            this.videoRecorderService.updateRequestedStopTime(ManageEventResult.access$1((ManageEventResult)result).getEventId(), ManageEventResult.access$1((ManageEventResult)result).getDateStopRequested());
        }
        if (ManageEventResult.access$0((ManageEventResult)result) == ManageEventStatus.ERROR) {
            return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.ERROR);
        }
        Event event = ManageEventResult.access$1((ManageEventResult)result) == null ? null : ManageEventResult.access$1((ManageEventResult)result).toDTO();
        return new ProcessEventResponse(ProcessEventResponse.ProcessEventStatus.SUCCESS, event);
    }

    private boolean productSupportAlarmVideoRecording(LanDeviceEntity device) {
        return "ON".equalsIgnoreCase(device.getProductFeatureValue(DeviceFeatureCode.ALARM_VIDEORECORDING));
    }

    private EventTrigger getEventTrigger(String eventType) {
        EventTrigger[] eventTriggerArray = EventTrigger.values();
        int n = eventTriggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventTrigger trigger = eventTriggerArray[n2];
            if (trigger.name().equalsIgnoreCase(eventType)) {
                return trigger;
            }
            ++n2;
        }
        return null;
    }

    private MediaType getMediaType(String mediaType) {
        MediaType[] mediaTypeArray = MediaType.values();
        int n = mediaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType type = mediaTypeArray[n2];
            if (type.name().equalsIgnoreCase(mediaType)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private void sendEmailNotifications(LanDeviceEntity device, EventTrigger eventTrigger, byte[] snapshot) {
        if (device == null) {
            return;
        }
        Set emailAddresses = this.getEmailAddresses(device);
        if (emailAddresses == null || emailAddresses.isEmpty()) {
            log.debug((Object)"No email addresses to send email notifications about event.");
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", device.getName());
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        if (snapshot != null) {
            attachments.put("snapshot.jpg", new ByteArrayResource(snapshot));
        }
        for (String emailAddress : emailAddresses) {
            EmailNotificationService.EmailCode emailCode = eventTrigger == EventTrigger.MOTION ? EmailNotificationService.EmailCode.MOTION_DETECTION : EmailNotificationService.EmailCode.AUDIO_DETECTION;
            this.emailNotificationService.sendEmail(emailAddress, emailCode, device.getUser().getLanguage(), placeholders, attachments);
        }
    }

    private boolean isBrickcomCamera(LanDeviceEntity device) {
        return device.getDeviceDesc().getMake().equals("Brickcom");
    }

    private boolean isMotionDetectionEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("motion_detection"));
    }

    private boolean isAudioDetectionEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("audio_detection"));
    }

    private boolean isAlarmLimit(LanDeviceEntity device, boolean isVideoclip) {
        LastAlarmDate lastEvent = (LastAlarmDate)this.lastAlarmDates.get(device.getLanDeviceId());
        Long lastEventTimestamp = lastEvent != null ? lastEvent.date : null;
        long currentTimestamp = this.systemSupport.currentTimeMillis();
        log.debug((Object)("lastEventDate for device with landeviceId=" + device.getLanDeviceId() + ": " + lastEventTimestamp + "."));
        Boolean waitForVideoclip = !isVideoclip && "ON".equals(device.getParamValue("alarm_video_clip"));
        if (waitForVideoclip.booleanValue()) {
            log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " is waiting for videoclip"));
        }
        if (isVideoclip && lastEvent != null && lastEvent.waitingForVideoclip.booleanValue()) {
            lastEvent.waitingForVideoclip = false;
            return false;
        }
        if (lastEventTimestamp == null) {
            this.lastAlarmDates.put(device.getLanDeviceId(), new LastAlarmDate(Long.valueOf(currentTimestamp), waitForVideoclip));
            return false;
        }
        int alarmLimit = Integer.parseInt(device.getParamValue("alarm_limit"));
        if (alarmLimit == 0) {
            this.lastAlarmDates.put(device.getLanDeviceId(), new LastAlarmDate(Long.valueOf(currentTimestamp), waitForVideoclip));
            return false;
        }
        long period = 3600000 / alarmLimit;
        if (currentTimestamp - lastEventTimestamp > period) {
            this.lastAlarmDates.put(device.getLanDeviceId(), new LastAlarmDate(Long.valueOf(currentTimestamp), waitForVideoclip));
            return false;
        }
        return true;
    }

    private int getVideoRecordingDuration(LanDeviceEntity device) {
        String value = device.getParamValue("video_recording_duration");
        return value == null || value.trim().length() == 0 ? 0 : Integer.parseInt(value);
    }

    private List<NoAlarmPeriod> getNoAlarmPeriods(LanDeviceEntity device) {
        HashMap<String, String> startTimes = new HashMap<String, String>();
        HashMap<String, String> endTimes = new HashMap<String, String>();
        HashMap<String, String> weekdays = new HashMap<String, String>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (param.getName().startsWith("no_alarm_start_time_")) {
                startTimes.put(param.getName().replace("no_alarm_start_time_", ""), param.getValue());
            }
            if (param.getName().startsWith("no_alarm_end_time_")) {
                endTimes.put(param.getName().replace("no_alarm_end_time_", ""), param.getValue());
            }
            if (!param.getName().startsWith("no_alarm_weekdays_")) continue;
            weekdays.put(param.getName().replace("no_alarm_weekdays_", ""), param.getValue());
        }
        ArrayList<NoAlarmPeriod> noAlarmPeriods = new ArrayList<NoAlarmPeriod>();
        for (String key : startTimes.keySet()) {
            NoAlarmPeriod noAlarmPeriod = new NoAlarmPeriod(this, (String)startTimes.get(key), (String)endTimes.get(key), (String)weekdays.get(key));
            noAlarmPeriods.add(noAlarmPeriod);
        }
        return noAlarmPeriods;
    }

    private boolean isAlarmOutOfPeriod(LanDeviceEntity device) {
        GregorianCalendar currentDate = new GregorianCalendar();
        int currentDayOfWeek = currentDate.get(7);
        currentDate.set(5, 1);
        currentDate.set(2, 0);
        currentDate.set(1, 1970);
        currentDate.set(13, 0);
        currentDate.set(14, 0);
        Date currentTime = currentDate.getTime();
        List noAlarmPeriods = this.getNoAlarmPeriods(device);
        for (NoAlarmPeriod noAlarmPeriod : noAlarmPeriods) {
            if (!NoAlarmPeriod.access$0((NoAlarmPeriod)noAlarmPeriod).contains(currentDayOfWeek) || !currentTime.after(NoAlarmPeriod.access$1((NoAlarmPeriod)noAlarmPeriod)) || !currentTime.before(NoAlarmPeriod.access$2((NoAlarmPeriod)noAlarmPeriod))) continue;
            return true;
        }
        return false;
    }

    private boolean isVideoRecordingEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("record_video"));
    }

    Set<String> getEmailAddresses(LanDeviceEntity device) {
        HashSet<String> addresses = new HashSet<String>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!param.getName().startsWith("email_notification_")) continue;
            addresses.add(param.getValue());
        }
        return addresses;
    }

    private boolean saveEventFile(byte[] eventFile, EventEntity event, String fileExtension) {
        log.debug((Object)("start saveSnapshotToFile(eventFile=" + eventFile + " ,event with evetId=" + event.getEventId() + ")"));
        if (eventFile == null || event == null || event.getEventId() == null) {
            return false;
        }
        String filename = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(event, fileExtension);
        return this.systemSupport.saveFile(filename, eventFile);
    }

    private String prepareEventFileName(EventEntity event, String extension) {
        return String.valueOf(Utils.formatDate((Date)event.getDateEvent(), (String)"yyyyMMddHHmmss")) + "_" + event.getEventId() + "." + extension;
    }

    private Date convertTextToDate(String date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            log.error((Object)("Error occured converting text " + date + " to date: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void sendIphoneNotifications(EventEntity event) {
        log.debug((Object)("start sendIphoneNotifications(event=" + event + ")"));
        if (event == null) {
            return;
        }
        List tokens = this.getIphoneNotificationTokens(event.getLanDevice().getLanDeviceId());
        String payload = this.preparePayloadAPNS(event);
        for (String token : tokens) {
            this.apnsNotificationGate.sendMessage(token, payload);
        }
    }

    private List<String> getIphoneNotificationTokens(Integer deviceId) {
        ArrayList<String> tokens = new ArrayList<String>();
        List eventNotifications = this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(deviceId, EventNotificationType.APNS);
        if (eventNotifications != null) {
            for (EventNotificationEntity entity : eventNotifications) {
                tokens.add(entity.getToken());
            }
        }
        return tokens;
    }

    private String preparePayloadAPNS(EventEntity event) {
        return "{\"aps\":{\"alert\":{\"loc-key\":\"APN_MSG\",\"loc-args\":[\"" + event.getLanDevice().getName() + "\",\"" + Utils.formatDate((Date)event.getDateEvent(), (String)"yy.MM.dd H:mm") + "\"]}},\"cameraid\":" + event.getLanDevice().getLanDeviceId() + ",\"eventid\":" + event.getEventId() + "}";
    }

    private void sendAndroidNotifications(EventEntity event) {
        log.debug((Object)("start sendAndroidNotifications(event=" + event + ")"));
        if (event == null) {
            return;
        }
        List eventNotifications = this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndType(event.getLanDevice().getLanDeviceId(), EventNotificationType.C2DM);
        if (eventNotifications == null || eventNotifications.isEmpty()) {
            log.debug((Object)"No android device tokens to send android notifications about event.");
            return;
        }
        for (EventNotificationEntity eventNotification : eventNotifications) {
            String payload = this.preparePayloadAndroid(event);
            String token = eventNotification.getToken();
            log.debug((Object)("Sending message '" + payload + "' for android device token '" + token + "'."));
            if (this.androidNotificationService.sendMessage(token, payload)) continue;
            log.warn((Object)"Error during sending android event notification");
            return;
        }
    }

    private String preparePayloadAndroid(EventEntity event) {
        return "data.cameraid=" + event.getLanDevice().getLanDeviceId() + "&data.eventid=" + event.getEventId() + "&data.cameraName=" + event.getLanDevice().getName() + "&data.dateEvent=" + event.getDateEvent().getTime();
    }

    @Transactional
    public void handleSnapshot(String macAddress, byte[] snapshot) {
        log.debug((Object)("start handleSnapshot(macAddress=" + macAddress + ", snapshot=" + snapshot + ")"));
        Thread thread = new Thread((Runnable)new EventSnapshotUpdater(this, macAddress, snapshot));
        thread.start();
    }

    private boolean isLanDeviceValid(LanDeviceEntity device) {
        if (device == null) {
            return false;
        }
        if (device.getProduct().getProductFeature(DeviceFeatureCode.LANDEVICE_VALIDITY) == null) {
            return true;
        }
        DateWithoutTimeComparator comparator = new DateWithoutTimeComparator(this);
        return comparator.compare(device.getValidTo(), this.systemSupport.getCurrentDate()) >= 0;
    }

    private boolean isProductSupportAlarms(LanDeviceEntity device) {
        return "ON".equalsIgnoreCase(device.getProductFeatureValue(DeviceFeatureCode.ALARM));
    }

    private boolean isProductSupportRecording(LanDeviceEntity device) {
        return "ON".equalsIgnoreCase(device.getProductFeatureValue(DeviceFeatureCode.VIDEORECORDING));
    }

    private byte[] getCameraSnapshot(LanDeviceEntity device) {
        if (device == null) {
            log.warn((Object)"Trying take snapshot for null lan device.");
            return null;
        }
        GenericCamera driver = (GenericCamera)this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            log.warn((Object)("Not found driver for lan device wit landeviceId=" + device.getLanDeviceId() + "."));
            return null;
        }
        if (this.isEventLedLightEnabled(device)) {
            this.switchIllumination(device, true);
        }
        String resolution = device.getParamValue("resolution");
        log.debug((Object)("getting snapshot from camera (id = " + device.getLanDeviceId() + ", resolution = " + resolution + ")"));
        byte[] snapshot = driver.getCurrentSnapshot(device, resolution);
        if (this.isEventLedLightEnabled(device) && !this.isVideoRecordingEnabled(device)) {
            this.switchIllumination(device, false);
        }
        return snapshot;
    }

    public void processEventSnapshot(Integer eventId, byte[] snapshot) {
        log.debug((Object)("start processEventSnapshot(eventId=" + eventId + ", snapshot=" + snapshot + ")"));
        if (eventId == null) {
            log.warn((Object)"Attempt to update snapshot for incorrect eventId.");
            return;
        }
        if (snapshot == null) {
            log.warn((Object)("Attempt to update snapshot to null for event with eventId=" + eventId + "."));
            return;
        }
        EventEntity event = this.eventDAO.findEventById(eventId);
        if (event == null) {
            log.warn((Object)("Not found event for eventId=" + eventId + " in order to update its snapshot."));
            return;
        }
        if (!this.saveEventFile(snapshot, event, "jpg")) {
            log.warn((Object)("Snapshot for event with eventId=" + eventId + " has not been saved"));
            return;
        }
        String filename = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(event, "jpg");
        this.videoRecorderService.getEventsFilesController().uploadFile(filename);
        log.info((Object)("Snapshot for event with eventId=" + eventId + " has been saved."));
        event.setImageFileSize(Integer.valueOf(snapshot.length));
        if (this.eventDAO.updateEvent(event) == null) {
            log.warn((Object)("Snapshot lenght for event with eventId=" + eventId + " has not been updated."));
            return;
        }
        log.info((Object)("Snapshot for event with eventId=" + eventId + " has been updaet successfuly."));
    }

    public RemoveEventsResponse removeEvents(List<Integer> eventIds) throws InvalidSessionException {
        log.debug((Object)("start removeEvent(eventIds=" + eventIds.toString() + ")"));
        this.authUtils.ensureLoggedIn();
        RemoveEventsResponse response = new RemoveEventsResponse();
        response.status = RemoveEventsResponse.RemoveEventsStatus.SUCCESS;
        ArrayList<Integer> eventIdsToRemove = new ArrayList<Integer>();
        eventIdsToRemove.addAll(eventIds);
        for (Integer eventId : eventIds) {
            EventEntity eventEntity = this.eventDAO.findEventById(eventId);
            if (eventEntity == null || !this.canCurrentUserAccessEvent(eventEntity)) {
                eventIdsToRemove.remove(new Integer(eventId));
                response.status = RemoveEventsResponse.RemoveEventsStatus.FAILED;
                continue;
            }
            this.forceStopRecordingIfRequired(eventEntity);
        }
        int deleted = this.eventDAO.setEventsAsDeleted(eventIdsToRemove);
        if (deleted != eventIdsToRemove.size()) {
            response.status = RemoveEventsResponse.RemoveEventsStatus.FAILED;
        }
        log.debug((Object)("exit removeEvent(eventIds=" + ((Object)eventIdsToRemove).toString() + ") removed events: " + deleted));
        return response;
    }

    public void createEvent(String token, String type, Integer videoLength) {
        this.createEvent(token, this.getEventType(type), videoLength);
    }

    public void createEvent(String token, EventType type, Integer videoLength) {
        LanDeviceEntity device;
        log.trace((Object)("start createEvent(token=" + token + ", type=" + type + ", videoLength=" + videoLength + ")"));
        this.throwIf(StringUtils.isBlank((CharSequence)token), CreateEventException.ErrorCode.NO_TOKEN);
        this.throwIf(type == null, CreateEventException.ErrorCode.NO_TYPE);
        if (type == EventType.VIDEO) {
            this.throwIf(videoLength == null, CreateEventException.ErrorCode.NO_VIDEO_LENGTH);
            this.throwIf(videoLength <= 0, CreateEventException.ErrorCode.INVALID_VIDEO_LENGTH);
        }
        this.throwIf((device = this.lanDeviceDAO.getDeviceByToken(token)) == null || device.getDeleted(), CreateEventException.ErrorCode.DEVICE_NOT_FOUND);
        this.throwIf(!this.isCamera(device), CreateEventException.ErrorCode.UNSUPPORTED_OPERATION);
        this.throwIf(!this.isConnected(device), CreateEventException.ErrorCode.DEVICE_DISCONNECTED);
        EventEntity event = this.eventDAO.getActiveEvent(device.getLanDeviceId());
        if (event != null && type == EventType.VIDEO) {
            Integer maxVideoLength = this.getMaxVideoLength();
            if (this.calculateRequestedVideoLenght(event) + (long)videoLength.intValue() > (long)maxVideoLength.intValue()) {
                event.setDateStopRequested(this.addSeconds(event.getDateStartRequested(), maxVideoLength.intValue()));
            } else {
                event.setDateStopRequested(this.addSeconds(event.getDateStopRequested(), videoLength.intValue()));
            }
            if (this.eventDAO.updateEvent(event) == null) {
                log.warn((Object)"Failed to prolong video length.");
                throw new CreateEventException(CreateEventException.ErrorCode.ERROR);
            }
            this.videoRecorderService.updateRequestedStopTime(event.getEventId(), event.getDateStopRequested());
            return;
        }
        event = new EventEntity();
        event.setDateEvent(this.systemSupport.getCurrentDate());
        event.setEventtrigger(EventTrigger.MANUAL);
        event.setLanDevice(device);
        EventEntity storedEvent = null;
        if (type == EventType.VIDEO) {
            Date now = this.systemSupport.getCurrentDate();
            event.setDateStartRequested(now);
            Integer maxVideoLength = this.getMaxVideoLength();
            event.setDateStopRequested(this.addSeconds(now, (videoLength > maxVideoLength ? maxVideoLength : videoLength).intValue()));
            storedEvent = this.eventDAO.createEvent(event);
            if (storedEvent == null) {
                log.warn((Object)("Failed to store event for token=" + token + " and type=" + type + "."));
                throw new CreateEventException(CreateEventException.ErrorCode.ERROR);
            }
            this.startVideoRecording(device, storedEvent);
        } else if (type == EventType.SNAPSHOT) {
            byte[] snapshot = this.getCameraSnapshot(device);
            event.setVideoFileSize(Integer.valueOf(snapshot.length));
            storedEvent = this.eventDAO.createEvent(event);
            if (storedEvent == null) {
                log.warn((Object)("Failed to store event for token=" + token + " and type=" + type + "."));
                throw new CreateEventException(CreateEventException.ErrorCode.ERROR);
            }
            String filename = String.valueOf(this.snapshotsPath) + this.prepareEventFileName(event, "jpg");
            this.storeFile(filename, snapshot);
            this.videoRecorderService.getEventsFilesController().uploadFile(filename);
        } else {
            throw new CreateEventException(CreateEventException.ErrorCode.UNSUPPORTED_TYPE);
        }
    }

    private Date addSeconds(Date date, int seconds) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    private void throwIf(boolean confition, CreateEventException.ErrorCode errorCode) {
        if (confition) {
            throw new CreateEventException(errorCode);
        }
    }

    private EventType getEventType(String type) {
        this.throwIf(StringUtils.isBlank((CharSequence)type), CreateEventException.ErrorCode.NO_TYPE);
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType = eventTypeArray[n2];
            if (eventType.name().equalsIgnoreCase(type)) {
                return eventType;
            }
            ++n2;
        }
        throw new CreateEventException(CreateEventException.ErrorCode.UNSUPPORTED_TYPE);
    }

    private boolean isCamera(LanDeviceEntity device) {
        return device.getDeviceDesc().getClassDevice().equals("camera");
    }

    private boolean isConnected(LanDeviceEntity device) {
        return this.connectionService.findById(device.getMac()) != null;
    }

    private Date getStopDate(Date date, Integer lenght) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(13, lenght);
        return calendar.getTime();
    }

    private void storeFile(String filepath, byte[] body) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(filepath), (byte[])body);
        }
        catch (IOException ex) {
            log.warn((Object)("Failed to store file " + filepath + ": " + ex.getMessage()));
            throw new RuntimeException(ex);
        }
    }

    private long calculateRequestedVideoLenght(EventEntity event) {
        return (event.getDateStopRequested().getTime() - event.getDateStartRequested().getTime()) / 1000L;
    }

    private Integer getMaxVideoLength() {
        return this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.LANDEVICE_EVENT_MAX_DUARATION);
    }

    public void stopVideoRecording(String token) {
        log.trace((Object)("start stopVideoRecording(token=" + token + ")"));
        this.throwIf(StringUtils.isBlank((CharSequence)token), StopVideoRecordingException.ErrorCode.NO_TOKEN);
        LanDeviceEntity device = this.lanDeviceDAO.getDeviceByToken(token);
        this.throwIf(device == null || device.getDeleted(), StopVideoRecordingException.ErrorCode.DEVICE_NOT_FOUND);
        this.throwIf(!this.isCamera(device), StopVideoRecordingException.ErrorCode.UNSUPPORTED_OPERATION);
        this.throwIf(!this.isConnected(device), StopVideoRecordingException.ErrorCode.DEVICE_DISCONNECTED);
        EventEntity event = this.eventDAO.getActiveEvent(device.getLanDeviceId());
        this.throwIf(event == null, StopVideoRecordingException.ErrorCode.NO_ACTIVE_RECORDING);
        event.setDateStopRequested(this.systemSupport.getCurrentDate());
        if (this.eventDAO.updateEvent(event) == null) {
            log.warn((Object)("Failed stop recording for event with eventId=" + event.getEventId()));
            throw new StopVideoRecordingException(StopVideoRecordingException.ErrorCode.ERROR);
        }
        this.videoRecorderService.updateRequestedStopTime(event.getEventId(), event.getDateStopRequested());
    }

    private void throwIf(boolean confition, StopVideoRecordingException.ErrorCode errorCode) {
        if (confition) {
            throw new StopVideoRecordingException(errorCode);
        }
    }

    public void createSnapshotEvent(String token, byte[] snapshot) {
        this.throwIf(StringUtils.isBlank((CharSequence)token), CreateSnapshotEventException.ErrorCode.NO_TOKEN);
        this.throwIf(snapshot == null, CreateSnapshotEventException.ErrorCode.NO_SNAPSHOT);
        log.info((Object)("Creating snaphsot event for token=" + token + " and snapshot=" + snapshot.length));
        LanDeviceEntity device = this.lanDeviceDAO.getDeviceByToken(token);
        this.throwIf(device == null || device.getDeleted(), CreateSnapshotEventException.ErrorCode.DEVICE_NOT_FOUND);
        this.throwIf(!this.isCamera(device), CreateSnapshotEventException.ErrorCode.UNSUPPORTED_OPERATION);
        EventEntity event = new EventEntity();
        event.setDateEvent(this.systemSupport.getCurrentDate());
        event.setEventtrigger(EventTrigger.MANUAL);
        event.setLanDevice(device);
        EventEntity storedEvent = null;
        event.setImageFileSize(Integer.valueOf(snapshot.length));
        storedEvent = this.eventDAO.createEvent(event);
        if (storedEvent == null) {
            log.warn((Object)("Failed to store imange event for token=" + token + "."));
            throw new CreateSnapshotEventException(CreateSnapshotEventException.ErrorCode.ERROR);
        }
        String filename = this.snapshotsPath;
        if (!filename.endsWith("/")) {
            filename = String.valueOf(filename) + "/";
        }
        filename = String.valueOf(filename) + this.prepareEventFileName(storedEvent, "jpg");
        this.storeFile(filename, snapshot);
        this.videoRecorderService.getEventsFilesController().uploadFile(filename);
    }

    private void throwIf(boolean confition, CreateSnapshotEventException.ErrorCode errorCode) {
        if (confition) {
            throw new CreateSnapshotEventException(errorCode);
        }
    }

    static /* synthetic */ Date access$0(EventServiceImpl eventServiceImpl, String string, String string2) {
        return eventServiceImpl.convertTextToDate(string, string2);
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }

    static /* synthetic */ LanDeviceDAO access$2(EventServiceImpl eventServiceImpl) {
        return eventServiceImpl.lanDeviceDAO;
    }

    static /* synthetic */ EventDAO access$3(EventServiceImpl eventServiceImpl) {
        return eventServiceImpl.eventDAO;
    }

    static /* synthetic */ boolean access$4(EventServiceImpl eventServiceImpl, byte[] byArray, EventEntity eventEntity, String string) {
        return eventServiceImpl.saveEventFile(byArray, eventEntity, string);
    }

    static /* synthetic */ String access$5(EventServiceImpl eventServiceImpl) {
        return eventServiceImpl.snapshotsPath;
    }

    static /* synthetic */ String access$6(EventServiceImpl eventServiceImpl, EventEntity eventEntity, String string) {
        return eventServiceImpl.prepareEventFileName(eventEntity, string);
    }

    static /* synthetic */ VideoRecorderServiceImpl access$7(EventServiceImpl eventServiceImpl) {
        return eventServiceImpl.videoRecorderService;
    }
}

