/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.restserver.db.dao.EmailTemplateDAO;
import pl.smartapps.restserver.db.main.EmailTemplateEntity;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.impl.EmailNotificationServiceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={EmailNotificationServiceImpl.class})
public class EmailNotificationServiceTests {
    private EmailNotificationServiceImpl emailNotificationService;
    private JavaMailSenderImpl mailSender;
    private EmailTemplateDAO emailTemplateDAO;
    private String emailAddress = "team@homemonitor.ch";
    private Boolean emailEnabled = true;

    @Before
    public void setUp() {
        this.emailNotificationService = new EmailNotificationServiceImpl();
        this.mailSender = (JavaMailSenderImpl)PowerMock.createMock(JavaMailSenderImpl.class);
        this.emailNotificationService.setMailSender(this.mailSender);
        this.emailTemplateDAO = (EmailTemplateDAO)PowerMock.createMock(EmailTemplateDAO.class);
        this.emailNotificationService.setEmailTemplateDAO(this.emailTemplateDAO);
        this.emailNotificationService.setFrom(this.emailAddress);
        this.emailNotificationService.setEmailEnabled(this.emailEnabled);
    }

    @Test
    public void testGetUserPlaeholders() {
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("userUsername");
        user.setEmail("userEmail");
        user.setFirstname("userFirstname");
        user.setLastname("userLastname");
        user.setAddress("userAddress");
        user.setTown("userTown");
        user.setZipCode("userZip");
        user.setState("userState");
        user.setCountry("userCountry");
        user.setLanguage("userLanguage");
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.emailNotificationService.getUserPlaceholders(user);
        HashMap<String, String> expectedResponse = new HashMap<String, String>();
        expectedResponse.put("%USERNAME%", "userUsername");
        expectedResponse.put("%ADDR_EMAIL%", "userEmail");
        expectedResponse.put("%ADDR_NAME%", "userFirstname userLastname");
        expectedResponse.put("%ADDR_FNAME%", "userFirstname");
        expectedResponse.put("%ADDR_LNAME%", "userLastname");
        expectedResponse.put("%ADDR_ADDRESS%", "userAddress");
        expectedResponse.put("%ADDR_TOWN%", "userTown");
        expectedResponse.put("%ADDR_ZIP%", "userZip");
        expectedResponse.put("%ADDR_STATE%", "userState");
        expectedResponse.put("%ADDR_COUNTRY%", "userCountry");
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserPlaeholdersWithNullState() {
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("userUsername");
        user.setEmail("userEmail");
        user.setFirstname("userFirstname");
        user.setLastname("userLastname");
        user.setAddress("userAddress");
        user.setTown("userTown");
        user.setZipCode("userZip");
        user.setState(null);
        user.setCountry("userCountry");
        user.setLanguage("userLanguage");
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.emailNotificationService.getUserPlaceholders(user);
        HashMap<String, String> expectedResponse = new HashMap<String, String>();
        expectedResponse.put("%USERNAME%", "userUsername");
        expectedResponse.put("%ADDR_EMAIL%", "userEmail");
        expectedResponse.put("%ADDR_NAME%", "userFirstname userLastname");
        expectedResponse.put("%ADDR_FNAME%", "userFirstname");
        expectedResponse.put("%ADDR_LNAME%", "userLastname");
        expectedResponse.put("%ADDR_ADDRESS%", "userAddress");
        expectedResponse.put("%ADDR_TOWN%", "userTown");
        expectedResponse.put("%ADDR_ZIP%", "userZip");
        expectedResponse.put("%ADDR_STATE%", "");
        expectedResponse.put("%ADDR_COUNTRY%", "userCountry");
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithUserUserPlaceholders() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("userLanguage");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        StringBuilder templateBody = new StringBuilder();
        templateBody.append("User details: ");
        templateBody.append("username: %USERNAME%, ");
        templateBody.append("email: %ADDR_EMAIL%, ");
        templateBody.append("name: %ADDR_NAME%, ");
        templateBody.append("firstname: %ADDR_FNAME%, ");
        templateBody.append("lastname: %ADDR_LNAME%, ");
        templateBody.append("address: %ADDR_ADDRESS%, ");
        templateBody.append("town: %ADDR_TOWN%, ");
        templateBody.append("zip: %ADDR_ZIP%, ");
        templateBody.append("state: %ADDR_STATE%, ");
        templateBody.append("country: %ADDR_COUNTRY%.");
        template.setBody(templateBody.toString());
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userFirstname userLastname <userEmail>");
        helper.setSubject("This is test, short subject");
        StringBuilder emailBody = new StringBuilder();
        emailBody.append("User details: ");
        emailBody.append("username: userUsername, ");
        emailBody.append("email: userEmail, ");
        emailBody.append("name: userFirstname userLastname, ");
        emailBody.append("firstname: userFirstname, ");
        emailBody.append("lastname: userLastname, ");
        emailBody.append("address: userAddress, ");
        emailBody.append("town: userTown, ");
        emailBody.append("zip: userZip, ");
        emailBody.append("state: userState, ");
        emailBody.append("country: userCountry.");
        helper.setText(emailBody.toString());
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail(this.prepareUser(), EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailDisabled() throws Exception {
        this.emailNotificationService.setEmailEnabled(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail(this.prepareUser(), EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithUserUserPlaceholdersAndNullUserState() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("userLanguage");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        StringBuilder templateBody = new StringBuilder();
        templateBody.append("User details: ");
        templateBody.append("username: %USERNAME%, ");
        templateBody.append("email: %ADDR_EMAIL%, ");
        templateBody.append("name: %ADDR_NAME%, ");
        templateBody.append("firstname: %ADDR_FNAME%, ");
        templateBody.append("lastname: %ADDR_LNAME%, ");
        templateBody.append("address: %ADDR_ADDRESS%, ");
        templateBody.append("town: %ADDR_TOWN%, ");
        templateBody.append("zip: %ADDR_ZIP%, ");
        templateBody.append("state: %ADDR_STATE%, ");
        templateBody.append("country: %ADDR_COUNTRY%.");
        template.setBody(templateBody.toString());
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userFirstname userLastname <userEmail>");
        helper.setSubject("This is test, short subject");
        StringBuilder emailBody = new StringBuilder();
        emailBody.append("User details: ");
        emailBody.append("username: userUsername, ");
        emailBody.append("email: userEmail, ");
        emailBody.append("name: userFirstname userLastname, ");
        emailBody.append("firstname: userFirstname, ");
        emailBody.append("lastname: userLastname, ");
        emailBody.append("address: userAddress, ");
        emailBody.append("town: userTown, ");
        emailBody.append("zip: userZip, ");
        emailBody.append("state: , ");
        emailBody.append("country: userCountry.");
        helper.setText(emailBody.toString());
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setState(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithFirstnameAndWithLastname() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("userLanguage");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userFirstname userLastname <userEmail>");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail(this.prepareUser(), EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    private User prepareUser() {
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("userUsername");
        user.setEmail("userEmail");
        user.setFirstname("userFirstname");
        user.setLastname("userLastname");
        user.setAddress("userAddress");
        user.setTown("userTown");
        user.setZipCode("userZip");
        user.setState("userState");
        user.setCountry("userCountry");
        user.setLanguage("userLanguage");
        return user;
    }

    @Test
    public void testSendMailForUserWithFirstnameAndWithoutLastname() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("userLanguage");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userEmail");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setLastname(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithoutFirstnameAndWithLastname() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userEmail");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setFirstname(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithoutFirstnameAndWithoutLastname() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userEmail");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setFirstname(null);
        user.setLastname(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithoutLanguage() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userFirstname userLastname <userEmail>");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setLanguage(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithNullPlaceholdersValues() throws Exception {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%PLACEHOLDER%", null);
        placeholders.put("%LINK%", null);
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "userLanguage")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("userEmail");
        helper.setSubject("This is test,  subject");
        helper.setText("This is test,  email body with fake link: .");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setFirstname(null);
        user.setLastname(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailForUserWithNullEmail() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        PowerMock.replayAll((Object[])new Object[0]);
        User user = this.prepareUser();
        user.setEmail(null);
        boolean response = this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithSomeAttachementsSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        ByteArrayResource attachement1 = new ByteArrayResource(new byte[5]);
        ByteArrayResource attachement2 = new ByteArrayResource(new byte[6]);
        attachments.put("attachement1.jpg", attachement1);
        attachments.put("attachement2.jpg", attachement2);
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, true, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        helper.addAttachment("attachement1.jpg", (InputStreamSource)attachement1);
        helper.addAttachment("attachement2.jpg", (InputStreamSource)attachement2);
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, attachments);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithOneAttachementSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        ByteArrayResource attachement = new ByteArrayResource(new byte[5]);
        attachments.put("attachement.jpg", attachement);
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, true, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        helper.addAttachment("attachement.jpg", (InputStreamSource)attachement);
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, attachments);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithEmptyAttachementsSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        HashMap attachments = new HashMap();
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, attachments);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithNullAttachementsSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, false, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithHtmlBodyAndWithoutAttachmentsSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        template.setBodyHtml("<html>This is test, <b>%PLACEHOLDER%</b> email body with fake link: %LINK%.</html>");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, true, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.", "<html>This is test, <b>short</b> email body with fake link: http://fake.pl.</html>");
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithSomeAttachementsAndWithBodyHtmlSuccessfuly() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        ByteArrayResource attachement1 = new ByteArrayResource(new byte[5]);
        ByteArrayResource attachement2 = new ByteArrayResource(new byte[6]);
        attachments.put("attachement1.jpg", attachement1);
        attachments.put("attachement2.jpg", attachement2);
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        template.setBodyHtml("<html>This is test, <b>%PLACEHOLDER%</b> email body with fake link: %LINK%.</html>");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, true, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.", "<html>This is test, <b>short</b> email body with fake link: http://fake.pl.</html>");
        helper.addAttachment("attachement1.jpg", (InputStreamSource)attachement1);
        helper.addAttachment("attachement2.jpg", (InputStreamSource)attachement2);
        this.mailSender.send(message);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, attachments);
        Assert.assertEquals((Object)true, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithNullNRecipient() throws Exception {
        HashMap placeholders = new HashMap();
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail(null, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithEmptyNRecipient() throws Exception {
        HashMap placeholders = new HashMap();
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithMissingTemplate() throws Exception {
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithNullSubject() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject(null);
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesWithNullBody() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody(null);
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, null);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMailWithTemplatesFailure() throws Exception {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLACEHOLDER%", "short");
        placeholders.put("%LINK%", "http://fake.pl");
        HashMap<String, ByteArrayResource> attachments = new HashMap<String, ByteArrayResource>();
        ByteArrayResource attachement1 = new ByteArrayResource(new byte[5]);
        ByteArrayResource attachement2 = new ByteArrayResource(new byte[6]);
        attachments.put("attachement1.jpg", attachement1);
        attachments.put("attachement2.jpg", attachement2);
        EmailTemplateEntity template = new EmailTemplateEntity();
        template.setEmailTemplateId(Integer.valueOf(1));
        template.setEmailCode("ACCOUNT_ACTIVATION");
        template.setLanguage("en");
        template.setSubject("This is test, %PLACEHOLDER% subject");
        template.setBody("This is test, %PLACEHOLDER% email body with fake link: %LINK%.");
        EasyMock.expect((Object)this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage("ACCOUNT_ACTIVATION", "en")).andReturn((Object)template);
        MimeMessage message = (MimeMessage)PowerMock.createMock(MimeMessage.class);
        EasyMock.expect((Object)this.mailSender.createMimeMessage()).andReturn((Object)message);
        MimeMessageHelper helper = (MimeMessageHelper)PowerMock.createMock(MimeMessageHelper.class);
        PowerMock.expectNew(MimeMessageHelper.class, (Object[])new Object[]{message, true, "UTF-8"}).andReturn((Object)helper);
        helper.setFrom(this.emailAddress);
        helper.setTo("test@test.pl");
        helper.setSubject("This is test, short subject");
        helper.setText("This is test, short email body with fake link: http://fake.pl.");
        helper.addAttachment("attachement1.jpg", (InputStreamSource)attachement1);
        helper.addAttachment("attachement2.jpg", (InputStreamSource)attachement2);
        this.mailSender.send(message);
        PowerMock.expectLastCall().andThrow((Throwable)new MailSendException(""));
        PowerMock.replayAll((Object[])new Object[0]);
        boolean response = this.emailNotificationService.sendEmail("test@test.pl", EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, "en", placeholders, attachments);
        Assert.assertEquals((Object)false, (Object)response);
        PowerMock.verifyAll();
    }
}

