/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.restserver.db.dao.EmailTemplateDAO;
import pl.smartapps.restserver.db.main.EmailTemplateEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.service.EmailNotificationService;

@Service
public class EmailNotificationServiceImpl
implements EmailNotificationService {
    private static Logger log = Logger.getLogger(EmailNotificationServiceImpl.class);
    private JavaMailSenderImpl mailSender;
    private EmailTemplateDAO emailTemplateDAO;
    private String from;
    private Boolean emailEnabled;

    @Autowired
    @Required
    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    @Autowired
    @Required
    public void setEmailTemplateDAO(EmailTemplateDAO emailTemplateDAO) {
        this.emailTemplateDAO = emailTemplateDAO;
    }

    @Value(value="${email.from}")
    public void setFrom(String from) {
        this.from = from;
    }

    @Value(value="${email.enabled:true}")
    public void setEmailEnabled(Boolean enabled) {
        this.emailEnabled = enabled;
    }

    public boolean sendEmail(User user, EmailNotificationService.EmailCode emailCode, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        log.debug((Object)("start sendEmail(user with userId=" + (user == null ? "null" : user.getId()) + ", emailCode=" + emailCode + ", " + ", placeholders=" + placeholders + ", attachments=" + attachments + ")"));
        if (user == null) {
            log.warn((Object)"User missing.");
            return false;
        }
        placeholders.putAll(this.getUserPlaceholders(user));
        return this.sendEmail(this.buildRecipient(user), emailCode, user.getLanguage() != null && !user.getLanguage().isEmpty() ? user.getLanguage() : "en", placeholders, attachments);
    }

    public boolean sendEmail(UserEntity user, EmailNotificationService.EmailCode emailCode, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        log.debug((Object)("start sendEmail(user with userId=" + (user == null ? "null" : user.getId()) + ", emailCode=" + emailCode + ", " + ", placeholders=" + placeholders + ", attachments=" + attachments + ")"));
        if (user == null) {
            log.warn((Object)"User missing.");
            return false;
        }
        placeholders.putAll(this.getUserPlaceholders(user));
        return this.sendEmail(this.buildRecipient(user), emailCode, user.getLanguage() != null && !user.getLanguage().isEmpty() ? user.getLanguage() : "en", placeholders, attachments);
    }

    public boolean sendEmail(User user, String emailCode, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        log.debug((Object)("start sendEmail(user with userId=" + (user == null ? "null" : user.getId()) + ", emailCode=" + emailCode + ", " + ", placeholders=" + placeholders + ", attachments=" + attachments + ")"));
        if (user == null) {
            log.warn((Object)"User missing.");
            return false;
        }
        placeholders.putAll(this.getUserPlaceholders(user));
        return this.sendEmail(this.buildRecipient(user), emailCode, user.getLanguage(), placeholders, attachments);
    }

    public boolean sendEmail(UserEntity user, String emailCode, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        log.debug((Object)("start sendEmail(user with userId=" + (user == null ? "null" : user.getId()) + ", emailCode=" + emailCode + ", " + ", placeholders=" + placeholders + ", attachments=" + attachments + ")"));
        if (user == null) {
            log.warn((Object)"User missing.");
            return false;
        }
        placeholders.putAll(this.getUserPlaceholders(user));
        return this.sendEmail(this.buildRecipient(user), emailCode, user.getLanguage(), placeholders, attachments);
    }

    public Map<String, String> getUserPlaceholders(User user) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USERNAME%", user.getUsername());
        placeholders.put("%ADDR_EMAIL%", user.getEmail());
        placeholders.put("%ADDR_NAME%", String.valueOf(user.getFirstname()) + " " + user.getLastname());
        placeholders.put("%ADDR_FNAME%", user.getFirstname());
        placeholders.put("%ADDR_LNAME%", user.getLastname());
        placeholders.put("%ADDR_ADDRESS%", user.getAddress());
        placeholders.put("%ADDR_TOWN%", user.getTown());
        placeholders.put("%ADDR_ZIP%", user.getZipCode());
        String state = user.getState() == null ? "" : user.getState();
        placeholders.put("%ADDR_STATE%", state);
        placeholders.put("%ADDR_COUNTRY%", user.getCountry());
        return placeholders;
    }

    public Map<String, String> getUserPlaceholders(UserEntity user) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USERNAME%", user.getUsername());
        placeholders.put("%ADDR_EMAIL%", user.getEmail());
        placeholders.put("%ADDR_NAME%", String.valueOf(user.getFirstname()) + " " + user.getLastname());
        placeholders.put("%ADDR_FNAME%", user.getFirstname());
        placeholders.put("%ADDR_LNAME%", user.getLastname());
        placeholders.put("%ADDR_ADDRESS%", user.getAddress());
        placeholders.put("%ADDR_TOWN%", user.getTown());
        placeholders.put("%ADDR_ZIP%", user.getZipCode());
        String state = user.getState() == null ? "" : user.getState();
        placeholders.put("%ADDR_STATE%", state);
        placeholders.put("%ADDR_COUNTRY%", user.getCountry());
        return placeholders;
    }

    private String buildRecipient(User user) {
        return this.buildRecipient(user.getFirstname(), user.getLastname(), user.getEmail());
    }

    private String buildRecipient(UserEntity user) {
        return this.buildRecipient(user.getFirstname(), user.getLastname(), user.getEmail());
    }

    private String buildRecipient(String firstname, String lastname, String email) {
        if (this.isBlank(email)) {
            return null;
        }
        if (this.isBlank(firstname) || this.isBlank(lastname)) {
            return email;
        }
        StringBuilder recipient = new StringBuilder();
        recipient.append(firstname).append(" ").append(lastname).append(" ");
        recipient.append("<").append(email).append(">");
        return recipient.toString();
    }

    private boolean isBlank(String text) {
        return text == null || text.trim().isEmpty();
    }

    public boolean sendEmail(String recipient, EmailNotificationService.EmailCode emailCode, String language, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        return this.sendEmail(recipient, emailCode.name(), language, placeholders, attachments);
    }

    public boolean sendEmail(String recipient, String emailCode, String language, Map<String, String> placeholders, Map<String, ByteArrayResource> attachments) {
        log.debug((Object)("start sendEmail(recipient=" + recipient + ", emailCode=" + emailCode + ", language=" + language + ", placeholders=" + placeholders + ", attachments=" + attachments + ")"));
        if (!this.emailEnabled.booleanValue()) {
            log.warn((Object)"Sending emails disabled in configuration file");
            return false;
        }
        if (recipient == null || recipient.trim().length() == 0) {
            log.warn((Object)"Recipient misssing.");
            return false;
        }
        EmailTemplateEntity emailTemplate = this.emailTemplateDAO.findEmailTemplateByEmailCodeAnLanguage(emailCode, language);
        if (emailTemplate == null) {
            log.warn((Object)("No email template found for emailCode=" + emailCode + ", and language=" + language + "."));
            return false;
        }
        String subject = this.replacePlaceholders(emailTemplate.getSubject(), placeholders);
        if (subject == null) {
            log.warn((Object)"Email subject missing!");
            return false;
        }
        String body = this.replacePlaceholders(emailTemplate.getBody(), placeholders);
        if (body == null) {
            log.warn((Object)"Email body missing!");
            return false;
        }
        String htmlBody = this.replacePlaceholders(emailTemplate.getBodyHtml(), placeholders);
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            boolean multipart = htmlBody != null || this.areAttachments(attachments);
            MimeMessageHelper helper = new MimeMessageHelper(message, multipart, "UTF-8");
            helper.setFrom(this.from);
            helper.setTo(recipient);
            helper.setSubject(subject);
            if (htmlBody == null) {
                helper.setText(body);
            } else {
                helper.setText(body, htmlBody);
            }
            if (this.areAttachments(attachments)) {
                for (Map.Entry<String, ByteArrayResource> attachment : attachments.entrySet()) {
                    helper.addAttachment(attachment.getKey(), (InputStreamSource)attachment.getValue());
                }
            }
            this.mailSender.send(message);
        }
        catch (Exception me) {
            log.error((Object)("Failed to send email with subject '" + subject + "' to '" + recipient + "'."));
            if (log.isDebugEnabled()) {
                me.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private boolean areAttachments(Map<String, ByteArrayResource> attachments) {
        return attachments != null && !attachments.isEmpty();
    }

    private String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null) {
            return null;
        }
        if (placeholders == null || placeholders.isEmpty()) {
            return text;
        }
        for (Map.Entry<String, String> placeholder : placeholders.entrySet()) {
            text = placeholder.getValue() == null ? text.replace(placeholder.getKey(), "") : text.replace(placeholder.getKey(), placeholder.getValue());
        }
        text = text.replace("\\n", "\n");
        return text;
    }
}

