/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.restserver.db.dao.DyndnsDAO;
import pl.smartapps.restserver.db.main.DyndnsEntity;
import pl.smartapps.restserver.service.DynDNS;
import pl.smartapps.restserver.service.GetDynDNSException;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SetDynDNSException;
import pl.smartapps.restserver.service.VerifyDynDNSException;
import pl.smartapps.restserver.service.impl.DynDNSServiceImpl;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DynDNSServiceImpl.class, Utils.class, DomainName.class})
public class DynDNSServiceImplTests {
    private DynDNSServiceImpl dynDNSService;
    private DyndnsDAO dyndnsDAO;
    private GatewayDeviceConnectionService deviceConnection;
    private Connector connector;
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.dynDNSService = new DynDNSServiceImpl();
        this.dyndnsDAO = (DyndnsDAO)PowerMock.createMock(DyndnsDAO.class);
        this.dynDNSService.setDyndnsDAO(this.dyndnsDAO);
        this.deviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.dynDNSService.setDeviceConnection(this.deviceConnection);
        this.connector = (Connector)PowerMock.createMock(Connector.class);
        this.dynDNSService.setConnector(this.connector);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.dynDNSService.setParameterService(this.parameterService);
        PowerMock.mockStatic(Utils.class);
    }

    @Test
    public void testVerifyDynDNSWithTakenName() {
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        DyndnsEntity entity = new DyndnsEntity();
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn((Object)entity);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyDynDNSException.ErrorCode errorCode = null;
        try {
            Assert.assertEquals((Object)false, (Object)this.dynDNSService.verifyDynDNS(name));
        }
        catch (VerifyDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyDynDNSWithAvailableName() {
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyDynDNSException.ErrorCode errorCode = null;
        try {
            Assert.assertEquals((Object)true, (Object)this.dynDNSService.verifyDynDNS(name));
        }
        catch (VerifyDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyDynDNSWithNoName() {
        String name = "";
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        VerifyDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.verifyDynDNS(name);
        }
        catch (VerifyDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)VerifyDynDNSException.ErrorCode.NO_NAME, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnaledGetDynDNSWithStoredHaId() {
        String haId = "testHaId";
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        DyndnsEntity entity = new DyndnsEntity(name, haId, true);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)entity);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDynDNSException.ErrorCode errorCode = null;
        try {
            DynDNS dynDNS = this.dynDNSService.getDynDNS(haId);
            Assert.assertEquals((Object)name, (Object)dynDNS.getName());
            Assert.assertEquals((Object)true, (Object)dynDNS.isEnabled());
        }
        catch (GetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisabledGetDynDNSWithStoredHaId() {
        String haId = "testHaId";
        String name = "testName";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        DyndnsEntity entity = new DyndnsEntity(name, haId, false);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)entity);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDynDNSException.ErrorCode errorCode = null;
        try {
            DynDNS dynDNS = this.dynDNSService.getDynDNS(haId);
            Assert.assertEquals((Object)name, (Object)dynDNS.getName());
            Assert.assertEquals((Object)false, (Object)dynDNS.isEnabled());
        }
        catch (GetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDynDNSWithNoStoredHaId() {
        String haId = "testHaId";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDynDNSException.ErrorCode errorCode = null;
        try {
            Assert.assertEquals(null, (Object)this.dynDNSService.getDynDNS(haId));
        }
        catch (GetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDynDNSWithNoHaId() {
        String haId = "";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        GetDynDNSException.ErrorCode errorCode = null;
        try {
            Assert.assertEquals(null, (Object)this.dynDNSService.getDynDNS(haId));
        }
        catch (GetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)GetDynDNSException.ErrorCode.NO_HAID, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSCreateEnabledNewEntrySuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn(null);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        PowerMock.expectNew(DyndnsEntity.class, (Object[])new Object[]{name, haId, enabled}).andReturn((Object)dyndns);
        EasyMock.expect((Object)this.dyndnsDAO.store(dyndns, false)).andReturn((Object)dyndns);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        SetRegisteredResponse registeredResponse = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(haId, true)).andReturn((Object)registeredResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSCreateEnabledNewEntryFailureSetOnCommServer() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn(null);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        PowerMock.expectNew(DyndnsEntity.class, (Object[])new Object[]{name, haId, enabled}).andReturn((Object)dyndns);
        EasyMock.expect((Object)this.dyndnsDAO.store(dyndns, false)).andReturn((Object)dyndns);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)AddDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSCreateEnabledNewEntryNameTaken() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn((Object)dyndns);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NAME_TAKEN, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSCreateNotEnabledNewEntrySuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "";
        Boolean enabled = false;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateNameTaken() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)"otherName");
        DyndnsEntity otherDyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn((Object)otherDyndns);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NAME_TAKEN, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateNameSuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        String oldName = "testOldName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)oldName);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByDomainName(name)).andReturn(null);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)oldName);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        RemoveDomainNameResponse deleteResponse = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.delete(haId, "/rest/dns/" + oldName + ".dyn.remote-nas.com", null, RemoveDomainNameResponse.class)).andReturn((Object)deleteResponse);
        EasyMock.expect((Object)deleteResponse.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        dyndns.setDomainName(name);
        dyndns.setEnabled(enabled.booleanValue());
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateEnabledSuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        dyndns.setEnabled(enabled.booleanValue());
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateEnabledFailure() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        dyndns.setEnabled(enabled.booleanValue());
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)AddDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateNotEnabledSuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = false;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        dyndns.setEnabled(enabled.booleanValue());
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.delete(haId, "/rest/dns/testName.dyn.remote-nas.com", null, RemoveDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSUpdateNotEnabledFailure() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = false;
        String requestIp = "IP";
        String devicePublicIp = "IP";
        String domain = "dyn.remote-nas.com";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp);
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        dyndns.setEnabled(enabled.booleanValue());
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.delete(haId, "/rest/dns/testName.dyn.remote-nas.com", null, RemoveDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)RemoveDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSIpNotMatch() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        String devicePublicIp = "IP2";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        GatewayDevice device = (GatewayDevice)PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getPublicIpAddress()).andReturn((Object)devicePublicIp).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSDeviceNotConnected() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.deviceConnection.findById(haId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSNoRequestIp() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)requestIp)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NO_REQUEST_IP, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSNoEnabled() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        Boolean enabled = null;
        String requestIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NO_ENABLED, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSNoName() throws Exception {
        String haId = "testHaId";
        String name = "";
        Boolean enabled = true;
        String requestIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)name)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NO_NAME, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetDynDNSNoHaId() throws Exception {
        String haId = "";
        String name = "testName";
        Boolean enabled = true;
        String requestIp = "IP";
        EasyMock.expect((Object)Utils.isBlank((String)haId)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        SetDynDNSException.ErrorCode errorCode = null;
        try {
            this.dynDNSService.setDynDNS(haId, name, enabled, requestIp);
        }
        catch (SetDynDNSException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetDynDNSException.ErrorCode.NO_HAID, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testIsRegisteredTrue() {
        String haId = "testHaId";
        DyndnsEntity dyndns = new DyndnsEntity();
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.dynDNSService.isRegistered(haId));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsRegisteredFalse() {
        String haId = "testHaId";
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.dynDNSService.isRegistered(haId));
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerSuccessfully() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        String domain = "dyn.remote-nas.com";
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.isEnabled()).andReturn((Object)true);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        this.dynDNSService.notifyCommServer(haId);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerDynDNSDisabled() throws Exception {
        String haId = "testHaId";
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.isEnabled()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.dynDNSService.notifyCommServer(haId);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerFailure() throws Exception {
        String haId = "testHaId";
        String name = "testName";
        String domain = "dyn.remote-nas.com";
        DyndnsEntity dyndns = (DyndnsEntity)PowerMock.createMock(DyndnsEntity.class);
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn((Object)dyndns);
        EasyMock.expect((Object)dyndns.isEnabled()).andReturn((Object)true);
        EasyMock.expect((Object)dyndns.getDomainName()).andReturn((Object)name);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN)).andReturn((Object)domain);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{String.valueOf(name) + "." + domain, haId, DomainName.AddressType.PUBLIC}).andReturn((Object)domainName);
        StringEntity stringEntity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)stringEntity);
        stringEntity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(haId, "/rest/dns", null, (HttpEntity)stringEntity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)AddDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        this.dynDNSService.notifyCommServer(haId);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerDeviceNotRegistered() throws Exception {
        String haId = "testHaId";
        EasyMock.expect((Object)this.dyndnsDAO.getDyndnsByHaId(haId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.dynDNSService.notifyCommServer(haId);
        PowerMock.verifyAll();
    }
}

