/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.restserver.db.dao.DyndnsDAO;
import pl.smartapps.restserver.db.main.DyndnsEntity;
import pl.smartapps.restserver.service.DynDNS;
import pl.smartapps.restserver.service.DynDNSService;
import pl.smartapps.restserver.service.GetDynDNSException;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SetDynDNSException;
import pl.smartapps.restserver.service.VerifyDynDNSException;
import pl.smartapps.restserver.util.Utils;

@Service
public class DynDNSServiceImpl
implements DynDNSService {
    private static Logger log = Logger.getLogger(DynDNSServiceImpl.class);
    private DyndnsDAO dyndnsDAO;
    private GatewayDeviceConnectionService deviceConnection;
    private Connector connector;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setDyndnsDAO(DyndnsDAO dyndnsDAO) {
        this.dyndnsDAO = dyndnsDAO;
    }

    @Autowired
    @Required
    public void setDeviceConnection(GatewayDeviceConnectionService deviceConnection) {
        this.deviceConnection = deviceConnection;
    }

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public boolean verifyDynDNS(String name) {
        log.trace((Object)("start verifyDynDNS(name=" + name + ")"));
        if (Utils.isBlank((String)name)) {
            throw new VerifyDynDNSException(VerifyDynDNSException.ErrorCode.NO_NAME);
        }
        return this.dyndnsDAO.getDyndnsByDomainName(name) == null;
    }

    public DynDNS getDynDNS(String haId) {
        log.trace((Object)("start getDynDNS(haId=" + haId + ")"));
        if (Utils.isBlank((String)haId)) {
            throw new GetDynDNSException(GetDynDNSException.ErrorCode.NO_HAID);
        }
        DyndnsEntity dyndns = this.dyndnsDAO.getDyndnsByHaId(haId);
        return dyndns == null ? null : new DynDNS(dyndns.getDomainName(), dyndns.isEnabled());
    }

    @Transactional
    public void setDynDNS(String haId, String name, Boolean enabled, String requestIp) {
        log.trace((Object)("start setDynDNS(haId=" + haId + ", name=" + name + ", enabled=" + enabled + ", requestIp=" + requestIp + ")"));
        if (Utils.isBlank((String)haId)) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.NO_HAID);
        }
        if (enabled == null) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.NO_ENABLED);
        }
        if (enabled.booleanValue() && Utils.isBlank((String)name)) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.NO_NAME);
        }
        if (Utils.isBlank((String)requestIp)) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.NO_REQUEST_IP);
        }
        GatewayDevice device = this.deviceConnection.findById(haId);
        if (device == null) {
            log.info((Object)("Device with haId=" + haId + " is not connected"));
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.ERROR);
        }
        if (!device.getPublicIpAddress().equals(requestIp)) {
            log.info((Object)("Request IP " + requestIp + " and device public IP " + device.getPublicIpAddress() + " do not match"));
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.ERROR);
        }
        DyndnsEntity dyndns = this.dyndnsDAO.getDyndnsByHaId(haId);
        if (!this.isNameAvailable(name, dyndns)) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.NAME_TAKEN);
        }
        if (dyndns == null) {
            log.trace((Object)("Creating new dynDNS entry for name=" + name + " and haId=" + haId + "."));
            dyndns = new DyndnsEntity(name, haId, enabled.booleanValue());
            this.connector.setRegistered(haId, true);
            this.dyndnsDAO.store(dyndns, false);
        } else {
            if (this.nameChanged(dyndns, name)) {
                this.removeDynDNS(dyndns.getDomainName(), haId);
            }
            dyndns.setEnabled(enabled.booleanValue());
            dyndns.setDomainName(name);
            this.dyndnsDAO.store(dyndns, true);
        }
        this.synchronizeDynDNS(name, haId, enabled.booleanValue());
    }

    private boolean nameChanged(DyndnsEntity dyndns, String name) {
        return !name.equals(dyndns.getDomainName());
    }

    private boolean isNameAvailable(String name, DyndnsEntity dyndns) {
        if (dyndns == null && Utils.isBlank((String)name)) {
            return false;
        }
        if (Utils.isBlank((String)name)) {
            return true;
        }
        if (dyndns != null && dyndns.getDomainName().equals(name)) {
            return true;
        }
        return this.dyndnsDAO.getDyndnsByDomainName(name) == null;
    }

    private void synchronizeDynDNS(String name, String haId, boolean enabled) {
        if (!this.syncDynDNS(name, haId, enabled)) {
            throw new SetDynDNSException(SetDynDNSException.ErrorCode.ERROR);
        }
    }

    private boolean syncDynDNS(String name, String haId, boolean enabled) {
        log.trace((Object)("start synchronizeDynDNS(name=" + name + ", haId=" + haId + ", enabled=" + enabled + ")"));
        return enabled ? this.createDynDNS(name, haId) : this.removeDynDNS(name, haId);
    }

    private boolean createDynDNS(String name, String haId) {
        AddDomainNameResponse response;
        block3: {
            log.trace((Object)("start createDynDNS(name=" + name + ", haId=" + haId + ")"));
            try {
                HttpEntity entity = this.createDomainNameEntity(this.getAddress(name), haId, DomainName.AddressType.PUBLIC);
                response = (AddDomainNameResponse)this.connector.post(haId, "/rest/dns", null, entity, AddDomainNameResponse.class);
                if (response.getStatus() != Response.Status.SUCCESS) break block3;
                return true;
            }
            catch (UnsupportedEncodingException ex) {
                log.warn((Object)("Failed to create dynDNS for name=" + name + " and haId=" + haId + ": " + ex.getMessage()));
                return false;
            }
        }
        log.warn((Object)("Failed to create dynDNS for name=" + name + " and haId=" + haId + ": " + response.getErrorCode()));
        return false;
    }

    private boolean removeDynDNS(String name, String haId) {
        log.trace((Object)("start removeDynDNS(name=" + name + ", haId=" + haId + ")"));
        String path = "/rest/dns/" + this.getAddress(name);
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)this.connector.delete(haId, path, null, RemoveDomainNameResponse.class);
        if (response.getStatus() == Response.Status.SUCCESS) {
            return true;
        }
        log.warn((Object)("Failed to remove dynDNS for name=" + name + " and haId=" + haId + ": " + response.getErrorCode()));
        return false;
    }

    private String getAddress(String name) {
        String domain = this.getDynDNSDomain();
        if (domain == null) {
            throw new NullPointerException("domain");
        }
        StringBuilder address = new StringBuilder();
        address.append(name);
        if (!domain.startsWith(".")) {
            address.append(".");
        }
        address.append(domain);
        return address.toString();
    }

    private String getDynDNSDomain() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.DYN_DNS_DOMAIN);
    }

    private HttpEntity createDomainNameEntity(String domain, String mac, DomainName.AddressType type) throws UnsupportedEncodingException {
        DomainName domainName = new DomainName(domain, mac, type);
        StringEntity entity = Utils.createEntity((Object)domainName);
        entity.setContentType("application/json");
        return entity;
    }

    public boolean isRegistered(String haId) {
        log.trace((Object)("start isRegistered(haId=" + haId + ")"));
        return this.dyndnsDAO.getDyndnsByHaId(haId) != null;
    }

    public void notifyCommServer(String haId) {
        log.trace((Object)("start notifyCommServer(haId=" + haId + ")"));
        DyndnsEntity dyndns = this.dyndnsDAO.getDyndnsByHaId(haId);
        if (dyndns != null && dyndns.isEnabled()) {
            this.createDynDNS(dyndns.getDomainName(), haId);
        }
    }
}

