/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DomainName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.DomainNameService;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.DnsimpleGate;
import pl.smartapps.restserver.service.impl.DomainServiceImpl;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DomainServiceImpl.class, Utils.class, DigestUtils.class})
public class DomainServiceImplTests {
    private DomainServiceImpl domainService;
    private ParameterService parameterService;
    private GatewayClientDAO gatewayClientDAO;
    private DnsimpleGate dnsimpleGate;
    private SystemSupport systemSupport;
    private DomainNameService domainNameService;

    @Before
    public void setUp() {
        this.domainService = new DomainServiceImpl();
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.domainService.setParameterService(this.parameterService);
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.domainService.setGatewayClientDAO(this.gatewayClientDAO);
        this.dnsimpleGate = (DnsimpleGate)PowerMock.createMock(DnsimpleGate.class);
        this.domainService.setDnsimpleGate(this.dnsimpleGate);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.domainService.setSystemSupport(this.systemSupport);
        this.domainNameService = (DomainNameService)PowerMock.createMock(DomainNameService.class);
        this.domainService.setDomainNameService(this.domainNameService);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(DigestUtils.class);
    }

    @Test
    public void testSetUpPublicDomainWithDnsimpleWithoutPreviousDomainSuccessfully() {
        String mac = "testMac";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        client.setUpnpAddress(addressDns);
        client.setDomainRecordId(recordId);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithDnsimpleWithoutPreviousDomainFailureRegisterDomain() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn(null);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithDnsimpleWithPreviousDomainAndChangedPublicIpSuccessfully() {
        String mac = "testMac";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        Integer domainRecorId = 23;
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn((Object)domainRecorId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecorId)).andReturn((Object)record);
        String changedPublicIp = "11.11.11.12";
        EasyMock.expect((Object)record.getContent()).andReturn((Object)changedPublicIp);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn((Object)domainRecorId);
        EasyMock.expect((Object)this.dnsimpleGate.deleteRecord(domainRecorId)).andReturn((Object)true);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac).anyTimes();
        client.setUpnpAddress(addressDns);
        client.setDomainRecordId(recordId);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithDnsimpleWithPreviousDomainAndUnchangedPublicIpSuccessfully() {
        String mac = "testMac";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        Integer domainRecordId = 23;
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn((Object)domainRecordId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecordId)).andReturn((Object)record);
        EasyMock.expect((Object)record.getContent()).andReturn((Object)publicIp);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn((Object)domainRecordId);
        String dnsAddress = "testDnsAddress";
        EasyMock.expect((Object)client.getUpnpAddress()).andReturn((Object)dnsAddress);
        client.setDomainRecordId(domainRecordId);
        client.setUpnpAddress(dnsAddress);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithDnsimpleWithPreviousDomainNotFound() {
        String mac = "testMac";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        Integer domainRecorId = 23;
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getDomainRecordId()).andReturn((Object)domainRecorId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecorId)).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        client.setUpnpAddress(addressDns);
        client.setDomainRecordId(recordId);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithDnsimpleWithoutPreviousDomainSuccessfully() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        client.setLocalAddressDns(addressDns);
        client.setLocalDomainRecordId(recordId);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap params = new HashMap();
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithDnsimpleWithoutPreviousDomainFailureRegisterDomain() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn(null);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap params = new HashMap();
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithDnsimpleWithPreviousDomainAndChangedPublicIpSuccessfully() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Integer domainRecorId = 23;
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn((Object)domainRecorId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecorId)).andReturn((Object)record);
        String changedPublicIp = "11.11.11.12";
        EasyMock.expect((Object)record.getContent()).andReturn((Object)changedPublicIp);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn((Object)domainRecorId);
        EasyMock.expect((Object)this.dnsimpleGate.deleteRecord(domainRecorId)).andReturn((Object)true);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac).anyTimes();
        client.setLocalAddressDns(addressDns);
        client.setLocalDomainRecordId(recordId);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        HashMap params = new HashMap();
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithDnsimpleWithPreviousDomainAndUnchangedPublicIpSuccessfully() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        Integer domainRecordId = 23;
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn((Object)domainRecordId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecordId)).andReturn((Object)record);
        EasyMock.expect((Object)record.getContent()).andReturn((Object)publicIp);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn((Object)domainRecordId);
        String dnsAddress = "testDnsAddress";
        EasyMock.expect((Object)client.getLocalAddressDns()).andReturn((Object)dnsAddress);
        client.setLocalDomainRecordId(domainRecordId);
        client.setLocalAddressDns(dnsAddress);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithDnsimpleWithPreviousDomainNotFound() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        Integer domainRecorId = 23;
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        EasyMock.expect((Object)client.getLocalDomainRecordId()).andReturn((Object)domainRecorId);
        DnsimpleGate.Record record = (DnsimpleGate.Record)PowerMock.createMock(DnsimpleGate.Record.class);
        EasyMock.expect((Object)this.dnsimpleGate.getRecord(domainRecorId)).andReturn(null);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        EasyMock.expect((Object)this.dnsimpleGate.createRecord(name, publicIp)).andReturn((Object)record);
        String addressDns = "testAddressDns";
        EasyMock.expect((Object)this.dnsimpleGate.getAddress(name)).andReturn((Object)addressDns);
        Integer recordId = 1;
        EasyMock.expect((Object)record.getId()).andReturn((Object)recordId);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        client.setLocalAddressDns(addressDns);
        client.setLocalDomainRecordId(recordId);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithCommServerWithoutPreviousDomainNotFound() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        String oldAddress = "";
        EasyMock.expect((Object)client.getUpnpAddress()).andReturn((Object)oldAddress);
        EasyMock.expect((Object)Utils.isBlank((String)oldAddress)).andReturn((Object)true);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac).times(2);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        String newAddress = "newAddress";
        EasyMock.expect((Object)this.domainNameService.getAddress(name)).andReturn((Object)newAddress);
        EasyMock.expect((Object)this.domainNameService.createRecord(name, mac, DomainName.AddressType.PUBLIC)).andReturn((Object)true);
        client.setUpnpAddress(newAddress);
        client.setDomainRecordId(null);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpPublicDomainWithCommServerWithPreviousDomain() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        String address = "testAddress";
        EasyMock.expect((Object)client.getUpnpAddress()).andReturn((Object)address);
        EasyMock.expect((Object)Utils.isBlank((String)address)).andReturn((Object)false);
        EasyMock.expect((Object)this.domainNameService.getRecord(address)).andReturn(null);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        String name = "testName";
        EasyMock.expect((Object)this.domainNameService.getName(address)).andReturn((Object)name);
        EasyMock.expect((Object)this.domainNameService.createRecord(name, mac, DomainName.AddressType.PUBLIC)).andReturn((Object)true);
        client.setUpnpAddress(address);
        client.setDomainRecordId(null);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithCommServerWithoutPreviousDomainNotFound() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        String oldAddress = "";
        EasyMock.expect((Object)client.getLocalAddressDns()).andReturn((Object)oldAddress);
        EasyMock.expect((Object)Utils.isBlank((String)oldAddress)).andReturn((Object)true);
        long now = 123456L;
        String name = "testDomainName";
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac).times(2);
        EasyMock.expect((Object)this.systemSupport.currentTimeMillis()).andReturn((Object)now);
        EasyMock.expect((Object)DigestUtils.md5Hex((String)"testMac_123456")).andReturn((Object)name);
        String newAddress = "newAddress";
        EasyMock.expect((Object)this.domainNameService.getAddress(name)).andReturn((Object)newAddress);
        EasyMock.expect((Object)this.domainNameService.createRecord(name, mac, DomainName.AddressType.LOCAL)).andReturn((Object)true);
        client.setLocalAddressDns(newAddress);
        client.setLocalDomainRecordId(null);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpLocalDomainWithCommServerWithPreviousDomain() {
        String mac = "testMac";
        String publicIp = "11.11.11.11";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        String address = "testAddress";
        EasyMock.expect((Object)client.getLocalAddressDns()).andReturn((Object)address);
        EasyMock.expect((Object)Utils.isBlank((String)address)).andReturn((Object)false);
        EasyMock.expect((Object)this.domainNameService.getRecord(address)).andReturn(null);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        String name = "testName";
        EasyMock.expect((Object)this.domainNameService.getName(address)).andReturn((Object)name);
        EasyMock.expect((Object)this.domainNameService.createRecord(name, mac, DomainName.AddressType.LOCAL)).andReturn((Object)true);
        client.setLocalAddressDns(address);
        client.setLocalDomainRecordId(null);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.setUpDomain(mac, publicIp, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerAboutUpnpDomainAddressSuccessfully() throws Exception {
        String mac = "testMac";
        String publicIp = "testPublicIp";
        String upnpAddress = "testUpnpAddress";
        String domainName = "testDomainName";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        EasyMock.expect((Object)((GatewayClientEntity)clients.get(0))).andReturn((Object)client);
        EasyMock.expect((Object)client.getUpnpAddress()).andReturn((Object)upnpAddress).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)upnpAddress)).andReturn((Object)false);
        EasyMock.expect((Object)this.domainNameService.getName(upnpAddress)).andReturn((Object)domainName);
        EasyMock.expect((Object)this.domainNameService.createRecord(domainName, mac, DomainName.AddressType.PUBLIC)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)true, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerAboutUpnpDomainAddressBlankAddress() throws Exception {
        String mac = "testMac";
        String publicIp = "testPublicIp";
        String upnpAddress = "testUpnpAddress";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)false);
        EasyMock.expect((Object)((GatewayClientEntity)clients.get(0))).andReturn((Object)client);
        EasyMock.expect((Object)client.getUpnpAddress()).andReturn((Object)upnpAddress);
        EasyMock.expect((Object)Utils.isBlank((String)upnpAddress)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerAboutUpnpDomainAddressNotFoundAnyClients() throws Exception {
        String mac = "testMac";
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"COMM_SERVER");
        EasyMock.expect((Object)Utils.isBlank((String)"COMM_SERVER")).andReturn((Object)false);
        List clients = (List)PowerMock.createMock(List.class);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn((Object)clients);
        EasyMock.expect((Object)clients.isEmpty()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerAboutUpnpDomainAddressDnsGateNotCommServer() throws Exception {
        String mac = "testMac";
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn((Object)"DNSIMPLE");
        EasyMock.expect((Object)Utils.isBlank((String)"DNSIMPLE")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyCommServerAboutUpnpDomainAddressBlankDnsGateParameter() throws Exception {
        String mac = "testMac";
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE)).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotifyCommServerAboutUpnpDomainAddressBlankPublicIp() throws Exception {
        String mac = "testMac";
        String publicIp = "";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)publicIp)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotifyCommServerAboutUpnpDomainAddressBlankMac() throws Exception {
        String mac = "";
        String publicIp = "testPublicIp";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainService.notifyCommServerAboutUpnpDomainAddress(mac, publicIp);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testTearDownForPublicType() {
        String mac = "testMac";
        Integer upnpPort = 15800;
        String upnpReason = "testReason";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(client);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress(mac)).andReturn(clients);
        EasyMock.expect(params.get(DomainService.Param.UPNP_PORT)).andReturn((Object)upnpPort);
        client.setUpnpPort(upnpPort);
        EasyMock.expect(params.get(DomainService.Param.REASON)).andReturn((Object)upnpReason);
        client.setUpnpReason(upnpReason);
        EasyMock.expect((Object)this.gatewayClientDAO.store(client)).andReturn((Object)client);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.tearDownDomain(mac, DomainService.Type.PUBLIC, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testTearDownForLocalType() {
        String mac = "testMac";
        Map params = (Map)PowerMock.createMock(HashMap.class);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainService.tearDownDomain(mac, DomainService.Type.LOCAL, params);
        PowerMock.verifyAll();
    }
}

