/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DomainName;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.DomainNameService;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.service.DomainService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.DnsimpleGate;
import pl.smartapps.restserver.service.impl.DomainServiceImpl;
import pl.smartapps.restserver.util.Utils;

@Service
public class DomainServiceImpl
implements DomainService {
    private static Logger log = Logger.getLogger(DomainServiceImpl.class);
    private ParameterService parameterService;
    private GatewayClientDAO gatewayClientDAO;
    private DnsimpleGate dnsimpleGate;
    private SystemSupport systemSupport;
    private DomainNameService domainNameService;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setDnsimpleGate(DnsimpleGate dnsimpleGate) {
        this.dnsimpleGate = dnsimpleGate;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setDomainNameService(DomainNameService domainNameService) {
        this.domainNameService = domainNameService;
    }

    @Transactional
    public void setUpDomain(String mac, String ipAddress, DomainService.Type type, Map<DomainService.Param, Object> params) {
        log.debug((Object)("start setUpDomain(mac=" + mac + ", ipAddress=" + ipAddress + ", type=" + type + ", params=" + params + ")"));
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        if (clients.isEmpty()) {
            log.warn((Object)("Not found any gateway clients for mac=" + mac + "."));
            return;
        }
        GatewayClientEntity client = (GatewayClientEntity)clients.get(0);
        if (this.isDnsEnabled(type)) {
            log.trace((Object)("Dns is enabled for type=" + type + "."));
            Domain domain = null;
            DnsGate dnsGate = this.getDnsGate();
            log.trace((Object)("dns gate: " + dnsGate));
            if (dnsGate == DnsGate.DNSIMPLE) {
                Integer recordId = this.getRecordId(client, type);
                if (recordId == null) {
                    log.debug((Object)"Not found domain record id. New domain record will be registred.");
                    domain = this.registerDomain(client, ipAddress);
                } else {
                    log.debug((Object)("Found domain record id: " + recordId + "."));
                    DnsimpleGate.Record record = this.dnsimpleGate.getRecord(recordId);
                    if (record == null) {
                        log.warn((Object)("Not found domain record for recordId=" + recordId + ". New domain record will be registred."));
                        domain = this.registerDomain(client, ipAddress);
                    } else {
                        log.debug((Object)("Found record with recordId=" + recordId + "."));
                        if (!ipAddress.equals(record.getContent())) {
                            log.debug((Object)"IP address has chnaged. New domain record will be registred.");
                            this.deleteDomainRecord(client, type);
                            domain = this.registerDomain(client, ipAddress);
                        } else {
                            log.debug((Object)"IP address has not chnaged.");
                            domain = this.getDomain(client, type);
                        }
                    }
                }
            } else if (dnsGate == DnsGate.COMM_SERVER) {
                String address = this.getAddress(client, type);
                if (Utils.isBlank((String)address)) {
                    log.debug((Object)"Not found domain record id. New domain record will be registred.");
                    String upnpAddressName = this.generateUpnpAdressName(client.getMac());
                    this.domainNameService.createRecord(upnpAddressName, client.getMac(), type == DomainService.Type.PUBLIC ? DomainName.AddressType.PUBLIC : DomainName.AddressType.LOCAL);
                    address = this.domainNameService.getAddress(upnpAddressName);
                } else if (this.domainNameService.getRecord(address) == null) {
                    String name = this.domainNameService.getName(address);
                    log.debug((Object)("Not found address " + address + " on CommServer. Resending with name " + name + "."));
                    this.domainNameService.createRecord(name, client.getMac(), type == DomainService.Type.PUBLIC ? DomainName.AddressType.PUBLIC : DomainName.AddressType.LOCAL);
                }
                domain = new Domain(this, null, address);
            } else {
                log.warn((Object)("Unsupported dns gate: " + dnsGate));
                return;
            }
            if (domain == null) {
                log.warn((Object)("Failed to create doamin for mac=" + mac + ", ipAddress=" + ipAddress + ", type=" + type + "."));
                return;
            }
            for (GatewayClientEntity c : clients) {
                if (type == DomainService.Type.PUBLIC) {
                    c.setUpnpAddress(domain.getAddress());
                    c.setDomainRecordId(domain.getRecordId());
                    c.setUpnpPort((Integer)params.get(DomainService.Param.UPNP_PORT));
                    c.setUpnpReason((String)params.get(DomainService.Param.REASON));
                } else {
                    c.setLocalAddressDns(domain.getAddress());
                    c.setLocalDomainRecordId(domain.getRecordId());
                }
                this.gatewayClientDAO.store(c);
            }
        }
    }

    private boolean isDnsEnabled(DomainService.Type type) {
        ParameterService.ParameterCode code = type == DomainService.Type.PUBLIC ? ParameterService.ParameterCode.GATEWAYCLIENT_UPNP_ADDRESS_DNS : ParameterService.ParameterCode.GATEWAYCLIENT_LOCAL_DOMAIN_ADDRESS_DNS;
        return this.parameterService.getBoolParameterValue(code);
    }

    private DnsGate getDnsGate() {
        String value = this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAYCLIENT_DNS_GATE);
        if (Utils.isBlank((String)value)) {
            log.warn((Object)"Not found GATEWAYCLIENT_DNS_GATE parameter");
            return null;
        }
        if (value.equalsIgnoreCase("dnsimple")) {
            return DnsGate.DNSIMPLE;
        }
        if (value.equalsIgnoreCase("comm_server")) {
            return DnsGate.COMM_SERVER;
        }
        log.warn((Object)("Not supported dns gate: " + value));
        return null;
    }

    private Integer getRecordId(GatewayClientEntity client, DomainService.Type type) {
        return type == DomainService.Type.PUBLIC ? client.getDomainRecordId() : client.getLocalDomainRecordId();
    }

    private String getAddress(GatewayClientEntity client, DomainService.Type type) {
        return type == DomainService.Type.PUBLIC ? client.getUpnpAddress() : client.getLocalAddressDns();
    }

    private Domain getDomain(GatewayClientEntity client, DomainService.Type type) {
        if (type == DomainService.Type.PUBLIC) {
            return new Domain(this, client.getDomainRecordId(), client.getUpnpAddress());
        }
        return new Domain(this, client.getLocalDomainRecordId(), client.getLocalAddressDns());
    }

    private Domain registerDomain(GatewayClientEntity client, String ipAddress) {
        String upnpAddressName = this.generateUpnpAdressName(client.getMac());
        DnsimpleGate.Record record = this.dnsimpleGate.createRecord(upnpAddressName, ipAddress);
        if (record == null) {
            return null;
        }
        return new Domain(this, record.getId(), this.dnsimpleGate.getAddress(upnpAddressName));
    }

    private String generateUpnpAdressName(String mac) {
        return DigestUtils.md5Hex((String)(String.valueOf(mac) + "_" + this.systemSupport.currentTimeMillis()));
    }

    private void deleteDomainRecord(GatewayClientEntity client, DomainService.Type type) {
        Integer recordId = this.getRecordId(client, type);
        if (!this.dnsimpleGate.deleteRecord(recordId)) {
            log.debug((Object)("Failed to delete domain record with recordId=" + recordId + ". This domain record with recordId=" + recordId + " shall be removed manually!."));
        }
    }

    @Transactional(readOnly=true)
    public boolean notifyCommServerAboutUpnpDomainAddress(String mac, String publicIp) {
        log.trace((Object)("start notifyCommServerAboutUpnpDomainAddress(mac=" + mac + ", publicIp=" + publicIp + ")"));
        if (Utils.isBlank((String)mac)) {
            throw new IllegalArgumentException("mac is blank");
        }
        if (Utils.isBlank((String)publicIp)) {
            throw new IllegalArgumentException("publicIp is blank");
        }
        if (DnsGate.COMM_SERVER != this.getDnsGate()) {
            log.trace((Object)"Current dns gate is not commserver.");
            return false;
        }
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        if (clients.isEmpty()) {
            log.debug((Object)("Not found any gateway client with mac=" + mac + "."));
            return false;
        }
        GatewayClientEntity client = (GatewayClientEntity)clients.get(0);
        if (Utils.isBlank((String)client.getUpnpAddress())) {
            return false;
        }
        String name = this.domainNameService.getName(client.getUpnpAddress());
        return this.domainNameService.createRecord(name, mac, DomainName.AddressType.PUBLIC);
    }

    @Transactional
    public void tearDownDomain(String mac, DomainService.Type type, Map<DomainService.Param, Object> params) {
        log.debug((Object)("start tearDownDomain(mac=" + mac + ", type=" + type + ", params=" + params + ")"));
        if (type == DomainService.Type.PUBLIC) {
            List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
            if (clients.isEmpty()) {
                log.warn((Object)("Not found any gateway clients for mac=" + mac + "."));
                return;
            }
            for (GatewayClientEntity client : clients) {
                client.setUpnpPort((Integer)params.get(DomainService.Param.UPNP_PORT));
                client.setUpnpReason((String)params.get(DomainService.Param.REASON));
                this.gatewayClientDAO.store(client);
            }
        }
    }
}

