/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.HttpClientFactory;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.DnsimpleGate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DnsimpleGate {
    private static Logger log = Logger.getLogger(DnsimpleGate.class);
    private ParameterService parameterService;
    private HttpClientFactory httpClientFactory;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    private String getDnsimpleEndpoint() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.DNSIMPLE_ENDPOINT);
    }

    private String getDnsimpleDomain() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.DNSIMPLE_DOMAIN);
    }

    public String getAddress(String name) {
        String domain = this.getDnsimpleDomain();
        return name == null || name.trim().isEmpty() ? domain : String.valueOf(name) + "." + domain;
    }

    private String getAuthToken() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.DNSIMPLE_TOKEN);
    }

    public Response get(String path) throws ClientProtocolException, IOException {
        log.debug((Object)("start get(path=" + path + ")"));
        HttpGet httpGet = new HttpGet(String.valueOf(this.getDnsimpleEndpoint()) + path);
        httpGet.setHeader("X-DNSimple-Domain-Token", this.getAuthToken());
        httpGet.setHeader("Accept", "application/json");
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return new Response(response);
    }

    public Response post(String path, String requestBody) throws ClientProtocolException, IOException {
        log.debug((Object)("start post(path=" + path + ", requestBody=" + requestBody + ")"));
        HttpPost httpPost = new HttpPost(String.valueOf(this.getDnsimpleEndpoint()) + path);
        httpPost.setHeader("X-DNSimple-Domain-Token", this.getAuthToken());
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return new Response(response);
    }

    public Response put(String path, String requestBody) throws ClientProtocolException, IOException {
        log.debug((Object)("start put(path=" + path + ", requestBody=" + requestBody + ")"));
        HttpPut httpPut = new HttpPut(String.valueOf(this.getDnsimpleEndpoint()) + path);
        httpPut.setHeader("X-DNSimple-Domain-Token", this.getAuthToken());
        httpPut.setHeader("Accept", "application/json");
        httpPut.setEntity((HttpEntity)new StringEntity(requestBody));
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        return new Response(response);
    }

    public Response delete(String path) throws ClientProtocolException, IOException {
        log.debug((Object)("start delete(path=" + path + ")"));
        HttpDelete httpDelete = new HttpDelete(String.valueOf(this.getDnsimpleEndpoint()) + path);
        httpDelete.setHeader("X-DNSimple-Domain-Token", this.getAuthToken());
        httpDelete.setHeader("Accept", "application/json");
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return new Response(response);
    }

    public Record createRecord(String name, String ipAddress) {
        Response response;
        ObjectMapper mapper;
        block4: {
            log.debug((Object)("start createRecord(name=" + name + ", ipAddress=" + ipAddress + ")"));
            try {
                RecordWrapper record = new RecordWrapper();
                record.getRecord().setName(name);
                record.getRecord().setRecordType("A");
                record.getRecord().setContent(ipAddress);
                record.getRecord().setTtl(Integer.valueOf(3600));
                record.getRecord().setPrio(Integer.valueOf(10));
                mapper = new ObjectMapper();
                String requestBody = mapper.writeValueAsString((Object)record);
                log.debug((Object)("create record request: " + requestBody.toString()));
                response = this.post("/domains/" + this.getDnsimpleDomain() + "/records", requestBody);
                log.debug((Object)("create record response: " + requestBody.toString()));
                if (Response.access$0((Response)response) == 201) break block4;
                log.warn((Object)("Failed to create record for name=" + name + "and ipAddress=" + ipAddress + ". Response status code: " + Response.access$0((Response)response) + "."));
                return null;
            }
            catch (Exception e) {
                log.warn((Object)("Failed to create record for name=" + name + " and ipAddress=" + ipAddress + ": " + e.getMessage() + "."));
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        RecordWrapper recordWrapper = (RecordWrapper)mapper.readValue(response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return recordWrapper.getRecord();
    }

    public boolean deleteRecord(Integer recordId) {
        log.debug((Object)("start deleteRecord(recordId=" + recordId + "."));
        if (recordId == null) {
            return false;
        }
        try {
            Response response = this.delete("/domains/" + this.getDnsimpleDomain() + "/records/" + recordId);
            log.debug((Object)("delete record response: " + response));
            if (Response.access$0((Response)response) != 200 && Response.access$0((Response)response) != 204) {
                log.info((Object)("Failed to delete record for recordId=" + recordId + ". Response status code: " + Response.access$0((Response)response) + "."));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Record getRecord(Integer recordId) {
        Response response;
        block4: {
            log.debug((Object)("start getRecord(recordId=" + recordId + ")"));
            if (recordId == null) {
                return null;
            }
            try {
                response = this.get("/domains/" + this.getDnsimpleDomain() + "/records/" + recordId);
                log.debug((Object)("get record respnse: " + response));
                if (Response.access$0((Response)response) == 200) break block4;
                log.info((Object)("Failed to get record for recordId=" + recordId + ". Response status code: " + Response.access$0((Response)response) + "."));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        RecordWrapper recordWrapper = (RecordWrapper)mapper.readValue(response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return recordWrapper.getRecord();
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }
}

