/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.service.impl.DeviceNameGenerator;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DeviceNameGenerator.class})
public class DeviceNameGeneratorTests {
    private DeviceNameGenerator deviceNameGenerator;
    private LanDeviceDAO lanDeviceDAO;

    @Before
    public void setUp() {
        this.deviceNameGenerator = new DeviceNameGenerator();
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.deviceNameGenerator.setLanDeviceDAO(this.lanDeviceDAO);
    }

    @Test
    public void testGenerateNameForCameraWhenNullMaxIndexNot() {
        Integer userId = 1;
        String deviceType = "camera";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"Camera #0", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForCameraWhenFoundMaxIndexNot0() {
        Integer userId = 1;
        String deviceType = "camera";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(2.0));
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"Camera #3", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForCameraWhenFoundMaxIndex0() {
        Integer userId = 1;
        String deviceType = "camera";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(0.0));
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(userId, deviceType)).andReturn((Object)new Long(2L));
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"Camera #3", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForCameraWhenFoundMaxIndex0AndNullCount() {
        Integer userId = 1;
        String deviceType = "camera";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(0.0));
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(userId, deviceType)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"Camera #0", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForNasWhenNullMaxIndexNot() {
        Integer userId = 1;
        String deviceType = "nas";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"NAS #0", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForNasWhenFoundMaxIndexNot0() {
        Integer userId = 1;
        String deviceType = "nas";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(2.0));
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"NAS #3", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForNasWhenFoundMaxIndex0() {
        Integer userId = 1;
        String deviceType = "nas";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(0.0));
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(userId, deviceType)).andReturn((Object)new Long(2L));
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"NAS #3", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForNasWhenFoundMaxIndex0AndNullCount() {
        Integer userId = 1;
        String deviceType = "nas";
        String mac = "00:00:00:00:00:00";
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(userId, deviceType)).andReturn((Object)new Double(0.0));
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(userId, deviceType)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"NAS #0", (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGenerateNameForWebInterface() {
        Integer userId = 1;
        String deviceType = "webinterface";
        String mac = "00:00:00:00:00:00";
        PowerMock.replayAll((Object[])new Object[0]);
        String actual = this.deviceNameGenerator.generate(userId, deviceType, mac);
        Assert.assertEquals((Object)"Web Interface 00:00:00:00:00:00", (Object)actual);
        PowerMock.verifyAll();
    }
}

