/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;

@Component
public class DeviceNameGenerator {
    private static Logger log = Logger.getLogger(DeviceNameGenerator.class);
    private LanDeviceDAO lanDeviceDAO;

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    public String generate(Integer userId, String deviceType, String gatewayClientMac) {
        log.trace((Object)("start generate(userId=" + userId + ", deviceType=" + deviceType + ", gatewayClientMac=" + gatewayClientMac + ")"));
        if (deviceType.equalsIgnoreCase("camera")) {
            return "Camera #" + this.getLanDeviceNameIndex(userId, "camera");
        }
        if (deviceType.equalsIgnoreCase("nas")) {
            return "NAS #" + this.getLanDeviceNameIndex(userId, "nas");
        }
        if (deviceType.equalsIgnoreCase("webinterface")) {
            return "Web Interface " + gatewayClientMac;
        }
        return "";
    }

    private Integer getLanDeviceNameIndex(Integer userId, String deviceClass) {
        log.trace((Object)"start getLanDeviceNameIndex()");
        Double foundIndex = this.lanDeviceDAO.findMaxCameraIndex(userId, deviceClass);
        if (foundIndex == null) {
            log.debug((Object)"Found max camera index is null. Returning 0!");
            return 0;
        }
        int index = foundIndex.intValue();
        log.debug((Object)("Found max camera index is " + index));
        if (index == 0) {
            Long devicesCount = this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(userId, deviceClass);
            if (devicesCount == null) {
                return 0;
            }
            index = devicesCount.intValue();
        }
        log.trace((Object)("exit getLanDeviceNameIndex(): " + (index + 1)));
        return ++index;
    }
}

