/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.AwsS3Controller;

@Component
public class AwsS3Controller
implements EventsFilesController {
    private static Logger log = Logger.getLogger(AwsS3Controller.class);
    private SystemSupport systemSupport;
    private ParameterService parameterService;
    private TransferManager tm;
    private String bucketName;
    private AmazonS3 s3client;
    private boolean enabled;

    @PostConstruct
    public void init() {
        boolean bl = this.enabled = this.parameterService.getString(ParameterService.ParameterCode.AWS_BUCKET_NAME, null) != null;
        if (!this.enabled) {
            log.info((Object)"aws is disabled...");
            return;
        }
        1 credentials = new /* Unavailable Anonymous Inner Class!! */;
        this.s3client = new AmazonS3Client((AWSCredentials)credentials);
        String serverAddress = this.parameterService.getParameterValue(ParameterService.ParameterCode.AWS_SERVER_ADDRESS);
        String serverPort = this.parameterService.getParameterValue(ParameterService.ParameterCode.AWS_SERVER_PORT);
        if (serverAddress != null) {
            this.s3client.setEndpoint(String.valueOf(serverAddress) + (serverPort != null ? ":" + serverPort : ""));
        }
        this.tm = new TransferManager(this.s3client);
        this.bucketName = this.parameterService.getParameterValue(ParameterService.ParameterCode.AWS_BUCKET_NAME);
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void uploadFile(String filePath) {
        if (!this.enabled) {
            log.warn((Object)("Trying to upload file " + filePath + " while aws is disabled"));
            return;
        }
        if (this.systemSupport.getFile(filePath).exists()) {
            String keyName = filePath.substring(filePath.lastIndexOf("/") > -1 ? filePath.lastIndexOf("/") + 1 : 0);
            Upload upload = this.tm.upload(this.bucketName, keyName, new File(filePath));
            upload.addProgressListener((ProgressListener)new UploadProgressListener(this, filePath));
        }
    }

    private boolean shouldDeleteFile() {
        String value = this.parameterService.getParameterValue(ParameterService.ParameterCode.AWS_DELETE_FILE);
        if (value == null) {
            return true;
        }
        return value.equals("ON");
    }

    public void downloadImage(HttpServletRequest request, HttpServletResponse response, EventEntity event, String fileName, String saveFileName) throws IOException {
        this.downloadFile(request, response, fileName, saveFileName);
    }

    public void downloadVideo(HttpServletRequest request, HttpServletResponse response, EventEntity event, String fileName, String saveFileName) throws IOException {
        this.downloadFile(request, response, fileName, saveFileName);
    }

    private void downloadFile(HttpServletRequest request, HttpServletResponse response, String fileName, String saveFileName) throws IOException {
        if (!this.enabled) {
            log.warn((Object)("Trying to download file " + fileName + " while aws is disabled"));
            return;
        }
        Date expiryDate = new Date();
        expiryDate.setTime(expiryDate.getTime() + 86400000L);
        saveFileName = this.encodeFileName(saveFileName);
        GeneratePresignedUrlRequest rq = new GeneratePresignedUrlRequest(this.bucketName, fileName);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides().withContentDisposition("attachment; filename=" + saveFileName + "; filename*=UTF-8''" + saveFileName);
        rq.setResponseHeaders(responseHeaders);
        rq.setExpiration(expiryDate);
        URL link = this.s3client.generatePresignedUrl(rq);
        response.sendRedirect(link.toString());
    }

    private String encodeFileName(String fileName) throws UnsupportedEncodingException {
        return URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
    }

    public boolean deleteFile(String fileName) {
        try {
            this.s3client.deleteObject(new DeleteObjectRequest(this.bucketName, fileName));
        }
        catch (AmazonServiceException ase) {
            return false;
        }
        catch (AmazonClientException ace) {
            return false;
        }
        return true;
    }

    public boolean fileExists(String fileName) {
        try {
            this.s3client.getObjectMetadata(this.bucketName, fileName);
        }
        catch (AmazonServiceException ase) {
            return false;
        }
        catch (AmazonClientException ace) {
            return false;
        }
        return true;
    }

    public void stop() {
        if (!this.enabled) {
            return;
        }
        this.tm.shutdownNow();
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ boolean access$1(AwsS3Controller awsS3Controller) {
        return awsS3Controller.shouldDeleteFile();
    }

    static /* synthetic */ SystemSupport access$2(AwsS3Controller awsS3Controller) {
        return awsS3Controller.systemSupport;
    }

    static /* synthetic */ ParameterService access$3(AwsS3Controller awsS3Controller) {
        return awsS3Controller.parameterService;
    }
}

