/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.util.SharedCache;
import java.util.concurrent.ConcurrentMap;
import nl.captcha.Captcha;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationStatus;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.rest.response.LogoutResponse;
import pl.smartapps.restserver.rest.security.RememberMeManager;
import pl.smartapps.restserver.rest.security.SsoToken;
import pl.smartapps.restserver.service.AttemptService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AuthenticationUtils.class, SecurityUtils.class, Captcha.class, ThreadContext.class, UsernamePasswordToken.class, SsoToken.class})
public class AuthenticationUtilsTests {
    private AuthenticationUtils authUtils;
    private Subject subject;
    private Session session;
    private SecurityManager securityManager;
    private UserDAO userDAO;
    private AttemptService attemptService;
    private ParameterService parameterService;
    private SharedCache sharedCache;

    @Before
    public void setUp() {
        this.authUtils = new AuthenticationUtils();
        this.securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        this.authUtils.setSecurityManager(this.securityManager);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.authUtils.setUserDAO(this.userDAO);
        this.attemptService = (AttemptService)PowerMock.createMock(AttemptService.class);
        this.authUtils.setAttemptService(this.attemptService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.authUtils.setParameterService(this.parameterService);
        this.sharedCache = (SharedCache)PowerMock.createMock(SharedCache.class);
        this.authUtils.setSharedCache(this.sharedCache);
        this.subject = (Subject)PowerMock.createMock(Subject.class);
        this.session = (Session)PowerMock.createMock(Session.class);
    }

    @After
    public void tearDown() {
        PowerMock.resetAll((Object[])new Object[0]);
    }

    @Test
    public void testInitialize() {
        ConcurrentMap activeSessions = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect((Object)this.sharedCache.getMap("activeSessions")).andReturn((Object)activeSessions);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.initialize();
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLoggedInTrue() {
        String principal = "";
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.authUtils.isLoggedIn());
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLoggedInFalse() {
        Object principal = null;
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.isLoggedIn());
        PowerMock.verifyAll();
    }

    @Test
    public void testEnsureLoggedInTrue() throws InvalidSessionException {
        String principal = "";
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.ensureLoggedIn();
        PowerMock.verifyAll();
    }

    @Test(expected=InvalidSessionException.class)
    public void testEnsureLoggedInFalse() throws InvalidSessionException {
        Object principal = null;
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.ensureLoggedIn();
        PowerMock.verifyAll();
    }

    @Test
    public void testHasRoleFalse() {
        AuthenticationUtils.Role role = AuthenticationUtils.Role.ADMIN;
        this.getCurrentSubjectTest();
        this.subject.checkRole("admin");
        EasyMock.expectLastCall().andThrow((Throwable)new AuthorizationException());
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.hasRole(role));
        PowerMock.verifyAll();
    }

    @Test
    public void testHasRoleTrue() {
        AuthenticationUtils.Role role = AuthenticationUtils.Role.ADMIN;
        this.getCurrentSubjectTest();
        this.subject.checkRole("admin");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.authUtils.hasRole(role));
        PowerMock.verifyAll();
    }

    @Test
    public void testHasAnyRoleNoRole() {
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[0]));
        PowerMock.verifyAll();
    }

    @Test
    public void testHasAnyRoleFalse() {
        this.getCurrentSubjectTest();
        this.subject.checkRole("admin");
        EasyMock.expectLastCall().andThrow((Throwable)new AuthorizationException());
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN}));
        PowerMock.verifyAll();
    }

    @Test
    public void testHasAnyRoleTrue() {
        this.getCurrentSubjectTest();
        this.subject.checkRole("admin");
        EasyMock.expectLastCall().andThrow((Throwable)new AuthorizationException());
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("integration");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION}));
        PowerMock.verifyAll();
    }

    @Test
    public void testEnsureHasRoleTrue() throws InvalidSessionException {
        String principal = "";
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("admin");
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.verifyAll();
    }

    @Test(expected=InvalidSessionException.class)
    public void testEnsureHasRoleNotLoggedIn() throws InvalidSessionException {
        Object principal = null;
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.verifyAll();
    }

    @Test(expected=InvalidSessionException.class)
    public void testEnsureHasRoleFalse() throws InvalidSessionException {
        String principal = "";
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("admin");
        EasyMock.expectLastCall().andThrow((Throwable)new AuthorizationException());
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentSubject() {
        this.getCurrentSubjectTest();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)this.subject, (Object)this.authUtils.getCurrentSubject());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUserId() {
        String key = "sudoUserId";
        Integer userId = 11;
        this.getStoredDataTest(key, (Object)userId);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("admin");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)userId, (Object)this.authUtils.getCurrentUserId());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUserIdNotAdmin() {
        String key = "sudoUserId";
        Integer userId = 11;
        String principal = "11";
        this.getStoredDataTest(key, (Object)userId);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("admin");
        EasyMock.expectLastCall().andThrow((Throwable)new AuthorizationException());
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)userId, (Object)this.authUtils.getCurrentUserId());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUserIdNoStoredData() {
        String key = "sudoUserId";
        Integer userId = 11;
        String principal = "11";
        this.getStoredDataTest(key, null);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)userId, (Object)this.authUtils.getCurrentUserId());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUserIdNoPrincipal() {
        String key = "sudoUserId";
        Object principal = null;
        this.getStoredDataTest(key, null);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertNull((Object)this.authUtils.getCurrentUserId());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUser() {
        String key = "sudoUserId";
        Integer userId = 11;
        this.getStoredDataTest(key, (Object)userId);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        this.subject.checkRole("admin");
        UserEntity currentUser = new UserEntity();
        currentUser.setId(userId);
        EasyMock.expect((Object)this.userDAO.findUserById(userId, false, false)).andReturn((Object)currentUser);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)currentUser, (Object)this.authUtils.getCurrentUser());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentUserNoCurrentUser() {
        String key = "sudoUserId";
        Object principal = null;
        this.getStoredDataTest(key, null);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertNull((Object)this.authUtils.getCurrentUser());
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfulWithRememberMe() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = true;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"regular");
        this.attemptService.reset(username);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfulWithoutRememberMe() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"regular");
        this.attemptService.reset(username);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserUnknownAccountException() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expectLastCall().andThrow((Throwable)new UnknownAccountException());
        this.attemptService.record(username);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.FAILED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserIncorrectCredentialsException() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expectLastCall().andThrow((Throwable)new IncorrectCredentialsException());
        this.attemptService.record(username);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.FAILED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserLockedAccountException() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expectLastCall().andThrow((Throwable)new LockedAccountException());
        this.attemptService.record(username);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.FAILED_NOTACTIVATED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserOtherException() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expectLastCall().andThrow((Throwable)new /* Unavailable Anonymous Inner Class!! */);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserForLokedAccount() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.FAILED_EXCESSIVEATTEMPTS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfulWithSsoToken() throws Exception {
        String username = null;
        String password = null;
        String ssoId = "sso-id";
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(ssoId)).andReturn((Object)false);
        Integer userId = 11;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserBySsoId(ssoId)).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        SsoToken token = (SsoToken)PowerMock.createMock(SsoToken.class);
        PowerMock.expectNew(SsoToken.class, (Object[])new Object[]{userId, ssoId}).andReturn((Object)token);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"sso");
        this.attemptService.reset(ssoId);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserWithSsoTokenAndLockedAccount() throws Exception {
        String username = null;
        String password = null;
        String ssoId = "sso-id";
        boolean rememberMe = false;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(ssoId)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.FAILED_EXCESSIVEATTEMPTS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfullyWithOneSessionModeAndNonePreviousSession() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = true;
        ConcurrentMap activeSessions = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.authUtils, (String)"activeSessions", (Object)activeSessions);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"regular");
        this.attemptService.reset(username);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)true);
        Object oldSessionId = null;
        EasyMock.expect(activeSessions.get(username)).andReturn(oldSessionId);
        String sessioIdText = "testSessionId";
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessioIdText);
        EasyMock.expect((Object)activeSessions.put(username, sessioIdText)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfullyWithOneSessionModeAndWithPreviousSession() throws Exception {
        String username = "test7";
        String password = "test5A";
        String ssoId = null;
        boolean rememberMe = true;
        ConcurrentMap activeSessions = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.authUtils, (String)"activeSessions", (Object)activeSessions);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(username)).andReturn((Object)false);
        UsernamePasswordToken token = (UsernamePasswordToken)PowerMock.createMock(UsernamePasswordToken.class);
        PowerMock.expectNew(UsernamePasswordToken.class, (Object[])new Object[0]).andReturn((Object)token);
        token.setUsername(username);
        char[] passwordArray = new char[]{'t', 'e', 's', 't', '5', 'A'};
        token.setPassword(EasyMock.aryEq((char[])passwordArray));
        token.setRememberMe(rememberMe);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"regular");
        this.attemptService.reset(username);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)true);
        String oldSessionId = "testOldSessionId";
        EasyMock.expect(activeSessions.get(username)).andReturn((Object)oldSessionId);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey oldSessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{oldSessionId}).andReturn((Object)oldSessionKey);
        Session oldSession = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)oldSessionKey)).andReturn((Object)oldSession);
        oldSession.stop();
        String sessioIdText = "testSessionId";
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessioIdText);
        EasyMock.expect((Object)activeSessions.put(username, sessioIdText)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfullyWithSsoIsAndOneSessionModeEnbledAndNonePreviousSession() throws Exception {
        String username = null;
        String password = null;
        String ssoId = "testSsoId";
        boolean rememberMe = false;
        ConcurrentMap activeSessions = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.authUtils, (String)"activeSessions", (Object)activeSessions);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(ssoId)).andReturn((Object)false);
        Integer userId = 11;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserBySsoId(ssoId)).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        SsoToken token = (SsoToken)PowerMock.createMock(SsoToken.class);
        PowerMock.expectNew(SsoToken.class, (Object[])new Object[]{userId, ssoId}).andReturn((Object)token);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"sso");
        this.attemptService.reset(ssoId);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)true);
        Object oldSessionId = null;
        EasyMock.expect(activeSessions.get(ssoId)).andReturn(oldSessionId);
        String sessioIdText = "testSessionId";
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessioIdText);
        EasyMock.expect((Object)activeSessions.put(ssoId, sessioIdText)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserSuccesfullyWithSsoIdAndOneSessionModeEnabledAndWithPreviousSession() throws Exception {
        String username = null;
        String password = null;
        String ssoId = "testSsoId";
        boolean rememberMe = false;
        ConcurrentMap activeSessions = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.authUtils, (String)"activeSessions", (Object)activeSessions);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)3);
        EasyMock.expect((Object)this.attemptService.locked(ssoId)).andReturn((Object)false);
        Integer userId = 11;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserBySsoId(ssoId)).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        SsoToken token = (SsoToken)PowerMock.createMock(SsoToken.class);
        PowerMock.expectNew(SsoToken.class, (Object[])new Object[]{userId, ssoId}).andReturn((Object)token);
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.stop();
        this.subject.login((AuthenticationToken)token);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        this.session.setAttribute((Object)"sessionType", (Object)"sso");
        this.attemptService.reset(ssoId);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false)).andReturn((Object)true);
        String oldSessionId = "testOldSessionId";
        EasyMock.expect(activeSessions.get(ssoId)).andReturn((Object)oldSessionId);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey oldSessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{oldSessionId}).andReturn((Object)oldSessionKey);
        Session oldSession = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)oldSessionKey)).andReturn((Object)oldSession);
        oldSession.stop();
        String sessioIdText = "testSessionId";
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessioIdText);
        EasyMock.expect((Object)activeSessions.put(ssoId, sessioIdText)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticateResponse.AuthenticateStatus response = this.authUtils.authenticate(username, password, ssoId, rememberMe);
        Assert.assertEquals((Object)AuthenticateResponse.AuthenticateStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLogoutUserOk() {
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.isAuthenticated()).andReturn((Object)true);
        this.subject.logout();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LogoutResponse.LogoutStatus.OK, (Object)this.authUtils.logoutUser());
        PowerMock.verifyAll();
    }

    @Test
    public void testLogoutUserFailed() {
        this.getCurrentSubjectTest();
        EasyMock.expect((Object)this.subject.isAuthenticated()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LogoutResponse.LogoutStatus.FAILED, (Object)this.authUtils.logoutUser());
        PowerMock.verifyAll();
    }

    @Test
    public void testIsCaptchaCorrectTrue() {
        String captchaText = "c4p7ch4";
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        Captcha captcha = (Captcha)PowerMock.createMock(Captcha.class);
        EasyMock.expect((Object)this.session.getAttribute((Object)"simpleCaptcha")).andReturn((Object)captcha);
        EasyMock.expect((Object)captcha.isCorrect(captchaText)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.authUtils.isCaptchaCorrect(captchaText));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsCaptchaCorrectFalse() {
        String captchaText = "c4p7ch4";
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        Captcha captcha = (Captcha)PowerMock.createMock(Captcha.class);
        EasyMock.expect((Object)this.session.getAttribute((Object)"simpleCaptcha")).andReturn((Object)captcha);
        EasyMock.expect((Object)captcha.isCorrect(captchaText)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.isCaptchaCorrect(captchaText));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsCaptchaCorrectNoCaptcha() {
        String captchaText = "c4p7ch4";
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getAttribute((Object)"simpleCaptcha")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.authUtils.isCaptchaCorrect(captchaText));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRememberMeCookie() {
        String rememberMe = "rememberMeCookie";
        PowerMock.mockStatic(ThreadContext.class);
        EasyMock.expect((Object)ThreadContext.get((Object)RememberMeManager.REMEMBER_ME_KEY)).andReturn((Object)rememberMe);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)rememberMe, (Object)this.authUtils.getRememberMeCookie());
        PowerMock.verifyAll();
    }

    @Test
    public void testStoreRememberMeCookie() {
        String rememberMe = "rememberMeCookie";
        PowerMock.mockStatic(ThreadContext.class);
        ThreadContext.put((Object)RememberMeManager.REMEMBER_ME_KEY, (Object)rememberMe);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.storeRememberMeCookie(rememberMe);
        PowerMock.verifyAll();
    }

    @Test
    public void testStoreData() {
        String key = "";
        String value = "";
        this.storeDataTest(key, (Object)value);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.storeData(key, (Object)value);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetStoredData() {
        String key = "";
        String value = "";
        this.getStoredDataTest(key, (Object)value);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)value, (Object)this.authUtils.getStoredData(key));
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveData() {
        String key = "";
        String value = "";
        this.removeDataTest(key, value);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authUtils.removeData(key);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusNoRememberMePrincipalNull() {
        String rememberMeCookie = null;
        String key = "sessionType";
        String value = "regular";
        this.getStoredDataTest(key, (Object)value);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        String sessionId = "session-id";
        Object principal = null;
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusWithRememberMePrincipalNull() throws Exception {
        String rememberMeCookie = "remember-me";
        String key = "sessionType";
        String value = "regular";
        String sessionId = "session-id";
        this.getStoredDataTest(key, (Object)value);
        PowerMock.mockStatic(ThreadContext.class);
        ThreadContext.put((Object)RememberMeManager.REMEMBER_ME_KEY, (Object)rememberMeCookie);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)this.securityManager);
        Subject.Builder builder = (Subject.Builder)PowerMock.createMock(Subject.Builder.class);
        PowerMock.expectNew(Subject.Builder.class, (Object[])new Object[]{this.securityManager}).andReturn((Object)builder);
        EasyMock.expect((Object)builder.buildSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        Object principal = null;
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn(principal);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusWithRememberMeSubjectRemembered() throws Exception {
        String rememberMeCookie = "remember-me";
        String key = "sessionType";
        String value = "regular";
        String sessionId = "session-id";
        this.getStoredDataTest(key, (Object)value);
        PowerMock.mockStatic(ThreadContext.class);
        ThreadContext.put((Object)RememberMeManager.REMEMBER_ME_KEY, (Object)rememberMeCookie);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)this.securityManager);
        Subject.Builder builder = (Subject.Builder)PowerMock.createMock(Subject.Builder.class);
        PowerMock.expectNew(Subject.Builder.class, (Object[])new Object[]{this.securityManager}).andReturn((Object)builder);
        EasyMock.expect((Object)builder.buildSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        Integer principal = 11;
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        PrincipalCollection principalCollection = (PrincipalCollection)PowerMock.createMock(PrincipalCollection.class);
        EasyMock.expect((Object)this.subject.getPrincipals()).andReturn((Object)principalCollection);
        this.session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)principalCollection);
        EasyMock.expect((Object)this.subject.isRemembered()).andReturn((Object)true);
        long timeout = 31536000000L;
        this.session.setTimeout(timeout);
        UserEntity user = new UserEntity();
        String username = "username";
        user.setId(principal);
        user.setUsername(username);
        EasyMock.expect((Object)this.userDAO.findUserById(principal, false, false)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        expectedStatus.setLoggedIn(true);
        expectedStatus.setUsername(username);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusWithRememberMeSubjectNotRememberedNoUserFound() throws Exception {
        String rememberMeCookie = "remember-me";
        String key = "sessionType";
        String value = "regular";
        String sessionId = "session-id";
        this.getStoredDataTest(key, (Object)value);
        PowerMock.mockStatic(ThreadContext.class);
        ThreadContext.put((Object)RememberMeManager.REMEMBER_ME_KEY, (Object)rememberMeCookie);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)this.securityManager);
        Subject.Builder builder = (Subject.Builder)PowerMock.createMock(Subject.Builder.class);
        PowerMock.expectNew(Subject.Builder.class, (Object[])new Object[]{this.securityManager}).andReturn((Object)builder);
        EasyMock.expect((Object)builder.buildSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        Integer principal = 11;
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        PrincipalCollection principalCollection = (PrincipalCollection)PowerMock.createMock(PrincipalCollection.class);
        EasyMock.expect((Object)this.subject.getPrincipals()).andReturn((Object)principalCollection);
        this.session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)principalCollection);
        EasyMock.expect((Object)this.subject.isRemembered()).andReturn((Object)false);
        long timeout = 900000L;
        this.session.setTimeout(timeout);
        EasyMock.expect((Object)this.userDAO.findUserById(principal, false, false)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusNoRememberMe() {
        String rememberMeCookie = null;
        String key = "sessionType";
        String value = "regular";
        this.getStoredDataTest(key, (Object)value);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        String sessionId = "session-id";
        Integer principal = 11;
        String username = "username";
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        UserEntity user = new UserEntity();
        user.setId(principal);
        user.setUsername(username);
        EasyMock.expect((Object)this.userDAO.findUserById(principal, false, false)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        expectedStatus.setLoggedIn(true);
        expectedStatus.setUsername(username);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckAuthenticationStatusNoRememberMeUserDeleted() {
        String rememberMeCookie = null;
        String key = "sessionType";
        String value = "regular";
        this.getStoredDataTest(key, (Object)value);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        String sessionId = "session-id";
        Integer principal = 11;
        String username = "username";
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
        EasyMock.expect((Object)this.session.getId()).andReturn((Object)sessionId);
        EasyMock.expect((Object)this.subject.getPrincipal()).andReturn((Object)principal);
        UserEntity user = new UserEntity();
        user.setId(principal);
        user.setUsername(username);
        user.setDeleted(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserById(principal, false, false)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        AuthenticationStatus expectedStatus = new AuthenticationStatus();
        expectedStatus.setSessionType(value);
        expectedStatus.setSessionId(sessionId);
        AuthenticationStatus status = this.authUtils.checkAuthenticationStatus(rememberMeCookie);
        Assert.assertEquals((Object)expectedStatus.getSessionType(), (Object)status.getSessionType());
        Assert.assertEquals((Object)expectedStatus.getSessionId(), (Object)status.getSessionId());
        Assert.assertEquals((Object)expectedStatus.isLoggedIn(), (Object)status.isLoggedIn());
        Assert.assertEquals((Object)expectedStatus.getUsername(), (Object)status.getUsername());
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionSuccessfully() throws Exception {
        UserEntity user = new UserEntity(Integer.valueOf(1));
        PowerMock.mockStatic(SecurityUtils.class);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        Subject.Builder builder = (Subject.Builder)PowerMock.createMock(Subject.Builder.class);
        PowerMock.expectNew(Subject.Builder.class, (Object[])new Object[]{securityManager}).andReturn((Object)builder);
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection();
        principalCollection.add((Object)1, "pl.smartapps.restserver.rest.security.CustomRealm_0");
        EasyMock.expect((Object)builder.principals((PrincipalCollection)principalCollection)).andReturn((Object)builder);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)builder.buildSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session).times(2);
        PrincipalCollection principals = (PrincipalCollection)PowerMock.createMock(PrincipalCollection.class);
        EasyMock.expect((Object)subject.getPrincipals()).andReturn((Object)principals);
        session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)principals);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"sessionId");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.authUtils.createSession(user);
        Assert.assertEquals((Object)"sessionId", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionFailureBuildSubject() throws Exception {
        UserEntity user = new UserEntity(Integer.valueOf(1));
        PowerMock.mockStatic(SecurityUtils.class);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        Subject.Builder builder = (Subject.Builder)PowerMock.createMock(Subject.Builder.class);
        PowerMock.expectNew(Subject.Builder.class, (Object[])new Object[]{securityManager}).andReturn((Object)builder);
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection();
        principalCollection.add((Object)1, "pl.smartapps.restserver.rest.security.CustomRealm_0");
        EasyMock.expect((Object)builder.principals((PrincipalCollection)principalCollection)).andReturn((Object)builder);
        EasyMock.expect((Object)builder.buildSubject()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.authUtils.createSession(user);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    private void getCurrentSubjectTest() {
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
    }

    private void getCurrentSessionTest() {
        PowerMock.mockStatic(SecurityUtils.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)this.subject);
        EasyMock.expect((Object)this.subject.getSession()).andReturn((Object)this.session);
    }

    private void getStoredDataTest(String key, Object value) {
        this.getCurrentSessionTest();
        EasyMock.expect((Object)this.session.getAttribute((Object)key)).andReturn(value);
    }

    private void storeDataTest(String key, Object value) {
        this.getCurrentSessionTest();
        this.session.setAttribute((Object)key, value);
    }

    private void removeDataTest(String key, String value) {
        this.getCurrentSessionTest();
        EasyMock.expect((Object)this.session.removeAttribute((Object)key)).andReturn((Object)value);
    }
}

