/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.util.SharedCache;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import nl.captcha.Captcha;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import pl.smartapps.hm.WebViewer.server.support.ShiroSecureDispatchServlet;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationStatus;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.rest.response.LogoutResponse;
import pl.smartapps.restserver.rest.security.RememberMeManager;
import pl.smartapps.restserver.rest.security.SsoToken;
import pl.smartapps.restserver.service.AttemptService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

@Component
public class AuthenticationUtils {
    private static final Logger log = Logger.getLogger(AuthenticationUtils.class);
    public static final String SUDO_USER_ID = "sudoUserId";
    public static final String SESSION_TYPE = "sessionType";
    public static final String SESSION_TYPE_SSO = "sso";
    public static final String SESSION_TYPE_REGULAR = "regular";
    private UserDAO userDAO;
    private AttemptService attemptService;
    private SharedCache sharedCache;
    private Map<String, String> activeSessions;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Autowired
    @Required
    @Qualifier(value="loginAttemptServiceImpl")
    public void setAttemptService(AttemptService attemptService) {
        this.attemptService = attemptService;
    }

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setSecurityManager(SecurityManager securityManager) {
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    @PostConstruct
    public void initialize() {
        this.activeSessions = this.sharedCache.getMap("activeSessions");
    }

    public boolean isLoggedIn() {
        Object principal = this.getCurrentSubject().getPrincipal();
        log.debug((Object)("isLoggedIn: getPrincipal returned: " + principal));
        return principal != null;
    }

    public void ensureLoggedIn() throws InvalidSessionException {
        log.trace((Object)"ensureLoggedIn: start");
        if (!this.isLoggedIn()) {
            log.debug((Object)"ensureLoggedIn: not logged in, throwing AccessException");
            throw new InvalidSessionException();
        }
    }

    public boolean hasAnyRole(Role ... roles) {
        if (roles == null) {
            return false;
        }
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (this.hasRole(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        try {
            this.getCurrentSubject().checkRole(role.getCode());
        }
        catch (AuthorizationException ae) {
            return false;
        }
        return true;
    }

    public void ensureHasRole(Role role) throws InvalidSessionException {
        this.ensureLoggedIn();
        if (!this.hasRole(role)) {
            throw new InvalidSessionException();
        }
    }

    public Subject getCurrentSubject() {
        return SecurityUtils.getSubject();
    }

    public Integer getCurrentUserId() {
        Integer sudoUserId = (Integer)this.getStoredData(SUDO_USER_ID);
        if (sudoUserId != null && this.hasRole(Role.ADMIN)) {
            return sudoUserId;
        }
        Subject subject = SecurityUtils.getSubject();
        if (subject.getPrincipal() == null) {
            return null;
        }
        return Integer.parseInt(subject.getPrincipal().toString());
    }

    public UserEntity getCurrentUser() {
        log.trace((Object)"start getCurrentUser()");
        Integer currentUserId = this.getCurrentUserId();
        log.debug((Object)("currentUserId: " + currentUserId));
        if (currentUserId == null) {
            return null;
        }
        UserEntity currentUser = this.userDAO.findUserById(currentUserId, false, false);
        log.debug((Object)("currentUser: " + currentUser));
        return currentUser;
    }

    public AuthenticateResponse.AuthenticateStatus authenticate(String username, String password, String ssoId, boolean rememberMe) {
        AuthenticateResponse.AuthenticateStatus status;
        block10: {
            boolean loginCounter = this.isInvalidLoginCounterEnabled();
            if (loginCounter && this.attemptService.locked(ssoId == null ? username : ssoId)) {
                return AuthenticateResponse.AuthenticateStatus.FAILED_EXCESSIVEATTEMPTS;
            }
            AuthenticationToken token = this.getAuthenticationToken(username, password, ssoId, rememberMe);
            Subject currentSubject = this.getCurrentSubject();
            Session session = currentSubject.getSession();
            try {
                session.stop();
                currentSubject.login(token);
                session = currentSubject.getSession();
                if (ssoId == null || ssoId.trim().isEmpty()) {
                    session.setAttribute((Object)SESSION_TYPE, (Object)SESSION_TYPE_REGULAR);
                } else {
                    session.setAttribute((Object)SESSION_TYPE, (Object)SESSION_TYPE_SSO);
                }
                status = AuthenticateResponse.AuthenticateStatus.OK;
                this.resetAttempts(loginCounter, ssoId == null ? username : ssoId);
                log.info((Object)("Logged on user account called '" + username + "'."));
                if (this.isOneSessionModeEnabled()) {
                    log.trace((Object)("One session mode is enabled. Removing old user's session for " + (ssoId == null ? "username=" + username : "ssoId=" + ssoId)));
                    String oldSessionId = (String)this.activeSessions.get(ssoId == null ? username : ssoId);
                    if (oldSessionId != null) {
                        this.invalidateSession(oldSessionId);
                    }
                    this.activeSessions.put(ssoId == null ? username : ssoId, session.getId().toString());
                }
            }
            catch (UnknownAccountException uae) {
                status = AuthenticateResponse.AuthenticateStatus.FAILED;
                log.info((Object)("Unknown account for username '" + username + "'."));
                this.recordAttempt(loginCounter, username);
            }
            catch (IncorrectCredentialsException ice) {
                status = AuthenticateResponse.AuthenticateStatus.FAILED;
                log.info((Object)("Incorrect credentials for account called '" + username + "'."));
                this.recordAttempt(loginCounter, username);
            }
            catch (LockedAccountException lae) {
                status = AuthenticateResponse.AuthenticateStatus.FAILED_NOTACTIVATED;
                log.info((Object)("Account called '" + username + "' has not been activated yet!"));
                this.recordAttempt(loginCounter, username);
            }
            catch (AuthenticationException ae) {
                status = AuthenticateResponse.AuthenticateStatus.ERROR;
                log.error((Object)("An unexpected error occurred during logon to account called '" + username + "': " + ae.getMessage()));
                if (!log.isDebugEnabled()) break block10;
                ae.printStackTrace();
            }
        }
        return status;
    }

    private boolean isInvalidLoginCounterEnabled() {
        return this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5)) > 0;
    }

    private void resetAttempts(boolean counterEnabled, String key) {
        if (counterEnabled) {
            this.attemptService.reset(key);
        }
    }

    private void recordAttempt(boolean counterEnabled, String key) {
        if (counterEnabled) {
            this.attemptService.record(key);
        }
    }

    private AuthenticationToken getAuthenticationToken(String username, String password, String ssoId, boolean rememberMe) {
        if (ssoId == null) {
            UsernamePasswordToken token = new UsernamePasswordToken();
            token.setUsername(username);
            token.setPassword(password.toCharArray());
            token.setRememberMe(rememberMe);
            return token;
        }
        UserEntity user = this.userDAO.findUserBySsoId(ssoId);
        return new SsoToken(user.getId(), ssoId, rememberMe);
    }

    private boolean isOneSessionModeEnabled() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_ONE_SESSION_MODE, false);
    }

    private void invalidateSession(String sessionId) {
        try {
            Session session = SecurityUtils.getSecurityManager().getSession((SessionKey)new DefaultSessionKey((Serializable)((Object)sessionId)));
            if (session != null) {
                session.stop();
            }
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
    }

    public LogoutResponse.LogoutStatus logoutUser() {
        Subject subject = this.getCurrentSubject();
        if (subject.isAuthenticated() || subject.isRemembered()) {
            subject.logout();
            return LogoutResponse.LogoutStatus.OK;
        }
        return LogoutResponse.LogoutStatus.FAILED;
    }

    public boolean isCaptchaCorrect(String enteredCaptcha) {
        log.trace((Object)("start isCaptchaCorrect(enteredCaptcha=" + enteredCaptcha + ")"));
        Subject subject = this.getCurrentSubject();
        Session session = subject.getSession();
        Captcha captcha = (Captcha)session.getAttribute((Object)"simpleCaptcha");
        return captcha != null && captcha.isCorrect(enteredCaptcha);
    }

    public String getRememberMeCookie() {
        return (String)ThreadContext.get((Object)RememberMeManager.REMEMBER_ME_KEY);
    }

    public void storeRememberMeCookie(String rememberMeCookie) {
        ThreadContext.put((Object)RememberMeManager.REMEMBER_ME_KEY, (Object)rememberMeCookie);
    }

    public void storeData(String dataKey, Object data) {
        this.getCurrentSubject().getSession().setAttribute((Object)dataKey, data);
    }

    public Object getStoredData(String dataKey) {
        return this.getCurrentSubject().getSession().getAttribute((Object)dataKey);
    }

    public void removeData(String dataKey) {
        this.getCurrentSubject().getSession().removeAttribute((Object)dataKey);
    }

    public AuthenticationStatus checkAuthenticationStatus(String rememberMeCookie) {
        log.trace((Object)"start checkAuthenticationStatus(rememberMeCookie=...)");
        this.getCurrentSubject().getSession().stop();
        AuthenticationStatus status = new AuthenticationStatus();
        String sessionType = (String)SecurityUtils.getSubject().getSession().getAttribute((Object)SESSION_TYPE);
        status.setSessionType(sessionType);
        if (rememberMeCookie != null) {
            this.storeRememberMeCookie(rememberMeCookie);
            Subject.Builder builder = new Subject.Builder(SecurityUtils.getSecurityManager());
            Subject subject = builder.sessionId(SecurityUtils.getSubject().getSession().getId()).buildSubject();
            Session session = subject.getSession();
            status.setSessionId(session.getId().toString());
            Object principal = subject.getPrincipal();
            if (principal != null) {
                session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)subject.getPrincipals());
                if (subject.isRemembered()) {
                    session.setTimeout(31536000000L);
                } else {
                    session.setTimeout(900000L);
                }
                UserEntity currentUserDAO = this.userDAO.findUserById(Integer.valueOf(Integer.parseInt(principal.toString())), false, false);
                if (currentUserDAO != null && !currentUserDAO.isDeleted()) {
                    log.debug((Object)("currentUser: " + currentUserDAO.getUsername()));
                    status.setSubscriptionValidTo(this.getSubscriptionValidTo());
                    status.setLoggedIn(true);
                    status.setUsername(currentUserDAO.getUsername());
                }
            }
        } else {
            UserEntity currentUserDAO;
            Subject currentUser = this.getCurrentSubject();
            status.setSessionId(currentUser.getSession().getId().toString());
            Object principal = currentUser.getPrincipal();
            if (principal != null && (currentUserDAO = this.userDAO.findUserById(Integer.valueOf(Integer.parseInt(principal.toString())), false, false)) != null && !currentUserDAO.isDeleted()) {
                log.debug((Object)("currentUser: " + currentUserDAO.getUsername()));
                status.setSubscriptionValidTo(this.getSubscriptionValidTo());
                status.setLoggedIn(true);
                status.setUsername(currentUserDAO.getUsername());
            }
        }
        return status;
    }

    public Date getSubscriptionValidTo() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2011, 11, 31);
        return calendar.getTime();
    }

    public String getClientIpAddress() {
        return (String)ShiroSecureDispatchServlet.threadLocalClientIpAddress.get();
    }

    public String createSession(UserEntity user) {
        Subject.Builder builder = new Subject.Builder(SecurityUtils.getSecurityManager());
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection();
        principalCollection.add((Object)user.getId(), "pl.smartapps.restserver.rest.security.CustomRealm_0");
        builder.principals((PrincipalCollection)principalCollection);
        Subject subject = builder.buildSubject();
        if (subject == null) {
            return null;
        }
        subject.getSession().setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)subject.getPrincipals());
        return subject.getSession().getId().toString();
    }
}

