/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.util.SharedCache;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import pl.smartapps.restserver.service.AttemptService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.AttemptHandler;

public abstract class AttemptServiceImpl
implements AttemptService {
    protected ParameterService parameterService;
    private SharedCache sharedCache;
    private Map<String, AttemptHandler> attempts;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @PostConstruct
    public void initialize() {
        this.attempts = this.sharedCache.getMap(this.getMapName());
    }

    protected abstract String getMapName();

    public boolean locked(String key) {
        AttemptHandler attempt = (AttemptHandler)this.attempts.get(key);
        return attempt != null && attempt.isLocked();
    }

    public void record(String key) {
        AttemptHandler attempt = (AttemptHandler)this.attempts.get(key);
        if (attempt == null) {
            attempt = new AttemptHandler(this.getLockPeriod().longValue(), this.getMaxAttemptCount().intValue());
        }
        attempt.update();
        this.attempts.put(key, attempt);
    }

    protected abstract Long getLockPeriod();

    protected abstract Integer getMaxAttemptCount();

    public void reset(String key) {
        this.attempts.remove(key);
    }
}

