/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import pl.smartapps.restserver.service.impl.AttemptHandler;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AttemptHandler.class, System.class})
public class AttemptHandlerTests {
    int lockPeriod = 180000;
    int maxAttempts = 3;
    long now = 1395920888751L;
    AttemptHandler attemptHandler;

    @Before
    public void setUp() {
        PowerMock.mockStatic(System.class);
        this.attemptHandler = new AttemptHandler((long)this.lockPeriod, this.maxAttempts);
    }

    @Test
    public void testUpdateForNewObject() {
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)this.now);
        PowerMock.replayAll((Object[])new Object[0]);
        this.attemptHandler.update();
        PowerMock.verifyAll();
        Assert.assertEquals((Object)this.now, (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp"));
        Assert.assertEquals((Object)1, (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"attemptCount"));
    }

    @Test
    public void testUpdateJustBeforeLock() {
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp", (Object)this.now);
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"attemptCount", (Object)2);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)(this.now + (long)this.lockPeriod - 1L));
        PowerMock.replayAll((Object[])new Object[0]);
        this.attemptHandler.update();
        PowerMock.verifyAll();
        Assert.assertEquals((Object)(this.now + (long)this.lockPeriod - 1L), (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp"));
        Assert.assertEquals((Object)3, (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"attemptCount"));
    }

    @Test
    public void testUpdateJustAfterLock() {
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp", (Object)this.now);
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"attemptCount", (Object)2);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)(this.now + (long)this.lockPeriod + 1L));
        PowerMock.replayAll((Object[])new Object[0]);
        this.attemptHandler.update();
        PowerMock.verifyAll();
        Assert.assertEquals((Object)(this.now + (long)this.lockPeriod + 1L), (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp"));
        Assert.assertEquals((Object)1, (Object)Whitebox.getInternalState((Object)this.attemptHandler, (String)"attemptCount"));
    }

    @Test
    public void testIsLockTrue() {
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp", (Object)this.now);
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"attemptCount", (Object)3);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)(this.now + (long)this.lockPeriod));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.attemptHandler.isLocked());
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLockFalseCauseOfTimestamp() {
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp", (Object)this.now);
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"attemptCount", (Object)3);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)(this.now + (long)this.lockPeriod + 1L));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.attemptHandler.isLocked());
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLockFalseCauseOfAttemptsCount() {
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"lastAttemptTimestamp", (Object)this.now);
        Whitebox.setInternalState((Object)this.attemptHandler, (String)"attemptCount", (Object)2);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.attemptHandler.isLocked());
        PowerMock.verifyAll();
    }
}

