/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.Serializable;

public class AttemptHandler
implements Serializable {
    private static final long serialVersionUID = -4976020373064114548L;
    private int maxAttempts;
    private long lockPeriod;
    private long lastAttemptTimestamp;
    private int attemptCount;

    public AttemptHandler(long lockPeriod, int maxAttempts) {
        this.lockPeriod = lockPeriod;
        this.maxAttempts = maxAttempts;
        this.lastAttemptTimestamp = 0L;
        this.attemptCount = 0;
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.lastAttemptTimestamp == 0L) {
            this.lastAttemptTimestamp = now;
        }
        this.attemptCount = now - this.lastAttemptTimestamp > this.lockPeriod ? 1 : ++this.attemptCount;
        this.lastAttemptTimestamp = now;
    }

    public boolean isLocked() {
        return this.attemptCount >= this.maxAttempts && System.currentTimeMillis() - this.lastAttemptTimestamp <= this.lockPeriod;
    }

    public String toString() {
        return "AttemptHandler [lockPeriod=" + this.lockPeriod + ", maxAttempts=" + this.maxAttempts + ", lastAttemptTimestamp=" + this.lastAttemptTimestamp + ", attemptCount=" + this.attemptCount + "]";
    }
}

