/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.db.dao.ApplicationDAO;
import pl.smartapps.restserver.db.main.ApplicationEntity;
import pl.smartapps.restserver.rest.Application;
import pl.smartapps.restserver.service.ApplicationService;
import pl.smartapps.restserver.service.DeviceType;
import pl.smartapps.restserver.service.impl.GetApplicationException;
import pl.smartapps.restserver.service.impl.GetApplicationsException;

@Service
public class ApplicationServiceImpl
implements ApplicationService {
    private static Logger log = Logger.getLogger(ApplicationServiceImpl.class);
    private ApplicationDAO applicationDAO;

    @Autowired
    @Required
    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public List<Application> getApplications(DeviceType deviceType) {
        log.trace((Object)("start getApplications(deviceType=" + deviceType + ")"));
        if (deviceType == null) {
            throw new GetApplicationsException(GetApplicationsException.ErrorCode.NO_TYPE);
        }
        List entities = this.applicationDAO.getByDeviceType(deviceType);
        ArrayList<Application> apps = new ArrayList<Application>();
        for (ApplicationEntity entity : entities) {
            Application app = new Application();
            app.setApplicationId(entity.getApplicationId());
            app.setName(entity.getName());
            apps.add(app);
        }
        return apps;
    }

    public Application getApplication(Integer applicationId) {
        log.trace((Object)("start getApplication(applicationId=" + applicationId + ")"));
        if (applicationId == null) {
            throw new GetApplicationException(GetApplicationException.ErrorCode.NO_APP_ID);
        }
        ApplicationEntity entity = this.applicationDAO.getApplicationById(applicationId);
        if (entity == null) {
            throw new GetApplicationException(GetApplicationException.ErrorCode.APP_NOT_FOUND);
        }
        Application app = new Application();
        app.setApplicationId(entity.getApplicationId());
        app.setName(entity.getName());
        app.setCode(entity.getCode());
        return app;
    }
}

