/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.ByteArrayInputStream;
import java.util.Timer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.AndroidNotificationServiceImpl;
import pl.smartapps.restserver.service.impl.AndroidNotificationServiceTests;
import pl.smartapps.restserver.service.impl.ParameterServiceImpl;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AndroidNotificationServiceImpl.class, HttpPost.class, DefaultHttpClient.class, Timer.class})
public class AndroidNotificationServiceTests {
    private AndroidNotificationServiceImpl androidNotificationService;
    private EventNotificationDAO eventNotificationDAO;
    private ParameterServiceImpl parameterService;
    public static final String PARAM_REGISTRATION_ID = "registration_id";
    public static final String PARAM_DELAY_WHILE_IDLE = "delay_while_idle";
    public static final String PARAM_COLLAPSE_KEY = "collapse_key";
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$service$impl$AndroidNotificationServiceTests$ResultType;

    @Before
    public void setUp() {
        this.androidNotificationService = new AndroidNotificationServiceImpl();
        this.eventNotificationDAO = (EventNotificationDAO)PowerMock.createMock(EventNotificationDAO.class);
        this.androidNotificationService.setEventNotificationDAO(this.eventNotificationDAO);
        this.parameterService = (ParameterServiceImpl)PowerMock.createMock(ParameterServiceImpl.class);
        this.androidNotificationService.setParameterService((ParameterService)this.parameterService);
    }

    @Test
    public void testSendMessageSuccess() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.SUCCESS, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    /*
     * Exception decompiling
     */
    private void sendMessage(String registrationId, String payload, ResultType resultType, String authToken) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testSendMessageAuthTokenIsNull() throws Exception {
        String registrationId = "AAA";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn(null);
        String token = this.getToken();
        EasyMock.expect((Object)this.parameterService.updateParameter(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN, token)).andReturn((Object)true);
        this.sendMessage(registrationId, payload, ResultType.SUCCESS, "0");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    private String getToken() throws Exception {
        String username = "user";
        String password = "pass";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_USERNAME)).andReturn((Object)username);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_PASSWORD)).andReturn((Object)password);
        StringBuilder builder = new StringBuilder();
        builder.append("Email=").append(username);
        builder.append("&Passwd=").append(password);
        builder.append("&accountType=GOOGLE");
        builder.append("&source=smartapps");
        builder.append("&service=ac2dm");
        byte[] data = builder.toString().getBytes();
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String androidUrl = "https://www.google.com/accounts/ClientLogin";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{androidUrl}).andReturn((Object)httpPost);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        ByteArrayEntity entity = (ByteArrayEntity)PowerMock.createMock(ByteArrayEntity.class);
        PowerMock.expectNew(ByteArrayEntity.class, (Object[])new Object[]{EasyMock.aryEq((byte[])data)}).andReturn((Object)entity);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity);
        StatusLine mockStatusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)mockStatusLine);
        EasyMock.expect((Object)mockStatusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity mockResponseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)mockResponseEntity);
        String responseString = "Auth=0";
        EasyMock.expect((Object)mockResponseEntity.getContent()).andReturn((Object)new ByteArrayInputStream(responseString.getBytes("UTF-8")));
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        return "0";
    }

    @Test
    public void testSendMessageAuthTokenIsNullGetTokenUnauthorized() throws Exception {
        String registrationId = "AAA";
        String payload = "payload";
        String username = "user";
        String password = "pass";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_USERNAME)).andReturn((Object)username);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_PASSWORD)).andReturn((Object)password);
        StringBuilder builder = new StringBuilder();
        builder.append("Email=").append(username);
        builder.append("&Passwd=").append(password);
        builder.append("&accountType=GOOGLE");
        builder.append("&source=smartapps");
        builder.append("&service=ac2dm");
        byte[] data = builder.toString().getBytes();
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String androidUrl = "https://www.google.com/accounts/ClientLogin";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{androidUrl}).andReturn((Object)httpPost);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        ByteArrayEntity entity = (ByteArrayEntity)PowerMock.createMock(ByteArrayEntity.class);
        PowerMock.expectNew(ByteArrayEntity.class, (Object[])new Object[]{EasyMock.aryEq((byte[])data)}).andReturn((Object)entity);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity);
        StatusLine mockStatusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)mockStatusLine);
        EasyMock.expect((Object)mockStatusLine.getStatusCode()).andReturn((Object)403);
        HttpEntity mockResponseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)mockResponseEntity);
        String responseString = "Error=error";
        EasyMock.expect((Object)mockResponseEntity.getContent()).andReturn((Object)new ByteArrayInputStream(responseString.getBytes("UTF-8")));
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageAuthTokenIsNullUsernameIsNull() {
        String registrationId = "AAA";
        String payload = "payload";
        String password = "pass";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_USERNAME)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_PASSWORD)).andReturn((Object)password);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageAuthTokenIsNullPasswordIsNull() {
        String registrationId = "AAA";
        String payload = "payload";
        String username = "user";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_USERNAME)).andReturn((Object)username);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_PASSWORD)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageResponseIsNull() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_NULL_RESPONSE, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    public void testSendMessageResponseCodeUnauthorized() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_CODEUNAUTHORIZED, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    public void testSendMessageResponseCodeForbidden() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_CODEFORBIDDEN, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    public void testSendMessageResponseCodeUnavailable() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_CODEUNAVAILABLE, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    public void testSendMessageResponseErrorQuotaExceeded() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_QUOTAEXCEEDED, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    public void testSendMessageResponseErrorDeviceQuotaExceeded() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_DEVICEQUOTAEXCEEDED, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageResponseErrorMismatchSenderId() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_MISMATCHSENDERID, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageResponseErrorMissingRegistration() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_MISSINGREGISTARTION, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendMessageResponseErrorNotRegistered() throws Exception {
        String authToken = "authToken";
        String registrationId = "regId";
        String payload = "payload";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN)).andReturn((Object)authToken);
        this.sendMessage(registrationId, payload, ResultType.ERROR_NOTREGISTERED, authToken);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.androidNotificationService.sendMessage(registrationId, payload));
        PowerMock.verifyAll();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$service$impl$AndroidNotificationServiceTests$ResultType() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$service$impl$AndroidNotificationServiceTests$ResultType != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$service$impl$AndroidNotificationServiceTests$ResultType;
        }
        int[] nArray = new int[ResultType.values().length];
        try {
            nArray[ResultType.ERROR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_CODEFORBIDDEN.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_CODEUNAUTHORIZED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_CODEUNAVAILABLE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_DEVICEQUOTAEXCEEDED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_MISMATCHSENDERID.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_MISSINGREGISTARTION.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_NOTREGISTERED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_NULL_RESPONSE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_QUOTAEXCEEDED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.ERROR_SERVICEUNAVAILABLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ResultType.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$service$impl$AndroidNotificationServiceTests$ResultType = nArray;
        return nArray;
    }
}

