/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.HttpClientFactory;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.rest.response.UnregisterDeviceResponse;
import pl.smartapps.restserver.rest.response.UpdateDeviceResponse;
import pl.smartapps.restserver.service.AndroidNotificationService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.EventNotificationType;

@Service
public class AndroidNotificationServiceImpl
implements AndroidNotificationService {
    public static final String PARAM_REGISTRATION_ID = "registration_id";
    public static final String PARAM_DELAY_WHILE_IDLE = "delay_while_idle";
    public static final String PARAM_COLLAPSE_KEY = "collapse_key";
    private static final String UTF8 = "UTF-8";
    private static final String DEVICE_QUOTA_EXCEEDED = "DeviceQuotaExceeded";
    private static final String QUOTA_EXCEEDED = "QuotaExceeded";
    private static final String MISSING_REGISTRATION = "MissingRegistration";
    private static final String MISMATCH_SENDER_ID = "MismatchSenderId";
    private static final String NOT_REGISTERED = "NotRegistered";
    private static Logger log = Logger.getLogger(AndroidNotificationServiceImpl.class);
    private ParameterService parameterService;
    int retries = 0;
    @Autowired
    private EventNotificationDAO eventNotificationDAO;
    private HttpClientFactory httpClientFactory;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void setEventNotificationDAO(EventNotificationDAO eventNotificationDAO) {
        this.eventNotificationDAO = eventNotificationDAO;
    }

    public boolean sendMessage(String registrationId, String payload) {
        byte[] postData;
        block7: {
            log.trace((Object)("start sendMessage(registrationId=" + registrationId + ", payload=" + payload));
            StringBuilder postDataBuilder = new StringBuilder();
            postDataBuilder.append(PARAM_REGISTRATION_ID).append("=").append(registrationId);
            postDataBuilder.append("&").append(PARAM_COLLAPSE_KEY).append("=").append("0");
            postData = null;
            try {
                postDataBuilder.append("&").append(payload);
                postData = postDataBuilder.toString().getBytes(UTF8);
            }
            catch (UnsupportedEncodingException e) {
                if (!log.isDebugEnabled()) break block7;
                e.printStackTrace();
            }
        }
        String authToken = this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN);
        if (authToken == null) {
            block8: {
                log.debug((Object)"Auth token is null");
                try {
                    authToken = this.getToken();
                }
                catch (IOException e) {
                    log.warn((Object)"Error occured while getting android auth token");
                    if (!log.isDebugEnabled()) break block8;
                    e.printStackTrace();
                }
            }
            if (authToken == null) {
                log.debug((Object)"Auth token is null again");
                return false;
            }
            log.debug((Object)("Auth token=" + authToken));
            this.parameterService.updateParameter(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN, authToken);
        } else {
            log.debug((Object)("Auth token=" + authToken));
        }
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpPost postMethod = new HttpPost("https://android.clients.google.com/c2dm/send");
        postMethod.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        postMethod.addHeader("Authorization", "GoogleLogin auth=" + authToken);
        ByteArrayEntity postEntity = new ByteArrayEntity(postData);
        postMethod.setEntity((HttpEntity)postEntity);
        this.performSending(httpClient, postMethod, registrationId);
        return true;
    }

    private void performSending(HttpClient httpClient, HttpPost postMethod, String registrationId) {
        block17: {
            log.trace((Object)"start performSending");
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
                if (response == null || response.getEntity() == null) {
                    log.error((Object)"Response is null");
                    return;
                }
                int responseCode = response.getStatusLine().getStatusCode();
                log.debug((Object)("Response code=" + responseCode));
                if (responseCode == 401 || responseCode == 403) {
                    log.warn((Object)"Unauthorized - need token");
                    this.updateToken();
                    new Timer().schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 5000L);
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String line = null;
                if (responseCode == 503) {
                    String retryAfterString = null;
                    line = reader.readLine();
                    if (line != null) {
                        if (line.startsWith("Retry-After=")) {
                            retryAfterString = line.substring(12);
                        }
                        ++this.retries;
                        log.debug((Object)("Retries number=" + this.retries));
                        long retryAfter = 5L;
                        if (retryAfterString != null && retryAfterString.length() > 0) {
                            retryAfter = Long.parseLong(retryAfterString);
                        }
                        long delay = (long)(((double)retryAfter + Math.random() * Math.pow(2.0, this.retries) * 100.0) * 1000.0);
                        new Timer().schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, delay);
                        return;
                    }
                }
                this.retries = 0;
                String error = null;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("Error=")) continue;
                    error = line.substring(6);
                }
                if (error != null) {
                    log.warn((Object)("Sending Android notification message error: " + error));
                    if (error.equals(QUOTA_EXCEEDED) || error.equals(DEVICE_QUOTA_EXCEEDED)) {
                        new Timer().schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 5000L);
                        return;
                    }
                    if (error.equals(MISSING_REGISTRATION) || error.equals(MISMATCH_SENDER_ID) || error.equals(NOT_REGISTERED)) {
                        this.eventNotificationDAO.removeEventNotificationByEventNotificationTypeAndToken(EventNotificationType.C2DM, registrationId);
                    }
                } else {
                    log.debug((Object)"Sending Android notification success");
                }
                httpClient.getConnectionManager().shutdown();
            }
            catch (ClientProtocolException e) {
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (IllegalStateException e) {
                if (!log.isDebugEnabled()) break block17;
                e.printStackTrace();
            }
        }
    }

    private void updateToken() {
        block2: {
            log.debug((Object)"start updateToken");
            try {
                this.parameterService.updateParameter(ParameterService.ParameterCode.ANDROID_NOTIFICATION_TOKEN, this.getToken());
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    private String getToken() throws IOException {
        log.debug((Object)"start getToken");
        String username = this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_USERNAME);
        String password = this.parameterService.getParameterValue(ParameterService.ParameterCode.ANDROID_NOTIFICATION_PASSWORD);
        if (username == null || password == null) {
            log.error((Object)"Invalid username or password for google auth");
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Email=").append(username);
        builder.append("&Passwd=").append(password);
        builder.append("&accountType=GOOGLE");
        builder.append("&source=smartapps");
        builder.append("&service=ac2dm");
        byte[] data = builder.toString().getBytes();
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        HttpPost postMethod = new HttpPost("https://www.google.com/accounts/ClientLogin");
        postMethod.addHeader("Content-Type", "application/x-www-form-urlencoded");
        postMethod.setEntity((HttpEntity)new ByteArrayEntity(data));
        HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
        if (response == null || response.getEntity() == null) {
            log.warn((Object)"Response is null");
            return null;
        }
        int responseCode = response.getStatusLine().getStatusCode();
        log.debug((Object)("Response code=" + responseCode));
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = null;
        if (responseCode == 403) {
            String error = null;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Error=")) continue;
                error = line.substring(6);
            }
            log.warn((Object)("Unauthorized - login failed: error: " + error));
            httpClient.getConnectionManager().shutdown();
            return null;
        }
        String auth_key = null;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("Auth=")) continue;
            auth_key = line.substring(5);
        }
        httpClient.getConnectionManager().shutdown();
        return auth_key;
    }

    public UpdateDeviceResponse updateDeviceId(String registrationId) {
        List eventNotifications = this.eventNotificationDAO.findEventNotificationsByToken(registrationId);
        if (eventNotifications != null && eventNotifications.size() > 0) {
            for (EventNotificationEntity eventNotification : eventNotifications) {
                eventNotification.setToken(registrationId);
                this.eventNotificationDAO.updateEventNotification(eventNotification);
            }
        }
        return new UpdateDeviceResponse(UpdateDeviceResponse.UpdateDeviceStatus.SUCCESS);
    }

    public UnregisterDeviceResponse deleteInactiveDevice(String registrationId) {
        if (this.eventNotificationDAO.removeEventNotificationByEventNotificationTypeAndToken(EventNotificationType.C2DM, registrationId)) {
            return new UnregisterDeviceResponse(UnregisterDeviceResponse.UnregisterDeviceStatus.SUCCESS);
        }
        return new UnregisterDeviceResponse(UnregisterDeviceResponse.UnregisterDeviceStatus.FAILED_DEVICENOTFOUND);
    }

    static /* synthetic */ void access$0(AndroidNotificationServiceImpl androidNotificationServiceImpl, HttpClient httpClient, HttpPost httpPost, String string) {
        androidNotificationServiceImpl.performSending(httpClient, httpPost, string);
    }
}

