/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.codegenerator.GCActivationCodeGenerator;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.rest.validator.ActivationCodeValidator;
import pl.smartapps.restserver.rest.validator.MacAddressValidator;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.ActivationCodeHandler;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ActivationCodeHandler.class})
public class ActivationCodeHandlerTests {
    private ActivationCodeHandler activationCodeHandler;
    private MacAddressValidator macAddressValidator;
    private ActivationCodeValidator activationCodeValidator;
    private GCActivationCodeGenerator activationCodeGenerator;
    private ProductManagementService productManagementService;

    @Before
    public void setUp() {
        this.activationCodeHandler = new ActivationCodeHandler();
        this.macAddressValidator = (MacAddressValidator)PowerMock.createMock(MacAddressValidator.class);
        this.activationCodeHandler.setMacAddressValidator(this.macAddressValidator);
        this.activationCodeValidator = (ActivationCodeValidator)PowerMock.createMock(ActivationCodeValidator.class);
        this.activationCodeHandler.setActivationCodeValidator(this.activationCodeValidator);
        this.activationCodeGenerator = (GCActivationCodeGenerator)PowerMock.createMock(GCActivationCodeGenerator.class);
        this.activationCodeHandler.setActivationCodeGenerator(this.activationCodeGenerator);
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementService.class);
        this.activationCodeHandler.setProductManagementService(this.productManagementService);
    }

    @Test
    public void testgetMacAddressNullActivationCode() throws InvalidSessionException {
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress(null);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressEmptyActivationCode() throws InvalidSessionException {
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressForUndefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:80");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressWithWhiteSpaces() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("  00:02:D1:06:CD:80 ");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectMacAddressForUndefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:8Z");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectActivationCodeForUndefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8000000000");
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "0")).andReturn((Object)"aabo-cbyo-raaq");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectActivationCodeWithWhiteSpaces() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8000000000");
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "0")).andReturn((Object)"aabo-cbyo-raaq");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("  aabo-cbyo-raaq ");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectActivationCodeForUndefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaql");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressActivationCodeWithIncorrectChecksumUndefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn(null);
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8020000000");
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "32")).andReturn((Object)"easq-cjzo-warn");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressForIncorrectlyDefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"heh");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:80");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectMacAddressForIncorrectlyDefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"heh");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:8Z");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectActivationCodeForIncorrectlyDefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"heh");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8000000000");
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "0")).andReturn((Object)"aabo-cbyo-raaq");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectActivationCodeForIncorrectlyDefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"heh");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaql");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressActivationCodeWithIncorrectChecksumForIncorrectlyDefinedActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"heh");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8020000000");
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "32")).andReturn((Object)"easq-cjzo-warn");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressForMacOrCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC_OR_CODE");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:80");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectMacAddressForMacOrCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC_OR_CODE");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:8Z");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectActivationCodeForMacOrCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC_OR_CODE");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8000000000");
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "0")).andReturn((Object)"aabo-cbyo-raaq");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectActivationCodeForMacOrCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC_OR_CODE");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaql");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressActivationCodeWithIncorrectChecksumForMacOrCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC_OR_CODE");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8020000000");
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "32")).andReturn((Object)"easq-cjzo-warn");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressForMacActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:80");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectMacAddressForMacActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC");
        EasyMock.expect((Object)this.macAddressValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:8Z");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressActivationCodeForMacActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"MAC");
        EasyMock.expect((Object)this.macAddressValidator.validate("aabo-cbyo-raaq")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectMacAddressForCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"CODE");
        EasyMock.expect((Object)this.activationCodeValidator.validate("00:02:D1:06:CD:80")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:80");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectMacAddressForCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"CODE");
        EasyMock.expect((Object)this.activationCodeValidator.validate("00:02:D1:06:CD:8Z")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("00:02:D1:06:CD:8Z");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressCorrectActivationCodeForCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"CODE");
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8000000000");
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "0")).andReturn((Object)"aabo-cbyo-raaq");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals((Object)"00:02:D1:06:CD:80", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressIncorrectActivationCodeForCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"CODE");
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaql")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaql");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testgetMacAddressActivationCodeWithIncorrectChecksumForCodeActivationMethod() throws InvalidSessionException {
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.ACTIVATION_METHOD)).andReturn((Object)"CODE");
        EasyMock.expect((Object)this.activationCodeValidator.validate("aabo-cbyo-raaq")).andReturn((Object)true);
        EasyMock.expect((Object)this.activationCodeGenerator.decodeCode("aabo-cbyo-raaq")).andReturn((Object)"0002D106CD8020000000");
        EasyMock.expect((Object)this.activationCodeGenerator.generateCode("00:02:D1:06:CD:80", "32")).andReturn((Object)"easq-cjzo-warn");
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testFormatMacAddress() {
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress(null), null);
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("01:23:45:67:89:AB"), (Object)"01:23:45:67:89:AB");
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("01:23:45:67:89:ab"), (Object)"01:23:45:67:89:AB");
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("01-23-45-67-89-AB"), (Object)"01:23:45:67:89:AB");
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("01-23-45-67-89-ab"), (Object)"01:23:45:67:89:AB");
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("0123456789AB"), (Object)"01:23:45:67:89:AB");
        Assert.assertEquals((Object)this.activationCodeHandler.formatMacAddress("0123456789ab"), (Object)"01:23:45:67:89:AB");
    }
}

