/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.smartapps.restserver.server.UDPNotificationServerCmdInterface;

public class UDPNotificationServer {
    private static Logger log = Logger.getLogger(UDPNotificationServer.class);
    private DatagramChannel server;
    private Selector selector;
    UDPNotificationServerCmdInterface receiver;
    final int Port;
    final int BufferSize = 2048;
    final String IPAddress;
    boolean running;
    private Thread networkThread = new /* Unavailable Anonymous Inner Class!! */;

    public void beanDestroyed() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.selector.wakeup();
        this.networkThread.interrupt();
        try {
            this.networkThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void listen() throws Exception {
        if (this.selector.select() == 0) {
            return;
        }
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = keys.iterator();
        while (i.hasNext()) {
            ByteBuffer buffer;
            DatagramChannel client;
            InetSocketAddress clientAddress;
            SelectionKey key = i.next();
            i.remove();
            if (!key.isReadable() || !(key.channel() instanceof DatagramChannel) || (clientAddress = (InetSocketAddress)(client = (DatagramChannel)key.channel()).receive(buffer = ByteBuffer.allocate(2048))) == null || this.receiver == null) continue;
            this.receiver.process(buffer);
        }
    }

    public UDPNotificationServer(String ipAddress, int port, UDPNotificationServerCmdInterface receiver) {
        this.receiver = receiver;
        this.IPAddress = ipAddress;
        this.Port = port;
        log.debug((Object)("UDPNotificationServer: ip: " + this.IPAddress + ", port: " + this.Port));
        if (this.Port == 0) {
            log.debug((Object)"UDPNotificationServer: disabled, not starting");
            return;
        }
        try {
            this.server = DatagramChannel.open();
            this.server.socket().setReuseAddress(true);
            this.server.configureBlocking(false);
            this.server.socket().setReuseAddress(true);
            this.server.socket().bind(new InetSocketAddress(this.IPAddress, this.Port));
            this.selector = Selector.open();
            this.server.register(this.selector, 1);
            this.networkThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ void access$0(UDPNotificationServer uDPNotificationServer) throws Exception {
        uDPNotificationServer.listen();
    }

    static /* synthetic */ DatagramChannel access$1(UDPNotificationServer uDPNotificationServer) {
        return uDPNotificationServer.server;
    }
}

