/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.server;

import homemonitor.Utility;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import pl.smartapps.restserver.server.UDPNotificationServerCmdInterface;

public class UDPNotificationCmdImpl
implements UDPNotificationServerCmdInterface {
    private static Logger log = Logger.getLogger(UDPNotificationCmdImpl.class);
    private String lanDeviceServerUrl;

    @Value(value="${lanDevice.serverUrl}")
    public void setGdtServerAddress(String lanDeviceServerUrl) {
        this.lanDeviceServerUrl = lanDeviceServerUrl;
    }

    public ByteBuffer process(ByteBuffer buffer) {
        log.debug((Object)("UDPNotificationCmdImpl.process: data: " + buffer.toString()));
        if (buffer.position() < 48) {
            log.error((Object)("UDPNotificationCmdImpl.process failed, data too short (" + buffer.position() + ")"));
            return null;
        }
        byte[] request = buffer.array();
        int offset = 10;
        String eventType = Utility.byteArrayASCIIToString((byte[])request, (int)offset, (int)10);
        String ip = Utility.byteArrayASCIIToString((byte[])request, (int)(offset += eventType.length() + 1 + "IP=".length()), (int)10);
        String mac = Utility.byteArrayASCIIToString((byte[])request, (int)(offset += ip.length() + 1 + "Message=".length()), (int)44);
        String user = Utility.byteArrayASCIIToString((byte[])request, (int)(offset += mac.length() + 1), (int)44);
        String pass = Utility.byteArrayASCIIToString((byte[])request, (int)(offset += user.length() + 1), (int)10);
        log.debug((Object)("MAC: " + mac + ", IP: " + ip + ", EventType: " + eventType));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        StringBuilder url = new StringBuilder();
        if (!this.lanDeviceServerUrl.startsWith("http://")) {
            url.append("http://");
        }
        url.append(this.lanDeviceServerUrl);
        URI uri = URI.create(String.valueOf(url.toString()) + "/events/motion/brickcom?id=" + mac + "&eventType=" + eventType);
        HttpGet httpGet = new HttpGet(uri);
        httpGet.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(user, pass), (String)"UTF-8", (boolean)false));
        try {
            HttpResponse res = httpClient.execute((HttpUriRequest)httpGet);
            log.debug((Object)res.toString());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] response = new byte[]{};
        return ByteBuffer.wrap(response);
    }
}

