/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.validator;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import pl.smartapps.restserver.rest.validator.MacAddressValidator;
import pl.smartapps.restserver.rest.validator.Validator;

public class MacAddressValidatorTests {
    private Validator macAddressValidator;

    @Before
    public void setUp() {
        this.macAddressValidator = new MacAddressValidator();
    }

    @Test
    public void test() {
        Assert.assertFalse((boolean)this.macAddressValidator.validate(null));
        Assert.assertFalse((boolean)this.macAddressValidator.validate(""));
        Assert.assertFalse((boolean)this.macAddressValidator.validate(" "));
        Assert.assertFalse((boolean)this.macAddressValidator.validate("a"));
        Assert.assertFalse((boolean)this.macAddressValidator.validate("aabo-cc2z-t2af)"));
        Assert.assertFalse((boolean)this.macAddressValidator.validate("aaaa-aaaa-aaaf"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("00:00:00:00:00:00"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("00:11:22:33:44:55"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("00:1A:B6:00:0E:9A"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("00:1A:B6:11:22:04"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("00-1A-B6-11-22-04"));
        Assert.assertTrue((boolean)this.macAddressValidator.validate("001AB6112204"));
        Assert.assertFalse((boolean)this.macAddressValidator.validate("00:1A:B6:11:22:0G"));
    }

    @After
    public void tearDown() {
        this.macAddressValidator = null;
    }
}

