/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.validator;

import org.springframework.stereotype.Component;
import pl.smartapps.restserver.rest.validator.Validator;

@Component
public class MacAddressValidator
implements Validator {
    private static final String[] MAC_PATTERNS = new String[]{"^([0-9A-Fa-f]{2}-){5}[0-9A-Fa-f]{2}$", "^([0-9A-Fa-f]{2}:){5}[0-9A-Fa-f]{2}$", "^[0-9A-Fa-f]{12}$"};

    public boolean validate(String text) {
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        return this.isMacAddress(text);
    }

    private boolean isMacAddress(String text) {
        String[] stringArray = MAC_PATTERNS;
        int n = MAC_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (text.matches(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

