/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.validator;

import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import pl.smartapps.restserver.rest.validator.EmailValidator;

public class EmailValidatorTests {
    private static Logger log = Logger.getLogger(EmailValidatorTests.class);
    private String[] validEmailAddresses = new String[]{"l3tt3rsAndNumb3rs@domain.com", "has-dash@domain.com", "hasApostrophe.o'leary@domain.org", "uncommonTLD@domain.museum", "uncommonTLD@domain.travel", "uncommonTLD@domain.mobi", "countryCodeTLD@domain.uk", "countryCodeTLD@domain.rw", "lettersInDomain@911.com", "underscore_inLocal@domain.net", "IPInsteadOfDomain@127.0.0.1", "IPAndPort@127.0.0.1:25", "subdomain@sub.domain.com", "local@dash-inDdomain.com", "dot.inLocal@foo.com", "a@singleLetterLocal.org", "singleLetterDomain@x.org", "&*=?^+{}'~@validCharsInLocal.net", "foor@bar.newTLD"};
    private String[] invalidEmailAddresses = new String[]{"missingDomain@.com", "@missingLocal.org", "missingatSign.net", "missingDot@com", "two@@signs.com", "colonButNoPort@127.0.0.1:", "", "someone-else@127.0.0.1.26", ".localStartsWithDot@domain.com", "localEndsWithDot.@domain.com", "two..consecutiveDots@domain.com", "domainStartsWithDash@-domain.com", "domainEndsWithDash@domain-.com", "numbersInTLD@domain.c0m", "missingTLD@domain.", "! \"#$%(),/;<>[]`|@invalidCharsInLocal.org", "invalidCharsInDomain@! \"#$%(),/;<>_[]`|.org", "local@SecondLevelDomainNamesAreInvalidIfTheyAreLongerThan64Charactersss.org"};

    @Test
    public void testEmailValidate() {
        String email;
        EmailValidator validator = new EmailValidator();
        String[] stringArray = this.validEmailAddresses;
        int n = this.validEmailAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            email = stringArray[n2];
            log.debug((Object)("Processcing valid email address: " + email + " --> " + validator.validate(email)));
            Assert.assertTrue((boolean)validator.validate(email));
            ++n2;
        }
        stringArray = this.invalidEmailAddresses;
        n = this.invalidEmailAddresses.length;
        n2 = 0;
        while (n2 < n) {
            email = stringArray[n2];
            log.debug((Object)("Processcing invalid email address: " + email + " --> " + validator.validate(email)));
            Assert.assertTrue((!validator.validate(email) ? 1 : 0) != 0);
            ++n2;
        }
    }
}

