/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.io.IOException;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.Subject;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.rest.security.WrongSessionFilter;
import pl.smartapps.restserver.rest.security.WrongSessionFilterConfig;
import pl.smartapps.restserver.service.AttemptService;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={WrongSessionFilter.class, SecurityUtils.class, DefaultSessionKey.class})
public class WrongSessionFilterTests {
    private WrongSessionFilter filter;
    private AttemptService attemptService;
    private WrongSessionFilterConfig config;

    @Before
    public void setUp() {
        this.filter = new WrongSessionFilter();
        this.attemptService = (AttemptService)PowerMock.createMock(AttemptService.class);
        this.filter.setAttemptService(this.attemptService);
        this.config = (WrongSessionFilterConfig)PowerMock.createMock(WrongSessionFilterConfig.class);
        this.filter.setConfig(this.config);
        PowerMock.mockStatic(SecurityUtils.class);
    }

    @Test
    public void testDisabled() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)false);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDirectAddress() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/untracked");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testProxyAddress() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/untracked");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testUntrackedUrl() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked_0");
        untrakedUrls.add("/app/test/untracked_1");
        untrakedUrls.add("/app/test/untracked_2");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/untracked_0").times(2);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testTrackedUrlWithValidSession() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/tracked");
        HttpSession httpSession = (HttpSession)PowerMock.createMock(HttpSession.class);
        EasyMock.expect((Object)request.getSession()).andReturn((Object)httpSession);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)httpSession.getId()).andReturn((Object)sessionId);
        Session shiroSession = (Session)PowerMock.createMock(Session.class);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey sessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{sessionId}).andReturn((Object)sessionKey);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)sessionKey)).andReturn((Object)shiroSession);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)subject);
        Object principal = new Object();
        EasyMock.expect((Object)subject.getPrincipal()).andReturn(principal);
        this.attemptService.reset(address);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testTrackedUrlWithInvalidSession() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/tracked");
        HttpSession httpSession = (HttpSession)PowerMock.createMock(HttpSession.class);
        EasyMock.expect((Object)request.getSession()).andReturn((Object)httpSession);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)httpSession.getId()).andReturn((Object)sessionId);
        Session shiroSession = (Session)PowerMock.createMock(Session.class);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey sessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{sessionId}).andReturn((Object)sessionKey);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)sessionKey)).andReturn((Object)shiroSession);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)subject);
        EasyMock.expect((Object)subject.getPrincipal()).andReturn(null);
        this.attemptService.record(address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testTrackedUrlWithInvalidSessionAndLock() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/tracked");
        HttpSession httpSession = (HttpSession)PowerMock.createMock(HttpSession.class);
        EasyMock.expect((Object)request.getSession()).andReturn((Object)httpSession);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)httpSession.getId()).andReturn((Object)sessionId);
        Session shiroSession = (Session)PowerMock.createMock(Session.class);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey sessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{sessionId}).andReturn((Object)sessionKey);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)sessionKey)).andReturn((Object)shiroSession);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)SecurityUtils.getSubject()).andReturn((Object)subject);
        EasyMock.expect((Object)subject.getPrincipal()).andReturn(null);
        this.attemptService.record(address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)true);
        response.setStatus(401);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testTrackedUrlWithNullSession() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        HashSet<String> untrakedUrls = new HashSet<String>();
        untrakedUrls.add("/app/test/untracked");
        EasyMock.expect((Object)this.config.getUntrackedUrls()).andReturn(untrakedUrls);
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/app/test/tracked");
        HttpSession httpSession = (HttpSession)PowerMock.createMock(HttpSession.class);
        EasyMock.expect((Object)request.getSession()).andReturn((Object)httpSession);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)httpSession.getId()).andReturn((Object)sessionId);
        SecurityManager securityManager = (SecurityManager)PowerMock.createMock(SecurityManager.class);
        EasyMock.expect((Object)SecurityUtils.getSecurityManager()).andReturn((Object)securityManager);
        DefaultSessionKey sessionKey = (DefaultSessionKey)PowerMock.createMock(DefaultSessionKey.class);
        PowerMock.expectNew(DefaultSessionKey.class, (Object[])new Object[]{sessionId}).andReturn((Object)sessionKey);
        EasyMock.expect((Object)securityManager.getSession((SessionKey)sessionKey)).andReturn(null);
        this.attemptService.record(address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)false);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddressLocked() throws Exception {
        HttpServletRequest request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)PowerMock.createMock(FilterChain.class);
        EasyMock.expect((Object)this.config.isEnabled()).andReturn((Object)true);
        String address = "158.255.93.130";
        EasyMock.expect((Object)request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)address);
        EasyMock.expect((Object)this.attemptService.locked(address)).andReturn((Object)true);
        response.setStatus(401);
        PowerMock.replayAll((Object[])new Object[0]);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        PowerMock.verifyAll();
    }
}

