/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import pl.smartapps.restserver.rest.security.WrongSessionFilterConfig;
import pl.smartapps.restserver.service.ParameterService;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={WrongSessionFilterConfig.class, System.class})
public class WrongSessionFilterConfigTests {
    private WrongSessionFilterConfig config;
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.config = new WrongSessionFilterConfig();
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.config.setParameterService(this.parameterService);
        PowerMock.mockStatic(System.class);
    }

    @Test
    public void testInitialize() {
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.INVALID_SESSION_ENABLED, false)).andReturn((Object)true);
        long now = 1398669939504L;
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        String untrakedUrls = "/test1;/test2;/test3";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.INVALID_SESSION_UNTRACKED_URLS)).andReturn((Object)untrakedUrls);
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        PowerMock.replayAll((Object[])new Object[0]);
        this.config.initialize();
        PowerMock.verifyAll();
        Assert.assertEquals((Object)true, (Object)Whitebox.getInternalState((Object)this.config, (String)"enabled"));
        Assert.assertEquals((Object)1398670839504L, (Object)Whitebox.getInternalState((Object)this.config, (String)"enabledExpiry"));
        HashSet<String> urls = new HashSet<String>();
        urls.add("/test1");
        urls.add("/test2");
        urls.add("/test3");
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEqualCollection((Collection)this.getUntrackedUrls(), urls));
        Assert.assertEquals((Object)1398670839504L, (Object)Whitebox.getInternalState((Object)this.config, (String)"untrackedUrlsExpiry"));
    }

    private Set<String> getUntrackedUrls() {
        return (Set)Whitebox.getInternalState((Object)this.config, (String)"untrackedUrls");
    }

    @Test
    public void testIsEnabledValid() {
        Whitebox.setInternalState((Object)this.config, (String)"enabled", (Object)true);
        long now = 1398669939504L;
        Whitebox.setInternalState((Object)this.config, (String)"enabledExpiry", (Object)(now + 1L));
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.config.isEnabled());
        Assert.assertEquals((Object)(now + 1L), (Object)Whitebox.getInternalState((Object)this.config, (String)"enabledExpiry"));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsEnabledExpired() {
        Whitebox.setInternalState((Object)this.config, (String)"enabled", (Object)true);
        long now = 1398669939504L;
        Whitebox.setInternalState((Object)this.config, (String)"enabledExpiry", (Object)(now - 1L));
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now).times(2);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.INVALID_SESSION_ENABLED, false)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.config.isEnabled());
        Assert.assertEquals((long)(now + 900000L), (long)this.getEnabledExpiry());
        PowerMock.verifyAll();
    }

    private long getEnabledExpiry() {
        return (Long)Whitebox.getInternalState((Object)this.config, (String)"enabledExpiry");
    }

    @Test
    public void testGetUntracedUrlsValid() {
        HashSet<String> urls = new HashSet<String>();
        urls.add("/test1");
        urls.add("/test2");
        urls.add("/test3");
        Whitebox.setInternalState((Object)this.config, (String)"untrackedUrls", urls);
        long now = 1398669939504L;
        Whitebox.setInternalState((Object)this.config, (String)"untrackedUrlsExpiry", (Object)(now + 1L));
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEqualCollection(urls, (Collection)this.config.getUntrackedUrls()));
        Assert.assertEquals((Object)(now + 1L), (Object)Whitebox.getInternalState((Object)this.config, (String)"untrackedUrlsExpiry"));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUntracedUrlsExpired() {
        HashSet<String> urls = new HashSet<String>();
        urls.add("/test1");
        Whitebox.setInternalState((Object)this.config, (String)"untrackedUrls", urls);
        long now = 1398669939504L;
        Whitebox.setInternalState((Object)this.config, (String)"untrackedUrlsExpiry", (Object)(now - 1L));
        EasyMock.expect((Object)System.currentTimeMillis()).andReturn((Object)now).times(2);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.INVALID_SESSION_UNTRACKED_URLS)).andReturn((Object)"/test1;/test2;/test3");
        PowerMock.replayAll((Object[])new Object[0]);
        HashSet<String> newUrls = new HashSet<String>();
        newUrls.add("/test1");
        newUrls.add("/test2");
        newUrls.add("/test3");
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEqualCollection(newUrls, (Collection)this.config.getUntrackedUrls()));
        Assert.assertEquals((Object)(now + 900000L), (Object)Whitebox.getInternalState((Object)this.config, (String)"untrackedUrlsExpiry"));
        PowerMock.verifyAll();
    }
}

