/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.Utils;

@Component
public class WrongSessionFilterConfig {
    private ParameterService parameterService;
    private boolean enabled;
    private long enabledExpiry;
    private Set<String> untrackedUrls;
    private long untrackedUrlsExpiry;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @PostConstruct
    public void initialize() {
        this.updateEnabled();
        this.updateUntrackedUrls();
    }

    private synchronized void updateEnabled() {
        this.enabled = this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.INVALID_SESSION_ENABLED, false);
        this.enabledExpiry = this.getExpiry();
    }

    private long getExpiry() {
        return System.currentTimeMillis() + 900000L;
    }

    private synchronized void updateUntrackedUrls() {
        String value = this.parameterService.getParameterValue(ParameterService.ParameterCode.INVALID_SESSION_UNTRACKED_URLS);
        HashSet<String> urls = new HashSet<String>();
        if (!Utils.isBlank((String)value)) {
            String[] splittedUrls;
            String[] stringArray = splittedUrls = value.split(";");
            int n = splittedUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                if (!Utils.isBlank((String)url)) {
                    urls.add(url.trim());
                }
                ++n2;
            }
        }
        this.untrackedUrls = urls;
        this.untrackedUrlsExpiry = this.getExpiry();
    }

    public boolean isEnabled() {
        if (System.currentTimeMillis() > this.enabledExpiry) {
            this.updateEnabled();
        }
        return this.enabled;
    }

    public Set<String> getUntrackedUrls() {
        if (System.currentTimeMillis() > this.untrackedUrlsExpiry) {
            this.updateUntrackedUrls();
        }
        return new HashSet<String>(this.untrackedUrls);
    }
}

