/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.web.filter.GenericFilterBean;
import pl.smartapps.restserver.rest.security.WrongSessionFilterConfig;
import pl.smartapps.restserver.service.AttemptService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WrongSessionFilter
extends GenericFilterBean {
    private static Logger log = Logger.getLogger(WrongSessionFilter.class);
    private AttemptService attemptService;
    private WrongSessionFilterConfig config;

    @Autowired
    @Required
    @Qualifier(value="sessionAttemptServiceImpl")
    public void setAttemptService(AttemptService attemptService) {
        this.attemptService = attemptService;
    }

    @Autowired
    @Required
    public void setConfig(WrongSessionFilterConfig config) {
        this.config = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.config.isEnabled()) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rep = (HttpServletResponse)response;
            String remoteAddress = this.getRemoteAddress((ServletRequest)req);
            if (this.attemptService.locked(remoteAddress)) {
                rep.setStatus(401);
                return;
            }
            if (this.traced(req)) {
                if (!this.isSessionValid(req.getSession().getId())) {
                    log.info((Object)("Detected invalid session from " + remoteAddress + " calling " + req.getMethod() + " " + WrongSessionFilter.getFullUrl((HttpServletRequest)req)));
                    this.attemptService.record(remoteAddress);
                    if (this.attemptService.locked(remoteAddress)) {
                        log.info((Object)("Address " + remoteAddress + " has been blocked due to too many invalid sessions"));
                        rep.setStatus(401);
                        return;
                    }
                } else {
                    this.attemptService.reset(remoteAddress);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public static String getFullUrl(HttpServletRequest request) {
        String reqUrl = request.getRequestURL().toString();
        String query = request.getQueryString();
        if (query != null) {
            reqUrl = String.valueOf(reqUrl) + "?" + query;
        }
        return reqUrl;
    }

    private String getRemoteAddress(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        String header = req.getHeader("X-Forwarded-For");
        return header != null ? header : req.getRemoteAddr();
    }

    private boolean traced(HttpServletRequest req) {
        for (String untracedUrl : this.config.getUntrackedUrls()) {
            if (!req.getRequestURI().startsWith(untracedUrl)) continue;
            return false;
        }
        return true;
    }

    private boolean isSessionValid(String id) {
        Session session = this.getShiroSession(id);
        return session != null && SecurityUtils.getSubject().getPrincipal() != null;
    }

    private Session getShiroSession(String id) {
        try {
            return SecurityUtils.getSecurityManager().getSession((SessionKey)new DefaultSessionKey((Serializable)((Object)id)));
        }
        catch (SessionException ex) {
            return null;
        }
    }
}

