/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.SimpleByteSource;
import pl.smartapps.restserver.rest.security.PasswordHashGenerator;

public class SsoAuthenticationInfo
implements SaltedAuthenticationInfo {
    private static final long serialVersionUID = 1913007369614662587L;
    private Integer userId;
    private String ssoId;
    private String salt;
    private String realmName;
    private PasswordHashGenerator passwordHashGenerator = new PasswordHashGenerator();

    public SsoAuthenticationInfo(Integer userId, String ssoId, String realmName) {
        this.salt = this.passwordHashGenerator.getSalt();
        this.setUserId(userId);
        this.setSsoId(ssoId);
        this.setRealmName(realmName);
    }

    public Object getCredentials() {
        String hashedPassword = this.passwordHashGenerator.generate(this.ssoId, this.salt);
        return hashedPassword;
    }

    public PrincipalCollection getPrincipals() {
        SimplePrincipalCollection pc = new SimplePrincipalCollection((Object)this.userId, this.realmName);
        return pc;
    }

    public void setSsoId(String ssoId) {
        this.ssoId = ssoId;
    }

    public String getSsoId() {
        return this.ssoId;
    }

    public ByteSource getCredentialsSalt() {
        return new SimpleByteSource(this.salt);
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

