/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import com.vestiacom.util.SharedCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ShiroSessionDAO
extends AbstractSessionDAO {
    private SharedCache sharedCache;
    private Map<Serializable, Session> sessions;

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @PostConstruct
    public void initialize() {
        this.sessions = this.sharedCache.getMap("shiroSessions");
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.storeSession(sessionId, session);
        return sessionId;
    }

    protected Session storeSession(Serializable id, Session session) {
        if (id == null) {
            throw new NullPointerException("id argument cannot be null.");
        }
        return this.sessions.put(id, session);
    }

    protected Session doReadSession(Serializable sessionId) {
        return (Session)this.sessions.get(sessionId);
    }

    public void update(Session session) throws UnknownSessionException {
        this.storeSession(session.getId(), session);
    }

    public void delete(Session session) {
        if (session == null) {
            throw new NullPointerException("session argument cannot be null.");
        }
        Serializable id = session.getId();
        if (id != null) {
            return;
        }
        this.sessions.remove(id);
    }

    public Collection<Session> getActiveSessions() {
        Collection values = this.sessions.values();
        if (this.isEmpty(values)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(values);
    }

    private boolean isEmpty(Collection<Session> c) {
        return c == null || c.isEmpty();
    }
}

