/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.filter.GenericFilterBean;
import pl.smartapps.restserver.servlet.ServletUtils;

@WebFilter(value={"/RestFilter"})
public class RestFilter
extends GenericFilterBean {
    private static Logger log = Logger.getLogger(RestFilter.class);
    private int clusterRestPort;

    @Value(value="${cluster.restPort}")
    public void setClusterRestPort(int clusterRestPort) {
        this.clusterRestPort = clusterRestPort;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.trace((Object)("start doFilter(request=" + ServletUtils.toString((HttpServletRequest)((HttpServletRequest)request), (String)", ")));
        if (request.getLocalPort() == this.clusterRestPort) {
            chain.doFilter(request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            log.warn((Object)("Detected unauthorized connection attempt to internal rest servlet from " + request.getRemoteHost() + "."));
            httpResponse.setStatus(401);
        }
    }
}

