/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.security.AuthenticationRequiredException;
import pl.smartapps.restserver.rest.security.FrontAuthenticationFilter;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FrontAuthenticationFilter.class, ServletFileUpload.class, FileItemFactory.class, ThreadContext.class})
public class FrontAuthenticationFilterTests {
    private FrontAuthenticationFilter authenticationFilter;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private FilterChain filterChain;
    private LanDeviceDAO lanDeviceDAO;
    private DeviceDriverFactory deviceDriverFactory;
    private BasicAuthenticationEntryPoint basicEntryPoint;
    private DigestAuthenticationEntryPoint digestEntryPoint;
    private GenericLanDevice driver;

    @Before
    public void setUp() {
        this.authenticationFilter = new FrontAuthenticationFilter();
        this.servletRequest = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.servletResponse = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        this.filterChain = (FilterChain)PowerMock.createMock(FilterChain.class);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.authenticationFilter.setLanDeviceDAO(this.lanDeviceDAO);
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.authenticationFilter.setDeviceDriverFactory(this.deviceDriverFactory);
        this.basicEntryPoint = (BasicAuthenticationEntryPoint)PowerMock.createMock(BasicAuthenticationEntryPoint.class);
        this.authenticationFilter.setBasicEntryPoint(this.basicEntryPoint);
        this.digestEntryPoint = (DigestAuthenticationEntryPoint)PowerMock.createMock(DigestAuthenticationEntryPoint.class);
        this.authenticationFilter.setDigestEntryPoint(this.digestEntryPoint);
        this.driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        PowerMock.mockStatic(ServletFileUpload.class);
        PowerMock.mockStatic(ThreadContext.class);
    }

    @Test
    public void testDoFilterIncorrectMac() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        this.servletResponse.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterNotFoundDevice() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        this.servletResponse.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterNotFoundDeviceDriver() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn(null);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", null);
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.servletResponse.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterMacInQueryNoAuthRequired() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn(null);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn(null);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"PIR");
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.filterChain.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterMacInMultipartWithSnapshotNoAuthRequired() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn(null);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.isFormField()).andReturn((Object)true);
        EasyMock.expect((Object)item1.getString()).andReturn((Object)"eventType=AUDIO&message=id=AC:81:12:25:76:41&SN=AAHB01BB01452&MAC=ac:81:12:25:76:41&TIME=Wed Jan 7 18:21:54 2009");
        EasyMock.expect((Object)item2.isFormField()).andReturn((Object)false);
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"image/jpeg").times(2);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)snapshot);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", (Object)Utils.constructDate((int)2009, (int)1, (int)7, (int)19, (int)21, (int)54));
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"AUDIO");
        ThreadContext.put((Object)"lanDeviceSnapshot", (Object)snapshot);
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("AC:81:12:25:76:41")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn(null);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn(null);
        this.filterChain.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterMacInMultipartWithVideoClipNoAuthRequired() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn(null);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.isFormField()).andReturn((Object)true);
        EasyMock.expect((Object)item1.getString()).andReturn((Object)"eventType=AUDIO&message=id=AC:81:12:25:76:41&SN=AAHB01BB01452&MAC=ac:81:12:25:76:41&TIME=Wed Jan 7 18:21:54 2009");
        EasyMock.expect((Object)item2.isFormField()).andReturn((Object)false);
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"application/octet-stream").times(3);
        byte[] videoClip = new byte[128];
        InputStream inputStream = (InputStream)PowerMock.createMock(InputStream.class);
        EasyMock.expect((Object)item2.getInputStream()).andReturn((Object)inputStream);
        byte[] buffer = new byte[256];
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)PowerMock.createMock(ByteArrayOutputStream.class);
        PowerMock.expectNew(ByteArrayOutputStream.class, (Object[])new Object[0]).andReturn((Object)outputStream);
        EasyMock.expect((Object)inputStream.read(EasyMock.aryEq((byte[])buffer), EasyMock.eq((int)0), EasyMock.eq((int)256))).andReturn((Object)128);
        outputStream.write(EasyMock.aryEq((byte[])buffer), EasyMock.eq((int)0), EasyMock.eq((int)128));
        EasyMock.expect((Object)inputStream.read(EasyMock.aryEq((byte[])buffer), EasyMock.eq((int)0), EasyMock.eq((int)256))).andReturn((Object)-1);
        outputStream.flush();
        EasyMock.expect((Object)outputStream.toByteArray()).andReturn((Object)videoClip);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", (Object)Utils.constructDate((int)2009, (int)1, (int)7, (int)19, (int)21, (int)54));
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"AUDIO");
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceVideoClip", (Object)videoClip);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("AC:81:12:25:76:41")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn(null);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn(null);
        this.filterChain.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterBasicAuthRequired() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn((Object)GenericLanDevice.AuthType.BASIC);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn(null);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"PIR");
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.basicEntryPoint.commence((HttpServletRequest)EasyMock.eq((Object)this.servletRequest), (HttpServletResponse)EasyMock.eq((Object)this.servletResponse), (AuthenticationException)EasyMock.isA(AuthenticationRequiredException.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterDigestAuthRequired() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn((Object)GenericLanDevice.AuthType.DIGEST);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn(null);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"PIR");
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.digestEntryPoint.commence((HttpServletRequest)EasyMock.eq((Object)this.servletRequest), (HttpServletResponse)EasyMock.eq((Object)this.servletResponse), (AuthenticationException)EasyMock.isA(AuthenticationRequiredException.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterUnexpectedBasicAuth() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn((Object)GenericLanDevice.AuthType.DIGEST);
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"PIR");
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.digestEntryPoint.commence((HttpServletRequest)EasyMock.eq((Object)this.servletRequest), (HttpServletResponse)EasyMock.eq((Object)this.servletResponse), (AuthenticationException)EasyMock.isA(AuthenticationRequiredException.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoFilterUnexpectedDigestAuth() throws IOException, ServletException {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:06:CD:80");
        EasyMock.expect((Object)this.servletRequest.getParameter("eventType")).andReturn((Object)"PIR");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)this.driver);
        EasyMock.expect((Object)this.driver.getAuthType()).andReturn((Object)GenericLanDevice.AuthType.BASIC);
        String authHeader = "Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"";
        EasyMock.expect((Object)this.servletRequest.getHeader("Authorization")).andReturn((Object)authHeader);
        ThreadContext.put((Object)"lanDecviceId", (Object)1);
        ThreadContext.put((Object)"lanDeviceEventDate", null);
        ThreadContext.put((Object)"lanDeviceSnapshot", null);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)"PIR");
        ThreadContext.put((Object)"lanDeviceVideoClip", null);
        this.basicEntryPoint.commence((HttpServletRequest)EasyMock.eq((Object)this.servletRequest), (HttpServletResponse)EasyMock.eq((Object)this.servletResponse), (AuthenticationException)EasyMock.isA(AuthenticationRequiredException.class));
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationFilter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.servletRequest = null;
        this.servletResponse = null;
        this.filterChain = null;
        this.lanDeviceDAO = null;
        this.deviceDriverFactory = null;
        this.basicEntryPoint = null;
        this.digestEntryPoint = null;
    }
}

