/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.apache.shiro.util.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;
import org.springframework.web.filter.GenericFilterBean;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.security.AuthenticationRequiredException;
import pl.smartapps.restserver.rest.security.FrontAuthenticationFilter;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FrontAuthenticationFilter
extends GenericFilterBean {
    public static final String LAN_DEVICE_ID_KEY = "lanDecviceId";
    public static final String LAN_DEVICE_EVENT_TYPE_KEY = "lanDeviceEventType";
    public static final String LAN_DEVICE_SNAPSHOT_KEY = "lanDeviceSnapshot";
    public static final String LAN_DEVICE_VIDEO_CLIP_KEY = "lanDeviceVideoClip";
    public static final String LAN_DEVICE_EVENT_DATE_KEY = "lanDeviceEventDate";
    private static Logger log = Logger.getLogger(FrontAuthenticationFilter.class);
    private LanDeviceDAO lanDeviceDAO;
    private DeviceDriverFactory deviceDriverFactory;
    private BasicAuthenticationEntryPoint basicEntryPoint;
    private DigestAuthenticationEntryPoint digestEntryPoint;

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setBasicEntryPoint(BasicAuthenticationEntryPoint basicEntryPoint) {
        this.basicEntryPoint = basicEntryPoint;
    }

    @Autowired
    @Required
    public void setDigestEntryPoint(DigestAuthenticationEntryPoint digestEntryPoint) {
        this.digestEntryPoint = digestEntryPoint;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String mac;
        log.debug((Object)"start AuthenticationFilter.doFilter");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ParsedRequest parsedRequest = this.processRequest(httpRequest);
        String string = mac = parsedRequest != null ? parsedRequest.macAddress : null;
        if (Utils.isBlank((String)mac)) {
            log.debug((Object)("Incorrect mac address: " + mac + "."));
            httpResponse.setStatus(404);
            return;
        }
        LanDeviceEntity device = this.lanDeviceDAO.findNotDeletedLanDeviceByMac(mac);
        if (device == null) {
            log.debug((Object)("Not found device for mac address: " + mac + "."));
            httpResponse.setStatus(404);
            return;
        }
        ThreadContext.put((Object)"lanDecviceId", (Object)device.getLanDeviceId());
        ThreadContext.put((Object)"lanDeviceEventDate", (Object)parsedRequest.eventDate);
        ThreadContext.put((Object)"lanDeviceEventType", (Object)parsedRequest.eventType);
        ThreadContext.put((Object)"lanDeviceSnapshot", (Object)parsedRequest.snapshot);
        ThreadContext.put((Object)"lanDeviceVideoClip", (Object)parsedRequest.videoClip);
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            log.debug((Object)("Not found driver for device with lanDeviceId= " + device.getLanDeviceId() + "."));
            httpResponse.setStatus(404);
            return;
        }
        GenericLanDevice.AuthType supportedAuthType = driver.getAuthType();
        String authorizationHeader = httpRequest.getHeader("Authorization");
        if (authorizationHeader == null) {
            if (supportedAuthType == null) {
                log.debug((Object)"Detected none authentication type.");
                chain.doFilter(request, response);
            } else if (supportedAuthType == GenericLanDevice.AuthType.BASIC) {
                log.debug((Object)"Detected basic authentication type.");
                this.basicEntryPoint.commence(httpRequest, httpResponse, (AuthenticationException)new AuthenticationRequiredException());
            } else {
                log.debug((Object)"Detected digest authentication type.");
                this.digestEntryPoint.commence(httpRequest, httpResponse, (AuthenticationException)new AuthenticationRequiredException());
            }
        } else if (authorizationHeader.toLowerCase().startsWith("basic ") && supportedAuthType == GenericLanDevice.AuthType.DIGEST) {
            log.debug((Object)"incorrect authentication type: basic.");
            this.digestEntryPoint.commence(httpRequest, httpResponse, (AuthenticationException)new AuthenticationRequiredException());
        } else if (authorizationHeader.toLowerCase().startsWith("digest ") && supportedAuthType == GenericLanDevice.AuthType.BASIC) {
            log.debug((Object)"incorrect authentication type: digest.");
            this.basicEntryPoint.commence(httpRequest, httpResponse, (AuthenticationException)new AuthenticationRequiredException());
        } else {
            chain.doFilter(request, response);
        }
    }

    public ParsedRequest processRequest(HttpServletRequest request) {
        ParsedRequest parsedRequest = new ParsedRequest(this, null);
        String macAddress = request.getParameter("id");
        if (macAddress != null) {
            String eventType;
            parsedRequest.macAddress = Utils.formatMacAddress((String)macAddress);
            parsedRequest.eventType = eventType = request.getParameter("eventType");
            return parsedRequest;
        }
        macAddress = this.getMacAddressFromPath(request);
        if (macAddress != null) {
            parsedRequest.macAddress = macAddress;
            String parameters = request.getParameter("Msg");
            String eventType = parameters.substring(0, parameters.indexOf(","));
            parsedRequest.eventType = eventType.equals("AudioDetect") ? "AUDIO" : eventType;
            return parsedRequest;
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            return parsedRequest;
        }
        DiskFileItemFactory fileItemFoctory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fileItemFoctory);
        try {
            List items = upload.parseRequest(request);
            log.debug((Object)("items size: " + items.size()));
            for (FileItem item : items) {
                if (item.isFormField()) {
                    Map messageParams = FrontAuthenticationFilter.parseMessage((String)item.getString());
                    parsedRequest.macAddress = Utils.formatMacAddress((String)((String)messageParams.get("id")));
                    parsedRequest.eventType = (String)messageParams.get("eventType");
                    parsedRequest.eventDate = this.extractDate(messageParams);
                    continue;
                }
                if (!item.getFieldName().equals("file") || item.getContentType() == null) continue;
                if (item.getContentType().endsWith("image/jpeg")) {
                    parsedRequest.snapshot = item.get();
                    continue;
                }
                if (!item.getContentType().endsWith("application/octet-stream")) continue;
                parsedRequest.videoClip = this.extractVideoClip(item.getInputStream());
            }
            return parsedRequest;
        }
        catch (Exception e) {
            log.debug((Object)("Error occured during extraction camera snapshot (MAC=" + (parsedRequest != null ? parsedRequest.macAddress : "null") + "): " + e.getMessage()));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private String getMacAddressFromPath(HttpServletRequest request) {
        String path = request.getRequestURI();
        int macPosition = path.lastIndexOf("/");
        if (macPosition < 0 || path.length() - macPosition - 1 != 12) {
            log.debug((Object)("MAC address not found in path: " + path));
            return null;
        }
        String rawMacAddress = path.substring(macPosition + 1);
        return Utils.formatMacAddress((String)rawMacAddress);
    }

    private static Map<String, String> parseMessage(String message) {
        String[] params;
        log.debug((Object)("start parseMessage(message=" + message + ")"));
        HashMap<String, String> messageParams = new HashMap<String, String>();
        if (message == null || message.trim().isEmpty()) {
            return messageParams;
        }
        message = message.replace("message=", "");
        String[] stringArray = params = message.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] paramElements = param.split("=");
            if (paramElements.length != 2) {
                log.warn((Object)("Unexpected param form: '" + param + "'."));
            } else {
                messageParams.put(paramElements[0].trim(), paramElements[1].trim());
            }
            ++n2;
        }
        return messageParams;
    }

    private byte[] extractVideoClip(InputStream stream) throws IOException {
        log.debug((Object)("start extractVideoClip(stream=" + stream + ")"));
        try {
            int readCount;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            while ((readCount = stream.read(buffer, 0, buffer.length)) != -1) {
                data.write(buffer, 0, readCount);
            }
            data.flush();
            return data.toByteArray();
        }
        catch (IOException e) {
            log.warn((Object)("Failed to extarct video clip: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private Date extractDate(Map<String, String> messageParams) {
        if (messageParams == null || messageParams.isEmpty()) {
            return null;
        }
        return Utils.parseDate((String)messageParams.get("TIME"), (String)"EEE MMM dd HH:mm:ss yyyy", (Locale)Locale.ENGLISH, (TimeZone)TimeZone.getTimeZone("UTC"));
    }
}

