/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.security.DigestUserDetailsService;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DigestUserDetailsService.class})
public class DigestUserDetailsServiceTests {
    private DigestUserDetailsService digestUserDetailsService;
    private LanDeviceDAO lanDeviceDAO;

    @Before
    public void setUp() {
        this.digestUserDetailsService = new DigestUserDetailsService();
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.digestUserDetailsService.setLanDeviceDAO(this.lanDeviceDAO);
    }

    @Test
    public void testAuthSuccesfull() {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)22, (String)"alarm_user", (String)"test", (String)"test"));
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)23, (String)"alarm_pass", (String)"test5A", (String)"test5A"));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(null)).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        UserDetails response = this.digestUserDetailsService.loadUserByUsername("test");
        ArrayList authorities = new ArrayList();
        User expectedResponse = new User("test", "test5A", false, true, true, true, authorities);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test(expected=UsernameNotFoundException.class)
    public void testAuthNotFoundDevice() {
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.digestUserDetailsService.loadUserByUsername("test");
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.lanDeviceDAO = null;
    }
}

