/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import org.apache.log4j.Logger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.SimpleByteSource;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.RoleEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.security.SsoAuthenticationInfo;
import pl.smartapps.restserver.rest.security.SsoToken;

public class CustomRealm
extends AuthorizingRealm {
    private static Logger log = Logger.getLogger(CustomRealm.class);
    private UserDAO userDAO;

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        log.info((Object)"start doGetAuthenticationInfo");
        AuthenticationToken token = null;
        if (authcToken instanceof UsernamePasswordToken) {
            token = authcToken;
            UserEntity user = this.userDAO.findUserByName(((UsernamePasswordToken)token).getUsername());
            if (user != null) {
                log.info((Object)("Found user for name " + user.getUsername() + ": " + user.toString()));
                if (user.getActivationCode() == null || user.getActivationCode().equals("")) {
                    SimpleByteSource salt = new SimpleByteSource(user.getPasswordSalt());
                    return new SimpleAuthenticationInfo((Object)user.getId(), (Object)user.getPassword(), (ByteSource)salt, this.getName());
                }
                throw new LockedAccountException("Account called '" + ((UsernamePasswordToken)token).getUsername() + "' has not been activated yet!");
            }
            return null;
        }
        if (authcToken instanceof SsoToken) {
            token = authcToken;
            UserEntity user = this.userDAO.findUserBySsoId(((SsoToken)token).getSsoId());
            if (user != null) {
                log.info((Object)("Found user for ssoId " + user.getSsoId() + ": " + user.toString()));
                return new SsoAuthenticationInfo(user.getId(), user.getSsoId(), this.getName());
            }
            return null;
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        log.debug((Object)("start doGetAuthorizationInfo(principals=" + principals + ")"));
        Integer userId = (Integer)principals.fromRealm(this.getName()).iterator().next();
        log.debug((Object)("userId: " + userId));
        UserEntity user = this.userDAO.findUserById(userId, false, false, true);
        if (user != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            for (RoleEntity role : user.getRoles()) {
                info.addRole(role.getName());
            }
            return info;
        }
        return null;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken || token instanceof SsoToken;
    }
}

