/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.security.BasicAuthenticationManager;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BasicAuthenticationManager.class})
public class BasicAuthenticationManagerTests {
    private BasicAuthenticationManager authenticationManager;
    private LanDeviceDAO lanDeviceDAO;
    private Authentication authentication;

    @Before
    public void setUp() {
        this.authenticationManager = new BasicAuthenticationManager();
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.authenticationManager.setLanDeviceDAO(this.lanDeviceDAO);
        this.authentication = (Authentication)PowerMock.createMock(Authentication.class);
    }

    @Test
    public void testAuthSuccesfull() {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)22, (String)"alarm_user", (String)"test", (String)"test"));
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)23, (String)"alarm_pass", (String)"test5A", (String)"test5A"));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(null)).andReturn((Object)device);
        EasyMock.expect((Object)this.authentication.getPrincipal()).andReturn((Object)"test");
        EasyMock.expectLastCall().times(3);
        EasyMock.expect((Object)this.authentication.getCredentials()).andReturn((Object)"test5A");
        EasyMock.expectLastCall().times(3);
        PowerMock.replayAll((Object[])new Object[0]);
        Authentication response = this.authenticationManager.authenticate(this.authentication);
        ArrayList authorities = new ArrayList();
        UsernamePasswordAuthenticationToken expectedResponse = new UsernamePasswordAuthenticationToken((Object)"test", (Object)"test5A", authorities);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test(expected=BadCredentialsException.class)
    public void testAuthIncorrectCredentials() {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)22, (String)"alarm_user", (String)"test", (String)"test"));
        device.getLanDeviceParams().add(TestDataUtils.prepareLanDeviceParamEntity((Integer)23, (String)"alarm_pass", (String)"test5A", (String)"test5A"));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(null)).andReturn((Object)device);
        EasyMock.expect((Object)this.authentication.getPrincipal()).andReturn((Object)"test");
        EasyMock.expectLastCall().times(3);
        EasyMock.expect((Object)this.authentication.getCredentials()).andReturn((Object)"test5Aa");
        EasyMock.expectLastCall().times(3);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationManager.authenticate(this.authentication);
        PowerMock.verifyAll();
    }

    @Test(expected=AuthenticationCredentialsNotFoundException.class)
    public void testAuthNotFoundDevice() {
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.authenticationManager.authenticate(this.authentication);
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.lanDeviceDAO = null;
        this.authentication = null;
    }
}

