/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest.security;

import java.util.ArrayList;
import org.apache.shiro.util.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;

@Component
public class BasicAuthenticationManager
implements AuthenticationManager {
    @Autowired
    private LanDeviceDAO lanDeviceDAO;

    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        Integer lanDeviceId = (Integer)ThreadContext.get((Object)"lanDecviceId");
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            throw new AuthenticationCredentialsNotFoundException("Not found lanDevice for id=" + lanDeviceId + ".");
        }
        if (this.authenticate(device, auth)) {
            ArrayList authorities = new ArrayList();
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), authorities);
            return token;
        }
        throw new BadCredentialsException("Bad credentials for lan device for id=" + lanDeviceId + ".");
    }

    private boolean authenticate(LanDeviceEntity device, Authentication authentication) {
        if (device == null || device.getLanDeviceParams() == null || device.getLanDeviceParams().isEmpty()) {
            return false;
        }
        if (authentication == null) {
            return false;
        }
        String alarmUser = device.getParamValue("alarm_user");
        String alarmPass = device.getParamValue("alarm_pass");
        if (alarmUser == null || alarmPass == null || authentication.getPrincipal() == null || authentication.getCredentials() == null) {
            return false;
        }
        return alarmUser.equals(authentication.getPrincipal()) && alarmPass.equals(authentication.getCredentials());
    }
}

