/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.hm.WebViewer.shared.model.AccountSettings;
import pl.smartapps.hm.WebViewer.shared.model.ActivateCameraResponse;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationCheckData;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationData;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ChangePassAsAdminData;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.DeviceSharedWithResponse;
import pl.smartapps.hm.WebViewer.shared.model.Event;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClientSendData;
import pl.smartapps.hm.WebViewer.shared.model.ICEParameters;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.Message;
import pl.smartapps.hm.WebViewer.shared.model.ReconfigurationDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.RegisterResponse;
import pl.smartapps.hm.WebViewer.shared.model.ShareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.model.Transaction;
import pl.smartapps.hm.WebViewer.shared.model.UnshareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.model.UpgradeFirmwareStatus;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.VerifyPasswordStatus;
import pl.smartapps.restserver.rest.AddDeviceRequest;
import pl.smartapps.restserver.rest.CreateEventResponse;
import pl.smartapps.restserver.rest.CreateSnapshotEventResponse;
import pl.smartapps.restserver.rest.GenerateNotificationTokenRequest;
import pl.smartapps.restserver.rest.GetApplicationResponse;
import pl.smartapps.restserver.rest.GetApplicationsResponse;
import pl.smartapps.restserver.rest.GetDynDNSResponse;
import pl.smartapps.restserver.rest.GetVersionsResponse;
import pl.smartapps.restserver.rest.RESTHandlerInterface;
import pl.smartapps.restserver.rest.SetDynDNSResponse;
import pl.smartapps.restserver.rest.StopVideoRecordingResponse;
import pl.smartapps.restserver.rest.UpdateNotificationTokenRequest;
import pl.smartapps.restserver.rest.VerifyDynDNSResponse;
import pl.smartapps.restserver.rest.response.ActivateGcResponse;
import pl.smartapps.restserver.rest.response.AddDeviceResponse;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.rest.response.CandidatesResponse;
import pl.smartapps.restserver.rest.response.ChangePasswordData;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.rest.response.CreateSessionResponse;
import pl.smartapps.restserver.rest.response.DeviceVerificationResponse;
import pl.smartapps.restserver.rest.response.ErrorReportResponse;
import pl.smartapps.restserver.rest.response.ExtendValidityResponse;
import pl.smartapps.restserver.rest.response.ForgotPasswordResponse;
import pl.smartapps.restserver.rest.response.GCStatusResponse;
import pl.smartapps.restserver.rest.response.GatewayClientResponse;
import pl.smartapps.restserver.rest.response.GenerateNotificationTokenResponse;
import pl.smartapps.restserver.rest.response.GetCommServerUrlResponse;
import pl.smartapps.restserver.rest.response.GetLanDevicesResponse;
import pl.smartapps.restserver.rest.response.GetVersionResponse;
import pl.smartapps.restserver.rest.response.IPAddressResponse;
import pl.smartapps.restserver.rest.response.LogoutResponse;
import pl.smartapps.restserver.rest.response.NewChangePasswordReponse;
import pl.smartapps.restserver.rest.response.ParameterValueResponse;
import pl.smartapps.restserver.rest.response.ProcessEventResponse;
import pl.smartapps.restserver.rest.response.RecordingControlResponse;
import pl.smartapps.restserver.rest.response.RemoveEventResponse;
import pl.smartapps.restserver.rest.response.RemoveNotificationTokenResponse;
import pl.smartapps.restserver.rest.response.RemoveResponse;
import pl.smartapps.restserver.rest.response.RemoveUserResponse;
import pl.smartapps.restserver.rest.response.Response;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.SendNotificationResponse;
import pl.smartapps.restserver.rest.response.SetDynDNSRequest;
import pl.smartapps.restserver.rest.response.SettingsResponse;
import pl.smartapps.restserver.rest.response.StatusResponse;
import pl.smartapps.restserver.rest.response.UnregisterDeviceResponse;
import pl.smartapps.restserver.rest.response.UpdateAccountSettingsResponse;
import pl.smartapps.restserver.rest.response.UpdateDeviceResponse;
import pl.smartapps.restserver.rest.response.UpdateNotificationTokenResponse;
import pl.smartapps.restserver.rest.response.UpdateSettingStatusResponse;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.AddedDevice;
import pl.smartapps.restserver.service.AndroidNotificationService;
import pl.smartapps.restserver.service.ApplicationService;
import pl.smartapps.restserver.service.ChangePasswordException;
import pl.smartapps.restserver.service.DeviceType;
import pl.smartapps.restserver.service.DynDNSService;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.FirmwareService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.GetDynDNSException;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.MessagesService;
import pl.smartapps.restserver.service.NotificationService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.SetDynDNSException;
import pl.smartapps.restserver.service.SettingsService;
import pl.smartapps.restserver.service.UserService;
import pl.smartapps.restserver.service.VerifyDynDNSException;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;
import pl.smartapps.restserver.service.impl.AddDeviceException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.CreateEventException;
import pl.smartapps.restserver.service.impl.CreateSnapshotEventException;
import pl.smartapps.restserver.service.impl.DeviceSessions;
import pl.smartapps.restserver.service.impl.GetApplicationException;
import pl.smartapps.restserver.service.impl.GetApplicationsException;
import pl.smartapps.restserver.service.impl.GetFirmwareVersionException;
import pl.smartapps.restserver.service.impl.StopVideoRecordingException;
import pl.smartapps.restserver.service.notification.GenerateTokenException;
import pl.smartapps.restserver.service.notification.RemoveTokenException;
import pl.smartapps.restserver.service.notification.SendNotificationException;
import pl.smartapps.restserver.service.notification.SendNotificationRequest;
import pl.smartapps.restserver.service.notification.UpdateTokenException;
import pl.smartapps.restserver.util.Utils;
import pl.smartapps.restserver.util.Version;

@Path(value="/")
@Produces(value={"application/json; charset=UTF-8"})
@Service
public class RESTHandler
implements RESTHandlerInterface {
    public static final Version VERSION = new Version(3, 2, 3);
    private Logger log = Logger.getLogger(RESTHandler.class);
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;
    private SettingsService settingsService;
    private UserService userService;
    private VideoStreamService videoStreamService;
    private EventService eventService;
    private EventlogService eventlogService;
    private AuthenticationUtils authUtils;
    private PaymentService paymentService;
    private AndroidNotificationService androidNotificationService;
    private ParameterService parameterService;
    private MessagesService messagesService;
    private DynDNSService dynDNSService;
    private ApplicationService applicationService;
    private NotificationService notificationService;
    private FirmwareService firmwareService;
    @Context
    private HttpServletRequest request;
    @Autowired
    private DeviceSessions sessions;

    private String getRealRemoteAddr() {
        String result = this.request.getHeader("x-real-ip");
        if (result == null) {
            result = this.request.getHeader("x-forwarded-for");
        }
        if (result == null) {
            result = this.request.getRemoteAddr();
        }
        return result;
    }

    @Autowired
    @Required
    public void setGatewayClientService(GatewayClientService gatewayClientService) {
        this.gatewayClientService = gatewayClientService;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Autowired
    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    @Required
    public void setVideoStreamService(VideoStreamService videoStreamService) {
        this.videoStreamService = videoStreamService;
    }

    @Autowired
    @Required
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Autowired
    @Required
    public void setAndroidNotificationService(AndroidNotificationService androidNotificationService) {
        this.androidNotificationService = androidNotificationService;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService service) {
        this.parameterService = service;
    }

    @Autowired
    @Required
    public void setMessagesService(MessagesService service) {
        this.messagesService = service;
    }

    @Autowired
    @Required
    public void setDynDNSService(DynDNSService dynDNSService) {
        this.dynDNSService = dynDNSService;
    }

    @Autowired
    @Required
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Autowired
    @Required
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Autowired
    @Required
    public void setFirmwareService(FirmwareService firmwareService) {
        this.firmwareService = firmwareService;
    }

    @GET
    @Path(value="/gc")
    public List<GatewayClient> getGatewayClients() {
        try {
            return this.gatewayClientService.getGatewayClients();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/activate")
    public ActivateGcResponse activeteGatewaClient(@QueryParam(value="code") String code) {
        try {
            return this.gatewayClientService.activeteGatewaClient(code);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/gc/{gcId}")
    public RemoveResponse removeGatewayClient(@PathParam(value="gcId") Integer gatewayClientId) {
        try {
            return this.gatewayClientService.removeGatewayClient(gatewayClientId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/{gcId}/icestatus")
    public String reportICEStatus(@PathParam(value="gcId") int gatewayClientId, @QueryParam(value="status") boolean status, @QueryParam(value="icetype") String icetype) {
        String mac;
        String statusValue;
        String description;
        String ip = this.getRealRemoteAddr();
        this.log.debug((Object)("reportICEStatus: gcId = " + gatewayClientId + ", status = " + status + ", ip = " + ip + ", icetype = " + icetype));
        if (status) {
            description = icetype;
            statusValue = "OK";
        } else {
            description = "";
            statusValue = "FAILED";
        }
        try {
            mac = this.gatewayClientService.getGatewayClientMACById(Integer.valueOf(gatewayClientId));
        }
        catch (InvalidSessionException e) {
            return null;
        }
        this.eventlogService.registerEventlog(GCEventType.CLIENTICE, mac, ip, statusValue, description);
        return "";
    }

    @GET
    @Path(value="/gc/{gcId}")
    public GCStatusResponse getGatewayClientStatus(@PathParam(value="gcId") int gatewayClientId) {
        try {
            return this.gatewayClientService.getGatewayClientStatus(gatewayClientId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld")
    public GetLanDevicesResponse getLanDevices(@QueryParam(value="class") String deviceClass) {
        try {
            return this.lanDeviceService.getLanDevices(this.getRealRemoteAddr(), deviceClass);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/{lanDeviceId}")
    public LanDevice getLanDevice(@PathParam(value="lanDeviceId") Integer lanDeviceId) {
        try {
            return this.lanDeviceService.getLanDevice(lanDeviceId, this.getRealRemoteAddr());
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/{gcId}/ld")
    public List<LanDevice> getLanDevicesForGc(@PathParam(value="gcId") Integer gcId) {
        try {
            return this.lanDeviceService.getLanDevicesForGc(gcId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/{gcId}/ld/search")
    public List<LanDevice> findLanDevices(@PathParam(value="gcId") Integer gcId) {
        try {
            return this.lanDeviceService.findLanDevices(gcId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/{gcId}/ld/verify")
    public DeviceVerificationResponse verifyDiscoveredLanDevice(@PathParam(value="gcId") Integer gcId, @QueryParam(value="mac") String mac, @QueryParam(value="address") String address, @QueryParam(value="deviceDescId") Integer deviceDescId) {
        try {
            return this.lanDeviceService.verifyDiscoveredLanDevice(gcId, mac, address, deviceDescId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/ld")
    @Consumes(value={"application/json"})
    public SaveResponse addLanDevice(LanDevice device) {
        try {
            return this.lanDeviceService.addLanDevice(device);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/videostream")
    public VideoStreamParamsResponse getVideoStreamPameters(@PathParam(value="lanDeviceId") Integer lanDeviceId) {
        try {
            return this.videoStreamService.getVideoStreamPameters(lanDeviceId, false);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/ld/{lanDeviceId}")
    public RemoveResponse removeLanDevice(@PathParam(value="lanDeviceId") Integer lanDeviceId) {
        try {
            return this.lanDeviceService.removeLanDevice(lanDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/settings")
    public SettingsResponse getLanDeviceSettings(@PathParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="appleDeviceId") String appleDeviceId) {
        try {
            return this.settingsService.getLanDeviceSettings(lanDeviceId, appleDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @PUT
    @Path(value="/ld/{lan_device_id}/settings")
    @Consumes(value={"application/json"})
    public SaveResponse updateLanDeviceSettings(@PathParam(value="lan_device_id") Integer lanDeviceId, LanDevice settings, @QueryParam(value="appleDeviceId") String appleDeviceId) {
        try {
            return this.settingsService.updateLanDeviceSettings(lanDeviceId, settings, appleDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/{lan_device_id}/videostatus")
    public String reportVideoStatus(@PathParam(value="lan_device_id") Integer lanDeviceId, @QueryParam(value="status") boolean status, @QueryParam(value="ip") String ip) {
        String description;
        String cameraMac;
        this.log.debug((Object)("reportVideoStatus: lan_device_id = " + lanDeviceId + ", status = " + status));
        try {
            cameraMac = this.lanDeviceService.getLanDeviceMACById(lanDeviceId);
            description = this.lanDeviceService.getLanDeviceIpAndPortById(lanDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
        this.eventlogService.registerEventlog(GCEventType.VIDEOSTREAM, cameraMac, ip, status ? "OK" : "FAILED", description);
        return "";
    }

    @GET
    @Path(value="/ice/params")
    public ICEParameters getICEParameters() {
        try {
            return this.videoStreamService.getICEParameters();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ice/search")
    public CandidatesResponse searchCandidates(@QueryParam(value="gcId") Integer gcId, @QueryParam(value="candidates") String candidates) {
        try {
            return this.videoStreamService.searchCandidates(gcId, candidates);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/user/register")
    @Consumes(value={"application/json"})
    public RegisterResponse registerUser(User user, @QueryParam(value="captcha") String captcha) {
        return this.userService.registerUser(user, captcha);
    }

    @GET
    @Path(value="/user/log")
    public AuthenticateResponse authenticateUser(@QueryParam(value="usr") String usr, @QueryParam(value="pass") String pass, @QueryParam(value="rm") boolean rme) {
        AuthenticationData data = new AuthenticationData();
        data.setUsername(usr);
        data.setPassword(pass);
        data.setRememberMe(rme);
        return this.userService.authenticateUser(data);
    }

    @POST
    @Path(value="/user/authenticate")
    @Consumes(value={"application/json"})
    public AuthenticateResponse authenticateUserWithoutPassExpiry(AuthenticationData data) {
        return this.userService.authenticateUser(data, false);
    }

    @POST
    @Path(value="/user/login")
    @Consumes(value={"application/json"})
    public AuthenticateResponse authenticateUserWithPassExpiry(AuthenticationData data) {
        return this.userService.authenticateUser(data, true);
    }

    @GET
    @Path(value="/user/logout")
    public LogoutResponse logoutUser() {
        try {
            return this.userService.logoutUser();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/user/ensureLogedIn")
    public AuthenticateResponse ensureLogedIn() {
        try {
            this.authUtils.ensureLoggedIn();
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.OK);
        }
        catch (InvalidSessionException e) {
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED);
        }
    }

    @GET
    @Path(value="/user")
    public AccountSettings getAccountSettings() {
        try {
            this.authUtils.ensureLoggedIn();
            return this.userService.getSettings();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @PUT
    @Path(value="/user")
    @Consumes(value={"application/json"})
    public UpdateAccountSettingsResponse updateUserSettings(AccountSettings settings) {
        try {
            this.authUtils.ensureLoggedIn();
            return this.userService.updateSettings(settings);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/user")
    public RemoveUserResponse removeUser(@QueryParam(value="userId") Integer userId) {
        try {
            return this.userService.removeUser(userId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/user/check")
    public AuthenticationStatus checkAuthenticationStatus(AuthenticationCheckData data) {
        return this.userService.checkAuthenticationStatus(data.getRememberMeCookie());
    }

    @POST
    @Path(value="/user/verifyPassword")
    public VerifyPasswordStatus verifyPassword(String password) {
        try {
            return this.userService.verifyPassword(password);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/user/forgotPassword")
    public ForgotPasswordResponse forgotPassword(@QueryParam(value="username") String username, @QueryParam(value="email") String email) {
        return this.userService.forgotPassword(username, email);
    }

    @POST
    @Path(value="/user/changePassword")
    @Consumes(value={"application/json"})
    public NewChangePasswordReponse changePassword(ChangePasswordData data) {
        try {
            this.userService.changePassword(data.getUsername(), data.getOldPassword(), data.getNewPassword());
        }
        catch (ChangePasswordException e) {
            return new NewChangePasswordReponse(e.getErrorCode());
        }
        return new NewChangePasswordReponse(null);
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/recording")
    public RecordingControlResponse recordingControl(@PathParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="isRecording") boolean isRecording) {
        try {
            return this.eventService.recordingControl(lanDeviceId, isRecording);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/recordingStatus")
    public Map<Integer, Boolean> getRecordingStatus() {
        try {
            return this.eventService.getRecordingStatus();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/event")
    public List<Event> getEvents() {
        try {
            return this.eventService.getEvents();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/event/{eventId}")
    public Event getEvent(@PathParam(value="eventId") Integer eventId) {
        try {
            return this.eventService.getEvent(eventId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/event/{eventId}")
    public RemoveEventResponse removeEvent(@PathParam(value="eventId") Integer eventId) {
        try {
            return this.eventService.removeEvent(eventId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/event")
    public CreateEventResponse createEvent(@QueryParam(value="token") String token, @QueryParam(value="type") String type, @QueryParam(value="videoLength") Integer videoLength) {
        try {
            this.eventService.createEvent(token, type, videoLength);
            return new CreateEventResponse();
        }
        catch (CreateEventException ex) {
            return new CreateEventResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to create event for token=" + token + " and type=" + type + ": " + ex.getMessage()));
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return new CreateEventResponse(CreateEventException.ErrorCode.ERROR);
        }
    }

    @PUT
    @Path(value="/event/stop")
    public StopVideoRecordingResponse stopVideoRecording(@QueryParam(value="token") String token) {
        try {
            this.eventService.stopVideoRecording(token);
            return new StopVideoRecordingResponse();
        }
        catch (StopVideoRecordingException ex) {
            return new StopVideoRecordingResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to stop event for token=" + token + ": " + ex.getMessage()));
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return new StopVideoRecordingResponse(StopVideoRecordingException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/event/snapshot")
    @Consumes(value={"multipart/form-data"})
    public CreateSnapshotEventResponse createEvent(@QueryParam(value="token") String token, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition contentDisposition) {
        try {
            byte[] snapshot = IOUtils.toByteArray((InputStream)stream);
            this.eventService.createSnapshotEvent(token, snapshot);
            return new CreateSnapshotEventResponse();
        }
        catch (CreateSnapshotEventException ex) {
            return new CreateSnapshotEventResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to create snapshot event for token=" + token + ": " + ex.getMessage()));
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return new CreateSnapshotEventResponse(CreateSnapshotEventException.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/messages")
    public List<Message> getMessages(@QueryParam(value="version") String version, @QueryParam(value="lang") String lang, @QueryParam(value="platform") String platform) {
        return this.messagesService.getMessages(version, lang, platform);
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/updateSingleSetting")
    public UpdateSettingStatusResponse updateLanDeviceParam(@PathParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="paramName") String paramName, @QueryParam(value="paramValue") String paramValue) {
        try {
            return new UpdateSettingStatusResponse(this.lanDeviceService.updateLanDeviceParamWithAuth(lanDeviceId, paramName, paramValue));
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/status")
    public Map<Integer, LanDeviceStatus> getLanDevicesStatus() {
        try {
            return this.lanDeviceService.getStatus();
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/rssi/{id}")
    public String testRssi(@PathParam(value="id") Integer id) throws InvalidSessionException {
        return this.lanDeviceService.checkRssi(id).toString();
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/triggerEvent")
    public ProcessEventResponse triggerExternalEvent(@PathParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="triggerType") String triggerType, @QueryParam(value="mediaType") String mediaType, @QueryParam(value="videoDuration") Integer videoDuration) {
        this.log.debug((Object)("start triggerExternalEvent(lanDeviceId=" + lanDeviceId + ", triggerType=" + triggerType + ", mediaType=" + mediaType + ", videoDuration=" + videoDuration + ")"));
        try {
            this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
            return this.eventService.processEvent(lanDeviceId, triggerType, null, mediaType, videoDuration, null, null);
        }
        catch (InvalidSessionException e) {
            this.log.debug((Object)("InvalidSessionException has been thrown: " + e.getMessage()));
            return null;
        }
    }

    @POST
    @Path(value="/user/newsession/{username}")
    public CreateSessionResponse createSession(@PathParam(value="username") String username) {
        try {
            return this.userService.createSession(username);
        }
        catch (InvalidSessionException e) {
            this.log.debug((Object)("InvalidSessionException has been thrown: " + e.getMessage()));
            return null;
        }
    }

    @POST
    @Path(value="/ld/{lanDeviceId}/extendValidity")
    @Consumes(value={"application/json"})
    public ExtendValidityResponse extendValidity(@PathParam(value="lanDeviceId") Integer lanDeviceId, Transaction transaction) {
        this.log.debug((Object)("start extendValidity(lanDeviceId=" + lanDeviceId + ", transaction=" + transaction + ")"));
        try {
            return this.paymentService.extendValidity(lanDeviceId, transaction);
        }
        catch (InvalidSessionException e) {
            this.log.debug((Object)("InvalidSessionException has been thrown: " + e.getMessage()));
            return null;
        }
    }

    @GET
    @Path(value="/device/update")
    public UpdateDeviceResponse updateDevice(@QueryParam(value="registrationId") String registrationId) {
        this.log.debug((Object)("start updateDevice(registrationId=" + registrationId + ")"));
        return this.androidNotificationService.updateDeviceId(registrationId);
    }

    @GET
    @Path(value="/device/unregister")
    public UnregisterDeviceResponse unregisterDevice(@QueryParam(value="registrationId") String registrationId) {
        this.log.debug((Object)("start unregisterDevice(registrationId=" + registrationId + ")"));
        return this.androidNotificationService.deleteInactiveDevice(registrationId);
    }

    @GET
    @Path(value="/ld/activate")
    public ActivateCameraResponse activeteLanDeviceClient(@QueryParam(value="code") String code) {
        try {
            return this.lanDeviceService.activateCamera(code, false, LanDeviceServiceExt.DeviceType.NAS);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/device/registerCamera")
    public ActivateCameraResponse registerCamera(@QueryParam(value="code") String code, @QueryParam(value="trial") boolean trial) throws InvalidSessionException {
        return this.lanDeviceService.activateCamera(code, trial, LanDeviceServiceExt.DeviceType.Camera);
    }

    @GET
    @Path(value="/param/get")
    public ParameterValueResponse paramGet(@QueryParam(value="name") String name) {
        this.log.debug((Object)("requested name: " + name));
        try {
            ParameterService.ParameterCode[] parameterCodeArray = ParameterService.ParameterCode.values();
            int n = parameterCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterService.ParameterCode code = parameterCodeArray[n2];
                if (code.getCode().equals(name)) {
                    String value = this.parameterService.getParameterValueWhenLoggedIn(code);
                    this.log.debug((Object)"name correct, returning value");
                    return new ParameterValueResponse(value);
                }
                ++n2;
            }
            this.log.debug((Object)"invalid name of parameter, returning null");
            return null;
        }
        catch (InvalidSessionException e) {
            this.log.debug((Object)"not logged in, returning null");
            return null;
        }
    }

    @GET
    @Path(value="/user/loginAs")
    public AuthenticateResponse loginAsUser(@QueryParam(value="userId") Integer userId) {
        try {
            if (this.userService.loginAsUser(userId)) {
                return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.OK);
            }
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED);
        }
        catch (InvalidSessionException e) {
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED);
        }
    }

    @POST
    @Path(value="/user/changePassAsAdmin")
    @Consumes(value={"application/json"})
    public ChangePasswordResponse changePassAsAdmin(ChangePassAsAdminData data) {
        try {
            Integer userId = data.getUserId();
            String password = data.getPassword();
            return this.userService.changePasswordAsAdmin(userId, password);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/checkConfigAsAdmin/{id}")
    public StatusResponse checkConfigStatus(@PathParam(value="id") Integer lanDeviceId) {
        try {
            CheckConfigurationStatus status = this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(lanDeviceId);
            return new StatusResponse(status.name());
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/reconfigureAsAdmin/{id}")
    public StatusResponse reconfigure(@PathParam(value="id") Integer lanDeviceId) {
        try {
            ReconfigurationDeviceStatus status = this.lanDeviceService.reconfigureLanDeviceAsAdmin(lanDeviceId);
            return new StatusResponse(status.name());
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/gc/sendData")
    public GatewayClientResponse gatewayClientSendData(GatewayClientSendData data) {
        try {
            String mac = data.getMac();
            String url = data.getUrl();
            if (data.getMethod() == GatewayClientSendData.Method.GET) {
                return this.gatewayClientService.send(mac, url);
            }
            String body = data.getBody();
            return this.gatewayClientService.sendPost(mac, url, body);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/updateFirmware/{id}")
    public SaveResponse updateFirmware(@PathParam(value="id") Integer gatewayClientId) {
        try {
            GatewayClient gatewayClient = this.gatewayClientService.getGatewayClient(gatewayClientId);
            return this.gatewayClientService.updateGatewayClient(gatewayClient);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/upgradeFirmware/{id}")
    public UpgradeFirmwareStatus upgradeFirmware(@PathParam(value="id") Integer lanDeviceId) {
        try {
            return this.lanDeviceService.upgradeFirmware(lanDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/upgradeGatewayClient/{id}")
    public GatewayClientResponse updateGatewayClient(@PathParam(value="id") Integer gatewayClientId) {
        try {
            GatewayClient gatewayClient = this.gatewayClientService.getGatewayClient(gatewayClientId);
            return this.gatewayClientService.upgradeGatewayClient(gatewayClient.getMac());
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/restartGatewayClient/{mac}")
    public GatewayClientResponse restartGatewayClient(@PathParam(value="mac") String macAddress) {
        try {
            return this.gatewayClientService.restart(macAddress);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/getPublicIP/{id}")
    public IPAddressResponse getGatewayClientPublicIp(@PathParam(value="id") Integer gatewayClientId) {
        try {
            GatewayClient gc = this.gatewayClientService.getGatewayClient(gatewayClientId);
            return new IPAddressResponse(gc.getPublicIpAddress(), gc.getStatus().name());
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/gc/executeScript/{mac}/{script}")
    public GatewayClientResponse executeScript(@PathParam(value="mac") String macAddress, @PathParam(value="script") String scriptName) {
        try {
            return this.gatewayClientService.runScript(macAddress, scriptName);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/test/processDevices")
    public String processDevices() {
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        try {
            this.lanDeviceService.manageDevicesProduct();
        }
        catch (InvalidSessionException e) {
            return null;
        }
        return "";
    }

    @GET
    @Path(value="/ld/connectivityerror/{id}/{error}")
    public ErrorReportResponse errorReport(@PathParam(value="id") Integer lanDeviceId, @PathParam(value="error") String errorString) {
        this.log.debug((Object)("Received error report for LD " + lanDeviceId + ": " + errorString));
        try {
            return this.lanDeviceService.checkLanDeviceAfterErrorReport(lanDeviceId, this.getRealRemoteAddr());
        }
        catch (InvalidSessionException e) {
            return new ErrorReportResponse(ErrorReportResponse.Status.FAILED);
        }
    }

    @POST
    @Path(value="/ld/share")
    public ShareDeviceResponse shareDevice(@QueryParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="email") String email) {
        try {
            return this.lanDeviceService.shareLanDevice(lanDeviceId, email);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @POST
    @Path(value="/ld/unshare")
    public UnshareDeviceResponse unshareDevice(@QueryParam(value="lanDeviceId") Integer lanDeviceId, @QueryParam(value="email") String email) {
        try {
            return this.lanDeviceService.unshareLanDevice(lanDeviceId, email);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/ld/{lanDeviceId}/sharedWith")
    public DeviceSharedWithResponse getDeviceSharedWith(@PathParam(value="lanDeviceId") Integer lanDeviceId) {
        try {
            return this.lanDeviceService.getDeviceSharedWith(lanDeviceId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/sessions")
    public String getSessions() {
        Set devices = this.sessions.devices();
        this.log.info((Object)(">>> Device's session size: " + devices.size()));
        for (String dev : devices) {
            this.log.info((Object)(">>> " + dev + " --> " + this.sessions.get(dev)));
        }
        return "ok";
    }

    @GET
    @Path(value="/version")
    public GetVersionResponse getVersion() {
        return new GetVersionResponse(VERSION.toString());
    }

    @GET
    @Path(value="/gc/{mac}/commServer")
    public GetCommServerUrlResponse getCommServerUrl(@PathParam(value="mac") String mac) {
        try {
            this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
            return this.gatewayClientService.getCommServerUrl(mac);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/pm/test")
    public String pmtest0() {
        Thread[] threads = new Thread[5];
        int i = 0;
        while (i < 5) {
            threads[i] = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            thread.start();
            ++n2;
        }
        return "ok";
    }

    @GET
    @Path(value="/dyndns/verify")
    public VerifyDynDNSResponse verifyDynDNS(@QueryParam(value="name") String name) {
        try {
            return new VerifyDynDNSResponse(this.dynDNSService.verifyDynDNS(name));
        }
        catch (VerifyDynDNSException ex) {
            return new VerifyDynDNSResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            return new VerifyDynDNSResponse(VerifyDynDNSException.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/dyndns")
    public GetDynDNSResponse getDynDNS(@QueryParam(value="haId") String haId) {
        try {
            return new GetDynDNSResponse(this.dynDNSService.getDynDNS(haId));
        }
        catch (GetDynDNSException ex) {
            return new GetDynDNSResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            return new GetDynDNSResponse(GetDynDNSException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/dyndns/set")
    @Consumes(value={"application/json"})
    public SetDynDNSResponse setDynDNS(SetDynDNSRequest dynDNSRequest) {
        this.log.trace((Object)("start setDynDNS(dynDNSRequest=" + dynDNSRequest + ")"));
        try {
            this.dynDNSService.setDynDNS(dynDNSRequest.getHaId(), dynDNSRequest.getName(), dynDNSRequest.getEnabled(), this.getRealRemoteAddr());
            return new SetDynDNSResponse(Response.Status.SUCCESS);
        }
        catch (SetDynDNSException ex) {
            return new SetDynDNSResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            return new SetDynDNSResponse(SetDynDNSException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/device")
    @Consumes(value={"application/json"})
    public AddDeviceResponse addDevice(AddDeviceRequest request) {
        this.log.trace((Object)("start addDevice(request=" + request + ")"));
        try {
            this.authUtils.ensureLoggedIn();
            AddedDevice addedDevice = this.lanDeviceService.addDevice(this.authUtils.getCurrentUser(), request);
            AddDeviceResponse resp = new AddDeviceResponse(addedDevice.getDrivercode(), addedDevice.getAppcode(), addedDevice.getGcid(), addedDevice.getToken());
            return resp;
        }
        catch (InvalidSessionException ex) {
            return new AddDeviceResponse(AddDeviceException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (AddDeviceException ex) {
            return new AddDeviceResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to add device " + request + ", cause=" + ex.getMessage()));
            ex.printStackTrace();
            return new AddDeviceResponse(AddDeviceException.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/app")
    public GetApplicationsResponse getApplications(@QueryParam(value="type") String type) {
        try {
            if (Utils.isBlank((String)type)) {
                return new GetApplicationsResponse(GetApplicationsException.ErrorCode.NO_TYPE);
            }
            DeviceType deviceType = DeviceType.parse((String)type);
            if (deviceType == null) {
                return new GetApplicationsResponse(GetApplicationsException.ErrorCode.INVALID_TYPE);
            }
            return new GetApplicationsResponse(this.applicationService.getApplications(deviceType));
        }
        catch (GetApplicationsException ex) {
            return new GetApplicationsResponse(ex.getErrorCode());
        }
        catch (Exception e) {
            return new GetApplicationsResponse(GetApplicationsException.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/app/{applicationId}")
    public GetApplicationResponse getApplications(@PathParam(value="applicationId") Integer applicationId) {
        try {
            return new GetApplicationResponse(this.applicationService.getApplication(applicationId));
        }
        catch (GetApplicationException ex) {
            return new GetApplicationResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            return new GetApplicationResponse(GetApplicationException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/notification/generateToken")
    public GenerateNotificationTokenResponse generateToken(GenerateNotificationTokenRequest request) {
        try {
            if (request == null) {
                throw new GenerateTokenException(GenerateTokenException.ErrorCode.NO_DATA);
            }
            this.authUtils.ensureLoggedIn();
            String token = this.notificationService.genreateNotificationToken(this.authUtils.getCurrentUser(), request.getNotificationType(), request.getRecipient());
            return new GenerateNotificationTokenResponse(token);
        }
        catch (InvalidSessionException ex) {
            return new GenerateNotificationTokenResponse(GenerateTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (GenerateTokenException ex) {
            return new GenerateNotificationTokenResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to generate notification token: " + ex.getMessage()));
            return new GenerateNotificationTokenResponse(GenerateTokenException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/notification/update")
    public UpdateNotificationTokenResponse updateNotification(UpdateNotificationTokenRequest request) {
        try {
            this.authUtils.ensureLoggedIn();
            this.notificationService.updateNotificationToken(this.authUtils.getCurrentUser(), request.getToken(), request.getRecipient());
            return new UpdateNotificationTokenResponse();
        }
        catch (InvalidSessionException ex) {
            return new UpdateNotificationTokenResponse(UpdateTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (UpdateTokenException ex) {
            return new UpdateNotificationTokenResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to update notification token for token=" + request.getToken() + ": " + ex.getMessage()));
            return new UpdateNotificationTokenResponse(UpdateTokenException.ErrorCode.ERROR);
        }
    }

    @POST
    @Path(value="/notification/send")
    public SendNotificationResponse sendNotification(SendNotificationRequest request) {
        try {
            this.notificationService.sendNotification(request);
            return new SendNotificationResponse();
        }
        catch (SendNotificationException ex) {
            return new SendNotificationResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to send notification for token=" + request.getToken() + ": " + ex.getMessage()));
            return new SendNotificationResponse(SendNotificationException.ErrorCode.ERROR);
        }
    }

    @DELETE
    @Path(value="/notification/{token}")
    public RemoveNotificationTokenResponse removeNotificationToken(@PathParam(value="token") String token) {
        try {
            this.authUtils.ensureLoggedIn();
            this.notificationService.removeNotificationToken(this.authUtils.getCurrentUser(), token);
            return new RemoveNotificationTokenResponse();
        }
        catch (InvalidSessionException ex) {
            return new RemoveNotificationTokenResponse(RemoveTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        catch (RemoveTokenException ex) {
            return new RemoveNotificationTokenResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to remove notification for token=" + token + ": " + ex.getMessage()));
            return new RemoveNotificationTokenResponse(RemoveTokenException.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/versions/{gatewayMac}")
    public GetVersionsResponse getVersions(@PathParam(value="gatewayMac") String gatewayMac) {
        try {
            return new GetVersionsResponse(this.firmwareService.getFirmwareVersions(gatewayMac));
        }
        catch (GetFirmwareVersionException ex) {
            return new GetVersionsResponse(ex.getErrorCode());
        }
        catch (Exception ex) {
            this.log.warn((Object)("Failed to get versions for gatewayMac=" + gatewayMac + ": " + ex.getMessage()));
            System.out.println(">>>>> heh");
            ex.printStackTrace();
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return new GetVersionsResponse(GetFirmwareVersionException.ErrorCode.ERROR);
        }
    }
}

