/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.GetDeviceIdsResponse;
import com.vestiacom.gdserver.rest.response.GetRegisteredResponse;
import com.vestiacom.gdserver.rest.response.HttpProxyVerificationResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.rest.response.CancelPairingResponse;
import pl.smartapps.restserver.rest.response.GetPairingResponse;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.GDServerCallbacks;
import pl.smartapps.restserver.util.Utils;

@Path(value="/gd")
@Produces(value={"application/json"})
@Service
public class ClusterHandler {
    private static Logger log = Logger.getLogger(ClusterHandler.class);
    private GDServerCallbacks gdServerCallbacks;
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type;

    @Autowired
    @Required
    public void setGdServerCallbacks(GDServerCallbacks gdServerCallbacks) {
        this.gdServerCallbacks = gdServerCallbacks;
    }

    @Autowired
    @Required
    public void setGatewayClientService(GatewayClientService gatewayClientService) {
        this.gatewayClientService = gatewayClientService;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @GET
    @Path(value="/{mac}/conected")
    public Response deviceConnected(@PathParam(value="mac") String mac, @QueryParam(value="publicIpAddress") String publicIpAddress, @QueryParam(value="localIpAddress") String localIpAddress, @QueryParam(value="gdServerAddress") String gdServerAddress, @QueryParam(value="registered") Boolean registered) {
        log.trace((Object)("start deviceConnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", localIpAddress=" + localIpAddress + ", gdServerAddress=" + gdServerAddress + ", registered=" + registered + ")"));
        this.gdServerCallbacks.connected(mac, publicIpAddress, localIpAddress, gdServerAddress, registered);
        return new Response(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/{mac}/disconected")
    public Response deviceDisconnected(@PathParam(value="mac") String mac, @QueryParam(value="publicIpAddress") String publicIpAddress, @QueryParam(value="reason") String reason, @QueryParam(value="gdServerAddress") String gdServerAddress) {
        log.trace((Object)("start deviceDisconnected(mac=" + mac + ", publicIpAddress=" + publicIpAddress + ", reason=" + reason + ")"));
        this.gdServerCallbacks.disconnected(mac, publicIpAddress, reason, gdServerAddress);
        return new Response(Response.Status.SUCCESS);
    }

    @POST
    @Path(value="/{mac}/logs")
    @Consumes(value={"application/json"})
    public Response receivedLogs(@PathParam(value="mac") String mac, List<Debuglog> debuglogs) {
        log.trace((Object)("start receivedLogs(mac=" + mac + ", debuglogs=" + Utils.getSize(debuglogs) + ")"));
        this.gdServerCallbacks.receivedLogs(mac, debuglogs);
        return new Response(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/{mac}/upnpStatus")
    public Response forwardUpnpStatus(@PathParam(value="mac") String mac, @QueryParam(value="state") UpnpForwardingState state, @QueryParam(value="upnpPort") Integer upnpPort, @QueryParam(value="statusCode") Integer statusCode, @QueryParam(value="reason") String reason, @QueryParam(value="publicIp") String publicIp) {
        log.trace((Object)("start forwardUpnpStatus(mac=" + mac + ", state=" + state + ", upnpPort=" + upnpPort + ", statusCode=" + statusCode + ", reason=" + reason + ", publicIp=" + publicIp + ")"));
        this.gatewayClientService.forwardUpnpStatus(mac, state, upnpPort, statusCode, reason, publicIp);
        return new Response(Response.Status.SUCCESS);
    }

    @POST
    @Path(value="/{mac}/upnpStatus")
    public Response forwardUpnpStatus(@PathParam(value="mac") String mac, SetUpUpnpForwardingResult status) {
        log.trace((Object)("start forwardUpnpStatus(mac=" + mac + ", status=" + status + ")"));
        this.gatewayClientService.forwardUpnpStatus(mac, status.getState(), status.getUpnpPort(), status.getStatusCode(), status.getReason(), status.getPublicIp());
        return new Response(Response.Status.SUCCESS);
    }

    @GET
    @Path(value="/{mac}/registered")
    public GetRegisteredResponse getRegistered(@PathParam(value="mac") String mac) {
        log.trace((Object)("start getRegistered(mac=" + mac + ")"));
        if (Utils.isBlank((String)mac)) {
            return new GetRegisteredResponse(GetRegisteredResponse.ErrorCode.NO_MAC);
        }
        try {
            return new GetRegisteredResponse(this.gatewayClientService.isRegistered(mac));
        }
        catch (Exception ex) {
            return new GetRegisteredResponse(GetRegisteredResponse.ErrorCode.ERROR);
        }
    }

    @GET
    @Path(value="/ld/verifyproxy")
    public HttpProxyVerificationResponse verifyHttpProxy(@QueryParam(value="deviceId") String deviceId, @QueryParam(value="gcId") int gcId, @QueryParam(value="ldId") int ldId) {
        try {
            return this.lanDeviceService.verifyHttpProxyConnection(deviceId, gcId, ldId);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @GET
    @Path(value="/restproxy/getpairing")
    public GetPairingResponse getPairing(@QueryParam(value="mac") String mac) {
        log.trace((Object)("start getPairing(mac=" + mac + ")"));
        try {
            List accounts = this.lanDeviceService.getPairing(mac);
            return new GetPairingResponse(GetPairingResponse.Status.SUCCESS, accounts);
        }
        catch (RuntimeException ex) {
            return new GetPairingResponse(GetPairingResponse.Status.ERROR);
        }
    }

    @GET
    @Path(value="/restproxy/cancelpairing")
    public CancelPairingResponse cancelPairing(@QueryParam(value="mac") String mac, @QueryParam(value="email") String email) {
        log.trace((Object)("start cancelPairing(mac=" + mac + ", email=" + email + ")"));
        return this.lanDeviceService.cancelPairing(mac, email);
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/batch")
    public Response receivedBatch(String msg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleUpnpStatus(Message msg) {
        Gson gson = new Gson();
        SetUpUpnpForwardingResult status = (SetUpUpnpForwardingResult)gson.fromJson(msg.getParam(Message.Param.VALUE), SetUpUpnpForwardingResult.class);
        this.gatewayClientService.forwardUpnpStatus(msg.getMac(), status.getState(), status.getUpnpPort(), status.getStatusCode(), status.getReason(), status.getReason());
    }

    @GET
    @Path(value="/{mac}/ids")
    public GetDeviceIdsResponse getIds(@PathParam(value="mac") String mac) {
        log.trace((Object)("start getIds(mac=" + mac + ")"));
        if (Utils.isBlank((String)mac)) {
            return new GetDeviceIdsResponse(GetDeviceIdsResponse.ErrorCode.NO_MAC);
        }
        try {
            return new GetDeviceIdsResponse(this.gatewayClientService.getDeviceIds(mac));
        }
        catch (Exception ex) {
            return new GetDeviceIdsResponse(GetDeviceIdsResponse.ErrorCode.ERROR);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type;
        }
        int[] nArray = new int[Message.Type.values().length];
        try {
            nArray[Message.Type.CONNECTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.DISCONNECTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.LOGS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Message.Type.UPNP_STATUS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$model$Message$Type = nArray;
        return nArray;
    }
}

