/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.db.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.RoleEntity;
import pl.smartapps.restserver.db.main.SSOServiceEntity;
import pl.smartapps.restserver.db.main.ShareEntity;

@Entity
@Table(name="user_")
@NamedQueries(value={@NamedQuery(name="UserEntity.FIND_BY_ID", query="select u from UserEntity u where u.id = :id")})
public class UserEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="user_seq")
    @SequenceGenerator(name="user_seq", sequenceName="user_seq", allocationSize=1)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="username")
    private String username;
    @Basic(optional=false)
    @Column(name="email")
    private String email;
    @Column(name="password")
    private String password;
    @Column(name="password_salt")
    private String passwordSalt;
    @Column(name="password_creation_date")
    private Date passwordCreationDate;
    @ManyToMany(mappedBy="users")
    private List<RoleEntity> roles;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user", fetch=FetchType.LAZY)
    private Set<GatewayClientEntity> gatewayClients;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user", fetch=FetchType.LAZY)
    private Set<LanDeviceEntity> lanDevices;
    @Basic(optional=false)
    @Column(name="deleted")
    private Integer deleted;
    @Basic(optional=false)
    @Column(name="added_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date addedDate;
    @Column(name="deleted_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @Column(name="activation_code")
    private String activationCode;
    @Column(name="change_password_code")
    private String changePasswordCode;
    @JoinColumn(name="product_id", referencedColumnName="product_id")
    @ManyToOne(optional=false)
    private ProductEntity product;
    @Column(name="firstname")
    private String firstname;
    @Column(name="lastname")
    private String lastname;
    @Column(name="address")
    private String address;
    @Column(name="town")
    private String town;
    @Column(name="zip_code")
    private String zipCode;
    @Column(name="state")
    private String state;
    @Column(name="country")
    private String country;
    @Column(name="phone_number")
    private String phoneNumber;
    @Column(name="language")
    private String language;
    @Column(name="log_conf")
    private String logConf;
    @Basic(optional=false)
    @Column(name="mailing")
    private boolean mailing;
    @Column(name="sso_id")
    private String ssoId;
    @JoinColumn(name="ssoservice_id", referencedColumnName="ssoservice_id")
    @ManyToOne(optional=true)
    private SSOServiceEntity ssoService;
    @OneToMany(mappedBy="user")
    private List<ShareEntity> shares;

    public UserEntity() {
    }

    public UserEntity(Integer id) {
        this.id = id;
    }

    public UserEntity(Integer id, String username, String email, String password) {
        this.id = id;
        this.username = username;
        this.email = email;
        this.password = password;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void setPasswordSalt(String passwordSalt) {
        this.passwordSalt = passwordSalt;
    }

    public Date getPasswordCreationDate() {
        return this.passwordCreationDate;
    }

    public void setPasswordCreationDate(Date passwordCreationDate) {
        this.passwordCreationDate = passwordCreationDate;
    }

    public List<RoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleEntity> roles) {
        this.roles = roles;
    }

    public Set<GatewayClientEntity> getGatewayClients() {
        return this.gatewayClients;
    }

    public void setGatewayClients(Set<GatewayClientEntity> gatewayClients) {
        this.gatewayClients = gatewayClients;
    }

    public Set<LanDeviceEntity> getLanDevices() {
        return this.lanDevices;
    }

    public void setLanDevices(Set<LanDeviceEntity> lanDevices) {
        this.lanDevices = lanDevices;
    }

    public Integer getDeleted() {
        return this.deleted;
    }

    public boolean isDeleted() {
        return this.deleted != null && !this.deleted.equals(0);
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getAddedDate() {
        return this.addedDate;
    }

    public void setAddedDate(Date addedDate) {
        this.addedDate = addedDate;
    }

    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public void setDeletedDate(Date deletedDate) {
        this.deletedDate = deletedDate;
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public String getChangePasswordCode() {
        return this.changePasswordCode;
    }

    public void setChangePasswordCode(String changePasswordCode) {
        this.changePasswordCode = changePasswordCode;
    }

    public ProductEntity getProduct() {
        return this.product;
    }

    public void setProduct(ProductEntity product) {
        this.product = product;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLogConf() {
        return this.logConf;
    }

    public void setLogConf(String logConf) {
        this.logConf = logConf;
    }

    public void setMailing(boolean mailing) {
        this.mailing = mailing;
    }

    public boolean isMailing() {
        return this.mailing;
    }

    public void setSsoId(String ssoId) {
        this.ssoId = ssoId;
    }

    public String getSsoId() {
        return this.ssoId;
    }

    public List<ShareEntity> getShares() {
        return this.shares;
    }

    public void setShares(List<ShareEntity> shares) {
        this.shares = shares;
    }

    public void addShare(ShareEntity share) {
        this.shares.add(share);
    }

    public void removeShare(ShareEntity share) {
        this.shares.remove(share);
    }

    public ProductfeatureEntity getProductFeature(UserFeatureCode code) {
        if (code == null) {
            return null;
        }
        for (ProductfeatureEntity productfeature : this.product.getProductfeatures()) {
            if (!productfeature.getFeature().getFeatureCode().equals(code.name())) continue;
            return productfeature;
        }
        return null;
    }

    public String getProductFeatureValue(UserFeatureCode code) {
        ProductfeatureEntity productfeature = this.getProductFeature(code);
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    public void setSsoService(SSOServiceEntity ssoService) {
        this.ssoService = ssoService;
    }

    public SSOServiceEntity getSsoService() {
        return this.ssoService;
    }

    public User toDTO() {
        User user = new User();
        user.setId(this.id);
        user.setUsername(this.username);
        user.setEmail(this.email);
        user.setAddedDate(this.addedDate);
        user.setDeleted(Boolean.valueOf(!this.deleted.equals(0)));
        user.setDeletedDate(this.deletedDate);
        user.setActivationCode(this.activationCode);
        user.setChangePasswordCode(this.changePasswordCode);
        user.setFirstname(this.firstname);
        user.setLastname(this.lastname);
        user.setAddress(this.address);
        user.setTown(this.town);
        user.setZipCode(this.zipCode);
        user.setState(this.state);
        user.setCountry(this.country);
        user.setPhoneNumber(this.phoneNumber);
        user.setLanguage(this.language);
        user.setLogConf(this.logConf);
        user.setMailing(Boolean.valueOf(this.mailing));
        user.setSsoId(this.ssoId);
        return user;
    }

    public static List<User> toDTOs(List<UserEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<User> users = new ArrayList<User>();
        for (UserEntity entity : entities) {
            users.add(entity.toDTO());
        }
        return users;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationCode == null ? 0 : this.activationCode.hashCode());
        result = 31 * result + (this.addedDate == null ? 0 : this.addedDate.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.changePasswordCode == null ? 0 : this.changePasswordCode.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = 31 * result + (this.deletedDate == null ? 0 : this.deletedDate.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.firstname == null ? 0 : this.firstname.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.lastname == null ? 0 : this.lastname.hashCode());
        result = 31 * result + (this.logConf == null ? 0 : this.logConf.hashCode());
        result = 31 * result + (this.mailing ? 1231 : 1237);
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.passwordSalt == null ? 0 : this.passwordSalt.hashCode());
        result = 31 * result + (this.product.getProductId() == null ? 0 : this.product.getProductId().hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.town == null ? 0 : this.town.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.zipCode == null ? 0 : this.zipCode.hashCode());
        result = 31 * result + (this.ssoId == null ? 0 : this.ssoId.hashCode());
        result = 31 * result + (this.ssoService == null ? 0 : this.ssoService.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserEntity other = (UserEntity)obj;
        if (this.activationCode == null ? other.activationCode != null : !this.activationCode.equals(other.activationCode)) {
            return false;
        }
        if (this.addedDate == null ? other.addedDate != null : !this.addedDate.equals(other.addedDate)) {
            return false;
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.changePasswordCode == null ? other.changePasswordCode != null : !this.changePasswordCode.equals(other.changePasswordCode)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.phoneNumber == null ? other.phoneNumber != null : !this.phoneNumber.equals(other.phoneNumber)) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.deletedDate == null ? other.deletedDate != null : !this.deletedDate.equals(other.deletedDate)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstname == null ? other.firstname != null : !this.firstname.equals(other.firstname)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.lastname == null ? other.lastname != null : !this.lastname.equals(other.lastname)) {
            return false;
        }
        if (this.logConf == null ? other.logConf != null : !this.logConf.equals(other.logConf)) {
            return false;
        }
        if (this.mailing != other.mailing) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.passwordSalt == null ? other.passwordSalt != null : !this.passwordSalt.equals(other.passwordSalt)) {
            return false;
        }
        if (this.product == null ? other.product != null : !this.product.getProductId().equals(other.product.getProductId())) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.town == null ? other.town != null : !this.town.equals(other.town)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.zipCode == null ? other.zipCode != null : !this.zipCode.equals(other.zipCode)) {
            return false;
        }
        if (this.ssoId == null ? other.ssoId != null : !this.ssoId.equals(other.ssoId)) {
            return false;
        }
        return !(this.ssoService == null ? other.ssoService != null : !this.ssoService.equals((Object)other.ssoService));
    }

    public String toString() {
        return "UserEntity [id=" + this.id + "]";
    }

    public String dump() {
        return "UserEntity [id=" + this.id + ", username=" + this.username + ", email=" + this.email + ", deleted=" + this.deleted + ", addedDate=" + this.addedDate + ", deletedDate=" + this.deletedDate + ", activationCode=" + this.activationCode + ", changePasswordCode=" + this.changePasswordCode + ", firstname=" + this.firstname + ", lastname=" + this.lastname + ", address=" + this.address + ", town=" + this.town + ", zipCode=" + this.zipCode + ", state=" + this.state + ", country=" + this.country + ", phoneNumber=" + this.phoneNumber + ", language=" + this.language + ", logConf=" + this.logConf + ", mailing=" + this.mailing + ", ssoId=" + this.ssoId + ", ssoService=" + this.ssoService + "]";
    }
}

